/**
 * Flowtype definitions for core.es5
 * Generated by Flowgen from a Typescript Definition
 * cf. https://github.com/microsoft/TypeScript/blob/master/lib/lib.es5.d.ts
 * Flowgen v1.10.0
 * and somewhat updated by comparison with the core lib built into Flow
 */

declare var NaN: number;
declare var Infinity: number;
declare var undefined: void;

/**
 * Evaluates JavaScript code and executes it.
 * @param x A String value that contains valid JavaScript code.
 */
declare function eval(x: string): any;

/**
 * Converts a string to an integer.
 * @param string A string to convert into a number.
 * @param radix A value between 2 and 36 that specifies the base of the number in numString.
 * If this argument is not supplied, strings with a prefix of '0x' are considered hexadecimal.
 * All other strings are considered decimal.
 */
declare function parseInt(string: mixed, radix?: number): number;

/**
 * Converts a string to a floating-point number.
 * @param string A string that contains a floating-point number.
 */
declare function parseFloat(string: mixed): number;

/**
 * Returns a Boolean value that indicates whether a value is the reserved value NaN (not a number).
 * @param number A numeric value.
 */
declare function isNaN(number: mixed): boolean;

/**
 * Determines whether a supplied number is finite.
 * @param number Any numeric value.
 */
declare function isFinite(number: mixed): boolean;

/**
 * Gets the unencoded version of an encoded Uniform Resource Identifier (URI).
 * @param encodedURI A value representing an encoded URI.
 */
declare function decodeURI(encodedURI: string): string;

/**
 * Gets the unencoded version of an encoded component of a Uniform Resource Identifier (URI).
 * @param encodedURIComponent A value representing an encoded URI component.
 */
declare function decodeURIComponent(encodedURIComponent: string): string;

/**
 * Encodes a text string as a valid Uniform Resource Identifier (URI)
 * @param uri A value representing an encoded URI.
 */
declare function encodeURI(uri: string): string;

/**
 * Encodes a text string as a valid component of a Uniform Resource Identifier (URI).
 * @param uriComponent A value representing an encoded URI component.
 */
declare function encodeURIComponent(uriComponent: mixed): string;

type PropertyDescriptor<T> = {
  enumerable?: boolean,
  configurable?: boolean,
  writable?: boolean,
  value?: T,
  get?: () => T,
  set?: (value: T) => void,
  ...
};

type PropertyDescriptorMap = {
  [s: string]: PropertyDescriptor<mixed>,
  ...
};

type $NotNullOrVoid =
  | number
  | string
  | boolean
  | {...}
  | $ReadOnlyArray<mixed>;

declare type PropertyKey = string | number | symbol;

/**
 * Provides functionality common to all JavaScript objects.
 */
declare class Object {
  constructor(value?: any): Object;
  static (o: ?void): { ... };
  static (o: boolean): Boolean;
  static (o: number): Number;
  static (o: string): String;
  static <T>(o: T): T;

  /**
   * Creates an object that has the specified prototype, and that optionally contains specified properties.
   * @param o Object to use as a prototype. May be null
   * @param properties JavaScript object that contains one or more property descriptors.
   */
  // compiler magic
  static create(
    o: { ... } | null,
    properties?: PropertyDescriptorMap
  ): any;

  /**
   * Adds one or more properties to an object, and/or modifies attributes of existing properties.
   * @param o Object on which to add or modify the properties. This can be a native JavaScript object or a DOM object.
   * @param properties JavaScript object that contains one or more descriptor objects. Each descriptor object describes a data property or an accessor property.
   */
  static defineProperties(
    o: { ... },
    properties: PropertyDescriptorMap
  ): any;

  /**
   * Adds a property to an object, or modifies attributes of an existing property.
   * @param o Object on which to add or modify the property. This can be a native JavaScript object (that is, a user-defined object or a built in object) or a DOM object.
   * @param p The property name.
   * @param attributes Descriptor for the property. It can be for a data property or an accessor property.
   */
  static defineProperty<T>(
    o: { ... },
    p: PropertyKey,
    attributes: PropertyDescriptor<T>
  ): any;

  /**
   * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.
   * @param o Object on which to lock the attributes.
   */
  static freeze<T>(a: T[]): $ReadOnlyArray<T>;

  /**
   * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.
   * @param o Object on which to lock the attributes.
   */
  static freeze<T: {[[call]]: any, ...}>(f: T): T;

  /**
   * Prevents the modification of existing property attributes and values, and prevents the addition of new properties.
   * @param o Object on which to lock the attributes.
   */
  static freeze<T: { ... }>(o: T): $ReadOnly<T>;

  /**
   * Gets the own property descriptor of the specified object.
   * An own property descriptor is one that is defined directly on the object and is not inherited from the object's prototype.
   * @param o Object that contains the property.
   * @param p Name of the property.
   */
  static getOwnPropertyDescriptor<O: { ... }, K: $Keys<O>>(
    o: O,
    p: K
  ): PropertyDescriptor<$ElementType<O, K>> | void;

  /**
   * Returns the names of the own properties of an object. The own properties of an object are those that are defined directly
   * on that object, and are not inherited from the object's prototype. The properties of an object include both fields (objects) and functions.
   * @param o Object that contains the own properties.
   */
  // This is documentation only. Object.getOwnPropertyNames is implemented in OCaml code
  // https://github.com/facebook/flow/blob/8ac01bc604a6827e6ee9a71b197bb974f8080049/src/typing/statement.ml#L6308
  static getOwnPropertyNames(o: $NotNullOrVoid): Array<string>;

  /**
   * Returns the prototype of an object.
   * @param o The object that references the prototype.
   */
  // magic
  static getPrototypeOf: Object$GetPrototypeOf;

  /**
   * Returns a value that indicates whether new properties can be added to an object.
   * @param o Object to test.
   */
  static isExtensible(o: $NotNullOrVoid): boolean;

  /**
   * Returns true if existing property attributes and values cannot be modified in an object, and new properties cannot be added to the object.
   * @param o Object to test.
   */
  static isFrozen(o: $NotNullOrVoid): boolean;

  /**
   * Returns true if existing property attributes cannot be modified in an object and new properties cannot be added to the object.
   * @param o Object to test.
   */
  static isSealed(o: $NotNullOrVoid): boolean;

  /**
   * Returns the names of the enumerable string properties and methods of an object.
   * @param o Object that contains the properties and methods. This can be an object that you created or an existing Document Object Model (DOM) object.
   */
  // This is documentation only. Object.keys is implemented in OCaml code.
  // https://github.com/facebook/flow/blob/8ac01bc604a6827e6ee9a71b197bb974f8080049/src/typing/statement.ml#L6308
  static keys(o: { ... }): Array<string>;

  /**
   * Prevents the modification of attributes of existing properties, and prevents the addition of new properties.
   * @param o Object on which to lock the attributes.
   */
  static seal<T>(o: T): T;

  /**
   * Prevents the addition of new properties to an object.
   * @param o Object to make non-extensible.
   */
  static preventExtensions<T: { ... }>(o: T): T;

  /**
   * Determines whether an object has a property with the specified name.
   * @param v A property name.
   */
  hasOwnProperty(v: PropertyKey): boolean;

  /**
   * Determines whether an object exists in another object's prototype chain.
   * @param v Another object whose prototype chain is to be checked.
   */
  isPrototypeOf(v: $NotNullOrVoid): boolean;

  /**
   * Determines whether a specified property is enumerable.
   * @param v A property name.
   */
  propertyIsEnumerable(v: PropertyKey): boolean;

  /**
   * Returns a date converted to a string using the current locale.
   */
  toLocaleString(): string;

  /**
   * Returns a string representation of an object.
   */
  toString(): string;

  /**
   * Returns the primitive value of the specified object.
   */
  valueOf(): mixed;
}

declare interface Symbol {
  /**
   * Returns a string representation of an object.
   */
  toString(): string;

  /**
   * Returns the primitive value of the specified object.
   */
  valueOf(): ?symbol;
}

// TODO: instance, static
declare class Function {
  proto apply: Function$Prototype$Apply; // (thisArg: any, argArray?: any) => any
  proto bind: Function$Prototype$Bind; // (thisArg: any, ...argArray: Array<any>) => any;
  proto call: Function$Prototype$Call; // (thisArg: any, ...argArray: Array<any>) => any
  toString(): string;
  arguments: any;
  caller: any | null;
  length: number;
  name: string;
}

declare class Boolean {
  constructor(value?: mixed): Boolean;
  static (value?: mixed): boolean;

  /**
   * Returns the primitive value of the specified object.
   */
  valueOf(): boolean;
  toString(): string;
}

/**
 * An object that represents a number of any kind. All JavaScript numbers are 64-bit floating-point numbers.
 */
declare class Number {
  /**
   * The largest number that can be represented in JavaScript. Equal to approximately 1.79E+308.
   */
  static +MAX_VALUE: number;

  /**
   * The closest number to zero that can be represented in JavaScript. Equal to approximately 5.00E-324.
   */
  static +MIN_VALUE: number;

  /**
   * A value that is not a number.
   * In equality comparisons, NaN does not equal any value, including itself. To test whether a value is equivalent to NaN, use the isNaN function.
   */
  static +NaN: number;

  /**
   * A value that is less than the largest negative number that can be represented in JavaScript.
   * JavaScript displays NEGATIVE_INFINITY values as -infinity.
   */
  static +NEGATIVE_INFINITY: number;

  /**
   * A value greater than the largest number that can be represented in JavaScript.
   * JavaScript displays POSITIVE_INFINITY values as infinity.
   */
  static +POSITIVE_INFINITY: number;

  static (value?: mixed): number;
  constructor(value?: mixed): Number;

  /**
   * Returns a string containing a number represented in exponential notation.
   * @param fractionDigits Number of digits after the decimal point. Must be in the range 0 - 20, inclusive.
   */
  toExponential(fractionDigits?: number): string;

  /**
   * Returns a string representing a number in fixed-point notation.
   * @param fractionDigits Number of digits after the decimal point. Must be in the range 0 - 20, inclusive.
   */
  toFixed(fractionDigits?: number): string;

  /**
   * Converts a number to a string by using the current or specified locale.
   * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.
   * @param options An object that contains one or more properties that specify comparison options.
   */
  toLocaleString(
    locales?: string | Array<string>,
    options?: Intl$NumberFormatOptions
  ): string;

  /**
   * Returns a string containing a number represented either in exponential or fixed-point notation with a specified number of digits.
   * @param precision Number of significant digits. Must be in the range 1 - 21, inclusive.
   */
  toPrecision(precision?: number): string;

  /**
   * Returns a string representation of an object.
   * @param radix Specifies a radix for converting numeric values to strings. This value is only used for numbers.
   */
  toString(radix?: number): string;

  /**
   * Returns the primitive value of the specified object.
   */
  valueOf(): number;
}

/**
 * An intrinsic object that provides basic mathematics functionality and constants.
 */
declare var Math: {
  /**
   * The mathematical constant e. This is Euler's number, the base of natural logarithms.
   */
    +E: number;

  /**
   * The natural logarithm of 10.
   */
    +LN10: number;

  /**
   * The natural logarithm of 2.
   */
    +LN2: number;

  /**
   * The base-2 logarithm of e.
   */
    +LOG2E: number;

  /**
   * The base-10 logarithm of e.
   */
    +LOG10E: number;

  /**
   * Pi. This is the ratio of the circumference of a circle to its diameter.
   */
    +PI: number;

  /**
   * The square root of 0.5, or, equivalently, one divided by the square root of 2.
   */
    +SQRT1_2: number;

  /**
   * The square root of 2.
   */
    +SQRT2: number;

  /**
   * Returns the absolute value of a number (the value without regard to whether it is positive or negative).
   * For example, the absolute value of -5 is the same as the absolute value of 5.
   * @param x A numeric expression for which the absolute value is needed.
   */
  abs(x: number): number;

  /**
   * Returns the arc cosine (or inverse cosine) of a number.
   * @param x A numeric expression.
   */
  acos(x: number): number;

  /**
   * Returns the arcsine of a number.
   * @param x A numeric expression.
   */
  asin(x: number): number;

  /**
   * Returns the arctangent of a number.
   * @param x A numeric expression for which the arctangent is needed.
   */
  atan(x: number): number;

  /**
   * Returns the angle (in radians) from the X axis to a point.
   * @param y A numeric expression representing the cartesian y-coordinate.
   * @param x A numeric expression representing the cartesian x-coordinate.
   */
  atan2(y: number, x: number): number;

  /**
   * Returns the smallest integer greater than or equal to its numeric argument.
   * @param x A numeric expression.
   */
  ceil(x: number): number;

  /**
   * Returns the cosine of a number.
   * @param x A numeric expression that contains an angle measured in radians.
   */
  cos(x: number): number;

  /**
   * Returns e (the base of natural logarithms) raised to a power.
   * @param x A numeric expression representing the power of e.
   */
  exp(x: number): number;

  /**
   * Returns the greatest integer less than or equal to its numeric argument.
   * @param x A numeric expression.
   */
  floor(x: number): number;

  /**
   * Returns the natural logarithm (base e) of a number.
   * @param x A numeric expression.
   */
  log(x: number): number;

  /**
   * Returns the larger of a set of supplied numeric expressions.
   * @param values Numeric expressions to be evaluated.
   */
  max(...values: number[]): number;

  /**
   * Returns the smaller of a set of supplied numeric expressions.
   * @param values Numeric expressions to be evaluated.
   */
  min(...values: number[]): number;

  /**
   * Returns the value of a base expression taken to a specified power.
   * @param x The base value of the expression.
   * @param y The exponent value of the expression.
   */
  pow(x: number, y: number): number;

  /**
   * Returns a pseudorandom number between 0 and 1.
   */
  random(): number;

  /**
   * Returns a supplied numeric expression rounded to the nearest integer.
   * @param x The value to be rounded to the nearest integer.
   */
  round(x: number): number;

  /**
   * Returns the sine of a number.
   * @param x A numeric expression that contains an angle measured in radians.
   */
  sin(x: number): number;

  /**
   * Returns the square root of a number.
   * @param x A numeric expression.
   */
  sqrt(x: number): number;

  /**
   * Returns the tangent of a number.
   * @param x A numeric expression that contains an angle measured in radians.
   */
  tan(x: number): number;
  ...
};

/**
 * All the Array.prototype methods and properties that don't mutate the array.
 */
declare class $ReadOnlyArray<+T> {
  /**
   * Returns a string representation of an array. The elements are converted to string using their toLocalString methods.
   */
  toLocaleString(): string;

  /**
   * Combines two or more arrays.
   * @param items Additional items to add to the end of array1.
   */
  concat<S, Item: $ReadOnlyArray<S> | S>(...items: Array<Item>): Array<T | S>;

  /**
   * Determines whether all the members of an array satisfy the specified test.
   * @param callbackfn A function that accepts up to three arguments. The every method calls
   * the callbackfn function for each element in the array until the callbackfn returns a value
   * which is coercible to the Boolean value false, or until the end of the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function.
   * If thisArg is omitted, undefined is used as the this value.
   */
  every(
    callbackfn: (value: T, index: number, array: $ReadOnlyArray<T>) => boolean,
    thisArg?: any
  ): boolean;

  /**
   * Returns the elements of an array that meet the condition specified in a callback function.
   * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
   */
  filter(callbackfn: typeof Boolean): Array<$NonMaybeType<T>>;  // special case for the function "Boolean"
  filter(
    callbackfn: (value: T, index: number, array: $ReadOnlyArray<T>) => boolean,
    thisArg?: any
  ): Array<T>;

  /**
   * Performs the specified action for each element in an array.
   * @param callbackfn A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
   */
  forEach(
    callbackfn: (value: T, index: number, array: $ReadOnlyArray<T>) => void,
    thisArg?: any
  ): void;

  /**
   * Returns the index of the first occurrence of a value in an array.
   * @param searchElement The value to locate in the array.
   * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at index 0.
   */
  indexOf(searchElement: T, fromIndex?: number): number;

  /**
   * Adds all the elements of an array separated by the specified separator string.
   * @param separator A string used to separate one element of an array from the next in the resulting String. If omitted, the array elements are separated with a comma.
   */
  join(separator?: string): string;

  /**
   * Returns the index of the last occurrence of a specified value in an array.
   * @param searchElement The value to locate in the array.
   * @param fromIndex The array index at which to begin the search. If fromIndex is omitted, the search starts at the last index in the array.
   */
  lastIndexOf(searchElement: T, fromIndex?: number): number;

  /**
   * Calls a defined callback function on each element of an array, and returns an array that contains the results.
   * @param callbackfn A function that accepts up to three arguments. The map method calls the callbackfn function one time for each element in the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
   */
  map<U>(
    callbackfn: (value: T, index: number, array: $ReadOnlyArray<T>) => U,
    thisArg?: any
  ): Array<U>;

  /**
   * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.
   * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.
   */
  reduce(
    callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: $ReadOnlyArray<T>) => T,
  ): T;

  /**
   * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.
   * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.
   * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.
   */
  reduce<U>(
    callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: $ReadOnlyArray<T>) => U,
    initialValue: U
  ): U;

  /**
   * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.
   * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.
   */
  reduceRight(
    callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: $ReadOnlyArray<T>) => T,
  ): T;

  /**
   * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.
   * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.
   * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.
   */
  reduceRight<U>(
    callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: $ReadOnlyArray<T>) => U,
    initialValue: U
  ): U;

  /**
   * Returns a section of an array.
   * @param start The beginning of the specified portion of the array.
   * @param end The end of the specified portion of the array. This is exclusive of the element at the index 'end'.
   */
  slice(start?: number, end?: number): Array<T>;

  /**
   * Determines whether the specified callback function returns true for any element of an array.
   * @param callbackfn A function that accepts up to three arguments. The some method calls
   * the callbackfn function for each element in the array until the callbackfn returns a value
   * which is coercible to the Boolean value true, or until the end of the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function.
   * If thisArg is omitted, undefined is used as the this value.
   */
  some(
    callbackfn: (value: T, index: number, array: $ReadOnlyArray<T>) => boolean,
    thisArg?: any
  ): boolean;

    +[key: number]: T;

  /**
   * Returns a string representation of an array.
   */
  toString(): string;

  /**
   * Gets the length of the array. This is a number one higher than the highest element defined in an array.
   */
    +length: number;
}

declare class Array<T> extends $ReadOnlyArray<T> {
  /**
   * Determines whether all the members of an array satisfy the specified test.
   * @param callbackfn A function that accepts up to three arguments. The every method calls
   * the callbackfn function for each element in the array until the callbackfn returns a value
   * which is coercible to the Boolean value false, or until the end of the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function.
   * If thisArg is omitted, undefined is used as the this value.
   */
  every(
    callbackfn: (value: T, index: number, array: Array<T>) => boolean,
    thisArg?: any
  ): boolean;

  /**
   * Returns the elements of an array that meet the condition specified in a callback function.
   * @param callbackfn A function that accepts up to three arguments. The filter method calls the callbackfn function one time for each element in the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
   */
  filter(
    callbackfn: (value: T, index: number, array: Array<T>) => boolean,
    thisArg?: any
  ): Array<T>;

  /**
   * Performs the specified action for each element in an array.
   * @param callbackfn A function that accepts up to three arguments. forEach calls the callbackfn function one time for each element in the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
   */
  forEach(
    callbackfn: (value: T, index: number, array: Array<T>) => void,
    thisArg?: any
  ): void;

  /**
   * Calls a defined callback function on each element of an array, and returns an array that contains the results.
   * @param callbackfn A function that accepts up to three arguments. The map method calls the callbackfn function one time for each element in the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function. If thisArg is omitted, undefined is used as the this value.
   */
  map<U>(
    callbackfn: (value: T, index: number, array: Array<T>) => U,
    thisArg?: any
  ): Array<U>;

  /**
   * Removes the last element from an array and returns it.
   */
  pop(): T;

  /**
   * Appends new elements to an array, and returns the new length of the array.
   * @param items New elements of the Array.
   */
  push(...items: Array<T>): number;

  /**
   * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.
   * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.
   */
  reduce(
    callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: Array<T>) => T,
  ): T;

  /**
   * Calls the specified callback function for all the elements in an array. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.
   * @param callbackfn A function that accepts up to four arguments. The reduce method calls the callbackfn function one time for each element in the array.
   * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.
   */
  reduce<U>(
    callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: Array<T>) => U,
    initialValue: U
  ): U;

  /**
   * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.
   * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.
   */
  reduceRight(
    callbackfn: (previousValue: T, currentValue: T, currentIndex: number, array: Array<T>) => T,
  ): T;

  /**
   * Calls the specified callback function for all the elements in an array, in descending order. The return value of the callback function is the accumulated result, and is provided as an argument in the next call to the callback function.
   * @param callbackfn A function that accepts up to four arguments. The reduceRight method calls the callbackfn function one time for each element in the array.
   * @param initialValue If initialValue is specified, it is used as the initial value to start the accumulation. The first call to the callbackfn function provides this value as an argument instead of an array value.
   */
  reduceRight<U>(
    callbackfn: (previousValue: U, currentValue: T, currentIndex: number, array: Array<T>) => U,
    initialValue: U
  ): U;

  /**
   * Reverses the elements in an Array.
   */
  reverse(): Array<T>;

  /**
   * Removes the first element from an array and returns it.
   */
  shift(): T;

  /**
   * Determines whether the specified callback function returns true for any element of an array.
   * @param callbackfn A function that accepts up to three arguments. The some method calls
   * the callbackfn function for each element in the array until the callbackfn returns a value
   * which is coercible to the Boolean value true, or until the end of the array.
   * @param thisArg An object to which the this keyword can refer in the callbackfn function.
   * If thisArg is omitted, undefined is used as the this value.
   */
  some(
    callbackfn: (value: T, index: number, array: Array<T>) => boolean,
    thisArg?: any
  ): boolean;

  /**
   * Sorts an array.
   * @param compareFn Function used to determine the order of the elements. It is expected to return
   * a negative value if first argument is less than second argument, zero if they're equal and a positive
   * value otherwise. If omitted, the elements are sorted in ascending, ASCII character order.
   * ```ts
   * [11,2,22,1].sort((a, b) => a - b)
   * ```
   */
  sort(compareFn?: (a: T, b: T) => number): Array<T>;

  /**
   * Removes elements from an array and, if necessary, inserts new elements in their place, returning the deleted elements.
   * @param start The zero-based location in the array from which to start removing elements.
   * @param deleteCount The number of elements to remove.
   * @param items Elements to insert into the array in place of the deleted elements.
   */
  splice(start: number, deleteCount: number, ...items: Array<T>): Array<T>;

  /**
   * Inserts new elements at the start of an array.
   * @param items Elements to insert at the start of the Array.
   */
  unshift(...items: Array<T>): number;

  [key: number]: T;

  /**
   * Gets or sets the length of the array. This is a number one higher than the highest element defined in an array.
   */
  length: number;

  static (length: number): Array<T>;
  static <U>(...values:Array<U>): Array<U>;

  static isArray(arg: mixed): boolean;
}

type $ArrayLike<T> = {
  [indexer: number]: T,
  length: number,
  ...
}

type RegExp$flags = $CharSet<"gimsuy">;
type RegExp$matchResult = Array<string> & {
  index?: number,
  input?: string,
  ...
};

/**
 * Allows manipulation and formatting of text strings and determination and location of substrings within strings.
 */
declare class String {
  /**
   * Returns the character at the specified index.
   * @param pos The zero-based index of the desired character.
   */
  charAt(pos: number): string;

  /**
   * Returns the Unicode value of the character at the specified location.
   * @param index The zero-based index of the desired character. If there is no character at the specified index, NaN is returned.
   */
  charCodeAt(index: number): number;

  /**
   * Returns a string that contains the concatenation of two or more strings.
   * @param strings The strings to append to the end of the string.
   */
  concat(...strings: Array<string>): string;

  constructor(value?: mixed): String;

  /**
   * Returns the position of the first occurrence of a substring.
   * @param searchString The substring to search for in the string
   * @param position The index at which to begin searching the String object. If omitted, search starts at the beginning of the string.
   */
  indexOf(searchString: string, position?: number): number;

  /**
   * Returns the last occurrence of a substring in the string.
   * @param searchString The substring to search for.
   * @param position The index at which to begin searching. If omitted, the search begins at the end of the string.
   */
  lastIndexOf(searchString: string, position?: number): number;

  /**
   * Determines whether two strings are equivalent in the current locale.
   * @param that String to compare to target string
   */
  localeCompare(that: string): number;

  /**
   * Determines whether two strings are equivalent in the current or specified locale.
   * @param that String to compare to target string
   * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used. This parameter must conform to BCP 47 standards; see the Intl.Collator object for details.
   * @param options An object that contains one or more properties that specify comparison options. see the Intl.Collator object for details.
   */
  localeCompare(
    that: string,
    locales?: string | Array<string>,
    options?: Intl$CollatorOptions
  ): number;

  /**
   * Matches a string with a regular expression, and returns an array containing the results of that search.
   * @param regexp A variable name or string literal containing the regular expression pattern and flags.
   */
  match(regexp: string | RegExp): RegExp$matchResult | null;

  /**
   * Replaces text in a string, using a regular expression or search string.
   * @param searchValue A string to search for.
   * @param replaceValue A string containing the text to replace for every successful match of searchValue in this string.
   */
  replace(searchValue: string | RegExp, replaceValue: string): string;

  /**
   * Replaces text in a string, using a regular expression or search string.
   * @param searchValue A string to search for.
   * @param replacer A function that returns the replacement text.
   */
  replace(
    searchValue: string | RegExp,
    replacer: (substring: string, ...args: Array<any>) => string
  ): string;

  /**
   * Finds the first substring match in a regular expression search.
   * @param regexp The regular expression pattern and applicable flags.
   */
  search(regexp: string | RegExp): number;

  /**
   * Returns a section of a string.
   * @param start The index to the beginning of the specified portion of stringObj.
   * @param end The index to the end of the specified portion of stringObj. The substring includes the characters up to, but not including, the character indicated by end.
   * If this value is not specified, the substring continues to the end of stringObj.
   */
  slice(start?: number, end?: number): string;

  /**
   * Split a string into substrings using the specified separator and return them as an array.
   * @param separator A string that identifies character or characters to use in separating the string. If omitted, a single-element array containing the entire string is returned.
   * @param limit A value used to limit the number of elements returned in the array.
   */
  split(separator: string | RegExp, limit?: number): Array<string>;

  /**
   * Gets a substring beginning at the specified location and having the specified length.
   * @param from The starting position of the desired substring. The index of the first character in the string is zero.
   * @param length The number of characters to include in the returned substring.
   */
  substr(from: number, length?: number): string;

  /**
   * Returns the substring at the specified location within a String object.
   * @param start The zero-based index number indicating the beginning of the substring.
   * @param end Zero-based index number indicating the end of the substring. The substring includes the characters up to, but not including, the character indicated by end.
   * If end is omitted, the characters from start through the end of the original string are returned.
   */
  substring(start: number, end?: number): string;

  /**
   * Converts all alphabetic characters to lowercase, taking into account the host environment's current locale.
   */
  toLocaleLowerCase(locale?: string | Array<string>): string;

  /**
   * Returns a string where all alphabetic characters have been converted to uppercase, taking into account the host environment's current locale.
   */
  toLocaleUpperCase(locale?: string | Array<string>): string;

  /**
   * Converts all the alphabetic characters in a string to lowercase.
   */
  toLowerCase(): string;

  /**
   * Converts all the alphabetic characters in a string to uppercase.
   */
  toUpperCase(): string;

  /**
   * Removes the leading and trailing white space and line terminator characters from a string.
   */
  trim(): string;

  /**
   * Returns the primitive value of the specified object.
   */
  valueOf(): string;

  /**
   * Returns a string representation of a string.
   */
  toString(): string;

  /**
   * Returns the length of a String object.
   */
    +length: number;

  [index: number]: string;

  static (value?: mixed): string;
  static fromCharCode(...codes: Array<number>): string;
}

declare class RegExp {
  static (pattern: RegExp): RegExp;
  static (pattern: string, flags?: RegExp$flags): RegExp;
  compile(): RegExp;
  constructor(pattern: RegExp): RegExp;
  constructor(pattern: string, flags?: RegExp$flags): RegExp;
  static lastMatch: string;

  /**
   * Executes a search on a string using a regular expression pattern, and returns an array containing the results of that search.
   * @param string The String object or string literal on which to perform the search.
   */
  exec(string: string): RegExp$matchResult | null;

  /**
   * Returns a Boolean value indicating the state of the global flag (g) used with a regular expression. Default is false. Read-only.
   */
    +global: boolean;

  /**
   * Returns a Boolean value indicating the state of the ignoreCase flag (i) used with a regular expression. Default is false. Read-only.
   */
    +ignoreCase: boolean;

  lastIndex: number;

  /**
   * Returns a Boolean value indicating the state of the multiline flag (m) used with a regular expression. Default is false. Read-only.
   */
    +multiline: boolean;

  /**
   * Returns a copy of the text of the regular expression pattern. Read-only. The regExp argument is a Regular expression object. It can be a variable name or a literal.
   */
  +source: string;

  /**
   * Returns a Boolean value that indicates whether or not a pattern exists in a searched string.
   * @param string String on which to perform the search.
   */
  test(string: string): boolean;
}

/**
 * Enables basic storage and retrieval of dates and times.
 */
declare class Date {
  constructor(): Date;
  constructor(timestamp: number): Date;
  constructor(date: Date): Date;
  constructor(dateString: string): Date;
  constructor(
    year: number,
    month: number,
    day?: number,
    hours?: number,
    minutes?: number,
    seconds?: number,
    ms?: number
  ): Date;

  /**
   * Gets the day-of-the-month, using local time.
   */
  getDate(): number;

  /**
   * Gets the day of the week, using local time.
   */
  getDay(): number;

  /**
   * Gets the year, using local time.
   */
  getFullYear(): number;

  /**
   * Gets the hours in a date, using local time.
   */
  getHours(): number;

  /**
   * Gets the milliseconds of a Date, using local time.
   */
  getMilliseconds(): number;

  /**
   * Gets the minutes of a Date object, using local time.
   */
  getMinutes(): number;

  /**
   * Gets the month, using local time.
   */
  getMonth(): number;

  /**
   * Gets the seconds of a Date object, using local time.
   */
  getSeconds(): number;

  /**
   * Gets the time value in milliseconds.
   */
  getTime(): number;

  /**
   * Gets the difference in minutes between the time on the local computer and Universal Coordinated Time (UTC).
   */
  getTimezoneOffset(): number;

  /**
   * Gets the day-of-the-month, using Universal Coordinated Time (UTC).
   */
  getUTCDate(): number;

  /**
   * Gets the day of the week using Universal Coordinated Time (UTC).
   */
  getUTCDay(): number;

  /**
   * Gets the year using Universal Coordinated Time (UTC).
   */
  getUTCFullYear(): number;

  /**
   * Gets the hours value in a Date object using Universal Coordinated Time (UTC).
   */
  getUTCHours(): number;

  /**
   * Gets the milliseconds of a Date object using Universal Coordinated Time (UTC).
   */
  getUTCMilliseconds(): number;

  /**
   * Gets the minutes of a Date object using Universal Coordinated Time (UTC).
   */
  getUTCMinutes(): number;

  /**
   * Gets the month of a Date object using Universal Coordinated Time (UTC).
   */
  getUTCMonth(): number;

  /**
   * Gets the seconds of a Date object using Universal Coordinated Time (UTC).
   */
  getUTCSeconds(): number;

  /**
   * Sets the numeric day-of-the-month value of the Date object using local time.
   * @param date A numeric value equal to the day of the month.
   */
  setDate(date: number): number;

  /**
   * Sets the year of the Date object using local time.
   * @param year A numeric value for the year.
   * @param month A zero-based numeric value for the month (0 for January, 11 for December). Must be specified if numDate is specified.
   * @param date A numeric value equal for the day of the month.
   */
  setFullYear(year: number, month?: number, date?: number): number;

  /**
   * Sets the hour value in the Date object using local time.
   * @param hours A numeric value equal to the hours value.
   * @param min A numeric value equal to the minutes value.
   * @param sec A numeric value equal to the seconds value.
   * @param ms A numeric value equal to the milliseconds value.
   */
  setHours(hours: number, min?: number, sec?: number, ms?: number): number;

  /**
   * Sets the milliseconds value in the Date object using local time.
   * @param ms A numeric value equal to the millisecond value.
   */
  setMilliseconds(ms: number): number;

  /**
   * Sets the minutes value in the Date object using local time.
   * @param min A numeric value equal to the minutes value.
   * @param sec A numeric value equal to the seconds value.
   * @param ms A numeric value equal to the milliseconds value.
   */
  setMinutes(min: number, sec?: number, ms?: number): number;

  /**
   * Sets the month value in the Date object using local time.
   * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively.
   * @param date A numeric value representing the day of the month. If this value is not supplied, the value from a call to the getDate method is used.
   */
  setMonth(month: number, date?: number): number;

  /**
   * Sets the seconds value in the Date object using local time.
   * @param sec A numeric value equal to the seconds value.
   * @param ms A numeric value equal to the milliseconds value.
   */
  setSeconds(sec: number, ms?: number): number;

  /**
   * Sets the date and time value in the Date object.
   * @param time A numeric value representing the number of elapsed milliseconds since midnight, January 1, 1970 GMT.
   */
  setTime(time: number): number;

  /**
   * Sets the numeric day of the month in the Date object using Universal Coordinated Time (UTC).
   * @param date A numeric value equal to the day of the month.
   */
  setUTCDate(date: number): number;

  /**
   * Sets the year value in the Date object using Universal Coordinated Time (UTC).
   * @param year A numeric value equal to the year.
   * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively. Must be supplied if numDate is supplied.
   * @param date A numeric value equal to the day of the month.
   */
  setUTCFullYear(year: number, month?: number, date?: number): number;

  /**
   * Sets the hours value in the Date object using Universal Coordinated Time (UTC).
   * @param hours A numeric value equal to the hours value.
   * @param min A numeric value equal to the minutes value.
   * @param sec A numeric value equal to the seconds value.
   * @param ms A numeric value equal to the milliseconds value.
   */
  setUTCHours(hours: number, min?: number, sec?: number, ms?: number): number;

  /**
   * Sets the milliseconds value in the Date object using Universal Coordinated Time (UTC).
   * @param ms A numeric value equal to the millisecond value.
   */
  setUTCMilliseconds(ms: number): number;

  /**
   * Sets the minutes value in the Date object using Universal Coordinated Time (UTC).
   * @param min A numeric value equal to the minutes value.
   * @param sec A numeric value equal to the seconds value.
   * @param ms A numeric value equal to the milliseconds value.
   */
  setUTCMinutes(min: number, sec?: number, ms?: number): number;

  /**
   * Sets the month value in the Date object using Universal Coordinated Time (UTC).
   * @param month A numeric value equal to the month. The value for January is 0, and other month values follow consecutively.
   * @param date A numeric value representing the day of the month. If it is not supplied, the value from a call to the getUTCDate method is used.
   */
  setUTCMonth(month: number, date?: number): number;

  /**
   * Sets the seconds value in the Date object using Universal Coordinated Time (UTC).
   * @param sec A numeric value equal to the seconds value.
   * @param ms A numeric value equal to the milliseconds value.
   */
  setUTCSeconds(sec: number, ms?: number): number;

  /**
   * Returns a string representation of a date. The format of the string depends on the locale.
   */
  toString(): string;

  /**
   * Returns a date as a string value.
   */
  toDateString(): string;

  /**
   * Returns a date as a string value in ISO format.
   */
  toISOString(): string;

  /**
   * Used by the JSON.stringify method to enable the transformation of an object's data for JavaScript Object Notation (JSON) serialization.
   */
  toJSON(key?: any): string;

  /**
   * Returns a date as a string value appropriate to the host environment's current locale.
   */
  toLocaleDateString(): string;

  /**
   * Converts a date to a string by using the current or specified locale.
   * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.
   * @param options An object that contains one or more properties that specify comparison options.
   */
  toLocaleDateString(
    locales?: string | Array<string>,
    options?: Intl$DateTimeFormatOptions
  ): string;

  /**
   * Returns a value as a string value appropriate to the host environment's current locale.
   */
  toLocaleString(): string;

  /**
   * Converts a date and time to a string by using the current or specified locale.
   * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.
   * @param options An object that contains one or more properties that specify comparison options.
   */
  toLocaleString(
    locales?: string | Array<string>,
    options?: Intl$DateTimeFormatOptions
  ): string;

  /**
   * Returns a time as a string value appropriate to the host environment's current locale.
   */
  toLocaleTimeString(): string;

  /**
   * Converts a time to a string by using the current or specified locale.
   * @param locales A locale string or array of locale strings that contain one or more language or locale tags. If you include more than one locale string, list them in descending order of priority so that the first entry is the preferred locale. If you omit this parameter, the default locale of the JavaScript runtime is used.
   * @param options An object that contains one or more properties that specify comparison options.
   */
  toLocaleTimeString(
    locales?: string | Array<string>,
    options?: Intl$DateTimeFormatOptions
  ): string;

  /**
   * Returns a time as a string value.
   */
  toTimeString(): string;

  /**
   * Returns a date converted to a string using Universal Coordinated Time (UTC).
   */
  toUTCString(): string;

  /**
   * Returns the stored time value in milliseconds since midnight, January 1, 1970 UTC.
   */
  valueOf(): number;

  static (): string;
  static now(): number;

  /**
   * Parses a string containing a date, and returns the number of milliseconds between that date and midnight, January 1, 1970.
   * @param s A date string
   */
  static parse(s: string): number;

  /**
   * Returns the number of milliseconds between midnight, January 1, 1970 Universal Coordinated Time (UTC) (or GMT) and the specified date.
   * @param year The full year designation is required for cross-century date accuracy. If year is between 0 and 99 is used, then year is assumed to be 1900 + year.
   * @param month The month as a number between 0 and 11 (January to December).
   * @param date The date as a number between 1 and 31.
   * @param hours Must be supplied if minutes is supplied. A number from 0 to 23 (midnight to 11pm) that specifies the hour.
   * @param minutes Must be supplied if seconds is supplied. A number from 0 to 59 that specifies the minutes.
   * @param seconds Must be supplied if milliseconds is supplied. A number from 0 to 59 that specifies the seconds.
   * @param ms A number from 0 to 999 that specifies the milliseconds.
   */
  static UTC(
    year: number,
    month: number,
    date?: number,
    hours?: number,
    minutes?: number,
    seconds?: number,
    ms?: number
  ): number;
}

declare class Error {
  static (message?: mixed): Error;
  constructor(message?: mixed): Error;

  name: string;
  message: string;
  stack?: string;
}

declare class EvalError extends Error {
  static (message?: mixed): EvalError;
}

declare class RangeError extends Error {
  static (message?: mixed): RangeError;
}

declare class ReferenceError extends Error {
  static (message?: mixed): ReferenceError;
}

declare class SyntaxError extends Error {
  static (message?: mixed): SyntaxError;
}

declare class TypeError extends Error {
  static (message?: mixed): TypeError;
}

declare class URIError extends Error {
  static (message?: mixed): URIError;
}

/**
 * An intrinsic object that provides functions to convert JavaScript values to and from the JavaScript Object Notation (JSON) format.
 */
declare class JSON {
  /**
   * Converts a JavaScript Object Notation (JSON) string into an object.
   * @param text A valid JSON string.
   * @param reviver A function that transforms the results. This function is called for each member of the object.
   * If a member contains nested objects, the nested objects are transformed before the parent object is.
   */
  static parse(text: string, reviver?: (key: string, value: mixed) => any): any;

  /**
   * Converts a JavaScript value to a JavaScript Object Notation (JSON) string.
   * @param value A JavaScript value, usually an object or array, to be converted.
   * @param replacer A function that transforms the results.
   * @param space Adds indentation, white space, and line break characters to the return-value JSON text to make it easier to read.
   */
  static stringify(
    value: null | string | number | boolean | {...} | $ReadOnlyArray<mixed>,
    replacer?: (key: string, value: mixed) => any,
    space?: string | number
  ): string;

  /**
   * Converts a JavaScript value to a JavaScript Object Notation (JSON) string.
   * @param value A JavaScript value, usually an object or array, to be converted.
   * @param replacer An array of strings and numbers that acts as a approved list for selecting the object properties that will be stringified.
   * @param space Adds indentation, white space, and line break characters to the return-value JSON text to make it easier to read.
   */
  static stringify(
    value: null | string | number | boolean | {...} | $ReadOnlyArray<mixed>,
    replacer?: ?Array<number | string>,
    space?: string | number
  ): string;

  // avoids massive breaking changes
  static stringify(
    value: mixed,
    replacer?: ?((key: string, value: any) => any) | Array<any>,
    space?: string | number
  ): string | void;
}

/**
 * Represents the completion of an asynchronous operation
 */
declare class Promise<+R> {
  constructor(callback: (
    resolve: (result: Promise<R> | R) => void,
    reject: (error: any) => void
  ) => void): void;

  /**
   * Attaches callbacks for the resolution and/or rejection of the Promise.
   * @param onfulfilled The callback to execute when the Promise is resolved.
   * @param onrejected The callback to execute when the Promise is rejected.
   * @returns A Promise for the completion of which ever callback is executed.
   */
  then(onFulfill: null | void, onReject: null | void): Promise<R>;
  then<U>(
    onFulfill: null | void,
    onReject: (error: any) => Promise<U> | U
  ): Promise<R | U>;
  then<U>(
    onFulfill: (value: R) => Promise<U> | U,
    onReject: null | void | ((error: any) => Promise<U> | U)
  ): Promise<U>;

  /**
   * Attaches a callback for only the rejection of the Promise.
   * @param onrejected The callback to execute when the Promise is rejected.
   * @returns A Promise for the completion of the callback.
   */
  catch(onReject: null | void): Promise<R>;
  catch<U>(
    onReject: (error: any) => Promise<U> | U
  ): Promise<R | U>;
}

/**
 * Computes a new string in which certain characters have been replaced by a hexadecimal escape sequence.
 * @param string A string value
 */
declare function escape(str: string): string;

/**
 * Computes a new string in which hexadecimal escape sequences are replaced with the character that it represents.
 * @param string A string value
 */
declare function unescape(str: string): string;
