package flipt.authz.v1

import data
import rego.v1

default allow = false

allow if {
	flipt.is_auth_method(input, "jwt")
	some rule in has_rules

	permit_string(rule.resource, input.request.resource)
	permit_slice(rule.actions, input.request.action)
	permit_string(rule.namespace, input.request.namespace)
}

allow if {
	flipt.is_auth_method(input, "jwt")
	some rule in has_rules

	permit_string(rule.resource, input.request.resource)
	permit_slice(rule.actions, input.request.action)
	not rule.namespace
}

has_rules contains rules if {
	some role in data.roles
	role.name == input.authentication.metadata["io.flipt.auth.role"]
	rules := role.rules[_]
}

permit_string(allowed, _) if {
	allowed == "*"
}

permit_string(allowed, requested) if {
	allowed == requested
}

permit_slice(allowed, _) if {
	allowed[_] = "*"
}

permit_slice(allowed, requested) if {
	allowed[_] = requested
}
