package config

import (
	"errors"
	"fmt"
)

const fieldErrFmt = "field %q: %w"

var (
	// errValidationRequired is returned when a required value is
	// either not supplied or supplied with empty value.
	errValidationRequired = errors.New("non-empty value is required")
	// errPositiveNonZeroDuration is returned when a negative or zero time.Duration is provided.
	errPositiveNonZeroDuration = errors.New("positive non-zero duration required")
)

func errFieldWrap(field string, err error) error {
	return fmt.Errorf(fieldErrFmt, field, err)
}

func errFieldRequired(field string) error {
	return errFieldWrap(field, errValidationRequired)
}
