const commonClasses = {

  // Icons and Misc
  iconsSize: 'w-5 h-5',
  disabled: 'opacity-60 select-none cursor-not-allowed ',

  // Inputs, selects, textarea on default _old_theme
  inputsBackground: 'bg-white dark:bg-gray-900',
  inputsBackgroundDarkerOrSofter: 'bg-gray-50 dark:bg-gray-800',
  inputsText: 'text-sm',
  inputsTextColor: 'text-gray-700 dark:text-white placeholder-gray-500/60',
  inputsBorder: 'border-0',
  inputsSpacing: 'px-4 py-3',
  inputsShadows: 'shadow',
  inputsRing: 'ring-gray-300 focus:ring-primary-600 dark:ring-white/20 dark:focus:ring-primary-600 focus-visible:ring-primary-600',
  inputsRingBase: 'ring-1 ring-inset focus:ring-inset focus:ring-2',

  inputsDisabled: 'disabled:opacity-50 disabled:cursor-not-allowed',
  inputsAutofill: '!autofill:bg-white !dark:autofill:bg-gray-900',

  inputsRadius: 'rounded-lg',
  inputsRadiusTop: 'rounded-none rounded-t-lg',
  inputsRadiusBottom: 'rounded-none rounded-b-lg',
  inputsRadiusLeft: 'rounded-none rounded-l-lg',
  inputsRadiusRight: 'rounded-none rounded-r-lg',
  inputsRadiusTopRight: 'rounded-none rounded-tr-lg',
  inputsRadiusTopLeft: 'rounded-none rounded-tl-lg',
  inputsRadiusBottomLeft: 'rounded-none rounded-bl-lg',
  inputsRadiusBottomRight: 'rounded-none rounded-br-lg',

  inputsTransition: 'transition duration-100 ease-in-out',

  // Inputs with Errors
  inputsErrorTextColor: 'text-red-400 placeholder-red-400',
  inputsErrorsBackground: 'bg-white dark:bg-gray-900',
  inputsErrorsBorder: 'border-0',
  inputsErrorsRing: 'ring-red-400 focus:ring-red-500 dark:ring-red-400 dark:focus:ring-red-500 focus-visible:ring-red-500 dark:focus-visible:ring-red-500',

  // Buttons
  buttonRing: 'focus:outline-none focus:ring-2 dark:focus:ring-offset-gray-900',
  buttonSizing: '',
  buttonErrorsRing: 'focus:outline-none focus:ring-2 dark:focus:ring-offset-gray-900 focus:ring-red-600',

  buttonRadius: 'rounded-md',
  buttonSpacing: 'px-3 py-2',
  buttonSpacingCircle: 'p-2',
  buttonShadow: 'shadow',
  buttonText: 'text-sm font-medium whitespace-nowrap',
  buttonTransition: 'transition ease-in-out duration-15',
  buttonPosition: 'block justify-center inline-flex items-center',

  // Overlays & Dropdowns
  dropdownsBackground: 'bg-white dark:bg-gray-900',
  dropdownsShadows: 'shadow-lg',
  dropdownsRadius: 'rounded-md',
  dropdownsBorder: 'border border-1 border-gray-300 dark:border-gray-700',
  dropdownsRing: 'ring-1 ring-gray-400/50 dark:ring-white/10',
  dropdownsFocus: 'focus:outline-none focus:ring-1 dark:focus:ring-offset-gray-900',

  // Options
  optionOrItemDisabled: 'opacity-50 cursor-not-allowed',

  // Positioning
  leftTop: 'justify-start items-start',
  leftCenter: 'justify-start items-center',
  leftBottom: 'justify-start items-end',
  rightTop: 'justify-end items-start',
  rightCenter: 'justify-end items-center',
  rightBottom: 'justify-end items-end',
  centerTop: 'justify-center items-start',
  centerCenter: 'justify-center items-center',
  centerBottom: 'justify-center items-end',
}

export {
  commonClasses,
}
