import 'cross-fetch/polyfill';
import { Config, EnqueuedTaskObject } from './types';
type queryParams<T> = {
    [key in keyof T]: string;
};
declare function toQueryParams<T extends object>(parameters: T): queryParams<T>;
declare class HttpRequests {
    headers: Record<string, any>;
    url: URL;
    requestConfig?: Config['requestConfig'];
    httpClient?: Required<Config>['httpClient'];
    constructor(config: Config);
    request({ method, url, params, body, config, }: {
        method: string;
        url: string;
        params?: {
            [key: string]: any;
        };
        body?: any;
        config?: Record<string, any>;
    }): Promise<any>;
    get(url: string, params?: {
        [key: string]: any;
    }, config?: Record<string, any>): Promise<void>;
    get<T = any>(url: string, params?: {
        [key: string]: any;
    }, config?: Record<string, any>): Promise<T>;
    post<T = any, R = EnqueuedTaskObject>(url: string, data?: T, params?: {
        [key: string]: any;
    }, config?: Record<string, any>): Promise<R>;
    put<T = any, R = EnqueuedTaskObject>(url: string, data?: T, params?: {
        [key: string]: any;
    }, config?: Record<string, any>): Promise<R>;
    patch(url: string, data?: any, params?: {
        [key: string]: any;
    }, config?: Record<string, any>): Promise<any>;
    delete(url: string, data?: any, params?: {
        [key: string]: any;
    }, config?: Record<string, any>): Promise<EnqueuedTaskObject>;
    delete<T>(url: string, data?: any, params?: {
        [key: string]: any;
    }, config?: Record<string, any>): Promise<T>;
}
export { HttpRequests, toQueryParams };
//# sourceMappingURL=http-requests.d.ts.map