import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
/**
  * Updates documents that match the specified query. If no query is specified, performs an update on every document in the index without changing the source, for example to pick up a mapping change.
  * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/docs-update-by-query.html | Elasticsearch API documentation}
  */
export default function UpdateByQueryApi(this: That, params: T.UpdateByQueryRequest | TB.UpdateByQueryRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.UpdateByQueryResponse>;
export default function UpdateByQueryApi(this: That, params: T.UpdateByQueryRequest | TB.UpdateByQueryRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.UpdateByQueryResponse, unknown>>;
export default function UpdateByQueryApi(this: That, params: T.UpdateByQueryRequest | TB.UpdateByQueryRequest, options?: TransportRequestOptions): Promise<T.UpdateByQueryResponse>;
export {};
