import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
export default class Transform {
    transport: Transport;
    constructor(transport: Transport);
    /**
      * Deletes an existing transform.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/delete-transform.html | Elasticsearch API documentation}
      */
    deleteTransform(this: That, params: T.TransformDeleteTransformRequest | TB.TransformDeleteTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformDeleteTransformResponse>;
    deleteTransform(this: That, params: T.TransformDeleteTransformRequest | TB.TransformDeleteTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformDeleteTransformResponse, unknown>>;
    deleteTransform(this: That, params: T.TransformDeleteTransformRequest | TB.TransformDeleteTransformRequest, options?: TransportRequestOptions): Promise<T.TransformDeleteTransformResponse>;
    /**
      * Retrieves configuration information for transforms.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-transform.html | Elasticsearch API documentation}
      */
    getTransform(this: That, params?: T.TransformGetTransformRequest | TB.TransformGetTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformGetTransformResponse>;
    getTransform(this: That, params?: T.TransformGetTransformRequest | TB.TransformGetTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformGetTransformResponse, unknown>>;
    getTransform(this: That, params?: T.TransformGetTransformRequest | TB.TransformGetTransformRequest, options?: TransportRequestOptions): Promise<T.TransformGetTransformResponse>;
    /**
      * Retrieves usage information for transforms.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-transform-stats.html | Elasticsearch API documentation}
      */
    getTransformStats(this: That, params: T.TransformGetTransformStatsRequest | TB.TransformGetTransformStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformGetTransformStatsResponse>;
    getTransformStats(this: That, params: T.TransformGetTransformStatsRequest | TB.TransformGetTransformStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformGetTransformStatsResponse, unknown>>;
    getTransformStats(this: That, params: T.TransformGetTransformStatsRequest | TB.TransformGetTransformStatsRequest, options?: TransportRequestOptions): Promise<T.TransformGetTransformStatsResponse>;
    /**
      * Previews a transform.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/preview-transform.html | Elasticsearch API documentation}
      */
    previewTransform<TTransform = unknown>(this: That, params?: T.TransformPreviewTransformRequest | TB.TransformPreviewTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformPreviewTransformResponse<TTransform>>;
    previewTransform<TTransform = unknown>(this: That, params?: T.TransformPreviewTransformRequest | TB.TransformPreviewTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformPreviewTransformResponse<TTransform>, unknown>>;
    previewTransform<TTransform = unknown>(this: That, params?: T.TransformPreviewTransformRequest | TB.TransformPreviewTransformRequest, options?: TransportRequestOptions): Promise<T.TransformPreviewTransformResponse<TTransform>>;
    /**
      * Instantiates a transform.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/put-transform.html | Elasticsearch API documentation}
      */
    putTransform(this: That, params: T.TransformPutTransformRequest | TB.TransformPutTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformPutTransformResponse>;
    putTransform(this: That, params: T.TransformPutTransformRequest | TB.TransformPutTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformPutTransformResponse, unknown>>;
    putTransform(this: That, params: T.TransformPutTransformRequest | TB.TransformPutTransformRequest, options?: TransportRequestOptions): Promise<T.TransformPutTransformResponse>;
    /**
      * Resets an existing transform.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/reset-transform.html | Elasticsearch API documentation}
      */
    resetTransform(this: That, params: T.TransformResetTransformRequest | TB.TransformResetTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformResetTransformResponse>;
    resetTransform(this: That, params: T.TransformResetTransformRequest | TB.TransformResetTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformResetTransformResponse, unknown>>;
    resetTransform(this: That, params: T.TransformResetTransformRequest | TB.TransformResetTransformRequest, options?: TransportRequestOptions): Promise<T.TransformResetTransformResponse>;
    /**
      * Schedules now a transform.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/schedule-now-transform.html | Elasticsearch API documentation}
      */
    scheduleNowTransform(this: That, params: T.TransformScheduleNowTransformRequest | TB.TransformScheduleNowTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformScheduleNowTransformResponse>;
    scheduleNowTransform(this: That, params: T.TransformScheduleNowTransformRequest | TB.TransformScheduleNowTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformScheduleNowTransformResponse, unknown>>;
    scheduleNowTransform(this: That, params: T.TransformScheduleNowTransformRequest | TB.TransformScheduleNowTransformRequest, options?: TransportRequestOptions): Promise<T.TransformScheduleNowTransformResponse>;
    /**
      * Starts one or more transforms.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/start-transform.html | Elasticsearch API documentation}
      */
    startTransform(this: That, params: T.TransformStartTransformRequest | TB.TransformStartTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformStartTransformResponse>;
    startTransform(this: That, params: T.TransformStartTransformRequest | TB.TransformStartTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformStartTransformResponse, unknown>>;
    startTransform(this: That, params: T.TransformStartTransformRequest | TB.TransformStartTransformRequest, options?: TransportRequestOptions): Promise<T.TransformStartTransformResponse>;
    /**
      * Stops one or more transforms.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/stop-transform.html | Elasticsearch API documentation}
      */
    stopTransform(this: That, params: T.TransformStopTransformRequest | TB.TransformStopTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformStopTransformResponse>;
    stopTransform(this: That, params: T.TransformStopTransformRequest | TB.TransformStopTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformStopTransformResponse, unknown>>;
    stopTransform(this: That, params: T.TransformStopTransformRequest | TB.TransformStopTransformRequest, options?: TransportRequestOptions): Promise<T.TransformStopTransformResponse>;
    /**
      * Updates certain properties of a transform.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/update-transform.html | Elasticsearch API documentation}
      */
    updateTransform(this: That, params: T.TransformUpdateTransformRequest | TB.TransformUpdateTransformRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformUpdateTransformResponse>;
    updateTransform(this: That, params: T.TransformUpdateTransformRequest | TB.TransformUpdateTransformRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformUpdateTransformResponse, unknown>>;
    updateTransform(this: That, params: T.TransformUpdateTransformRequest | TB.TransformUpdateTransformRequest, options?: TransportRequestOptions): Promise<T.TransformUpdateTransformResponse>;
    /**
      * Upgrades all transforms.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/upgrade-transforms.html | Elasticsearch API documentation}
      */
    upgradeTransforms(this: That, params?: T.TransformUpgradeTransformsRequest | TB.TransformUpgradeTransformsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.TransformUpgradeTransformsResponse>;
    upgradeTransforms(this: That, params?: T.TransformUpgradeTransformsRequest | TB.TransformUpgradeTransformsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TransformUpgradeTransformsResponse, unknown>>;
    upgradeTransforms(this: That, params?: T.TransformUpgradeTransformsRequest | TB.TransformUpgradeTransformsRequest, options?: TransportRequestOptions): Promise<T.TransformUpgradeTransformsResponse>;
}
export {};
