import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
export default class Security {
    transport: Transport;
    constructor(transport: Transport);
    /**
      * Creates or updates the user profile on behalf of another user.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-activate-user-profile.html | Elasticsearch API documentation}
      */
    activateUserProfile(this: That, params: T.SecurityActivateUserProfileRequest | TB.SecurityActivateUserProfileRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityActivateUserProfileResponse>;
    activateUserProfile(this: That, params: T.SecurityActivateUserProfileRequest | TB.SecurityActivateUserProfileRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityActivateUserProfileResponse, unknown>>;
    activateUserProfile(this: That, params: T.SecurityActivateUserProfileRequest | TB.SecurityActivateUserProfileRequest, options?: TransportRequestOptions): Promise<T.SecurityActivateUserProfileResponse>;
    /**
      * Enables authentication as a user and retrieve information about the authenticated user.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-authenticate.html | Elasticsearch API documentation}
      */
    authenticate(this: That, params?: T.SecurityAuthenticateRequest | TB.SecurityAuthenticateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityAuthenticateResponse>;
    authenticate(this: That, params?: T.SecurityAuthenticateRequest | TB.SecurityAuthenticateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityAuthenticateResponse, unknown>>;
    authenticate(this: That, params?: T.SecurityAuthenticateRequest | TB.SecurityAuthenticateRequest, options?: TransportRequestOptions): Promise<T.SecurityAuthenticateResponse>;
    /**
      * Updates the attributes of multiple existing API keys.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-bulk-update-api-keys.html | Elasticsearch API documentation}
      */
    bulkUpdateApiKeys(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    bulkUpdateApiKeys(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    bulkUpdateApiKeys(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Changes the passwords of users in the native realm and built-in users.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-change-password.html | Elasticsearch API documentation}
      */
    changePassword(this: That, params?: T.SecurityChangePasswordRequest | TB.SecurityChangePasswordRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityChangePasswordResponse>;
    changePassword(this: That, params?: T.SecurityChangePasswordRequest | TB.SecurityChangePasswordRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityChangePasswordResponse, unknown>>;
    changePassword(this: That, params?: T.SecurityChangePasswordRequest | TB.SecurityChangePasswordRequest, options?: TransportRequestOptions): Promise<T.SecurityChangePasswordResponse>;
    /**
      * Clear a subset or all entries from the API key cache.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-clear-api-key-cache.html | Elasticsearch API documentation}
      */
    clearApiKeyCache(this: That, params: T.SecurityClearApiKeyCacheRequest | TB.SecurityClearApiKeyCacheRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityClearApiKeyCacheResponse>;
    clearApiKeyCache(this: That, params: T.SecurityClearApiKeyCacheRequest | TB.SecurityClearApiKeyCacheRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityClearApiKeyCacheResponse, unknown>>;
    clearApiKeyCache(this: That, params: T.SecurityClearApiKeyCacheRequest | TB.SecurityClearApiKeyCacheRequest, options?: TransportRequestOptions): Promise<T.SecurityClearApiKeyCacheResponse>;
    /**
      * Evicts application privileges from the native application privileges cache.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-clear-privilege-cache.html | Elasticsearch API documentation}
      */
    clearCachedPrivileges(this: That, params: T.SecurityClearCachedPrivilegesRequest | TB.SecurityClearCachedPrivilegesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityClearCachedPrivilegesResponse>;
    clearCachedPrivileges(this: That, params: T.SecurityClearCachedPrivilegesRequest | TB.SecurityClearCachedPrivilegesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityClearCachedPrivilegesResponse, unknown>>;
    clearCachedPrivileges(this: That, params: T.SecurityClearCachedPrivilegesRequest | TB.SecurityClearCachedPrivilegesRequest, options?: TransportRequestOptions): Promise<T.SecurityClearCachedPrivilegesResponse>;
    /**
      * Evicts users from the user cache. Can completely clear the cache or evict specific users.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-clear-cache.html | Elasticsearch API documentation}
      */
    clearCachedRealms(this: That, params: T.SecurityClearCachedRealmsRequest | TB.SecurityClearCachedRealmsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityClearCachedRealmsResponse>;
    clearCachedRealms(this: That, params: T.SecurityClearCachedRealmsRequest | TB.SecurityClearCachedRealmsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityClearCachedRealmsResponse, unknown>>;
    clearCachedRealms(this: That, params: T.SecurityClearCachedRealmsRequest | TB.SecurityClearCachedRealmsRequest, options?: TransportRequestOptions): Promise<T.SecurityClearCachedRealmsResponse>;
    /**
      * Evicts roles from the native role cache.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-clear-role-cache.html | Elasticsearch API documentation}
      */
    clearCachedRoles(this: That, params: T.SecurityClearCachedRolesRequest | TB.SecurityClearCachedRolesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityClearCachedRolesResponse>;
    clearCachedRoles(this: That, params: T.SecurityClearCachedRolesRequest | TB.SecurityClearCachedRolesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityClearCachedRolesResponse, unknown>>;
    clearCachedRoles(this: That, params: T.SecurityClearCachedRolesRequest | TB.SecurityClearCachedRolesRequest, options?: TransportRequestOptions): Promise<T.SecurityClearCachedRolesResponse>;
    /**
      * Evicts tokens from the service account token caches.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-clear-service-token-caches.html | Elasticsearch API documentation}
      */
    clearCachedServiceTokens(this: That, params: T.SecurityClearCachedServiceTokensRequest | TB.SecurityClearCachedServiceTokensRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityClearCachedServiceTokensResponse>;
    clearCachedServiceTokens(this: That, params: T.SecurityClearCachedServiceTokensRequest | TB.SecurityClearCachedServiceTokensRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityClearCachedServiceTokensResponse, unknown>>;
    clearCachedServiceTokens(this: That, params: T.SecurityClearCachedServiceTokensRequest | TB.SecurityClearCachedServiceTokensRequest, options?: TransportRequestOptions): Promise<T.SecurityClearCachedServiceTokensResponse>;
    /**
      * Creates an API key for access without requiring basic authentication.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-create-api-key.html | Elasticsearch API documentation}
      */
    createApiKey(this: That, params?: T.SecurityCreateApiKeyRequest | TB.SecurityCreateApiKeyRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityCreateApiKeyResponse>;
    createApiKey(this: That, params?: T.SecurityCreateApiKeyRequest | TB.SecurityCreateApiKeyRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityCreateApiKeyResponse, unknown>>;
    createApiKey(this: That, params?: T.SecurityCreateApiKeyRequest | TB.SecurityCreateApiKeyRequest, options?: TransportRequestOptions): Promise<T.SecurityCreateApiKeyResponse>;
    /**
      * Creates a cross-cluster API key for API key based remote cluster access.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-create-cross-cluster-api-key.html | Elasticsearch API documentation}
      */
    createCrossClusterApiKey(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    createCrossClusterApiKey(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    createCrossClusterApiKey(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Creates a service account token for access without requiring basic authentication.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-create-service-token.html | Elasticsearch API documentation}
      */
    createServiceToken(this: That, params: T.SecurityCreateServiceTokenRequest | TB.SecurityCreateServiceTokenRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityCreateServiceTokenResponse>;
    createServiceToken(this: That, params: T.SecurityCreateServiceTokenRequest | TB.SecurityCreateServiceTokenRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityCreateServiceTokenResponse, unknown>>;
    createServiceToken(this: That, params: T.SecurityCreateServiceTokenRequest | TB.SecurityCreateServiceTokenRequest, options?: TransportRequestOptions): Promise<T.SecurityCreateServiceTokenResponse>;
    /**
      * Removes application privileges.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-delete-privilege.html | Elasticsearch API documentation}
      */
    deletePrivileges(this: That, params: T.SecurityDeletePrivilegesRequest | TB.SecurityDeletePrivilegesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityDeletePrivilegesResponse>;
    deletePrivileges(this: That, params: T.SecurityDeletePrivilegesRequest | TB.SecurityDeletePrivilegesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityDeletePrivilegesResponse, unknown>>;
    deletePrivileges(this: That, params: T.SecurityDeletePrivilegesRequest | TB.SecurityDeletePrivilegesRequest, options?: TransportRequestOptions): Promise<T.SecurityDeletePrivilegesResponse>;
    /**
      * Removes roles in the native realm.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-delete-role.html | Elasticsearch API documentation}
      */
    deleteRole(this: That, params: T.SecurityDeleteRoleRequest | TB.SecurityDeleteRoleRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityDeleteRoleResponse>;
    deleteRole(this: That, params: T.SecurityDeleteRoleRequest | TB.SecurityDeleteRoleRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityDeleteRoleResponse, unknown>>;
    deleteRole(this: That, params: T.SecurityDeleteRoleRequest | TB.SecurityDeleteRoleRequest, options?: TransportRequestOptions): Promise<T.SecurityDeleteRoleResponse>;
    /**
      * Removes role mappings.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-delete-role-mapping.html | Elasticsearch API documentation}
      */
    deleteRoleMapping(this: That, params: T.SecurityDeleteRoleMappingRequest | TB.SecurityDeleteRoleMappingRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityDeleteRoleMappingResponse>;
    deleteRoleMapping(this: That, params: T.SecurityDeleteRoleMappingRequest | TB.SecurityDeleteRoleMappingRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityDeleteRoleMappingResponse, unknown>>;
    deleteRoleMapping(this: That, params: T.SecurityDeleteRoleMappingRequest | TB.SecurityDeleteRoleMappingRequest, options?: TransportRequestOptions): Promise<T.SecurityDeleteRoleMappingResponse>;
    /**
      * Deletes a service account token.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-delete-service-token.html | Elasticsearch API documentation}
      */
    deleteServiceToken(this: That, params: T.SecurityDeleteServiceTokenRequest | TB.SecurityDeleteServiceTokenRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityDeleteServiceTokenResponse>;
    deleteServiceToken(this: That, params: T.SecurityDeleteServiceTokenRequest | TB.SecurityDeleteServiceTokenRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityDeleteServiceTokenResponse, unknown>>;
    deleteServiceToken(this: That, params: T.SecurityDeleteServiceTokenRequest | TB.SecurityDeleteServiceTokenRequest, options?: TransportRequestOptions): Promise<T.SecurityDeleteServiceTokenResponse>;
    /**
      * Deletes users from the native realm.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-delete-user.html | Elasticsearch API documentation}
      */
    deleteUser(this: That, params: T.SecurityDeleteUserRequest | TB.SecurityDeleteUserRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityDeleteUserResponse>;
    deleteUser(this: That, params: T.SecurityDeleteUserRequest | TB.SecurityDeleteUserRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityDeleteUserResponse, unknown>>;
    deleteUser(this: That, params: T.SecurityDeleteUserRequest | TB.SecurityDeleteUserRequest, options?: TransportRequestOptions): Promise<T.SecurityDeleteUserResponse>;
    /**
      * Disables users in the native realm.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-disable-user.html | Elasticsearch API documentation}
      */
    disableUser(this: That, params: T.SecurityDisableUserRequest | TB.SecurityDisableUserRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityDisableUserResponse>;
    disableUser(this: That, params: T.SecurityDisableUserRequest | TB.SecurityDisableUserRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityDisableUserResponse, unknown>>;
    disableUser(this: That, params: T.SecurityDisableUserRequest | TB.SecurityDisableUserRequest, options?: TransportRequestOptions): Promise<T.SecurityDisableUserResponse>;
    /**
      * Disables a user profile so it's not visible in user profile searches.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-disable-user-profile.html | Elasticsearch API documentation}
      */
    disableUserProfile(this: That, params: T.SecurityDisableUserProfileRequest | TB.SecurityDisableUserProfileRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityDisableUserProfileResponse>;
    disableUserProfile(this: That, params: T.SecurityDisableUserProfileRequest | TB.SecurityDisableUserProfileRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityDisableUserProfileResponse, unknown>>;
    disableUserProfile(this: That, params: T.SecurityDisableUserProfileRequest | TB.SecurityDisableUserProfileRequest, options?: TransportRequestOptions): Promise<T.SecurityDisableUserProfileResponse>;
    /**
      * Enables users in the native realm.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-enable-user.html | Elasticsearch API documentation}
      */
    enableUser(this: That, params: T.SecurityEnableUserRequest | TB.SecurityEnableUserRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityEnableUserResponse>;
    enableUser(this: That, params: T.SecurityEnableUserRequest | TB.SecurityEnableUserRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityEnableUserResponse, unknown>>;
    enableUser(this: That, params: T.SecurityEnableUserRequest | TB.SecurityEnableUserRequest, options?: TransportRequestOptions): Promise<T.SecurityEnableUserResponse>;
    /**
      * Enables a user profile so it's visible in user profile searches.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-enable-user-profile.html | Elasticsearch API documentation}
      */
    enableUserProfile(this: That, params: T.SecurityEnableUserProfileRequest | TB.SecurityEnableUserProfileRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityEnableUserProfileResponse>;
    enableUserProfile(this: That, params: T.SecurityEnableUserProfileRequest | TB.SecurityEnableUserProfileRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityEnableUserProfileResponse, unknown>>;
    enableUserProfile(this: That, params: T.SecurityEnableUserProfileRequest | TB.SecurityEnableUserProfileRequest, options?: TransportRequestOptions): Promise<T.SecurityEnableUserProfileResponse>;
    /**
      * Allows a kibana instance to configure itself to communicate with a secured elasticsearch cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-kibana-enrollment.html | Elasticsearch API documentation}
      */
    enrollKibana(this: That, params?: T.SecurityEnrollKibanaRequest | TB.SecurityEnrollKibanaRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityEnrollKibanaResponse>;
    enrollKibana(this: That, params?: T.SecurityEnrollKibanaRequest | TB.SecurityEnrollKibanaRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityEnrollKibanaResponse, unknown>>;
    enrollKibana(this: That, params?: T.SecurityEnrollKibanaRequest | TB.SecurityEnrollKibanaRequest, options?: TransportRequestOptions): Promise<T.SecurityEnrollKibanaResponse>;
    /**
      * Allows a new node to enroll to an existing cluster with security enabled.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-node-enrollment.html | Elasticsearch API documentation}
      */
    enrollNode(this: That, params?: T.SecurityEnrollNodeRequest | TB.SecurityEnrollNodeRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityEnrollNodeResponse>;
    enrollNode(this: That, params?: T.SecurityEnrollNodeRequest | TB.SecurityEnrollNodeRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityEnrollNodeResponse, unknown>>;
    enrollNode(this: That, params?: T.SecurityEnrollNodeRequest | TB.SecurityEnrollNodeRequest, options?: TransportRequestOptions): Promise<T.SecurityEnrollNodeResponse>;
    /**
      * Retrieves information for one or more API keys.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-api-key.html | Elasticsearch API documentation}
      */
    getApiKey(this: That, params?: T.SecurityGetApiKeyRequest | TB.SecurityGetApiKeyRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetApiKeyResponse>;
    getApiKey(this: That, params?: T.SecurityGetApiKeyRequest | TB.SecurityGetApiKeyRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetApiKeyResponse, unknown>>;
    getApiKey(this: That, params?: T.SecurityGetApiKeyRequest | TB.SecurityGetApiKeyRequest, options?: TransportRequestOptions): Promise<T.SecurityGetApiKeyResponse>;
    /**
      * Retrieves the list of cluster privileges and index privileges that are available in this version of Elasticsearch.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-builtin-privileges.html | Elasticsearch API documentation}
      */
    getBuiltinPrivileges(this: That, params?: T.SecurityGetBuiltinPrivilegesRequest | TB.SecurityGetBuiltinPrivilegesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetBuiltinPrivilegesResponse>;
    getBuiltinPrivileges(this: That, params?: T.SecurityGetBuiltinPrivilegesRequest | TB.SecurityGetBuiltinPrivilegesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetBuiltinPrivilegesResponse, unknown>>;
    getBuiltinPrivileges(this: That, params?: T.SecurityGetBuiltinPrivilegesRequest | TB.SecurityGetBuiltinPrivilegesRequest, options?: TransportRequestOptions): Promise<T.SecurityGetBuiltinPrivilegesResponse>;
    /**
      * Retrieves application privileges.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-privileges.html | Elasticsearch API documentation}
      */
    getPrivileges(this: That, params?: T.SecurityGetPrivilegesRequest | TB.SecurityGetPrivilegesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetPrivilegesResponse>;
    getPrivileges(this: That, params?: T.SecurityGetPrivilegesRequest | TB.SecurityGetPrivilegesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetPrivilegesResponse, unknown>>;
    getPrivileges(this: That, params?: T.SecurityGetPrivilegesRequest | TB.SecurityGetPrivilegesRequest, options?: TransportRequestOptions): Promise<T.SecurityGetPrivilegesResponse>;
    /**
      * Retrieves roles in the native realm.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-role.html | Elasticsearch API documentation}
      */
    getRole(this: That, params?: T.SecurityGetRoleRequest | TB.SecurityGetRoleRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetRoleResponse>;
    getRole(this: That, params?: T.SecurityGetRoleRequest | TB.SecurityGetRoleRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetRoleResponse, unknown>>;
    getRole(this: That, params?: T.SecurityGetRoleRequest | TB.SecurityGetRoleRequest, options?: TransportRequestOptions): Promise<T.SecurityGetRoleResponse>;
    /**
      * Retrieves role mappings.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-role-mapping.html | Elasticsearch API documentation}
      */
    getRoleMapping(this: That, params?: T.SecurityGetRoleMappingRequest | TB.SecurityGetRoleMappingRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetRoleMappingResponse>;
    getRoleMapping(this: That, params?: T.SecurityGetRoleMappingRequest | TB.SecurityGetRoleMappingRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetRoleMappingResponse, unknown>>;
    getRoleMapping(this: That, params?: T.SecurityGetRoleMappingRequest | TB.SecurityGetRoleMappingRequest, options?: TransportRequestOptions): Promise<T.SecurityGetRoleMappingResponse>;
    /**
      * Retrieves information about service accounts.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-service-accounts.html | Elasticsearch API documentation}
      */
    getServiceAccounts(this: That, params?: T.SecurityGetServiceAccountsRequest | TB.SecurityGetServiceAccountsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetServiceAccountsResponse>;
    getServiceAccounts(this: That, params?: T.SecurityGetServiceAccountsRequest | TB.SecurityGetServiceAccountsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetServiceAccountsResponse, unknown>>;
    getServiceAccounts(this: That, params?: T.SecurityGetServiceAccountsRequest | TB.SecurityGetServiceAccountsRequest, options?: TransportRequestOptions): Promise<T.SecurityGetServiceAccountsResponse>;
    /**
      * Retrieves information of all service credentials for a service account.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-service-credentials.html | Elasticsearch API documentation}
      */
    getServiceCredentials(this: That, params: T.SecurityGetServiceCredentialsRequest | TB.SecurityGetServiceCredentialsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetServiceCredentialsResponse>;
    getServiceCredentials(this: That, params: T.SecurityGetServiceCredentialsRequest | TB.SecurityGetServiceCredentialsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetServiceCredentialsResponse, unknown>>;
    getServiceCredentials(this: That, params: T.SecurityGetServiceCredentialsRequest | TB.SecurityGetServiceCredentialsRequest, options?: TransportRequestOptions): Promise<T.SecurityGetServiceCredentialsResponse>;
    /**
      * Retrieve settings for the security system indices
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-settings.html | Elasticsearch API documentation}
      */
    getSettings(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    getSettings(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    getSettings(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Creates a bearer token for access without requiring basic authentication.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-token.html | Elasticsearch API documentation}
      */
    getToken(this: That, params?: T.SecurityGetTokenRequest | TB.SecurityGetTokenRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetTokenResponse>;
    getToken(this: That, params?: T.SecurityGetTokenRequest | TB.SecurityGetTokenRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetTokenResponse, unknown>>;
    getToken(this: That, params?: T.SecurityGetTokenRequest | TB.SecurityGetTokenRequest, options?: TransportRequestOptions): Promise<T.SecurityGetTokenResponse>;
    /**
      * Retrieves information about users in the native realm and built-in users.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-user.html | Elasticsearch API documentation}
      */
    getUser(this: That, params?: T.SecurityGetUserRequest | TB.SecurityGetUserRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetUserResponse>;
    getUser(this: That, params?: T.SecurityGetUserRequest | TB.SecurityGetUserRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetUserResponse, unknown>>;
    getUser(this: That, params?: T.SecurityGetUserRequest | TB.SecurityGetUserRequest, options?: TransportRequestOptions): Promise<T.SecurityGetUserResponse>;
    /**
      * Retrieves security privileges for the logged in user.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-user-privileges.html | Elasticsearch API documentation}
      */
    getUserPrivileges(this: That, params?: T.SecurityGetUserPrivilegesRequest | TB.SecurityGetUserPrivilegesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetUserPrivilegesResponse>;
    getUserPrivileges(this: That, params?: T.SecurityGetUserPrivilegesRequest | TB.SecurityGetUserPrivilegesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetUserPrivilegesResponse, unknown>>;
    getUserPrivileges(this: That, params?: T.SecurityGetUserPrivilegesRequest | TB.SecurityGetUserPrivilegesRequest, options?: TransportRequestOptions): Promise<T.SecurityGetUserPrivilegesResponse>;
    /**
      * Retrieves user profiles for the given unique ID(s).
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-get-user-profile.html | Elasticsearch API documentation}
      */
    getUserProfile(this: That, params: T.SecurityGetUserProfileRequest | TB.SecurityGetUserProfileRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGetUserProfileResponse>;
    getUserProfile(this: That, params: T.SecurityGetUserProfileRequest | TB.SecurityGetUserProfileRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGetUserProfileResponse, unknown>>;
    getUserProfile(this: That, params: T.SecurityGetUserProfileRequest | TB.SecurityGetUserProfileRequest, options?: TransportRequestOptions): Promise<T.SecurityGetUserProfileResponse>;
    /**
      * Creates an API key on behalf of another user.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-grant-api-key.html | Elasticsearch API documentation}
      */
    grantApiKey(this: That, params: T.SecurityGrantApiKeyRequest | TB.SecurityGrantApiKeyRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityGrantApiKeyResponse>;
    grantApiKey(this: That, params: T.SecurityGrantApiKeyRequest | TB.SecurityGrantApiKeyRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityGrantApiKeyResponse, unknown>>;
    grantApiKey(this: That, params: T.SecurityGrantApiKeyRequest | TB.SecurityGrantApiKeyRequest, options?: TransportRequestOptions): Promise<T.SecurityGrantApiKeyResponse>;
    /**
      * Determines whether the specified user has a specified list of privileges.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-has-privileges.html | Elasticsearch API documentation}
      */
    hasPrivileges(this: That, params?: T.SecurityHasPrivilegesRequest | TB.SecurityHasPrivilegesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityHasPrivilegesResponse>;
    hasPrivileges(this: That, params?: T.SecurityHasPrivilegesRequest | TB.SecurityHasPrivilegesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityHasPrivilegesResponse, unknown>>;
    hasPrivileges(this: That, params?: T.SecurityHasPrivilegesRequest | TB.SecurityHasPrivilegesRequest, options?: TransportRequestOptions): Promise<T.SecurityHasPrivilegesResponse>;
    /**
      * Determines whether the users associated with the specified profile IDs have all the requested privileges.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-has-privileges-user-profile.html | Elasticsearch API documentation}
      */
    hasPrivilegesUserProfile(this: That, params: T.SecurityHasPrivilegesUserProfileRequest | TB.SecurityHasPrivilegesUserProfileRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityHasPrivilegesUserProfileResponse>;
    hasPrivilegesUserProfile(this: That, params: T.SecurityHasPrivilegesUserProfileRequest | TB.SecurityHasPrivilegesUserProfileRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityHasPrivilegesUserProfileResponse, unknown>>;
    hasPrivilegesUserProfile(this: That, params: T.SecurityHasPrivilegesUserProfileRequest | TB.SecurityHasPrivilegesUserProfileRequest, options?: TransportRequestOptions): Promise<T.SecurityHasPrivilegesUserProfileResponse>;
    /**
      * Invalidates one or more API keys.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-invalidate-api-key.html | Elasticsearch API documentation}
      */
    invalidateApiKey(this: That, params?: T.SecurityInvalidateApiKeyRequest | TB.SecurityInvalidateApiKeyRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityInvalidateApiKeyResponse>;
    invalidateApiKey(this: That, params?: T.SecurityInvalidateApiKeyRequest | TB.SecurityInvalidateApiKeyRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityInvalidateApiKeyResponse, unknown>>;
    invalidateApiKey(this: That, params?: T.SecurityInvalidateApiKeyRequest | TB.SecurityInvalidateApiKeyRequest, options?: TransportRequestOptions): Promise<T.SecurityInvalidateApiKeyResponse>;
    /**
      * Invalidates one or more access tokens or refresh tokens.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-invalidate-token.html | Elasticsearch API documentation}
      */
    invalidateToken(this: That, params?: T.SecurityInvalidateTokenRequest | TB.SecurityInvalidateTokenRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityInvalidateTokenResponse>;
    invalidateToken(this: That, params?: T.SecurityInvalidateTokenRequest | TB.SecurityInvalidateTokenRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityInvalidateTokenResponse, unknown>>;
    invalidateToken(this: That, params?: T.SecurityInvalidateTokenRequest | TB.SecurityInvalidateTokenRequest, options?: TransportRequestOptions): Promise<T.SecurityInvalidateTokenResponse>;
    /**
      * Exchanges an OpenID Connection authentication response message for an Elasticsearch access token and refresh token pair
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-oidc-authenticate.html | Elasticsearch API documentation}
      */
    oidcAuthenticate(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    oidcAuthenticate(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    oidcAuthenticate(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Invalidates a refresh token and access token that was generated from the OpenID Connect Authenticate API
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-oidc-logout.html | Elasticsearch API documentation}
      */
    oidcLogout(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    oidcLogout(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    oidcLogout(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Creates an OAuth 2.0 authentication request as a URL string
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-oidc-prepare-authentication.html | Elasticsearch API documentation}
      */
    oidcPrepareAuthentication(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    oidcPrepareAuthentication(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    oidcPrepareAuthentication(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Adds or updates application privileges.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-put-privileges.html | Elasticsearch API documentation}
      */
    putPrivileges(this: That, params: T.SecurityPutPrivilegesRequest | TB.SecurityPutPrivilegesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityPutPrivilegesResponse>;
    putPrivileges(this: That, params: T.SecurityPutPrivilegesRequest | TB.SecurityPutPrivilegesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityPutPrivilegesResponse, unknown>>;
    putPrivileges(this: That, params: T.SecurityPutPrivilegesRequest | TB.SecurityPutPrivilegesRequest, options?: TransportRequestOptions): Promise<T.SecurityPutPrivilegesResponse>;
    /**
      * Adds and updates roles in the native realm.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-put-role.html | Elasticsearch API documentation}
      */
    putRole(this: That, params: T.SecurityPutRoleRequest | TB.SecurityPutRoleRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityPutRoleResponse>;
    putRole(this: That, params: T.SecurityPutRoleRequest | TB.SecurityPutRoleRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityPutRoleResponse, unknown>>;
    putRole(this: That, params: T.SecurityPutRoleRequest | TB.SecurityPutRoleRequest, options?: TransportRequestOptions): Promise<T.SecurityPutRoleResponse>;
    /**
      * Creates and updates role mappings.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-put-role-mapping.html | Elasticsearch API documentation}
      */
    putRoleMapping(this: That, params: T.SecurityPutRoleMappingRequest | TB.SecurityPutRoleMappingRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityPutRoleMappingResponse>;
    putRoleMapping(this: That, params: T.SecurityPutRoleMappingRequest | TB.SecurityPutRoleMappingRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityPutRoleMappingResponse, unknown>>;
    putRoleMapping(this: That, params: T.SecurityPutRoleMappingRequest | TB.SecurityPutRoleMappingRequest, options?: TransportRequestOptions): Promise<T.SecurityPutRoleMappingResponse>;
    /**
      * Adds and updates users in the native realm. These users are commonly referred to as native users.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-put-user.html | Elasticsearch API documentation}
      */
    putUser(this: That, params: T.SecurityPutUserRequest | TB.SecurityPutUserRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityPutUserResponse>;
    putUser(this: That, params: T.SecurityPutUserRequest | TB.SecurityPutUserRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityPutUserResponse, unknown>>;
    putUser(this: That, params: T.SecurityPutUserRequest | TB.SecurityPutUserRequest, options?: TransportRequestOptions): Promise<T.SecurityPutUserResponse>;
    /**
      * Retrieves information for API keys using a subset of query DSL
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-query-api-key.html | Elasticsearch API documentation}
      */
    queryApiKeys(this: That, params?: T.SecurityQueryApiKeysRequest | TB.SecurityQueryApiKeysRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityQueryApiKeysResponse>;
    queryApiKeys(this: That, params?: T.SecurityQueryApiKeysRequest | TB.SecurityQueryApiKeysRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityQueryApiKeysResponse, unknown>>;
    queryApiKeys(this: That, params?: T.SecurityQueryApiKeysRequest | TB.SecurityQueryApiKeysRequest, options?: TransportRequestOptions): Promise<T.SecurityQueryApiKeysResponse>;
    /**
      * Exchanges a SAML Response message for an Elasticsearch access token and refresh token pair
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-saml-authenticate.html | Elasticsearch API documentation}
      */
    samlAuthenticate(this: That, params: T.SecuritySamlAuthenticateRequest | TB.SecuritySamlAuthenticateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecuritySamlAuthenticateResponse>;
    samlAuthenticate(this: That, params: T.SecuritySamlAuthenticateRequest | TB.SecuritySamlAuthenticateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecuritySamlAuthenticateResponse, unknown>>;
    samlAuthenticate(this: That, params: T.SecuritySamlAuthenticateRequest | TB.SecuritySamlAuthenticateRequest, options?: TransportRequestOptions): Promise<T.SecuritySamlAuthenticateResponse>;
    /**
      * Verifies the logout response sent from the SAML IdP
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-saml-complete-logout.html | Elasticsearch API documentation}
      */
    samlCompleteLogout(this: That, params: T.SecuritySamlCompleteLogoutRequest | TB.SecuritySamlCompleteLogoutRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecuritySamlCompleteLogoutResponse>;
    samlCompleteLogout(this: That, params: T.SecuritySamlCompleteLogoutRequest | TB.SecuritySamlCompleteLogoutRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecuritySamlCompleteLogoutResponse, unknown>>;
    samlCompleteLogout(this: That, params: T.SecuritySamlCompleteLogoutRequest | TB.SecuritySamlCompleteLogoutRequest, options?: TransportRequestOptions): Promise<T.SecuritySamlCompleteLogoutResponse>;
    /**
      * Consumes a SAML LogoutRequest
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-saml-invalidate.html | Elasticsearch API documentation}
      */
    samlInvalidate(this: That, params: T.SecuritySamlInvalidateRequest | TB.SecuritySamlInvalidateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecuritySamlInvalidateResponse>;
    samlInvalidate(this: That, params: T.SecuritySamlInvalidateRequest | TB.SecuritySamlInvalidateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecuritySamlInvalidateResponse, unknown>>;
    samlInvalidate(this: That, params: T.SecuritySamlInvalidateRequest | TB.SecuritySamlInvalidateRequest, options?: TransportRequestOptions): Promise<T.SecuritySamlInvalidateResponse>;
    /**
      * Invalidates an access token and a refresh token that were generated via the SAML Authenticate API
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-saml-logout.html | Elasticsearch API documentation}
      */
    samlLogout(this: That, params: T.SecuritySamlLogoutRequest | TB.SecuritySamlLogoutRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecuritySamlLogoutResponse>;
    samlLogout(this: That, params: T.SecuritySamlLogoutRequest | TB.SecuritySamlLogoutRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecuritySamlLogoutResponse, unknown>>;
    samlLogout(this: That, params: T.SecuritySamlLogoutRequest | TB.SecuritySamlLogoutRequest, options?: TransportRequestOptions): Promise<T.SecuritySamlLogoutResponse>;
    /**
      * Creates a SAML authentication request
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-saml-prepare-authentication.html | Elasticsearch API documentation}
      */
    samlPrepareAuthentication(this: That, params?: T.SecuritySamlPrepareAuthenticationRequest | TB.SecuritySamlPrepareAuthenticationRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecuritySamlPrepareAuthenticationResponse>;
    samlPrepareAuthentication(this: That, params?: T.SecuritySamlPrepareAuthenticationRequest | TB.SecuritySamlPrepareAuthenticationRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecuritySamlPrepareAuthenticationResponse, unknown>>;
    samlPrepareAuthentication(this: That, params?: T.SecuritySamlPrepareAuthenticationRequest | TB.SecuritySamlPrepareAuthenticationRequest, options?: TransportRequestOptions): Promise<T.SecuritySamlPrepareAuthenticationResponse>;
    /**
      * Generates SAML metadata for the Elastic stack SAML 2.0 Service Provider
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-saml-sp-metadata.html | Elasticsearch API documentation}
      */
    samlServiceProviderMetadata(this: That, params: T.SecuritySamlServiceProviderMetadataRequest | TB.SecuritySamlServiceProviderMetadataRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecuritySamlServiceProviderMetadataResponse>;
    samlServiceProviderMetadata(this: That, params: T.SecuritySamlServiceProviderMetadataRequest | TB.SecuritySamlServiceProviderMetadataRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecuritySamlServiceProviderMetadataResponse, unknown>>;
    samlServiceProviderMetadata(this: That, params: T.SecuritySamlServiceProviderMetadataRequest | TB.SecuritySamlServiceProviderMetadataRequest, options?: TransportRequestOptions): Promise<T.SecuritySamlServiceProviderMetadataResponse>;
    /**
      * Get suggestions for user profiles that match specified search criteria.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-suggest-user-profile.html | Elasticsearch API documentation}
      */
    suggestUserProfiles(this: That, params?: T.SecuritySuggestUserProfilesRequest | TB.SecuritySuggestUserProfilesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecuritySuggestUserProfilesResponse>;
    suggestUserProfiles(this: That, params?: T.SecuritySuggestUserProfilesRequest | TB.SecuritySuggestUserProfilesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecuritySuggestUserProfilesResponse, unknown>>;
    suggestUserProfiles(this: That, params?: T.SecuritySuggestUserProfilesRequest | TB.SecuritySuggestUserProfilesRequest, options?: TransportRequestOptions): Promise<T.SecuritySuggestUserProfilesResponse>;
    /**
      * Updates attributes of an existing API key.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-update-api-key.html | Elasticsearch API documentation}
      */
    updateApiKey(this: That, params: T.SecurityUpdateApiKeyRequest | TB.SecurityUpdateApiKeyRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityUpdateApiKeyResponse>;
    updateApiKey(this: That, params: T.SecurityUpdateApiKeyRequest | TB.SecurityUpdateApiKeyRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityUpdateApiKeyResponse, unknown>>;
    updateApiKey(this: That, params: T.SecurityUpdateApiKeyRequest | TB.SecurityUpdateApiKeyRequest, options?: TransportRequestOptions): Promise<T.SecurityUpdateApiKeyResponse>;
    /**
      * Updates attributes of an existing cross-cluster API key.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-update-cross-cluster-api-key.html | Elasticsearch API documentation}
      */
    updateCrossClusterApiKey(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    updateCrossClusterApiKey(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    updateCrossClusterApiKey(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Update settings for the security system index
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-update-settings.html | Elasticsearch API documentation}
      */
    updateSettings(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    updateSettings(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    updateSettings(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Update application specific data for the user profile of the given unique ID.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/security-api-update-user-profile-data.html | Elasticsearch API documentation}
      */
    updateUserProfileData(this: That, params: T.SecurityUpdateUserProfileDataRequest | TB.SecurityUpdateUserProfileDataRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.SecurityUpdateUserProfileDataResponse>;
    updateUserProfileData(this: That, params: T.SecurityUpdateUserProfileDataRequest | TB.SecurityUpdateUserProfileDataRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.SecurityUpdateUserProfileDataResponse, unknown>>;
    updateUserProfileData(this: That, params: T.SecurityUpdateUserProfileDataRequest | TB.SecurityUpdateUserProfileDataRequest, options?: TransportRequestOptions): Promise<T.SecurityUpdateUserProfileDataResponse>;
}
export {};
