import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
export default class QueryRuleset {
    transport: Transport;
    constructor(transport: Transport);
    /**
      * Deletes a query ruleset.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/delete-query-ruleset.html | Elasticsearch API documentation}
      */
    delete(this: That, params: T.QueryRulesetDeleteRequest | TB.QueryRulesetDeleteRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.QueryRulesetDeleteResponse>;
    delete(this: That, params: T.QueryRulesetDeleteRequest | TB.QueryRulesetDeleteRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.QueryRulesetDeleteResponse, unknown>>;
    delete(this: That, params: T.QueryRulesetDeleteRequest | TB.QueryRulesetDeleteRequest, options?: TransportRequestOptions): Promise<T.QueryRulesetDeleteResponse>;
    /**
      * Returns the details about a query ruleset.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-query-ruleset.html | Elasticsearch API documentation}
      */
    get(this: That, params: T.QueryRulesetGetRequest | TB.QueryRulesetGetRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.QueryRulesetGetResponse>;
    get(this: That, params: T.QueryRulesetGetRequest | TB.QueryRulesetGetRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.QueryRulesetGetResponse, unknown>>;
    get(this: That, params: T.QueryRulesetGetRequest | TB.QueryRulesetGetRequest, options?: TransportRequestOptions): Promise<T.QueryRulesetGetResponse>;
    /**
      * Lists query rulesets.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/list-query-rulesets.html | Elasticsearch API documentation}
      */
    list(this: That, params?: T.QueryRulesetListRequest | TB.QueryRulesetListRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.QueryRulesetListResponse>;
    list(this: That, params?: T.QueryRulesetListRequest | TB.QueryRulesetListRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.QueryRulesetListResponse, unknown>>;
    list(this: That, params?: T.QueryRulesetListRequest | TB.QueryRulesetListRequest, options?: TransportRequestOptions): Promise<T.QueryRulesetListResponse>;
    /**
      * Creates or updates a query ruleset.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/put-query-ruleset.html | Elasticsearch API documentation}
      */
    put(this: That, params: T.QueryRulesetPutRequest | TB.QueryRulesetPutRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.QueryRulesetPutResponse>;
    put(this: That, params: T.QueryRulesetPutRequest | TB.QueryRulesetPutRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.QueryRulesetPutResponse, unknown>>;
    put(this: That, params: T.QueryRulesetPutRequest | TB.QueryRulesetPutRequest, options?: TransportRequestOptions): Promise<T.QueryRulesetPutResponse>;
}
export {};
