import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
export default class Ml {
    transport: Transport;
    constructor(transport: Transport);
    /**
      * Clear the cached results from a trained model deployment
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/clear-trained-model-deployment-cache.html | Elasticsearch API documentation}
      */
    clearTrainedModelDeploymentCache(this: That, params: T.MlClearTrainedModelDeploymentCacheRequest | TB.MlClearTrainedModelDeploymentCacheRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlClearTrainedModelDeploymentCacheResponse>;
    clearTrainedModelDeploymentCache(this: That, params: T.MlClearTrainedModelDeploymentCacheRequest | TB.MlClearTrainedModelDeploymentCacheRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlClearTrainedModelDeploymentCacheResponse, unknown>>;
    clearTrainedModelDeploymentCache(this: That, params: T.MlClearTrainedModelDeploymentCacheRequest | TB.MlClearTrainedModelDeploymentCacheRequest, options?: TransportRequestOptions): Promise<T.MlClearTrainedModelDeploymentCacheResponse>;
    /**
      * Closes one or more anomaly detection jobs. A job can be opened and closed multiple times throughout its lifecycle.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-close-job.html | Elasticsearch API documentation}
      */
    closeJob(this: That, params: T.MlCloseJobRequest | TB.MlCloseJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlCloseJobResponse>;
    closeJob(this: That, params: T.MlCloseJobRequest | TB.MlCloseJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlCloseJobResponse, unknown>>;
    closeJob(this: That, params: T.MlCloseJobRequest | TB.MlCloseJobRequest, options?: TransportRequestOptions): Promise<T.MlCloseJobResponse>;
    /**
      * Deletes a calendar.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-calendar.html | Elasticsearch API documentation}
      */
    deleteCalendar(this: That, params: T.MlDeleteCalendarRequest | TB.MlDeleteCalendarRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteCalendarResponse>;
    deleteCalendar(this: That, params: T.MlDeleteCalendarRequest | TB.MlDeleteCalendarRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteCalendarResponse, unknown>>;
    deleteCalendar(this: That, params: T.MlDeleteCalendarRequest | TB.MlDeleteCalendarRequest, options?: TransportRequestOptions): Promise<T.MlDeleteCalendarResponse>;
    /**
      * Deletes scheduled events from a calendar.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-calendar-event.html | Elasticsearch API documentation}
      */
    deleteCalendarEvent(this: That, params: T.MlDeleteCalendarEventRequest | TB.MlDeleteCalendarEventRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteCalendarEventResponse>;
    deleteCalendarEvent(this: That, params: T.MlDeleteCalendarEventRequest | TB.MlDeleteCalendarEventRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteCalendarEventResponse, unknown>>;
    deleteCalendarEvent(this: That, params: T.MlDeleteCalendarEventRequest | TB.MlDeleteCalendarEventRequest, options?: TransportRequestOptions): Promise<T.MlDeleteCalendarEventResponse>;
    /**
      * Deletes anomaly detection jobs from a calendar.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-calendar-job.html | Elasticsearch API documentation}
      */
    deleteCalendarJob(this: That, params: T.MlDeleteCalendarJobRequest | TB.MlDeleteCalendarJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteCalendarJobResponse>;
    deleteCalendarJob(this: That, params: T.MlDeleteCalendarJobRequest | TB.MlDeleteCalendarJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteCalendarJobResponse, unknown>>;
    deleteCalendarJob(this: That, params: T.MlDeleteCalendarJobRequest | TB.MlDeleteCalendarJobRequest, options?: TransportRequestOptions): Promise<T.MlDeleteCalendarJobResponse>;
    /**
      * Deletes an existing data frame analytics job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/delete-dfanalytics.html | Elasticsearch API documentation}
      */
    deleteDataFrameAnalytics(this: That, params: T.MlDeleteDataFrameAnalyticsRequest | TB.MlDeleteDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteDataFrameAnalyticsResponse>;
    deleteDataFrameAnalytics(this: That, params: T.MlDeleteDataFrameAnalyticsRequest | TB.MlDeleteDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteDataFrameAnalyticsResponse, unknown>>;
    deleteDataFrameAnalytics(this: That, params: T.MlDeleteDataFrameAnalyticsRequest | TB.MlDeleteDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.MlDeleteDataFrameAnalyticsResponse>;
    /**
      * Deletes an existing datafeed.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-datafeed.html | Elasticsearch API documentation}
      */
    deleteDatafeed(this: That, params: T.MlDeleteDatafeedRequest | TB.MlDeleteDatafeedRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteDatafeedResponse>;
    deleteDatafeed(this: That, params: T.MlDeleteDatafeedRequest | TB.MlDeleteDatafeedRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteDatafeedResponse, unknown>>;
    deleteDatafeed(this: That, params: T.MlDeleteDatafeedRequest | TB.MlDeleteDatafeedRequest, options?: TransportRequestOptions): Promise<T.MlDeleteDatafeedResponse>;
    /**
      * Deletes expired and unused machine learning data.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-expired-data.html | Elasticsearch API documentation}
      */
    deleteExpiredData(this: That, params?: T.MlDeleteExpiredDataRequest | TB.MlDeleteExpiredDataRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteExpiredDataResponse>;
    deleteExpiredData(this: That, params?: T.MlDeleteExpiredDataRequest | TB.MlDeleteExpiredDataRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteExpiredDataResponse, unknown>>;
    deleteExpiredData(this: That, params?: T.MlDeleteExpiredDataRequest | TB.MlDeleteExpiredDataRequest, options?: TransportRequestOptions): Promise<T.MlDeleteExpiredDataResponse>;
    /**
      * Deletes a filter.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-filter.html | Elasticsearch API documentation}
      */
    deleteFilter(this: That, params: T.MlDeleteFilterRequest | TB.MlDeleteFilterRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteFilterResponse>;
    deleteFilter(this: That, params: T.MlDeleteFilterRequest | TB.MlDeleteFilterRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteFilterResponse, unknown>>;
    deleteFilter(this: That, params: T.MlDeleteFilterRequest | TB.MlDeleteFilterRequest, options?: TransportRequestOptions): Promise<T.MlDeleteFilterResponse>;
    /**
      * Deletes forecasts from a machine learning job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-forecast.html | Elasticsearch API documentation}
      */
    deleteForecast(this: That, params: T.MlDeleteForecastRequest | TB.MlDeleteForecastRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteForecastResponse>;
    deleteForecast(this: That, params: T.MlDeleteForecastRequest | TB.MlDeleteForecastRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteForecastResponse, unknown>>;
    deleteForecast(this: That, params: T.MlDeleteForecastRequest | TB.MlDeleteForecastRequest, options?: TransportRequestOptions): Promise<T.MlDeleteForecastResponse>;
    /**
      * Deletes an existing anomaly detection job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-job.html | Elasticsearch API documentation}
      */
    deleteJob(this: That, params: T.MlDeleteJobRequest | TB.MlDeleteJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteJobResponse>;
    deleteJob(this: That, params: T.MlDeleteJobRequest | TB.MlDeleteJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteJobResponse, unknown>>;
    deleteJob(this: That, params: T.MlDeleteJobRequest | TB.MlDeleteJobRequest, options?: TransportRequestOptions): Promise<T.MlDeleteJobResponse>;
    /**
      * Deletes an existing model snapshot.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-delete-snapshot.html | Elasticsearch API documentation}
      */
    deleteModelSnapshot(this: That, params: T.MlDeleteModelSnapshotRequest | TB.MlDeleteModelSnapshotRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteModelSnapshotResponse>;
    deleteModelSnapshot(this: That, params: T.MlDeleteModelSnapshotRequest | TB.MlDeleteModelSnapshotRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteModelSnapshotResponse, unknown>>;
    deleteModelSnapshot(this: That, params: T.MlDeleteModelSnapshotRequest | TB.MlDeleteModelSnapshotRequest, options?: TransportRequestOptions): Promise<T.MlDeleteModelSnapshotResponse>;
    /**
      * Deletes an existing trained inference model that is currently not referenced by an ingest pipeline.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/delete-trained-models.html | Elasticsearch API documentation}
      */
    deleteTrainedModel(this: That, params: T.MlDeleteTrainedModelRequest | TB.MlDeleteTrainedModelRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteTrainedModelResponse>;
    deleteTrainedModel(this: That, params: T.MlDeleteTrainedModelRequest | TB.MlDeleteTrainedModelRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteTrainedModelResponse, unknown>>;
    deleteTrainedModel(this: That, params: T.MlDeleteTrainedModelRequest | TB.MlDeleteTrainedModelRequest, options?: TransportRequestOptions): Promise<T.MlDeleteTrainedModelResponse>;
    /**
      * Deletes a model alias that refers to the trained model
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/delete-trained-models-aliases.html | Elasticsearch API documentation}
      */
    deleteTrainedModelAlias(this: That, params: T.MlDeleteTrainedModelAliasRequest | TB.MlDeleteTrainedModelAliasRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlDeleteTrainedModelAliasResponse>;
    deleteTrainedModelAlias(this: That, params: T.MlDeleteTrainedModelAliasRequest | TB.MlDeleteTrainedModelAliasRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlDeleteTrainedModelAliasResponse, unknown>>;
    deleteTrainedModelAlias(this: That, params: T.MlDeleteTrainedModelAliasRequest | TB.MlDeleteTrainedModelAliasRequest, options?: TransportRequestOptions): Promise<T.MlDeleteTrainedModelAliasResponse>;
    /**
      * Estimates the model memory
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-apis.html | Elasticsearch API documentation}
      */
    estimateModelMemory(this: That, params?: T.MlEstimateModelMemoryRequest | TB.MlEstimateModelMemoryRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlEstimateModelMemoryResponse>;
    estimateModelMemory(this: That, params?: T.MlEstimateModelMemoryRequest | TB.MlEstimateModelMemoryRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlEstimateModelMemoryResponse, unknown>>;
    estimateModelMemory(this: That, params?: T.MlEstimateModelMemoryRequest | TB.MlEstimateModelMemoryRequest, options?: TransportRequestOptions): Promise<T.MlEstimateModelMemoryResponse>;
    /**
      * Evaluates the data frame analytics for an annotated index.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/evaluate-dfanalytics.html | Elasticsearch API documentation}
      */
    evaluateDataFrame(this: That, params: T.MlEvaluateDataFrameRequest | TB.MlEvaluateDataFrameRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlEvaluateDataFrameResponse>;
    evaluateDataFrame(this: That, params: T.MlEvaluateDataFrameRequest | TB.MlEvaluateDataFrameRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlEvaluateDataFrameResponse, unknown>>;
    evaluateDataFrame(this: That, params: T.MlEvaluateDataFrameRequest | TB.MlEvaluateDataFrameRequest, options?: TransportRequestOptions): Promise<T.MlEvaluateDataFrameResponse>;
    /**
      * Explains a data frame analytics config.
      * @see {@link http://www.elastic.co/guide/en/elasticsearch/reference/8.13/explain-dfanalytics.html | Elasticsearch API documentation}
      */
    explainDataFrameAnalytics(this: That, params?: T.MlExplainDataFrameAnalyticsRequest | TB.MlExplainDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlExplainDataFrameAnalyticsResponse>;
    explainDataFrameAnalytics(this: That, params?: T.MlExplainDataFrameAnalyticsRequest | TB.MlExplainDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlExplainDataFrameAnalyticsResponse, unknown>>;
    explainDataFrameAnalytics(this: That, params?: T.MlExplainDataFrameAnalyticsRequest | TB.MlExplainDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.MlExplainDataFrameAnalyticsResponse>;
    /**
      * Forces any buffered data to be processed by the job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-flush-job.html | Elasticsearch API documentation}
      */
    flushJob(this: That, params: T.MlFlushJobRequest | TB.MlFlushJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlFlushJobResponse>;
    flushJob(this: That, params: T.MlFlushJobRequest | TB.MlFlushJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlFlushJobResponse, unknown>>;
    flushJob(this: That, params: T.MlFlushJobRequest | TB.MlFlushJobRequest, options?: TransportRequestOptions): Promise<T.MlFlushJobResponse>;
    /**
      * Predicts the future behavior of a time series by using its historical behavior.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-forecast.html | Elasticsearch API documentation}
      */
    forecast(this: That, params: T.MlForecastRequest | TB.MlForecastRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlForecastResponse>;
    forecast(this: That, params: T.MlForecastRequest | TB.MlForecastRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlForecastResponse, unknown>>;
    forecast(this: That, params: T.MlForecastRequest | TB.MlForecastRequest, options?: TransportRequestOptions): Promise<T.MlForecastResponse>;
    /**
      * Retrieves anomaly detection job results for one or more buckets.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-bucket.html | Elasticsearch API documentation}
      */
    getBuckets(this: That, params: T.MlGetBucketsRequest | TB.MlGetBucketsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetBucketsResponse>;
    getBuckets(this: That, params: T.MlGetBucketsRequest | TB.MlGetBucketsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetBucketsResponse, unknown>>;
    getBuckets(this: That, params: T.MlGetBucketsRequest | TB.MlGetBucketsRequest, options?: TransportRequestOptions): Promise<T.MlGetBucketsResponse>;
    /**
      * Retrieves information about the scheduled events in calendars.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-calendar-event.html | Elasticsearch API documentation}
      */
    getCalendarEvents(this: That, params: T.MlGetCalendarEventsRequest | TB.MlGetCalendarEventsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetCalendarEventsResponse>;
    getCalendarEvents(this: That, params: T.MlGetCalendarEventsRequest | TB.MlGetCalendarEventsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetCalendarEventsResponse, unknown>>;
    getCalendarEvents(this: That, params: T.MlGetCalendarEventsRequest | TB.MlGetCalendarEventsRequest, options?: TransportRequestOptions): Promise<T.MlGetCalendarEventsResponse>;
    /**
      * Retrieves configuration information for calendars.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-calendar.html | Elasticsearch API documentation}
      */
    getCalendars(this: That, params?: T.MlGetCalendarsRequest | TB.MlGetCalendarsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetCalendarsResponse>;
    getCalendars(this: That, params?: T.MlGetCalendarsRequest | TB.MlGetCalendarsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetCalendarsResponse, unknown>>;
    getCalendars(this: That, params?: T.MlGetCalendarsRequest | TB.MlGetCalendarsRequest, options?: TransportRequestOptions): Promise<T.MlGetCalendarsResponse>;
    /**
      * Retrieves anomaly detection job results for one or more categories.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-category.html | Elasticsearch API documentation}
      */
    getCategories(this: That, params: T.MlGetCategoriesRequest | TB.MlGetCategoriesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetCategoriesResponse>;
    getCategories(this: That, params: T.MlGetCategoriesRequest | TB.MlGetCategoriesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetCategoriesResponse, unknown>>;
    getCategories(this: That, params: T.MlGetCategoriesRequest | TB.MlGetCategoriesRequest, options?: TransportRequestOptions): Promise<T.MlGetCategoriesResponse>;
    /**
      * Retrieves configuration information for data frame analytics jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-dfanalytics.html | Elasticsearch API documentation}
      */
    getDataFrameAnalytics(this: That, params?: T.MlGetDataFrameAnalyticsRequest | TB.MlGetDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetDataFrameAnalyticsResponse>;
    getDataFrameAnalytics(this: That, params?: T.MlGetDataFrameAnalyticsRequest | TB.MlGetDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetDataFrameAnalyticsResponse, unknown>>;
    getDataFrameAnalytics(this: That, params?: T.MlGetDataFrameAnalyticsRequest | TB.MlGetDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.MlGetDataFrameAnalyticsResponse>;
    /**
      * Retrieves usage information for data frame analytics jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-dfanalytics-stats.html | Elasticsearch API documentation}
      */
    getDataFrameAnalyticsStats(this: That, params?: T.MlGetDataFrameAnalyticsStatsRequest | TB.MlGetDataFrameAnalyticsStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetDataFrameAnalyticsStatsResponse>;
    getDataFrameAnalyticsStats(this: That, params?: T.MlGetDataFrameAnalyticsStatsRequest | TB.MlGetDataFrameAnalyticsStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetDataFrameAnalyticsStatsResponse, unknown>>;
    getDataFrameAnalyticsStats(this: That, params?: T.MlGetDataFrameAnalyticsStatsRequest | TB.MlGetDataFrameAnalyticsStatsRequest, options?: TransportRequestOptions): Promise<T.MlGetDataFrameAnalyticsStatsResponse>;
    /**
      * Retrieves usage information for datafeeds.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-datafeed-stats.html | Elasticsearch API documentation}
      */
    getDatafeedStats(this: That, params?: T.MlGetDatafeedStatsRequest | TB.MlGetDatafeedStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetDatafeedStatsResponse>;
    getDatafeedStats(this: That, params?: T.MlGetDatafeedStatsRequest | TB.MlGetDatafeedStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetDatafeedStatsResponse, unknown>>;
    getDatafeedStats(this: That, params?: T.MlGetDatafeedStatsRequest | TB.MlGetDatafeedStatsRequest, options?: TransportRequestOptions): Promise<T.MlGetDatafeedStatsResponse>;
    /**
      * Retrieves configuration information for datafeeds.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-datafeed.html | Elasticsearch API documentation}
      */
    getDatafeeds(this: That, params?: T.MlGetDatafeedsRequest | TB.MlGetDatafeedsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetDatafeedsResponse>;
    getDatafeeds(this: That, params?: T.MlGetDatafeedsRequest | TB.MlGetDatafeedsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetDatafeedsResponse, unknown>>;
    getDatafeeds(this: That, params?: T.MlGetDatafeedsRequest | TB.MlGetDatafeedsRequest, options?: TransportRequestOptions): Promise<T.MlGetDatafeedsResponse>;
    /**
      * Retrieves filters.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-filter.html | Elasticsearch API documentation}
      */
    getFilters(this: That, params?: T.MlGetFiltersRequest | TB.MlGetFiltersRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetFiltersResponse>;
    getFilters(this: That, params?: T.MlGetFiltersRequest | TB.MlGetFiltersRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetFiltersResponse, unknown>>;
    getFilters(this: That, params?: T.MlGetFiltersRequest | TB.MlGetFiltersRequest, options?: TransportRequestOptions): Promise<T.MlGetFiltersResponse>;
    /**
      * Retrieves anomaly detection job results for one or more influencers.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-influencer.html | Elasticsearch API documentation}
      */
    getInfluencers(this: That, params: T.MlGetInfluencersRequest | TB.MlGetInfluencersRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetInfluencersResponse>;
    getInfluencers(this: That, params: T.MlGetInfluencersRequest | TB.MlGetInfluencersRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetInfluencersResponse, unknown>>;
    getInfluencers(this: That, params: T.MlGetInfluencersRequest | TB.MlGetInfluencersRequest, options?: TransportRequestOptions): Promise<T.MlGetInfluencersResponse>;
    /**
      * Retrieves usage information for anomaly detection jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-job-stats.html | Elasticsearch API documentation}
      */
    getJobStats(this: That, params?: T.MlGetJobStatsRequest | TB.MlGetJobStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetJobStatsResponse>;
    getJobStats(this: That, params?: T.MlGetJobStatsRequest | TB.MlGetJobStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetJobStatsResponse, unknown>>;
    getJobStats(this: That, params?: T.MlGetJobStatsRequest | TB.MlGetJobStatsRequest, options?: TransportRequestOptions): Promise<T.MlGetJobStatsResponse>;
    /**
      * Retrieves configuration information for anomaly detection jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-job.html | Elasticsearch API documentation}
      */
    getJobs(this: That, params?: T.MlGetJobsRequest | TB.MlGetJobsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetJobsResponse>;
    getJobs(this: That, params?: T.MlGetJobsRequest | TB.MlGetJobsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetJobsResponse, unknown>>;
    getJobs(this: That, params?: T.MlGetJobsRequest | TB.MlGetJobsRequest, options?: TransportRequestOptions): Promise<T.MlGetJobsResponse>;
    /**
      * Returns information on how ML is using memory.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-ml-memory.html | Elasticsearch API documentation}
      */
    getMemoryStats(this: That, params?: T.MlGetMemoryStatsRequest | TB.MlGetMemoryStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetMemoryStatsResponse>;
    getMemoryStats(this: That, params?: T.MlGetMemoryStatsRequest | TB.MlGetMemoryStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetMemoryStatsResponse, unknown>>;
    getMemoryStats(this: That, params?: T.MlGetMemoryStatsRequest | TB.MlGetMemoryStatsRequest, options?: TransportRequestOptions): Promise<T.MlGetMemoryStatsResponse>;
    /**
      * Gets stats for anomaly detection job model snapshot upgrades that are in progress.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-job-model-snapshot-upgrade-stats.html | Elasticsearch API documentation}
      */
    getModelSnapshotUpgradeStats(this: That, params: T.MlGetModelSnapshotUpgradeStatsRequest | TB.MlGetModelSnapshotUpgradeStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetModelSnapshotUpgradeStatsResponse>;
    getModelSnapshotUpgradeStats(this: That, params: T.MlGetModelSnapshotUpgradeStatsRequest | TB.MlGetModelSnapshotUpgradeStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetModelSnapshotUpgradeStatsResponse, unknown>>;
    getModelSnapshotUpgradeStats(this: That, params: T.MlGetModelSnapshotUpgradeStatsRequest | TB.MlGetModelSnapshotUpgradeStatsRequest, options?: TransportRequestOptions): Promise<T.MlGetModelSnapshotUpgradeStatsResponse>;
    /**
      * Retrieves information about model snapshots.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-snapshot.html | Elasticsearch API documentation}
      */
    getModelSnapshots(this: That, params: T.MlGetModelSnapshotsRequest | TB.MlGetModelSnapshotsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetModelSnapshotsResponse>;
    getModelSnapshots(this: That, params: T.MlGetModelSnapshotsRequest | TB.MlGetModelSnapshotsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetModelSnapshotsResponse, unknown>>;
    getModelSnapshots(this: That, params: T.MlGetModelSnapshotsRequest | TB.MlGetModelSnapshotsRequest, options?: TransportRequestOptions): Promise<T.MlGetModelSnapshotsResponse>;
    /**
      * Retrieves overall bucket results that summarize the bucket results of multiple anomaly detection jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-overall-buckets.html | Elasticsearch API documentation}
      */
    getOverallBuckets(this: That, params: T.MlGetOverallBucketsRequest | TB.MlGetOverallBucketsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetOverallBucketsResponse>;
    getOverallBuckets(this: That, params: T.MlGetOverallBucketsRequest | TB.MlGetOverallBucketsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetOverallBucketsResponse, unknown>>;
    getOverallBuckets(this: That, params: T.MlGetOverallBucketsRequest | TB.MlGetOverallBucketsRequest, options?: TransportRequestOptions): Promise<T.MlGetOverallBucketsResponse>;
    /**
      * Retrieves anomaly records for an anomaly detection job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-get-record.html | Elasticsearch API documentation}
      */
    getRecords(this: That, params: T.MlGetRecordsRequest | TB.MlGetRecordsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetRecordsResponse>;
    getRecords(this: That, params: T.MlGetRecordsRequest | TB.MlGetRecordsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetRecordsResponse, unknown>>;
    getRecords(this: That, params: T.MlGetRecordsRequest | TB.MlGetRecordsRequest, options?: TransportRequestOptions): Promise<T.MlGetRecordsResponse>;
    /**
      * Retrieves configuration information for a trained inference model.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-trained-models.html | Elasticsearch API documentation}
      */
    getTrainedModels(this: That, params?: T.MlGetTrainedModelsRequest | TB.MlGetTrainedModelsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetTrainedModelsResponse>;
    getTrainedModels(this: That, params?: T.MlGetTrainedModelsRequest | TB.MlGetTrainedModelsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetTrainedModelsResponse, unknown>>;
    getTrainedModels(this: That, params?: T.MlGetTrainedModelsRequest | TB.MlGetTrainedModelsRequest, options?: TransportRequestOptions): Promise<T.MlGetTrainedModelsResponse>;
    /**
      * Retrieves usage information for trained inference models.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-trained-models-stats.html | Elasticsearch API documentation}
      */
    getTrainedModelsStats(this: That, params?: T.MlGetTrainedModelsStatsRequest | TB.MlGetTrainedModelsStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlGetTrainedModelsStatsResponse>;
    getTrainedModelsStats(this: That, params?: T.MlGetTrainedModelsStatsRequest | TB.MlGetTrainedModelsStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlGetTrainedModelsStatsResponse, unknown>>;
    getTrainedModelsStats(this: That, params?: T.MlGetTrainedModelsStatsRequest | TB.MlGetTrainedModelsStatsRequest, options?: TransportRequestOptions): Promise<T.MlGetTrainedModelsStatsResponse>;
    /**
      * Evaluate a trained model.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/infer-trained-model.html | Elasticsearch API documentation}
      */
    inferTrainedModel(this: That, params: T.MlInferTrainedModelRequest | TB.MlInferTrainedModelRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlInferTrainedModelResponse>;
    inferTrainedModel(this: That, params: T.MlInferTrainedModelRequest | TB.MlInferTrainedModelRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlInferTrainedModelResponse, unknown>>;
    inferTrainedModel(this: That, params: T.MlInferTrainedModelRequest | TB.MlInferTrainedModelRequest, options?: TransportRequestOptions): Promise<T.MlInferTrainedModelResponse>;
    /**
      * Returns defaults and limits used by machine learning.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-ml-info.html | Elasticsearch API documentation}
      */
    info(this: That, params?: T.MlInfoRequest | TB.MlInfoRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlInfoResponse>;
    info(this: That, params?: T.MlInfoRequest | TB.MlInfoRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlInfoResponse, unknown>>;
    info(this: That, params?: T.MlInfoRequest | TB.MlInfoRequest, options?: TransportRequestOptions): Promise<T.MlInfoResponse>;
    /**
      * Opens one or more anomaly detection jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-open-job.html | Elasticsearch API documentation}
      */
    openJob(this: That, params: T.MlOpenJobRequest | TB.MlOpenJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlOpenJobResponse>;
    openJob(this: That, params: T.MlOpenJobRequest | TB.MlOpenJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlOpenJobResponse, unknown>>;
    openJob(this: That, params: T.MlOpenJobRequest | TB.MlOpenJobRequest, options?: TransportRequestOptions): Promise<T.MlOpenJobResponse>;
    /**
      * Posts scheduled events in a calendar.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-post-calendar-event.html | Elasticsearch API documentation}
      */
    postCalendarEvents(this: That, params: T.MlPostCalendarEventsRequest | TB.MlPostCalendarEventsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPostCalendarEventsResponse>;
    postCalendarEvents(this: That, params: T.MlPostCalendarEventsRequest | TB.MlPostCalendarEventsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPostCalendarEventsResponse, unknown>>;
    postCalendarEvents(this: That, params: T.MlPostCalendarEventsRequest | TB.MlPostCalendarEventsRequest, options?: TransportRequestOptions): Promise<T.MlPostCalendarEventsResponse>;
    /**
      * Sends data to an anomaly detection job for analysis.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-post-data.html | Elasticsearch API documentation}
      */
    postData<TData = unknown>(this: That, params: T.MlPostDataRequest<TData> | TB.MlPostDataRequest<TData>, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPostDataResponse>;
    postData<TData = unknown>(this: That, params: T.MlPostDataRequest<TData> | TB.MlPostDataRequest<TData>, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPostDataResponse, unknown>>;
    postData<TData = unknown>(this: That, params: T.MlPostDataRequest<TData> | TB.MlPostDataRequest<TData>, options?: TransportRequestOptions): Promise<T.MlPostDataResponse>;
    /**
      * Previews that will be analyzed given a data frame analytics config.
      * @see {@link http://www.elastic.co/guide/en/elasticsearch/reference/8.13/preview-dfanalytics.html | Elasticsearch API documentation}
      */
    previewDataFrameAnalytics(this: That, params?: T.MlPreviewDataFrameAnalyticsRequest | TB.MlPreviewDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPreviewDataFrameAnalyticsResponse>;
    previewDataFrameAnalytics(this: That, params?: T.MlPreviewDataFrameAnalyticsRequest | TB.MlPreviewDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPreviewDataFrameAnalyticsResponse, unknown>>;
    previewDataFrameAnalytics(this: That, params?: T.MlPreviewDataFrameAnalyticsRequest | TB.MlPreviewDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.MlPreviewDataFrameAnalyticsResponse>;
    /**
      * Previews a datafeed.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-preview-datafeed.html | Elasticsearch API documentation}
      */
    previewDatafeed<TDocument = unknown>(this: That, params?: T.MlPreviewDatafeedRequest | TB.MlPreviewDatafeedRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPreviewDatafeedResponse<TDocument>>;
    previewDatafeed<TDocument = unknown>(this: That, params?: T.MlPreviewDatafeedRequest | TB.MlPreviewDatafeedRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPreviewDatafeedResponse<TDocument>, unknown>>;
    previewDatafeed<TDocument = unknown>(this: That, params?: T.MlPreviewDatafeedRequest | TB.MlPreviewDatafeedRequest, options?: TransportRequestOptions): Promise<T.MlPreviewDatafeedResponse<TDocument>>;
    /**
      * Instantiates a calendar.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-put-calendar.html | Elasticsearch API documentation}
      */
    putCalendar(this: That, params: T.MlPutCalendarRequest | TB.MlPutCalendarRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutCalendarResponse>;
    putCalendar(this: That, params: T.MlPutCalendarRequest | TB.MlPutCalendarRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutCalendarResponse, unknown>>;
    putCalendar(this: That, params: T.MlPutCalendarRequest | TB.MlPutCalendarRequest, options?: TransportRequestOptions): Promise<T.MlPutCalendarResponse>;
    /**
      * Adds an anomaly detection job to a calendar.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-put-calendar-job.html | Elasticsearch API documentation}
      */
    putCalendarJob(this: That, params: T.MlPutCalendarJobRequest | TB.MlPutCalendarJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutCalendarJobResponse>;
    putCalendarJob(this: That, params: T.MlPutCalendarJobRequest | TB.MlPutCalendarJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutCalendarJobResponse, unknown>>;
    putCalendarJob(this: That, params: T.MlPutCalendarJobRequest | TB.MlPutCalendarJobRequest, options?: TransportRequestOptions): Promise<T.MlPutCalendarJobResponse>;
    /**
      * Instantiates a data frame analytics job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/put-dfanalytics.html | Elasticsearch API documentation}
      */
    putDataFrameAnalytics(this: That, params: T.MlPutDataFrameAnalyticsRequest | TB.MlPutDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutDataFrameAnalyticsResponse>;
    putDataFrameAnalytics(this: That, params: T.MlPutDataFrameAnalyticsRequest | TB.MlPutDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutDataFrameAnalyticsResponse, unknown>>;
    putDataFrameAnalytics(this: That, params: T.MlPutDataFrameAnalyticsRequest | TB.MlPutDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.MlPutDataFrameAnalyticsResponse>;
    /**
      * Instantiates a datafeed.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-put-datafeed.html | Elasticsearch API documentation}
      */
    putDatafeed(this: That, params: T.MlPutDatafeedRequest | TB.MlPutDatafeedRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutDatafeedResponse>;
    putDatafeed(this: That, params: T.MlPutDatafeedRequest | TB.MlPutDatafeedRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutDatafeedResponse, unknown>>;
    putDatafeed(this: That, params: T.MlPutDatafeedRequest | TB.MlPutDatafeedRequest, options?: TransportRequestOptions): Promise<T.MlPutDatafeedResponse>;
    /**
      * Instantiates a filter.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-put-filter.html | Elasticsearch API documentation}
      */
    putFilter(this: That, params: T.MlPutFilterRequest | TB.MlPutFilterRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutFilterResponse>;
    putFilter(this: That, params: T.MlPutFilterRequest | TB.MlPutFilterRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutFilterResponse, unknown>>;
    putFilter(this: That, params: T.MlPutFilterRequest | TB.MlPutFilterRequest, options?: TransportRequestOptions): Promise<T.MlPutFilterResponse>;
    /**
      * Instantiates an anomaly detection job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-put-job.html | Elasticsearch API documentation}
      */
    putJob(this: That, params: T.MlPutJobRequest | TB.MlPutJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutJobResponse>;
    putJob(this: That, params: T.MlPutJobRequest | TB.MlPutJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutJobResponse, unknown>>;
    putJob(this: That, params: T.MlPutJobRequest | TB.MlPutJobRequest, options?: TransportRequestOptions): Promise<T.MlPutJobResponse>;
    /**
      * Creates an inference trained model.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/put-trained-models.html | Elasticsearch API documentation}
      */
    putTrainedModel(this: That, params: T.MlPutTrainedModelRequest | TB.MlPutTrainedModelRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutTrainedModelResponse>;
    putTrainedModel(this: That, params: T.MlPutTrainedModelRequest | TB.MlPutTrainedModelRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutTrainedModelResponse, unknown>>;
    putTrainedModel(this: That, params: T.MlPutTrainedModelRequest | TB.MlPutTrainedModelRequest, options?: TransportRequestOptions): Promise<T.MlPutTrainedModelResponse>;
    /**
      * Creates a new model alias (or reassigns an existing one) to refer to the trained model
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/put-trained-models-aliases.html | Elasticsearch API documentation}
      */
    putTrainedModelAlias(this: That, params: T.MlPutTrainedModelAliasRequest | TB.MlPutTrainedModelAliasRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutTrainedModelAliasResponse>;
    putTrainedModelAlias(this: That, params: T.MlPutTrainedModelAliasRequest | TB.MlPutTrainedModelAliasRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutTrainedModelAliasResponse, unknown>>;
    putTrainedModelAlias(this: That, params: T.MlPutTrainedModelAliasRequest | TB.MlPutTrainedModelAliasRequest, options?: TransportRequestOptions): Promise<T.MlPutTrainedModelAliasResponse>;
    /**
      * Creates part of a trained model definition
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/put-trained-model-definition-part.html | Elasticsearch API documentation}
      */
    putTrainedModelDefinitionPart(this: That, params: T.MlPutTrainedModelDefinitionPartRequest | TB.MlPutTrainedModelDefinitionPartRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutTrainedModelDefinitionPartResponse>;
    putTrainedModelDefinitionPart(this: That, params: T.MlPutTrainedModelDefinitionPartRequest | TB.MlPutTrainedModelDefinitionPartRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutTrainedModelDefinitionPartResponse, unknown>>;
    putTrainedModelDefinitionPart(this: That, params: T.MlPutTrainedModelDefinitionPartRequest | TB.MlPutTrainedModelDefinitionPartRequest, options?: TransportRequestOptions): Promise<T.MlPutTrainedModelDefinitionPartResponse>;
    /**
      * Creates a trained model vocabulary
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/put-trained-model-vocabulary.html | Elasticsearch API documentation}
      */
    putTrainedModelVocabulary(this: That, params: T.MlPutTrainedModelVocabularyRequest | TB.MlPutTrainedModelVocabularyRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlPutTrainedModelVocabularyResponse>;
    putTrainedModelVocabulary(this: That, params: T.MlPutTrainedModelVocabularyRequest | TB.MlPutTrainedModelVocabularyRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlPutTrainedModelVocabularyResponse, unknown>>;
    putTrainedModelVocabulary(this: That, params: T.MlPutTrainedModelVocabularyRequest | TB.MlPutTrainedModelVocabularyRequest, options?: TransportRequestOptions): Promise<T.MlPutTrainedModelVocabularyResponse>;
    /**
      * Resets an existing anomaly detection job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-reset-job.html | Elasticsearch API documentation}
      */
    resetJob(this: That, params: T.MlResetJobRequest | TB.MlResetJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlResetJobResponse>;
    resetJob(this: That, params: T.MlResetJobRequest | TB.MlResetJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlResetJobResponse, unknown>>;
    resetJob(this: That, params: T.MlResetJobRequest | TB.MlResetJobRequest, options?: TransportRequestOptions): Promise<T.MlResetJobResponse>;
    /**
      * Reverts to a specific snapshot.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-revert-snapshot.html | Elasticsearch API documentation}
      */
    revertModelSnapshot(this: That, params: T.MlRevertModelSnapshotRequest | TB.MlRevertModelSnapshotRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlRevertModelSnapshotResponse>;
    revertModelSnapshot(this: That, params: T.MlRevertModelSnapshotRequest | TB.MlRevertModelSnapshotRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlRevertModelSnapshotResponse, unknown>>;
    revertModelSnapshot(this: That, params: T.MlRevertModelSnapshotRequest | TB.MlRevertModelSnapshotRequest, options?: TransportRequestOptions): Promise<T.MlRevertModelSnapshotResponse>;
    /**
      * Sets a cluster wide upgrade_mode setting that prepares machine learning indices for an upgrade.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-set-upgrade-mode.html | Elasticsearch API documentation}
      */
    setUpgradeMode(this: That, params?: T.MlSetUpgradeModeRequest | TB.MlSetUpgradeModeRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlSetUpgradeModeResponse>;
    setUpgradeMode(this: That, params?: T.MlSetUpgradeModeRequest | TB.MlSetUpgradeModeRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlSetUpgradeModeResponse, unknown>>;
    setUpgradeMode(this: That, params?: T.MlSetUpgradeModeRequest | TB.MlSetUpgradeModeRequest, options?: TransportRequestOptions): Promise<T.MlSetUpgradeModeResponse>;
    /**
      * Starts a data frame analytics job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/start-dfanalytics.html | Elasticsearch API documentation}
      */
    startDataFrameAnalytics(this: That, params: T.MlStartDataFrameAnalyticsRequest | TB.MlStartDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlStartDataFrameAnalyticsResponse>;
    startDataFrameAnalytics(this: That, params: T.MlStartDataFrameAnalyticsRequest | TB.MlStartDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlStartDataFrameAnalyticsResponse, unknown>>;
    startDataFrameAnalytics(this: That, params: T.MlStartDataFrameAnalyticsRequest | TB.MlStartDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.MlStartDataFrameAnalyticsResponse>;
    /**
      * Starts one or more datafeeds.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-start-datafeed.html | Elasticsearch API documentation}
      */
    startDatafeed(this: That, params: T.MlStartDatafeedRequest | TB.MlStartDatafeedRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlStartDatafeedResponse>;
    startDatafeed(this: That, params: T.MlStartDatafeedRequest | TB.MlStartDatafeedRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlStartDatafeedResponse, unknown>>;
    startDatafeed(this: That, params: T.MlStartDatafeedRequest | TB.MlStartDatafeedRequest, options?: TransportRequestOptions): Promise<T.MlStartDatafeedResponse>;
    /**
      * Start a trained model deployment.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/start-trained-model-deployment.html | Elasticsearch API documentation}
      */
    startTrainedModelDeployment(this: That, params: T.MlStartTrainedModelDeploymentRequest | TB.MlStartTrainedModelDeploymentRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlStartTrainedModelDeploymentResponse>;
    startTrainedModelDeployment(this: That, params: T.MlStartTrainedModelDeploymentRequest | TB.MlStartTrainedModelDeploymentRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlStartTrainedModelDeploymentResponse, unknown>>;
    startTrainedModelDeployment(this: That, params: T.MlStartTrainedModelDeploymentRequest | TB.MlStartTrainedModelDeploymentRequest, options?: TransportRequestOptions): Promise<T.MlStartTrainedModelDeploymentResponse>;
    /**
      * Stops one or more data frame analytics jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/stop-dfanalytics.html | Elasticsearch API documentation}
      */
    stopDataFrameAnalytics(this: That, params: T.MlStopDataFrameAnalyticsRequest | TB.MlStopDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlStopDataFrameAnalyticsResponse>;
    stopDataFrameAnalytics(this: That, params: T.MlStopDataFrameAnalyticsRequest | TB.MlStopDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlStopDataFrameAnalyticsResponse, unknown>>;
    stopDataFrameAnalytics(this: That, params: T.MlStopDataFrameAnalyticsRequest | TB.MlStopDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.MlStopDataFrameAnalyticsResponse>;
    /**
      * Stops one or more datafeeds.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-stop-datafeed.html | Elasticsearch API documentation}
      */
    stopDatafeed(this: That, params: T.MlStopDatafeedRequest | TB.MlStopDatafeedRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlStopDatafeedResponse>;
    stopDatafeed(this: That, params: T.MlStopDatafeedRequest | TB.MlStopDatafeedRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlStopDatafeedResponse, unknown>>;
    stopDatafeed(this: That, params: T.MlStopDatafeedRequest | TB.MlStopDatafeedRequest, options?: TransportRequestOptions): Promise<T.MlStopDatafeedResponse>;
    /**
      * Stop a trained model deployment.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/stop-trained-model-deployment.html | Elasticsearch API documentation}
      */
    stopTrainedModelDeployment(this: That, params: T.MlStopTrainedModelDeploymentRequest | TB.MlStopTrainedModelDeploymentRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlStopTrainedModelDeploymentResponse>;
    stopTrainedModelDeployment(this: That, params: T.MlStopTrainedModelDeploymentRequest | TB.MlStopTrainedModelDeploymentRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlStopTrainedModelDeploymentResponse, unknown>>;
    stopTrainedModelDeployment(this: That, params: T.MlStopTrainedModelDeploymentRequest | TB.MlStopTrainedModelDeploymentRequest, options?: TransportRequestOptions): Promise<T.MlStopTrainedModelDeploymentResponse>;
    /**
      * Updates certain properties of a data frame analytics job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/update-dfanalytics.html | Elasticsearch API documentation}
      */
    updateDataFrameAnalytics(this: That, params: T.MlUpdateDataFrameAnalyticsRequest | TB.MlUpdateDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlUpdateDataFrameAnalyticsResponse>;
    updateDataFrameAnalytics(this: That, params: T.MlUpdateDataFrameAnalyticsRequest | TB.MlUpdateDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlUpdateDataFrameAnalyticsResponse, unknown>>;
    updateDataFrameAnalytics(this: That, params: T.MlUpdateDataFrameAnalyticsRequest | TB.MlUpdateDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.MlUpdateDataFrameAnalyticsResponse>;
    /**
      * Updates certain properties of a datafeed.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-update-datafeed.html | Elasticsearch API documentation}
      */
    updateDatafeed(this: That, params: T.MlUpdateDatafeedRequest | TB.MlUpdateDatafeedRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlUpdateDatafeedResponse>;
    updateDatafeed(this: That, params: T.MlUpdateDatafeedRequest | TB.MlUpdateDatafeedRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlUpdateDatafeedResponse, unknown>>;
    updateDatafeed(this: That, params: T.MlUpdateDatafeedRequest | TB.MlUpdateDatafeedRequest, options?: TransportRequestOptions): Promise<T.MlUpdateDatafeedResponse>;
    /**
      * Updates the description of a filter, adds items, or removes items.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-update-filter.html | Elasticsearch API documentation}
      */
    updateFilter(this: That, params: T.MlUpdateFilterRequest | TB.MlUpdateFilterRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlUpdateFilterResponse>;
    updateFilter(this: That, params: T.MlUpdateFilterRequest | TB.MlUpdateFilterRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlUpdateFilterResponse, unknown>>;
    updateFilter(this: That, params: T.MlUpdateFilterRequest | TB.MlUpdateFilterRequest, options?: TransportRequestOptions): Promise<T.MlUpdateFilterResponse>;
    /**
      * Updates certain properties of an anomaly detection job.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-update-job.html | Elasticsearch API documentation}
      */
    updateJob(this: That, params: T.MlUpdateJobRequest | TB.MlUpdateJobRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlUpdateJobResponse>;
    updateJob(this: That, params: T.MlUpdateJobRequest | TB.MlUpdateJobRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlUpdateJobResponse, unknown>>;
    updateJob(this: That, params: T.MlUpdateJobRequest | TB.MlUpdateJobRequest, options?: TransportRequestOptions): Promise<T.MlUpdateJobResponse>;
    /**
      * Updates certain properties of a snapshot.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-update-snapshot.html | Elasticsearch API documentation}
      */
    updateModelSnapshot(this: That, params: T.MlUpdateModelSnapshotRequest | TB.MlUpdateModelSnapshotRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlUpdateModelSnapshotResponse>;
    updateModelSnapshot(this: That, params: T.MlUpdateModelSnapshotRequest | TB.MlUpdateModelSnapshotRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlUpdateModelSnapshotResponse, unknown>>;
    updateModelSnapshot(this: That, params: T.MlUpdateModelSnapshotRequest | TB.MlUpdateModelSnapshotRequest, options?: TransportRequestOptions): Promise<T.MlUpdateModelSnapshotResponse>;
    /**
      * Updates certain properties of trained model deployment.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/update-trained-model-deployment.html | Elasticsearch API documentation}
      */
    updateTrainedModelDeployment(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithOutMeta): Promise<T.TODO>;
    updateTrainedModelDeployment(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.TODO, unknown>>;
    updateTrainedModelDeployment(this: That, params?: T.TODO | TB.TODO, options?: TransportRequestOptions): Promise<T.TODO>;
    /**
      * Upgrades a given job snapshot to the current major version.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ml-upgrade-job-model-snapshot.html | Elasticsearch API documentation}
      */
    upgradeJobSnapshot(this: That, params: T.MlUpgradeJobSnapshotRequest | TB.MlUpgradeJobSnapshotRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlUpgradeJobSnapshotResponse>;
    upgradeJobSnapshot(this: That, params: T.MlUpgradeJobSnapshotRequest | TB.MlUpgradeJobSnapshotRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlUpgradeJobSnapshotResponse, unknown>>;
    upgradeJobSnapshot(this: That, params: T.MlUpgradeJobSnapshotRequest | TB.MlUpgradeJobSnapshotRequest, options?: TransportRequestOptions): Promise<T.MlUpgradeJobSnapshotResponse>;
    /**
      * Validates an anomaly detection job.
      * @see {@link https://www.elastic.co/guide/en/machine-learning/8.13/ml-jobs.html | Elasticsearch API documentation}
      */
    validate(this: That, params?: T.MlValidateRequest | TB.MlValidateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlValidateResponse>;
    validate(this: That, params?: T.MlValidateRequest | TB.MlValidateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlValidateResponse, unknown>>;
    validate(this: That, params?: T.MlValidateRequest | TB.MlValidateRequest, options?: TransportRequestOptions): Promise<T.MlValidateResponse>;
    /**
      * Validates an anomaly detection detector.
      * @see {@link https://www.elastic.co/guide/en/machine-learning/8.13/ml-jobs.html | Elasticsearch API documentation}
      */
    validateDetector(this: That, params: T.MlValidateDetectorRequest | TB.MlValidateDetectorRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.MlValidateDetectorResponse>;
    validateDetector(this: That, params: T.MlValidateDetectorRequest | TB.MlValidateDetectorRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.MlValidateDetectorResponse, unknown>>;
    validateDetector(this: That, params: T.MlValidateDetectorRequest | TB.MlValidateDetectorRequest, options?: TransportRequestOptions): Promise<T.MlValidateDetectorResponse>;
}
export {};
