import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
export default class Ingest {
    transport: Transport;
    constructor(transport: Transport);
    /**
      * Deletes a pipeline.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/delete-pipeline-api.html | Elasticsearch API documentation}
      */
    deletePipeline(this: That, params: T.IngestDeletePipelineRequest | TB.IngestDeletePipelineRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.IngestDeletePipelineResponse>;
    deletePipeline(this: That, params: T.IngestDeletePipelineRequest | TB.IngestDeletePipelineRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.IngestDeletePipelineResponse, unknown>>;
    deletePipeline(this: That, params: T.IngestDeletePipelineRequest | TB.IngestDeletePipelineRequest, options?: TransportRequestOptions): Promise<T.IngestDeletePipelineResponse>;
    /**
      * Returns statistical information about geoip databases
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/geoip-processor.html | Elasticsearch API documentation}
      */
    geoIpStats(this: That, params?: T.IngestGeoIpStatsRequest | TB.IngestGeoIpStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.IngestGeoIpStatsResponse>;
    geoIpStats(this: That, params?: T.IngestGeoIpStatsRequest | TB.IngestGeoIpStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.IngestGeoIpStatsResponse, unknown>>;
    geoIpStats(this: That, params?: T.IngestGeoIpStatsRequest | TB.IngestGeoIpStatsRequest, options?: TransportRequestOptions): Promise<T.IngestGeoIpStatsResponse>;
    /**
      * Returns a pipeline.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-pipeline-api.html | Elasticsearch API documentation}
      */
    getPipeline(this: That, params?: T.IngestGetPipelineRequest | TB.IngestGetPipelineRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.IngestGetPipelineResponse>;
    getPipeline(this: That, params?: T.IngestGetPipelineRequest | TB.IngestGetPipelineRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.IngestGetPipelineResponse, unknown>>;
    getPipeline(this: That, params?: T.IngestGetPipelineRequest | TB.IngestGetPipelineRequest, options?: TransportRequestOptions): Promise<T.IngestGetPipelineResponse>;
    /**
      * Returns a list of the built-in patterns.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/grok-processor.html | Elasticsearch API documentation}
      */
    processorGrok(this: That, params?: T.IngestProcessorGrokRequest | TB.IngestProcessorGrokRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.IngestProcessorGrokResponse>;
    processorGrok(this: That, params?: T.IngestProcessorGrokRequest | TB.IngestProcessorGrokRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.IngestProcessorGrokResponse, unknown>>;
    processorGrok(this: That, params?: T.IngestProcessorGrokRequest | TB.IngestProcessorGrokRequest, options?: TransportRequestOptions): Promise<T.IngestProcessorGrokResponse>;
    /**
      * Creates or updates a pipeline.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/ingest.html | Elasticsearch API documentation}
      */
    putPipeline(this: That, params: T.IngestPutPipelineRequest | TB.IngestPutPipelineRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.IngestPutPipelineResponse>;
    putPipeline(this: That, params: T.IngestPutPipelineRequest | TB.IngestPutPipelineRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.IngestPutPipelineResponse, unknown>>;
    putPipeline(this: That, params: T.IngestPutPipelineRequest | TB.IngestPutPipelineRequest, options?: TransportRequestOptions): Promise<T.IngestPutPipelineResponse>;
    /**
      * Allows to simulate a pipeline with example documents.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/simulate-pipeline-api.html | Elasticsearch API documentation}
      */
    simulate(this: That, params?: T.IngestSimulateRequest | TB.IngestSimulateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.IngestSimulateResponse>;
    simulate(this: That, params?: T.IngestSimulateRequest | TB.IngestSimulateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.IngestSimulateResponse, unknown>>;
    simulate(this: That, params?: T.IngestSimulateRequest | TB.IngestSimulateRequest, options?: TransportRequestOptions): Promise<T.IngestSimulateResponse>;
}
export {};
