import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
export default class Inference {
    transport: Transport;
    constructor(transport: Transport);
    /**
      * Delete model in the Inference API
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/delete-inference-api.html | Elasticsearch API documentation}
      */
    deleteModel(this: That, params: T.InferenceDeleteModelRequest | TB.InferenceDeleteModelRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.InferenceDeleteModelResponse>;
    deleteModel(this: That, params: T.InferenceDeleteModelRequest | TB.InferenceDeleteModelRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.InferenceDeleteModelResponse, unknown>>;
    deleteModel(this: That, params: T.InferenceDeleteModelRequest | TB.InferenceDeleteModelRequest, options?: TransportRequestOptions): Promise<T.InferenceDeleteModelResponse>;
    /**
      * Get a model in the Inference API
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/get-inference-api.html | Elasticsearch API documentation}
      */
    getModel(this: That, params: T.InferenceGetModelRequest | TB.InferenceGetModelRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.InferenceGetModelResponse>;
    getModel(this: That, params: T.InferenceGetModelRequest | TB.InferenceGetModelRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.InferenceGetModelResponse, unknown>>;
    getModel(this: That, params: T.InferenceGetModelRequest | TB.InferenceGetModelRequest, options?: TransportRequestOptions): Promise<T.InferenceGetModelResponse>;
    /**
      * Perform inference on a model
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/post-inference-api.html | Elasticsearch API documentation}
      */
    inference(this: That, params: T.InferenceInferenceRequest | TB.InferenceInferenceRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.InferenceInferenceResponse>;
    inference(this: That, params: T.InferenceInferenceRequest | TB.InferenceInferenceRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.InferenceInferenceResponse, unknown>>;
    inference(this: That, params: T.InferenceInferenceRequest | TB.InferenceInferenceRequest, options?: TransportRequestOptions): Promise<T.InferenceInferenceResponse>;
    /**
      * Configure a model for use in the Inference API
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/put-inference-api.html | Elasticsearch API documentation}
      */
    putModel(this: That, params: T.InferencePutModelRequest | TB.InferencePutModelRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.InferencePutModelResponse>;
    putModel(this: That, params: T.InferencePutModelRequest | TB.InferencePutModelRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.InferencePutModelResponse, unknown>>;
    putModel(this: That, params: T.InferencePutModelRequest | TB.InferencePutModelRequest, options?: TransportRequestOptions): Promise<T.InferencePutModelResponse>;
}
export {};
