import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
/**
  * Creates a new document in the index. Returns a 409 response when a document with a same ID already exists in the index.
  * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/docs-index_.html | Elasticsearch API documentation}
  */
export default function CreateApi<TDocument = unknown>(this: That, params: T.CreateRequest<TDocument> | TB.CreateRequest<TDocument>, options?: TransportRequestOptionsWithOutMeta): Promise<T.CreateResponse>;
export default function CreateApi<TDocument = unknown>(this: That, params: T.CreateRequest<TDocument> | TB.CreateRequest<TDocument>, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CreateResponse, unknown>>;
export default function CreateApi<TDocument = unknown>(this: That, params: T.CreateRequest<TDocument> | TB.CreateRequest<TDocument>, options?: TransportRequestOptions): Promise<T.CreateResponse>;
export {};
