import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
export default class Cluster {
    transport: Transport;
    constructor(transport: Transport);
    /**
      * Provides explanations for shard allocations in the cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-allocation-explain.html | Elasticsearch API documentation}
      */
    allocationExplain(this: That, params?: T.ClusterAllocationExplainRequest | TB.ClusterAllocationExplainRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterAllocationExplainResponse>;
    allocationExplain(this: That, params?: T.ClusterAllocationExplainRequest | TB.ClusterAllocationExplainRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterAllocationExplainResponse, unknown>>;
    allocationExplain(this: That, params?: T.ClusterAllocationExplainRequest | TB.ClusterAllocationExplainRequest, options?: TransportRequestOptions): Promise<T.ClusterAllocationExplainResponse>;
    /**
      * Deletes a component template
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/indices-component-template.html | Elasticsearch API documentation}
      */
    deleteComponentTemplate(this: That, params: T.ClusterDeleteComponentTemplateRequest | TB.ClusterDeleteComponentTemplateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterDeleteComponentTemplateResponse>;
    deleteComponentTemplate(this: That, params: T.ClusterDeleteComponentTemplateRequest | TB.ClusterDeleteComponentTemplateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterDeleteComponentTemplateResponse, unknown>>;
    deleteComponentTemplate(this: That, params: T.ClusterDeleteComponentTemplateRequest | TB.ClusterDeleteComponentTemplateRequest, options?: TransportRequestOptions): Promise<T.ClusterDeleteComponentTemplateResponse>;
    /**
      * Clears cluster voting config exclusions.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/voting-config-exclusions.html | Elasticsearch API documentation}
      */
    deleteVotingConfigExclusions(this: That, params?: T.ClusterDeleteVotingConfigExclusionsRequest | TB.ClusterDeleteVotingConfigExclusionsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterDeleteVotingConfigExclusionsResponse>;
    deleteVotingConfigExclusions(this: That, params?: T.ClusterDeleteVotingConfigExclusionsRequest | TB.ClusterDeleteVotingConfigExclusionsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterDeleteVotingConfigExclusionsResponse, unknown>>;
    deleteVotingConfigExclusions(this: That, params?: T.ClusterDeleteVotingConfigExclusionsRequest | TB.ClusterDeleteVotingConfigExclusionsRequest, options?: TransportRequestOptions): Promise<T.ClusterDeleteVotingConfigExclusionsResponse>;
    /**
      * Returns information about whether a particular component template exist
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/indices-component-template.html | Elasticsearch API documentation}
      */
    existsComponentTemplate(this: That, params: T.ClusterExistsComponentTemplateRequest | TB.ClusterExistsComponentTemplateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterExistsComponentTemplateResponse>;
    existsComponentTemplate(this: That, params: T.ClusterExistsComponentTemplateRequest | TB.ClusterExistsComponentTemplateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterExistsComponentTemplateResponse, unknown>>;
    existsComponentTemplate(this: That, params: T.ClusterExistsComponentTemplateRequest | TB.ClusterExistsComponentTemplateRequest, options?: TransportRequestOptions): Promise<T.ClusterExistsComponentTemplateResponse>;
    /**
      * Returns one or more component templates
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/indices-component-template.html | Elasticsearch API documentation}
      */
    getComponentTemplate(this: That, params?: T.ClusterGetComponentTemplateRequest | TB.ClusterGetComponentTemplateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterGetComponentTemplateResponse>;
    getComponentTemplate(this: That, params?: T.ClusterGetComponentTemplateRequest | TB.ClusterGetComponentTemplateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterGetComponentTemplateResponse, unknown>>;
    getComponentTemplate(this: That, params?: T.ClusterGetComponentTemplateRequest | TB.ClusterGetComponentTemplateRequest, options?: TransportRequestOptions): Promise<T.ClusterGetComponentTemplateResponse>;
    /**
      * Returns cluster settings.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-get-settings.html | Elasticsearch API documentation}
      */
    getSettings(this: That, params?: T.ClusterGetSettingsRequest | TB.ClusterGetSettingsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterGetSettingsResponse>;
    getSettings(this: That, params?: T.ClusterGetSettingsRequest | TB.ClusterGetSettingsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterGetSettingsResponse, unknown>>;
    getSettings(this: That, params?: T.ClusterGetSettingsRequest | TB.ClusterGetSettingsRequest, options?: TransportRequestOptions): Promise<T.ClusterGetSettingsResponse>;
    /**
      * Returns basic information about the health of the cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-health.html | Elasticsearch API documentation}
      */
    health(this: That, params?: T.ClusterHealthRequest | TB.ClusterHealthRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterHealthResponse>;
    health(this: That, params?: T.ClusterHealthRequest | TB.ClusterHealthRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterHealthResponse, unknown>>;
    health(this: That, params?: T.ClusterHealthRequest | TB.ClusterHealthRequest, options?: TransportRequestOptions): Promise<T.ClusterHealthResponse>;
    /**
      * Returns different information about the cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-info.html | Elasticsearch API documentation}
      */
    info(this: That, params: T.ClusterInfoRequest | TB.ClusterInfoRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterInfoResponse>;
    info(this: That, params: T.ClusterInfoRequest | TB.ClusterInfoRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterInfoResponse, unknown>>;
    info(this: That, params: T.ClusterInfoRequest | TB.ClusterInfoRequest, options?: TransportRequestOptions): Promise<T.ClusterInfoResponse>;
    /**
      * Returns a list of any cluster-level changes (e.g. create index, update mapping, allocate or fail shard) which have not yet been executed.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-pending.html | Elasticsearch API documentation}
      */
    pendingTasks(this: That, params?: T.ClusterPendingTasksRequest | TB.ClusterPendingTasksRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterPendingTasksResponse>;
    pendingTasks(this: That, params?: T.ClusterPendingTasksRequest | TB.ClusterPendingTasksRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterPendingTasksResponse, unknown>>;
    pendingTasks(this: That, params?: T.ClusterPendingTasksRequest | TB.ClusterPendingTasksRequest, options?: TransportRequestOptions): Promise<T.ClusterPendingTasksResponse>;
    /**
      * Updates the cluster voting config exclusions by node ids or node names.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/voting-config-exclusions.html | Elasticsearch API documentation}
      */
    postVotingConfigExclusions(this: That, params?: T.ClusterPostVotingConfigExclusionsRequest | TB.ClusterPostVotingConfigExclusionsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterPostVotingConfigExclusionsResponse>;
    postVotingConfigExclusions(this: That, params?: T.ClusterPostVotingConfigExclusionsRequest | TB.ClusterPostVotingConfigExclusionsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterPostVotingConfigExclusionsResponse, unknown>>;
    postVotingConfigExclusions(this: That, params?: T.ClusterPostVotingConfigExclusionsRequest | TB.ClusterPostVotingConfigExclusionsRequest, options?: TransportRequestOptions): Promise<T.ClusterPostVotingConfigExclusionsResponse>;
    /**
      * Creates or updates a component template
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/indices-component-template.html | Elasticsearch API documentation}
      */
    putComponentTemplate(this: That, params: T.ClusterPutComponentTemplateRequest | TB.ClusterPutComponentTemplateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterPutComponentTemplateResponse>;
    putComponentTemplate(this: That, params: T.ClusterPutComponentTemplateRequest | TB.ClusterPutComponentTemplateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterPutComponentTemplateResponse, unknown>>;
    putComponentTemplate(this: That, params: T.ClusterPutComponentTemplateRequest | TB.ClusterPutComponentTemplateRequest, options?: TransportRequestOptions): Promise<T.ClusterPutComponentTemplateResponse>;
    /**
      * Updates the cluster settings.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-update-settings.html | Elasticsearch API documentation}
      */
    putSettings(this: That, params?: T.ClusterPutSettingsRequest | TB.ClusterPutSettingsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterPutSettingsResponse>;
    putSettings(this: That, params?: T.ClusterPutSettingsRequest | TB.ClusterPutSettingsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterPutSettingsResponse, unknown>>;
    putSettings(this: That, params?: T.ClusterPutSettingsRequest | TB.ClusterPutSettingsRequest, options?: TransportRequestOptions): Promise<T.ClusterPutSettingsResponse>;
    /**
      * Returns the information about configured remote clusters.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-remote-info.html | Elasticsearch API documentation}
      */
    remoteInfo(this: That, params?: T.ClusterRemoteInfoRequest | TB.ClusterRemoteInfoRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterRemoteInfoResponse>;
    remoteInfo(this: That, params?: T.ClusterRemoteInfoRequest | TB.ClusterRemoteInfoRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterRemoteInfoResponse, unknown>>;
    remoteInfo(this: That, params?: T.ClusterRemoteInfoRequest | TB.ClusterRemoteInfoRequest, options?: TransportRequestOptions): Promise<T.ClusterRemoteInfoResponse>;
    /**
      * Allows to manually change the allocation of individual shards in the cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-reroute.html | Elasticsearch API documentation}
      */
    reroute(this: That, params?: T.ClusterRerouteRequest | TB.ClusterRerouteRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterRerouteResponse>;
    reroute(this: That, params?: T.ClusterRerouteRequest | TB.ClusterRerouteRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterRerouteResponse, unknown>>;
    reroute(this: That, params?: T.ClusterRerouteRequest | TB.ClusterRerouteRequest, options?: TransportRequestOptions): Promise<T.ClusterRerouteResponse>;
    /**
      * Returns a comprehensive information about the state of the cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-state.html | Elasticsearch API documentation}
      */
    state(this: That, params?: T.ClusterStateRequest | TB.ClusterStateRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterStateResponse>;
    state(this: That, params?: T.ClusterStateRequest | TB.ClusterStateRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterStateResponse, unknown>>;
    state(this: That, params?: T.ClusterStateRequest | TB.ClusterStateRequest, options?: TransportRequestOptions): Promise<T.ClusterStateResponse>;
    /**
      * Returns high-level overview of cluster statistics.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cluster-stats.html | Elasticsearch API documentation}
      */
    stats(this: That, params?: T.ClusterStatsRequest | TB.ClusterStatsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.ClusterStatsResponse>;
    stats(this: That, params?: T.ClusterStatsRequest | TB.ClusterStatsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.ClusterStatsResponse, unknown>>;
    stats(this: That, params?: T.ClusterStatsRequest | TB.ClusterStatsRequest, options?: TransportRequestOptions): Promise<T.ClusterStatsResponse>;
}
export {};
