import { Transport, TransportRequestOptions, TransportRequestOptionsWithMeta, TransportRequestOptionsWithOutMeta, TransportResult } from '@elastic/transport';
import * as T from '../types';
import * as TB from '../typesWithBodyKey';
interface That {
    transport: Transport;
}
export default class Cat {
    transport: Transport;
    constructor(transport: Transport);
    /**
      * Shows information about currently configured aliases to indices including filter and routing infos.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-alias.html | Elasticsearch API documentation}
      */
    aliases(this: That, params?: T.CatAliasesRequest | TB.CatAliasesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatAliasesResponse>;
    aliases(this: That, params?: T.CatAliasesRequest | TB.CatAliasesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatAliasesResponse, unknown>>;
    aliases(this: That, params?: T.CatAliasesRequest | TB.CatAliasesRequest, options?: TransportRequestOptions): Promise<T.CatAliasesResponse>;
    /**
      * Provides a snapshot of how many shards are allocated to each data node and how much disk space they are using.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-allocation.html | Elasticsearch API documentation}
      */
    allocation(this: That, params?: T.CatAllocationRequest | TB.CatAllocationRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatAllocationResponse>;
    allocation(this: That, params?: T.CatAllocationRequest | TB.CatAllocationRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatAllocationResponse, unknown>>;
    allocation(this: That, params?: T.CatAllocationRequest | TB.CatAllocationRequest, options?: TransportRequestOptions): Promise<T.CatAllocationResponse>;
    /**
      * Returns information about existing component_templates templates.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-component-templates.html | Elasticsearch API documentation}
      */
    componentTemplates(this: That, params?: T.CatComponentTemplatesRequest | TB.CatComponentTemplatesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatComponentTemplatesResponse>;
    componentTemplates(this: That, params?: T.CatComponentTemplatesRequest | TB.CatComponentTemplatesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatComponentTemplatesResponse, unknown>>;
    componentTemplates(this: That, params?: T.CatComponentTemplatesRequest | TB.CatComponentTemplatesRequest, options?: TransportRequestOptions): Promise<T.CatComponentTemplatesResponse>;
    /**
      * Provides quick access to the document count of the entire cluster, or individual indices.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-count.html | Elasticsearch API documentation}
      */
    count(this: That, params?: T.CatCountRequest | TB.CatCountRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatCountResponse>;
    count(this: That, params?: T.CatCountRequest | TB.CatCountRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatCountResponse, unknown>>;
    count(this: That, params?: T.CatCountRequest | TB.CatCountRequest, options?: TransportRequestOptions): Promise<T.CatCountResponse>;
    /**
      * Shows how much heap memory is currently being used by fielddata on every data node in the cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-fielddata.html | Elasticsearch API documentation}
      */
    fielddata(this: That, params?: T.CatFielddataRequest | TB.CatFielddataRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatFielddataResponse>;
    fielddata(this: That, params?: T.CatFielddataRequest | TB.CatFielddataRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatFielddataResponse, unknown>>;
    fielddata(this: That, params?: T.CatFielddataRequest | TB.CatFielddataRequest, options?: TransportRequestOptions): Promise<T.CatFielddataResponse>;
    /**
      * Returns a concise representation of the cluster health.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-health.html | Elasticsearch API documentation}
      */
    health(this: That, params?: T.CatHealthRequest | TB.CatHealthRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatHealthResponse>;
    health(this: That, params?: T.CatHealthRequest | TB.CatHealthRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatHealthResponse, unknown>>;
    health(this: That, params?: T.CatHealthRequest | TB.CatHealthRequest, options?: TransportRequestOptions): Promise<T.CatHealthResponse>;
    /**
      * Returns help for the Cat APIs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat.html | Elasticsearch API documentation}
      */
    help(this: That, params?: T.CatHelpRequest | TB.CatHelpRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatHelpResponse>;
    help(this: That, params?: T.CatHelpRequest | TB.CatHelpRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatHelpResponse, unknown>>;
    help(this: That, params?: T.CatHelpRequest | TB.CatHelpRequest, options?: TransportRequestOptions): Promise<T.CatHelpResponse>;
    /**
      * Returns information about indices: number of primaries and replicas, document counts, disk size, ...
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-indices.html | Elasticsearch API documentation}
      */
    indices(this: That, params?: T.CatIndicesRequest | TB.CatIndicesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatIndicesResponse>;
    indices(this: That, params?: T.CatIndicesRequest | TB.CatIndicesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatIndicesResponse, unknown>>;
    indices(this: That, params?: T.CatIndicesRequest | TB.CatIndicesRequest, options?: TransportRequestOptions): Promise<T.CatIndicesResponse>;
    /**
      * Returns information about the master node.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-master.html | Elasticsearch API documentation}
      */
    master(this: That, params?: T.CatMasterRequest | TB.CatMasterRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatMasterResponse>;
    master(this: That, params?: T.CatMasterRequest | TB.CatMasterRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatMasterResponse, unknown>>;
    master(this: That, params?: T.CatMasterRequest | TB.CatMasterRequest, options?: TransportRequestOptions): Promise<T.CatMasterResponse>;
    /**
      * Gets configuration and usage information about data frame analytics jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-dfanalytics.html | Elasticsearch API documentation}
      */
    mlDataFrameAnalytics(this: That, params?: T.CatMlDataFrameAnalyticsRequest | TB.CatMlDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatMlDataFrameAnalyticsResponse>;
    mlDataFrameAnalytics(this: That, params?: T.CatMlDataFrameAnalyticsRequest | TB.CatMlDataFrameAnalyticsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatMlDataFrameAnalyticsResponse, unknown>>;
    mlDataFrameAnalytics(this: That, params?: T.CatMlDataFrameAnalyticsRequest | TB.CatMlDataFrameAnalyticsRequest, options?: TransportRequestOptions): Promise<T.CatMlDataFrameAnalyticsResponse>;
    /**
      * Gets configuration and usage information about datafeeds.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-datafeeds.html | Elasticsearch API documentation}
      */
    mlDatafeeds(this: That, params?: T.CatMlDatafeedsRequest | TB.CatMlDatafeedsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatMlDatafeedsResponse>;
    mlDatafeeds(this: That, params?: T.CatMlDatafeedsRequest | TB.CatMlDatafeedsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatMlDatafeedsResponse, unknown>>;
    mlDatafeeds(this: That, params?: T.CatMlDatafeedsRequest | TB.CatMlDatafeedsRequest, options?: TransportRequestOptions): Promise<T.CatMlDatafeedsResponse>;
    /**
      * Gets configuration and usage information about anomaly detection jobs.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-anomaly-detectors.html | Elasticsearch API documentation}
      */
    mlJobs(this: That, params?: T.CatMlJobsRequest | TB.CatMlJobsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatMlJobsResponse>;
    mlJobs(this: That, params?: T.CatMlJobsRequest | TB.CatMlJobsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatMlJobsResponse, unknown>>;
    mlJobs(this: That, params?: T.CatMlJobsRequest | TB.CatMlJobsRequest, options?: TransportRequestOptions): Promise<T.CatMlJobsResponse>;
    /**
      * Gets configuration and usage information about inference trained models.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-trained-model.html | Elasticsearch API documentation}
      */
    mlTrainedModels(this: That, params?: T.CatMlTrainedModelsRequest | TB.CatMlTrainedModelsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatMlTrainedModelsResponse>;
    mlTrainedModels(this: That, params?: T.CatMlTrainedModelsRequest | TB.CatMlTrainedModelsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatMlTrainedModelsResponse, unknown>>;
    mlTrainedModels(this: That, params?: T.CatMlTrainedModelsRequest | TB.CatMlTrainedModelsRequest, options?: TransportRequestOptions): Promise<T.CatMlTrainedModelsResponse>;
    /**
      * Returns information about custom node attributes.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-nodeattrs.html | Elasticsearch API documentation}
      */
    nodeattrs(this: That, params?: T.CatNodeattrsRequest | TB.CatNodeattrsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatNodeattrsResponse>;
    nodeattrs(this: That, params?: T.CatNodeattrsRequest | TB.CatNodeattrsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatNodeattrsResponse, unknown>>;
    nodeattrs(this: That, params?: T.CatNodeattrsRequest | TB.CatNodeattrsRequest, options?: TransportRequestOptions): Promise<T.CatNodeattrsResponse>;
    /**
      * Returns basic statistics about performance of cluster nodes.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-nodes.html | Elasticsearch API documentation}
      */
    nodes(this: That, params?: T.CatNodesRequest | TB.CatNodesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatNodesResponse>;
    nodes(this: That, params?: T.CatNodesRequest | TB.CatNodesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatNodesResponse, unknown>>;
    nodes(this: That, params?: T.CatNodesRequest | TB.CatNodesRequest, options?: TransportRequestOptions): Promise<T.CatNodesResponse>;
    /**
      * Returns a concise representation of the cluster pending tasks.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-pending-tasks.html | Elasticsearch API documentation}
      */
    pendingTasks(this: That, params?: T.CatPendingTasksRequest | TB.CatPendingTasksRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatPendingTasksResponse>;
    pendingTasks(this: That, params?: T.CatPendingTasksRequest | TB.CatPendingTasksRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatPendingTasksResponse, unknown>>;
    pendingTasks(this: That, params?: T.CatPendingTasksRequest | TB.CatPendingTasksRequest, options?: TransportRequestOptions): Promise<T.CatPendingTasksResponse>;
    /**
      * Returns information about installed plugins across nodes node.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-plugins.html | Elasticsearch API documentation}
      */
    plugins(this: That, params?: T.CatPluginsRequest | TB.CatPluginsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatPluginsResponse>;
    plugins(this: That, params?: T.CatPluginsRequest | TB.CatPluginsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatPluginsResponse, unknown>>;
    plugins(this: That, params?: T.CatPluginsRequest | TB.CatPluginsRequest, options?: TransportRequestOptions): Promise<T.CatPluginsResponse>;
    /**
      * Returns information about index shard recoveries, both on-going completed.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-recovery.html | Elasticsearch API documentation}
      */
    recovery(this: That, params?: T.CatRecoveryRequest | TB.CatRecoveryRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatRecoveryResponse>;
    recovery(this: That, params?: T.CatRecoveryRequest | TB.CatRecoveryRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatRecoveryResponse, unknown>>;
    recovery(this: That, params?: T.CatRecoveryRequest | TB.CatRecoveryRequest, options?: TransportRequestOptions): Promise<T.CatRecoveryResponse>;
    /**
      * Returns information about snapshot repositories registered in the cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-repositories.html | Elasticsearch API documentation}
      */
    repositories(this: That, params?: T.CatRepositoriesRequest | TB.CatRepositoriesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatRepositoriesResponse>;
    repositories(this: That, params?: T.CatRepositoriesRequest | TB.CatRepositoriesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatRepositoriesResponse, unknown>>;
    repositories(this: That, params?: T.CatRepositoriesRequest | TB.CatRepositoriesRequest, options?: TransportRequestOptions): Promise<T.CatRepositoriesResponse>;
    /**
      * Provides low-level information about the segments in the shards of an index.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-segments.html | Elasticsearch API documentation}
      */
    segments(this: That, params?: T.CatSegmentsRequest | TB.CatSegmentsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatSegmentsResponse>;
    segments(this: That, params?: T.CatSegmentsRequest | TB.CatSegmentsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatSegmentsResponse, unknown>>;
    segments(this: That, params?: T.CatSegmentsRequest | TB.CatSegmentsRequest, options?: TransportRequestOptions): Promise<T.CatSegmentsResponse>;
    /**
      * Provides a detailed view of shard allocation on nodes.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-shards.html | Elasticsearch API documentation}
      */
    shards(this: That, params?: T.CatShardsRequest | TB.CatShardsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatShardsResponse>;
    shards(this: That, params?: T.CatShardsRequest | TB.CatShardsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatShardsResponse, unknown>>;
    shards(this: That, params?: T.CatShardsRequest | TB.CatShardsRequest, options?: TransportRequestOptions): Promise<T.CatShardsResponse>;
    /**
      * Returns all snapshots in a specific repository.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-snapshots.html | Elasticsearch API documentation}
      */
    snapshots(this: That, params?: T.CatSnapshotsRequest | TB.CatSnapshotsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatSnapshotsResponse>;
    snapshots(this: That, params?: T.CatSnapshotsRequest | TB.CatSnapshotsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatSnapshotsResponse, unknown>>;
    snapshots(this: That, params?: T.CatSnapshotsRequest | TB.CatSnapshotsRequest, options?: TransportRequestOptions): Promise<T.CatSnapshotsResponse>;
    /**
      * Returns information about the tasks currently executing on one or more nodes in the cluster.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/tasks.html | Elasticsearch API documentation}
      */
    tasks(this: That, params?: T.CatTasksRequest | TB.CatTasksRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatTasksResponse>;
    tasks(this: That, params?: T.CatTasksRequest | TB.CatTasksRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatTasksResponse, unknown>>;
    tasks(this: That, params?: T.CatTasksRequest | TB.CatTasksRequest, options?: TransportRequestOptions): Promise<T.CatTasksResponse>;
    /**
      * Returns information about existing templates.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-templates.html | Elasticsearch API documentation}
      */
    templates(this: That, params?: T.CatTemplatesRequest | TB.CatTemplatesRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatTemplatesResponse>;
    templates(this: That, params?: T.CatTemplatesRequest | TB.CatTemplatesRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatTemplatesResponse, unknown>>;
    templates(this: That, params?: T.CatTemplatesRequest | TB.CatTemplatesRequest, options?: TransportRequestOptions): Promise<T.CatTemplatesResponse>;
    /**
      * Returns cluster-wide thread pool statistics per node. By default the active, queue and rejected statistics are returned for all thread pools.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-thread-pool.html | Elasticsearch API documentation}
      */
    threadPool(this: That, params?: T.CatThreadPoolRequest | TB.CatThreadPoolRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatThreadPoolResponse>;
    threadPool(this: That, params?: T.CatThreadPoolRequest | TB.CatThreadPoolRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatThreadPoolResponse, unknown>>;
    threadPool(this: That, params?: T.CatThreadPoolRequest | TB.CatThreadPoolRequest, options?: TransportRequestOptions): Promise<T.CatThreadPoolResponse>;
    /**
      * Gets configuration and usage information about transforms.
      * @see {@link https://www.elastic.co/guide/en/elasticsearch/reference/8.13/cat-transforms.html | Elasticsearch API documentation}
      */
    transforms(this: That, params?: T.CatTransformsRequest | TB.CatTransformsRequest, options?: TransportRequestOptionsWithOutMeta): Promise<T.CatTransformsResponse>;
    transforms(this: That, params?: T.CatTransformsRequest | TB.CatTransformsRequest, options?: TransportRequestOptionsWithMeta): Promise<TransportResult<T.CatTransformsResponse, unknown>>;
    transforms(this: That, params?: T.CatTransformsRequest | TB.CatTransformsRequest, options?: TransportRequestOptions): Promise<T.CatTransformsResponse>;
}
export {};
