---
id: eject_collections
title: Eject Collections.
sidebar_label: Eject Collections
---

The **newest version of [FireCMS](https://app.firecms.co)**, version 3.0 allows you to fully manage the CMS in the Cloud
without having to manage code, so you can create collections using our **UI to create any schema** you need.

Consider the Books collection from our [demo](https://demo.firecms.co). The collection includes fields such as Title,
Subtitle, Authors, Rating, Category, etc. You can create this collection using the UI, and then manage it from the UI.
Any text, dates, images, list of text or other fields that you may think of.

![edit_collection_in_ui](/img/docs/collections/eject_collections_book_collection.png)

But what if you need to **customize** the view **further**, or prefer to use code to create the collection? FireCMS
allows you to do just that. You can start a customization process with
our [quickstart guide](https://firecms.co/docs/cloud/quickstart) and then upload it to the Cloud, using the same
hosted app.

A common question we receive is how to import the code of a collection. It's as simple as navigating to the Schema
Editor, clicking the Code button, and copying the generated code. You can then **eject the collection** and manage it
directly from your codebase.

![edit_collection_code_button](/img/docs/collections/eject_collections_code_button.png)

Next, paste the copied code into your preferred Code Editor.

![edit_collection_code_button](/img/docs/collections/eject_collections_code.png)

:::important
This feature is available across all plans, including free and plus subscriptions. We believe in the power of code and
want to make it accessible to everyone.
:::

In summary, the latest version of [FireCMS](https://app.firecms.co) provides a **seamless No Code experience** for
managing your CMS. However, if you need to customize your CMS further, you can easily switch to a Code-based approach.
All within a single app, [app.firecms.co](https://www.notion.so/e8af421701bb440ebcc4ef4ce265e9ad?pvs=21).

Here's the full code generated by the UI for the Books collection:

```tsx
import { EntityCollection } from "@firecms/core";

const BooksCollection: EntityCollection = {
    id: 'books',
    name: 'Books',
    path: 'books',
    editable: true,
    icon: 'table_rows',
    group: '',
    properties: {
        title: {
            name: 'Title',
            validation: {
                required: true,
            },
            dataType: 'string',
        },
        subtitle: {
            dataType: 'string',
            name: 'Subtitle',
        },
        authors: {
            name: 'Authors',
            dataType: 'string',
        },
        average_rating: {
            dataType: 'number',
            name: 'Average Rating',
        },
        category: {
            name: 'Category',
            dataType: 'string',
            enumValues: [
                {
                    id: 'drama',
                    label: 'Drama',
                },
                {
                    label: 'Education',
                    id: 'education',
                },
                {
                    label: 'Fantasy',
                    id: 'fantasy',
                },
                {
                    id: 'fantasy-fiction',
                    label: 'Fantasy Fiction',
                },
                {
                    label: 'Fiction',
                    id: 'fiction',
                },
                {
                    id: 'history',
                    label: 'History',
                },
                {
                    id: 'juvenile-fiction',
                    label: 'Juvenile Fiction',
                },
                {
                    id: 'philosophy',
                    label: 'Philosophy',
                },
                {
                    id: 'religion',
                    label: 'Religion',
                },
                {
                    label: 'Science',
                    id: 'science',
                },
                {
                    id: 'self-help',
                    label: 'Self Help',
                },
                {
                    id: 'travel',
                    label: 'Travel',
                },
            ],
        },
        created_at: {
            name: 'Created At',
            dataType: 'date',
        },
        description: {
            name: 'Description',
            dataType: 'string',
        },
        isbn10: {
            name: 'Isbn10',
            dataType: 'number',
        },
        isbn13: {
            name: 'Isbn13',
            dataType: 'number',
        },
        num_pages: {
            name: 'Num Pages',
            dataType: 'number',
        },
        published_year: {
            dataType: 'number',
            name: 'Published Year',
        },
        ratings_count: {
            name: 'Ratings Count',
            dataType: 'number',
        },
        spanish_description: {
            name: 'Spanish Description',
            dataType: 'string',
        },
        tags: {
            dataType: 'array',
            of: {
                dataType: 'string',
                editable: true,
                name: 'Tags',
            },
            name: 'Tags',
        },
        thumbnail: {
            dataType: 'string',
            url: true,
            name: 'Thumbnail',
        },
    },
    subcollections: [],
}
```
