---
slug: do_you_need_a_no_code_tool_for_firebase
title: Do you Need a No Code Tool for Firebase?
image: /img/avatars/marian_avatar.jpeg
author_name: Marian Moldovan
author_url: https://www.linkedin.com/in/marianmoldovan/
author_image_url: https://avatars.githubusercontent.com/u/1479084?v=4
---

![Firebase Landscape](../static/img/blog/landscape.jpg)

## Do You Need a No Code Tool for Firebase?

This article was initially titled **"No Code Tools for Firebase."** We already knew some tools, but as we delved into the research, we decided to drop the title—and the idea. You probably don't need a No Code tool for Firebase. So instead of a benchmark, welcome to the most opinionated article about Firebase and No Code tools.

### Firebase and Firestore

Firebase is one of the greatest products built for developers. Based on Cloud Services, it features a **Serverless** architecture that allows you to focus on building your product without worrying about the underlying infrastructure. So you have:

- Firestore: a NoSQL database to store your data in the cloud.
- Functions: a serverless function that allows you to run your code in response to events.
- Authentication: a secure authentication system.
- Storage: a secure file storage system.
- Hosting: a web hosting service that allows you to deploy your static files.
- Messaging: a messaging service that allows you to send push notifications to your users.
- A/B Testing, Remote Config, and many more services.

It gained a lot of popularity among mobile app developers. Here is our easy-to-integrate Backend as a Service with Authentication and File Storage. Simple to use and easy to integrate. Outstanding.

Is your value proposition building an Authentication system, Storage, or Backend? Have a seat and build your product. That's the idea.

### Firebase in Your Tech Stack

So, you decided to use Firebase to build your product. That usually means you are a developer or have an internal development team. The first decision is made. I am building a React App, so I am going to use Firebase for the Backend.

How are you going to integrate your client with Firebase? What strategy are you going to use to build your core product? The essence of your company.

**Code**

This can be debated, but if you are not ready to build code, you probably shouldn't use Firebase. Don't complicate yourself. There are amazing tools that can help you with that. Do you really want to handle Security Rules, Indexes, and all the other aspects you need to know about Firestore?

### No Code Tools for Firebase

There are some No Code tools for Firebase. Some of them are fully integrated, while others use limited functions of Firebase through their API. If a tool allows you to integrate with a REST API, you can probably use it. Some of them are: [FlutterFlow](https://www.flutterflow.io/), [JetAdmin](https://www.jetadmin.io/), [Retool](https://retool.com/), [Bubble](https://bubble.io/), etc.

What are you going to build with these tools?

- Admin Panel?
- Landing Page?
- Mobile App?

For some low-complexity products, these tools can be a great help. If you need to hack something quickly, these tools can be a great help. But for a developer, the best option is probably using custom code. Most of the founders I know prefer to build a React App for a landing page rather than using tools like Webflow. It may be faster, but it's going to be more flexible. And let's be honest, developers often struggle with the feature and customization options of these tools.

### Inside FireCMS

Is [FireCMS](https://app.firecms.co) a No Code tool? Yes, we built FireCMS Cloud for that: a fully managed SaaS.

But allow us to share a secret. We had the SaaS, a full No Code tool ready to launch, but we stopped. Why? Because we are developers. We wanted our customers to have the freedom to build anything they could with the previous code-based version. We didn't want to limit them. It didn't make any sense for us to release a new product with fewer features. So we stopped and built that. Using module federation, we allow FireCMS Cloud customers to upload custom code and change whatever they want. Give us the code, and we will handle it for you. From `yarn deploy` to [app.firecms.co](https://app.firecms.co).

You could say that FireCMS is a No Code, Low Code, or even Full Code tool. It depends on how you want to use it.

### Firebase in Our Tech Stacks

As many of you may know, FireCMS was born as an internal tool. We built it. Then we used it again, and again, and again. And ended up releasing it as a product.

What kind of projects? Startups. We helped build software-based startups. Among them: medicalmotion.de, theplanetapp.com, oikosbrain.com. Everything from simple landing pages to business intelligence dashboards and ETL pipelines.

In most of these projects, we used Firebase as a Backend. And we always missed a good Admin Tool—a professional dashboard to manage the data. A tool with a good UI/UX, permissions, and a good developer experience. Our best users are developers and ourselves—a serious dashboard for operations.

### Ending Thoughts

So, why won't you find a lot of No Code tools for Firebase? Because you probably don’t need them. Because maybe Firebase is not the best tool for your product.

If you need a UI on top of your Firebase data, go for software that allows you to customize anything. We will be happy to help you if you decide to use FireCMS. If not, custom code it is.

### What Are You Going to Build?

We want to hear about it :) Find us on [Discord](https://discord.gg/fxy7xsQm3m), [LinkedIn](https://www.linkedin.com/company/firecms/?originalSubdomain=es), or ping us at [hello@firecms.co](mailto:hello@firecms.co).
