---
slug: beta_9
title: FireCMS Beta.9 is out
author: Francesco Gatti
image: /img/avatars/francesco_avatar.jpg
author_url: https://www.linkedin.com/in/fgatti675
author_image_url: https://avatars.githubusercontent.com/u/5120271?v=4
---


# FireCMS Beta.9 is out

**Check what's new in your favourite CMS**

We are excited to announce the release of FireCMS Beta.9. This release includes a lot of new features and improvements,
including a new Markdown editor, multi select, and MongoDB support.

FireCMS continues its journey to become the most flexible and powerful CMS. We aim to become a true headless CMS, with
and by headless we mean compatible with any database and backend, as well as also detached from any frontend technology.

## New Markdown editor

![Editor](../static/img/new_editor.png)

Completely revamped Markdown editor inspired by Notion, with an amazing UX and **autocomplete features**.
The previous editor was not very user-friendly, and we have decided to replace it with a new one that is more powerful
and easier to use.
It is also now possible to **upload images** inline.
The editor can be used as a Markdown field in your collections, as well as a standalone component in your components.


## Multi select
![Multi select](../static/img/multi_select.png)

We have improved the multi select component, now supporting search and better performance. The previous
version would clip items based on the position of the dropdown, which was not ideal.

## MongoDB support

FireCMS continues to expand its database support. We have added a new package `@firecms/mongodb` 
that allows you to connect to MongoDB databases.

You can now run FireCMS PRO with MongoDB as your backend, with no connection to any Firebase services.
Use the Auth and Database services of MongoDB Atlas to authenticate and store your data.

This is part of our efforts to bring all the power of FireCMS with the [PRO](https://firecms.co/pro) version
to any database you want.

## UI updates

Our FireCMS UI package is available as a separate package, `@firecms/ui`. This allows you to use the same UI components
we use in FireCMS in your own projects.

![Toleroo](../static/img/toleroo.png)

We have improved it's customization capabilities. For example, Toleroo needs to apply it's brand guidelines to its
CMS implementation. Until now we could only change colors, but now we can change fonts, sizes, and more. For 
each text variant you can define a set of tailwind classes.

If you are updating from a previous version, you will need to add an import in your css:

```css
@import "@firecms/ui/index.css";
```

and then you are free to customize each style as you see fit.

```css
.typography-h1 {
    @apply text-6xl font-headers font-light;
}

.typography-h2 {
    @apply text-5xl font-headers font-light;
}

.typography-h3 {
    @apply text-4xl font-headers font-normal;
}
/* ... */
```

## And more

There are many more improvements and bug fixes. Check the [changelog](https://firecms.co/docs/changelog) for more details.

