---
slug: hola
title: Hello! Hola!
author: Francesco Gatti
image: /img/avatars/francesco_avatar.jpg
author_url: https://www.linkedin.com/in/fgatti675
author_image_url: https://avatars.githubusercontent.com/u/5120271?v=4
---

### Welcome to the **FireCMS** blog!

We will use this blog to keep you up to date of the latest updates regarding
FireCMS, as well as case-studies!

But first, a quick introduction on how we ended up building our own generic
headless admin panel/CMS solution based on Firebase!

We started **Camberi** as an apps and web development agency in 2018. We all
were experienced Firebase users, and we found it was a great fit to start **new
projects**, requested by clients.

### Motivation

Usually clients would like to develop an app or a webapp, and most times they
would need an additional tool for backend administration. We built 3 tools for
different projects, that were similar but slightly different. They were all
React projects. We soon realized a **generic solution** would help us a lot, so we
thought: There must be a generic headless CMS based on Firebase/Firestore right?

Right! There were some solutions out there, but we found problems with all of
them, which stopped us from using them:

- Either they were generic CMS tools that were **not optimised** for the Firestore
  data structure, with its pros and cons (such as React Admin, despite being a
  great tool).
- Or they impose a **specific Firestore data structure**, which means that are not
  suitable for every project. This is the case for Flamelink, which is a
  commercial solution based on Firebase, which follows a philosophy more similar
  to Wordpress.
- Or they don't provide **enough features**. The best solution we have found is
  Firetable, which shares some core concepts of FireCMS, but we find a bit limited
  in some Firestore specific areas. It is opinionated on a few things, like the
  way users are stored for example, and we don't like that.
  They provide a lot of good widgets but not
  the possibility to use your own easily.

With all the previous factors taken into account, and a pandemic keeping us
home, we decided to unify all the tools we had built into a generic one!

Companies put a lot of effort into building their client facing apps but
internal admin tools tend to be the **ugly ducklings**, with huge productivity
implications.

### Core concepts

Pretty soon we knew what we wanted to build. Firestore is a no-SQL database with
a data structure that consists of collections, that contain documents, that can
contain subcollections, and so on. We need that our UI reflects that structure,
with an arbitrary level of nested collections.

It is also crucial that that beautiful UI is customizable, and we have added
multiple customisation points based on both our needs and your input.

Our headless CMS **must** allow developers to extend it in any way they need, while
keeping it extremely simple to kickstart a new project, with the bare minimum
configuration. We need **sensible defaults that can be overridden or extended**.

### Features

FireCMS allows setting up a CMS in no time, just by introducing your collections
and document schemas as input, and it renders beautiful editable
spreadsheet-like tables and forms. It also builds all the **navigation** and
**authorization** views automatically, so you don't have to. All the **common use
cases** are covered out of the box, including strings, numbers, booleans,
arrays, maps, references to other documents, timestamps... We also provide
more **advanced use cases**, like:

- String enumerations with customization.
- Handling of files such as images, videos or anything really in Google Cloud
  Storage.
- We automatically generate complex fields for references to other collections,
  just by providing the collection path. Also, we handle correctly arrays of
  references.
- Markdown fields, with preview
- Complex typed array structures: such as an array that contains objects of type
  `text`, or `images`, or `products` like in our blog example!

Again, besides the basic and advanced use cases that are bundled with the library,
the CMS allows the developer to customise and override most aspects of it!

Take a look at the docs if you would like to know all the possible options!

We hope you enjoy using FireCMS as much as we do while developing it, and I
would like to take the change to thank all the external contributors with
feedback and PRs.

You rock! 🙌



