import React from "react";
import { CMSType, PropertyOrBuilder } from "./properties";

/**
 * This is the configuration object for a property.
 * These configs are generated by default for the properties defined in your
 * collections' configuration, but you can define your own to be used.
 */
export type PropertyConfig<T extends CMSType = any> = {

    /**
     * Key used to identify this property config.
     */
    key: PropertyConfigId | string;

    /**
     * Name of this field type.
     * This is not the name of the property.
     */
    name: string;

    /**
     * Default config for the property.
     * This property or builder will be used as the base values for the resulting property.
     * You can also use a builder function to generate the base property.
     */
    property: PropertyOrBuilder<T>;

    /**
     * Optional icon to be used in the field selector.
     * Use a 24x24 component, in order not to break the layout.
     * Any FireCMS icon can be used.
     */
    Icon?: React.ComponentType;

    /**
     * CSS color, used only in some plugins like the field selector.
     * e.g. "#2d7ff9"
     */
    color?: string;

    /**
     * Description of this field type.
     */
    description?: string;

}

export type PropertyConfigId =
    "text_field" |
    "multiline" |
    "markdown" |
    "url" |
    "email" |
    "select" |
    "multi_select" |
    "number_input" |
    "number_select" |
    "multi_number_select" |
    "file_upload" |
    "multi_file_upload" |
    "group" |
    "key_value" |
    "reference" |
    "multi_references" |
    "switch" |
    "date_time" |
    "repeat" |
    "custom_array" |
    "block";
