import React from "react";
import { useNavigationController } from "@firecms/core";
import { Button, Chip, CloseIcon, Container, Dialog, DialogContent, DialogTitle, IconButton, } from "@firecms/ui";
import { useNavigate } from "react-router-dom";
import { UpgradeToPlusButton } from "./UpgradeToPlusButton";

export function PlansComparisonDialog({
                                          open,
                                          onClose,
                                      }: {
    open: boolean,
    onClose: () => void
}) {

    const navigationController = useNavigationController();
    const navigate = useNavigate();
    const goToSubscriptions = () => {
        onClose();
        navigate(navigationController.basePath + "/settings");
    }

    return <Dialog
        fullScreen={true}
        open={open}
        onOpenChange={(open) => !open ? onClose() : undefined}
    >

        <DialogTitle hidden>Plans comparison</DialogTitle>
        <DialogContent fullHeight={true}>
            <PlansComparison/>
        </DialogContent>
        <IconButton className={"absolute top-4 right-4"}
                    onClick={onClose}>
            <CloseIcon/>
        </IconButton>
    </Dialog>;
}

export function PlansComparison() {

    const freeTier = (
        <div
            className="h-full max-w-sm p-6 border border-solid border-surface-200 rounded-lg shadow dark:border-surface-700 flex flex-col">

            <h3 className={"text-2xl md:text-4xl font-bold text-center text-surface-800 dark:text-surface-200 uppercase my-3"}>
                Free
            </h3>
            <div className={"grow"}>
                <p className={"text-lg mb-4 text-center font-semibold"}>
                    Try FireCMS and upgrade to a paid plan when you
                    need more features.
                </p>
                <ul>
                    <li className={"ml-8 list-disc"}>Unlimited projects</li>
                    <li className={"ml-8 list-disc"}>Unlimited collections</li>
                    <li className={"ml-8 list-disc"}>All available form fields</li>
                    <li className={"ml-8 list-disc"}>Schema editor and data inference</li>
                    <li className={"ml-8 list-disc"}>Advanced data import and export</li>
                    <li className={"ml-8 list-disc"}>Default roles</li>
                    <li className={"ml-8 list-disc"}>3 users</li>
                </ul>
            </div>
            <div className={"text-center mt-4 text-surface-600 dark:text-surface-400 w-full"}>
                <span className={"text-2xl font-bold "}>€0 user/month</span>
            </div>

        </div>
    );

    const plusTier = (
        <div
            className="h-full max-w-sm p-6 rounded-lg flex flex-col outline-none ring-2 ring-primary ring-opacity-75 ring-offset-2 ring-offset-transparent">

            <h3 className={"text-2xl md:text-4xl font-bold text-center dark:text-primary text-primary uppercase my-3"}>
                Plus
            </h3>
            <div className={"grow"}>
                <p className={"text-lg mb-4 text-center font-semibold"}>
                    Perfect for startups
                </p>
                <ul>
                    <li className={"ml-8 list-disc"}>Everything in the free tier</li>
                    <li className={"ml-8 list-disc"}>Local text search</li>
                    <li className={"ml-8 list-disc"}>Secondary databases</li>
                    <li className={"ml-8 list-disc"}>Unlimited users and roles</li>
                    <li className={"ml-8 list-disc"}>Unlimited data export</li>
                    <li className={"ml-8 list-disc"}>Theme and logo customization</li>
                    <li className={"ml-8 list-disc"}>Custom user roles</li>
                    <li className={"ml-8 list-disc"}>GPT-4 content generation</li>
                    <li className={"ml-8 list-disc"}>AppCheck</li>
                </ul>
            </div>

            <div className={"flex flex-col gap-4 items-center justify-center mt-8"}>

                <Chip colorScheme={"yellowLight"} className={"font-semibold"}>
                    ONE MONTH FREE TRIAL
                </Chip>
                <UpgradeToPlusButton includePriceSelect={true}
                                     includePriceLabel={false}
                                     largePriceLabel={true}/>
            </div>

        </div>
    );

    const proTier = (
        <div
            className="h-full max-w-sm p-6 border border-solid border-surface-200 rounded-lg shadow dark:border-surface-700 flex flex-col">

            <h3 className={"text-2xl md:text-4xl font-bold text-center text-surface-800 dark:text-surface-200 uppercase my-3"}>
                Pro
            </h3>
            <div className={"grow"}>
                <p className={"text-lg mb-4 text-center font-semibold"}>
                    Perfect for startups, companies or agencies.
                </p>
                <ul>
                    <li className={"ml-8 list-disc"}>Everything in PLUS</li>
                    <li className={"ml-8 list-disc"}>Self-hosted</li>
                    <li className={"ml-8 list-disc"}>Custom authentication and access control</li>
                    <li className={"ml-8 list-disc"}>Access to all the plugins</li>
                    <li className={"ml-8 list-disc"}>SAML SSO</li>
                    <li className={"ml-8 list-disc"}>Custom domain</li>
                    <li className={"ml-8 list-disc"}>Full CMS components customization</li>
                    <li className={"ml-8 list-disc"}>Priority support</li>
                    <li className={"ml-8 list-disc"}>Roadmap prioritization</li>
                </ul>
            </div>
            <div className={"text-center mt-4 text-surface-600 dark:text-surface-400 w-full"}>
                <span className={"text-2xl font-bold "}>€49.99 project/month</span>
            </div>
            <div className={"text-center mt-4 text-primary w-full"}>
                <Button
                    component={"a"}
                    size={"large"}
                    variant={"outlined"}
                    href="https://firecms.co/pro"
                    rel="noopener noreferrer"
                    target="_blank"
                >
                    More info
                </Button>
            </div>

        </div>
    );

    return <div className={"overflow-auto my-auto"}>
        <Container className={"flex flex-col gap-4 p-8 m-auto"}>

            <h2 className={"text-3xl md:text-4xl font-bold my-4 text-center"}>
                Full no-code/low-code solution
            </h2>

            <p>
                <strong>FireCMS Cloud</strong> offers a complete, end-to-end
                solution for businesses that require the highest level of
                support and security. With dedicated hosting, advanced features, and
                expert support, you will have everything you need to take your project
                to the next level.
            </p>

            {/*three columns layout*/}
            <div
                className="flex flex-col items-center lg:grid lg:grid-cols-3 gap-4 mt-2 w-full mx-auto"
            >
                {freeTier}
                {plusTier}
                {proTier}
            </div>

        </Container>
    </div>;

}
