/// <reference types="node" />
import { EventEmitter } from 'events';
import BaseConnection, { ConnectionOptions, ConnectionRequestParams, ConnectionRequestOptions, ConnectionRequestOptionsAsStream, ConnectionRequestResponse, ConnectionRequestResponseAsStream } from './BaseConnection';
import { Pool } from 'undici';
import { kEmitter } from '../symbols';
export default class Connection extends BaseConnection {
    pool: Pool;
    [kEmitter]: EventEmitter;
    constructor(opts: ConnectionOptions);
    request(params: ConnectionRequestParams, options: ConnectionRequestOptions): Promise<ConnectionRequestResponse>;
    request(params: ConnectionRequestParams, options: ConnectionRequestOptionsAsStream): Promise<ConnectionRequestResponseAsStream>;
    close(): Promise<void>;
}
