/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
/// <reference types="node" />
import { inspect } from 'util';
import * as http from 'http';
import { URL } from 'url';
import { ConnectionOptions as TlsConnectionOptions, TLSSocket, DetailedPeerCertificate } from 'tls';
import { Readable as ReadableStream } from 'stream';
import Diagnostic from '../Diagnostic';
import { ApiKeyAuth, BasicAuth, BearerAuth, HttpAgentOptions, UndiciAgentOptions, agentFn } from '../types';
import { kStatus, kDiagnostic, kCaFingerprint } from '../symbols';
export interface ConnectionOptions {
    url: URL;
    tls?: TlsConnectionOptions;
    id?: string;
    headers?: http.IncomingHttpHeaders;
    status?: string;
    auth?: BasicAuth | ApiKeyAuth | BearerAuth;
    diagnostic?: Diagnostic;
    timeout?: number;
    agent?: HttpAgentOptions | UndiciAgentOptions | agentFn | boolean;
    proxy?: string | URL;
    caFingerprint?: string;
}
export interface ConnectionRequestParams {
    method: string;
    path: string;
    headers?: http.IncomingHttpHeaders;
    body?: string | Buffer | ReadableStream | null;
    querystring?: string;
}
export interface ConnectionRequestOptions {
    requestId: string | number;
    name: string | symbol;
    context: any;
    maxResponseSize?: number;
    maxCompressedResponseSize?: number;
    signal?: AbortSignal;
    timeout?: number;
}
export interface ConnectionRequestOptionsAsStream extends ConnectionRequestOptions {
    asStream: true;
}
export interface ConnectionRequestResponse {
    body: string | Buffer;
    headers: http.IncomingHttpHeaders;
    statusCode: number;
}
export interface ConnectionRequestResponseAsStream {
    body: ReadableStream;
    headers: http.IncomingHttpHeaders;
    statusCode: number;
}
export default class BaseConnection {
    url: URL;
    tls: TlsConnectionOptions | null;
    id: string;
    timeout: number;
    headers: http.IncomingHttpHeaders;
    deadCount: number;
    resurrectTimeout: number;
    _openRequests: number;
    weight: number;
    [kStatus]: string;
    [kCaFingerprint]: string | null;
    [kDiagnostic]: Diagnostic;
    static statuses: {
        ALIVE: string;
        DEAD: string;
    };
    constructor(opts: ConnectionOptions);
    get status(): string;
    set status(status: string);
    get diagnostic(): Diagnostic;
    request(params: ConnectionRequestParams, options: ConnectionRequestOptions): Promise<ConnectionRequestResponse>;
    request(params: ConnectionRequestParams, options: ConnectionRequestOptionsAsStream): Promise<ConnectionRequestResponseAsStream>;
    close(): Promise<void>;
    [inspect.custom](depth: number, options: Record<string, any>): Record<string, any>;
    toJSON(): Record<string, any>;
}
export declare function prepareHeaders(headers?: http.IncomingHttpHeaders, auth?: BasicAuth | ApiKeyAuth | BearerAuth): http.IncomingHttpHeaders;
export declare function getIssuerCertificate(socket: TLSSocket): DetailedPeerCertificate | null;
