import { kJsonOptions } from './symbols';
export interface SerializerOptions {
    enablePrototypePoisoningProtection?: boolean | 'proto' | 'constructor';
}
export default class Serializer {
    [kJsonOptions]: {
        protoAction: string;
        constructorAction: string;
    };
    constructor(opts?: SerializerOptions);
    serialize(object: Record<string, any>): string;
    deserialize<T = unknown>(json: string): T;
    ndserialize(array: Array<Record<string, any> | string>): string;
    qserialize(object?: Record<string, any> | string): string;
}
