// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("google-gax/build/src/protobuf").protobufMinimal);

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;
    
    // Exported root namespace
    var $root = $protobuf.roots._google_cloud_pubsub_protos || ($protobuf.roots._google_cloud_pubsub_protos = {});
    
    $root.google = (function() {
    
        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};
    
        google.pubsub = (function() {
    
            /**
             * Namespace pubsub.
             * @memberof google
             * @namespace
             */
            var pubsub = {};
    
            pubsub.v1 = (function() {
    
                /**
                 * Namespace v1.
                 * @memberof google.pubsub
                 * @namespace
                 */
                var v1 = {};
    
                v1.Publisher = (function() {
    
                    /**
                     * Constructs a new Publisher service.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Publisher
                     * @extends $protobuf.rpc.Service
                     * @constructor
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     */
                    function Publisher(rpcImpl, requestDelimited, responseDelimited) {
                        $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                    }
    
                    (Publisher.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Publisher;
    
                    /**
                     * Creates new Publisher service using the specified rpc implementation.
                     * @function create
                     * @memberof google.pubsub.v1.Publisher
                     * @static
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     * @returns {Publisher} RPC service. Useful where requests and/or responses are streamed.
                     */
                    Publisher.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                        return new this(rpcImpl, requestDelimited, responseDelimited);
                    };
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|createTopic}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef CreateTopicCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Topic} [response] Topic
                     */
    
                    /**
                     * Calls CreateTopic.
                     * @function createTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.ITopic} request Topic message or plain object
                     * @param {google.pubsub.v1.Publisher.CreateTopicCallback} callback Node-style callback called with the error, if any, and Topic
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.createTopic = function createTopic(request, callback) {
                        return this.rpcCall(createTopic, $root.google.pubsub.v1.Topic, $root.google.pubsub.v1.Topic, request, callback);
                    }, "name", { value: "CreateTopic" });
    
                    /**
                     * Calls CreateTopic.
                     * @function createTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.ITopic} request Topic message or plain object
                     * @returns {Promise<google.pubsub.v1.Topic>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|updateTopic}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef UpdateTopicCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Topic} [response] Topic
                     */
    
                    /**
                     * Calls UpdateTopic.
                     * @function updateTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IUpdateTopicRequest} request UpdateTopicRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.UpdateTopicCallback} callback Node-style callback called with the error, if any, and Topic
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.updateTopic = function updateTopic(request, callback) {
                        return this.rpcCall(updateTopic, $root.google.pubsub.v1.UpdateTopicRequest, $root.google.pubsub.v1.Topic, request, callback);
                    }, "name", { value: "UpdateTopic" });
    
                    /**
                     * Calls UpdateTopic.
                     * @function updateTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IUpdateTopicRequest} request UpdateTopicRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Topic>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|publish}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef PublishCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.PublishResponse} [response] PublishResponse
                     */
    
                    /**
                     * Calls Publish.
                     * @function publish
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IPublishRequest} request PublishRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.PublishCallback} callback Node-style callback called with the error, if any, and PublishResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.publish = function publish(request, callback) {
                        return this.rpcCall(publish, $root.google.pubsub.v1.PublishRequest, $root.google.pubsub.v1.PublishResponse, request, callback);
                    }, "name", { value: "Publish" });
    
                    /**
                     * Calls Publish.
                     * @function publish
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IPublishRequest} request PublishRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.PublishResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|getTopic}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef GetTopicCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Topic} [response] Topic
                     */
    
                    /**
                     * Calls GetTopic.
                     * @function getTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IGetTopicRequest} request GetTopicRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.GetTopicCallback} callback Node-style callback called with the error, if any, and Topic
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.getTopic = function getTopic(request, callback) {
                        return this.rpcCall(getTopic, $root.google.pubsub.v1.GetTopicRequest, $root.google.pubsub.v1.Topic, request, callback);
                    }, "name", { value: "GetTopic" });
    
                    /**
                     * Calls GetTopic.
                     * @function getTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IGetTopicRequest} request GetTopicRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Topic>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|listTopics}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef ListTopicsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListTopicsResponse} [response] ListTopicsResponse
                     */
    
                    /**
                     * Calls ListTopics.
                     * @function listTopics
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicsRequest} request ListTopicsRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.ListTopicsCallback} callback Node-style callback called with the error, if any, and ListTopicsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.listTopics = function listTopics(request, callback) {
                        return this.rpcCall(listTopics, $root.google.pubsub.v1.ListTopicsRequest, $root.google.pubsub.v1.ListTopicsResponse, request, callback);
                    }, "name", { value: "ListTopics" });
    
                    /**
                     * Calls ListTopics.
                     * @function listTopics
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicsRequest} request ListTopicsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListTopicsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|listTopicSubscriptions}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef ListTopicSubscriptionsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListTopicSubscriptionsResponse} [response] ListTopicSubscriptionsResponse
                     */
    
                    /**
                     * Calls ListTopicSubscriptions.
                     * @function listTopicSubscriptions
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest} request ListTopicSubscriptionsRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.ListTopicSubscriptionsCallback} callback Node-style callback called with the error, if any, and ListTopicSubscriptionsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.listTopicSubscriptions = function listTopicSubscriptions(request, callback) {
                        return this.rpcCall(listTopicSubscriptions, $root.google.pubsub.v1.ListTopicSubscriptionsRequest, $root.google.pubsub.v1.ListTopicSubscriptionsResponse, request, callback);
                    }, "name", { value: "ListTopicSubscriptions" });
    
                    /**
                     * Calls ListTopicSubscriptions.
                     * @function listTopicSubscriptions
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest} request ListTopicSubscriptionsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListTopicSubscriptionsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|listTopicSnapshots}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef ListTopicSnapshotsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListTopicSnapshotsResponse} [response] ListTopicSnapshotsResponse
                     */
    
                    /**
                     * Calls ListTopicSnapshots.
                     * @function listTopicSnapshots
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest} request ListTopicSnapshotsRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.ListTopicSnapshotsCallback} callback Node-style callback called with the error, if any, and ListTopicSnapshotsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.listTopicSnapshots = function listTopicSnapshots(request, callback) {
                        return this.rpcCall(listTopicSnapshots, $root.google.pubsub.v1.ListTopicSnapshotsRequest, $root.google.pubsub.v1.ListTopicSnapshotsResponse, request, callback);
                    }, "name", { value: "ListTopicSnapshots" });
    
                    /**
                     * Calls ListTopicSnapshots.
                     * @function listTopicSnapshots
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest} request ListTopicSnapshotsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListTopicSnapshotsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|deleteTopic}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef DeleteTopicCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls DeleteTopic.
                     * @function deleteTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IDeleteTopicRequest} request DeleteTopicRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.DeleteTopicCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.deleteTopic = function deleteTopic(request, callback) {
                        return this.rpcCall(deleteTopic, $root.google.pubsub.v1.DeleteTopicRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "DeleteTopic" });
    
                    /**
                     * Calls DeleteTopic.
                     * @function deleteTopic
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IDeleteTopicRequest} request DeleteTopicRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Publisher|detachSubscription}.
                     * @memberof google.pubsub.v1.Publisher
                     * @typedef DetachSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.DetachSubscriptionResponse} [response] DetachSubscriptionResponse
                     */
    
                    /**
                     * Calls DetachSubscription.
                     * @function detachSubscription
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest} request DetachSubscriptionRequest message or plain object
                     * @param {google.pubsub.v1.Publisher.DetachSubscriptionCallback} callback Node-style callback called with the error, if any, and DetachSubscriptionResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Publisher.prototype.detachSubscription = function detachSubscription(request, callback) {
                        return this.rpcCall(detachSubscription, $root.google.pubsub.v1.DetachSubscriptionRequest, $root.google.pubsub.v1.DetachSubscriptionResponse, request, callback);
                    }, "name", { value: "DetachSubscription" });
    
                    /**
                     * Calls DetachSubscription.
                     * @function detachSubscription
                     * @memberof google.pubsub.v1.Publisher
                     * @instance
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest} request DetachSubscriptionRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.DetachSubscriptionResponse>} Promise
                     * @variation 2
                     */
    
                    return Publisher;
                })();
    
                v1.MessageStoragePolicy = (function() {
    
                    /**
                     * Properties of a MessageStoragePolicy.
                     * @memberof google.pubsub.v1
                     * @interface IMessageStoragePolicy
                     * @property {Array.<string>|null} [allowedPersistenceRegions] MessageStoragePolicy allowedPersistenceRegions
                     */
    
                    /**
                     * Constructs a new MessageStoragePolicy.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a MessageStoragePolicy.
                     * @implements IMessageStoragePolicy
                     * @constructor
                     * @param {google.pubsub.v1.IMessageStoragePolicy=} [properties] Properties to set
                     */
                    function MessageStoragePolicy(properties) {
                        this.allowedPersistenceRegions = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * MessageStoragePolicy allowedPersistenceRegions.
                     * @member {Array.<string>} allowedPersistenceRegions
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @instance
                     */
                    MessageStoragePolicy.prototype.allowedPersistenceRegions = $util.emptyArray;
    
                    /**
                     * Creates a new MessageStoragePolicy instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {google.pubsub.v1.IMessageStoragePolicy=} [properties] Properties to set
                     * @returns {google.pubsub.v1.MessageStoragePolicy} MessageStoragePolicy instance
                     */
                    MessageStoragePolicy.create = function create(properties) {
                        return new MessageStoragePolicy(properties);
                    };
    
                    /**
                     * Encodes the specified MessageStoragePolicy message. Does not implicitly {@link google.pubsub.v1.MessageStoragePolicy.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {google.pubsub.v1.IMessageStoragePolicy} message MessageStoragePolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    MessageStoragePolicy.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.allowedPersistenceRegions != null && message.allowedPersistenceRegions.length)
                            for (var i = 0; i < message.allowedPersistenceRegions.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.allowedPersistenceRegions[i]);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified MessageStoragePolicy message, length delimited. Does not implicitly {@link google.pubsub.v1.MessageStoragePolicy.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {google.pubsub.v1.IMessageStoragePolicy} message MessageStoragePolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    MessageStoragePolicy.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a MessageStoragePolicy message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.MessageStoragePolicy} MessageStoragePolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    MessageStoragePolicy.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.MessageStoragePolicy();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.allowedPersistenceRegions && message.allowedPersistenceRegions.length))
                                        message.allowedPersistenceRegions = [];
                                    message.allowedPersistenceRegions.push(reader.string());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a MessageStoragePolicy message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.MessageStoragePolicy} MessageStoragePolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    MessageStoragePolicy.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a MessageStoragePolicy message.
                     * @function verify
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    MessageStoragePolicy.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.allowedPersistenceRegions != null && message.hasOwnProperty("allowedPersistenceRegions")) {
                            if (!Array.isArray(message.allowedPersistenceRegions))
                                return "allowedPersistenceRegions: array expected";
                            for (var i = 0; i < message.allowedPersistenceRegions.length; ++i)
                                if (!$util.isString(message.allowedPersistenceRegions[i]))
                                    return "allowedPersistenceRegions: string[] expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a MessageStoragePolicy message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.MessageStoragePolicy} MessageStoragePolicy
                     */
                    MessageStoragePolicy.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.MessageStoragePolicy)
                            return object;
                        var message = new $root.google.pubsub.v1.MessageStoragePolicy();
                        if (object.allowedPersistenceRegions) {
                            if (!Array.isArray(object.allowedPersistenceRegions))
                                throw TypeError(".google.pubsub.v1.MessageStoragePolicy.allowedPersistenceRegions: array expected");
                            message.allowedPersistenceRegions = [];
                            for (var i = 0; i < object.allowedPersistenceRegions.length; ++i)
                                message.allowedPersistenceRegions[i] = String(object.allowedPersistenceRegions[i]);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a MessageStoragePolicy message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {google.pubsub.v1.MessageStoragePolicy} message MessageStoragePolicy
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    MessageStoragePolicy.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.allowedPersistenceRegions = [];
                        if (message.allowedPersistenceRegions && message.allowedPersistenceRegions.length) {
                            object.allowedPersistenceRegions = [];
                            for (var j = 0; j < message.allowedPersistenceRegions.length; ++j)
                                object.allowedPersistenceRegions[j] = message.allowedPersistenceRegions[j];
                        }
                        return object;
                    };
    
                    /**
                     * Converts this MessageStoragePolicy to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    MessageStoragePolicy.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for MessageStoragePolicy
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.MessageStoragePolicy
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    MessageStoragePolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.MessageStoragePolicy";
                    };
    
                    return MessageStoragePolicy;
                })();
    
                v1.SchemaSettings = (function() {
    
                    /**
                     * Properties of a SchemaSettings.
                     * @memberof google.pubsub.v1
                     * @interface ISchemaSettings
                     * @property {string|null} [schema] SchemaSettings schema
                     * @property {google.pubsub.v1.Encoding|null} [encoding] SchemaSettings encoding
                     * @property {string|null} [firstRevisionId] SchemaSettings firstRevisionId
                     * @property {string|null} [lastRevisionId] SchemaSettings lastRevisionId
                     */
    
                    /**
                     * Constructs a new SchemaSettings.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a SchemaSettings.
                     * @implements ISchemaSettings
                     * @constructor
                     * @param {google.pubsub.v1.ISchemaSettings=} [properties] Properties to set
                     */
                    function SchemaSettings(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * SchemaSettings schema.
                     * @member {string} schema
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     */
                    SchemaSettings.prototype.schema = "";
    
                    /**
                     * SchemaSettings encoding.
                     * @member {google.pubsub.v1.Encoding} encoding
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     */
                    SchemaSettings.prototype.encoding = 0;
    
                    /**
                     * SchemaSettings firstRevisionId.
                     * @member {string} firstRevisionId
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     */
                    SchemaSettings.prototype.firstRevisionId = "";
    
                    /**
                     * SchemaSettings lastRevisionId.
                     * @member {string} lastRevisionId
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     */
                    SchemaSettings.prototype.lastRevisionId = "";
    
                    /**
                     * Creates a new SchemaSettings instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {google.pubsub.v1.ISchemaSettings=} [properties] Properties to set
                     * @returns {google.pubsub.v1.SchemaSettings} SchemaSettings instance
                     */
                    SchemaSettings.create = function create(properties) {
                        return new SchemaSettings(properties);
                    };
    
                    /**
                     * Encodes the specified SchemaSettings message. Does not implicitly {@link google.pubsub.v1.SchemaSettings.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {google.pubsub.v1.ISchemaSettings} message SchemaSettings message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SchemaSettings.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.schema != null && Object.hasOwnProperty.call(message, "schema"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.schema);
                        if (message.encoding != null && Object.hasOwnProperty.call(message, "encoding"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.encoding);
                        if (message.firstRevisionId != null && Object.hasOwnProperty.call(message, "firstRevisionId"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.firstRevisionId);
                        if (message.lastRevisionId != null && Object.hasOwnProperty.call(message, "lastRevisionId"))
                            writer.uint32(/* id 4, wireType 2 =*/34).string(message.lastRevisionId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified SchemaSettings message, length delimited. Does not implicitly {@link google.pubsub.v1.SchemaSettings.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {google.pubsub.v1.ISchemaSettings} message SchemaSettings message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SchemaSettings.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a SchemaSettings message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.SchemaSettings} SchemaSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SchemaSettings.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.SchemaSettings();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.schema = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.encoding = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.firstRevisionId = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.lastRevisionId = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a SchemaSettings message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.SchemaSettings} SchemaSettings
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SchemaSettings.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a SchemaSettings message.
                     * @function verify
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    SchemaSettings.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.schema != null && message.hasOwnProperty("schema"))
                            if (!$util.isString(message.schema))
                                return "schema: string expected";
                        if (message.encoding != null && message.hasOwnProperty("encoding"))
                            switch (message.encoding) {
                            default:
                                return "encoding: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        if (message.firstRevisionId != null && message.hasOwnProperty("firstRevisionId"))
                            if (!$util.isString(message.firstRevisionId))
                                return "firstRevisionId: string expected";
                        if (message.lastRevisionId != null && message.hasOwnProperty("lastRevisionId"))
                            if (!$util.isString(message.lastRevisionId))
                                return "lastRevisionId: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a SchemaSettings message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.SchemaSettings} SchemaSettings
                     */
                    SchemaSettings.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.SchemaSettings)
                            return object;
                        var message = new $root.google.pubsub.v1.SchemaSettings();
                        if (object.schema != null)
                            message.schema = String(object.schema);
                        switch (object.encoding) {
                        default:
                            if (typeof object.encoding === "number") {
                                message.encoding = object.encoding;
                                break;
                            }
                            break;
                        case "ENCODING_UNSPECIFIED":
                        case 0:
                            message.encoding = 0;
                            break;
                        case "JSON":
                        case 1:
                            message.encoding = 1;
                            break;
                        case "BINARY":
                        case 2:
                            message.encoding = 2;
                            break;
                        }
                        if (object.firstRevisionId != null)
                            message.firstRevisionId = String(object.firstRevisionId);
                        if (object.lastRevisionId != null)
                            message.lastRevisionId = String(object.lastRevisionId);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a SchemaSettings message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {google.pubsub.v1.SchemaSettings} message SchemaSettings
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    SchemaSettings.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.schema = "";
                            object.encoding = options.enums === String ? "ENCODING_UNSPECIFIED" : 0;
                            object.firstRevisionId = "";
                            object.lastRevisionId = "";
                        }
                        if (message.schema != null && message.hasOwnProperty("schema"))
                            object.schema = message.schema;
                        if (message.encoding != null && message.hasOwnProperty("encoding"))
                            object.encoding = options.enums === String ? $root.google.pubsub.v1.Encoding[message.encoding] === undefined ? message.encoding : $root.google.pubsub.v1.Encoding[message.encoding] : message.encoding;
                        if (message.firstRevisionId != null && message.hasOwnProperty("firstRevisionId"))
                            object.firstRevisionId = message.firstRevisionId;
                        if (message.lastRevisionId != null && message.hasOwnProperty("lastRevisionId"))
                            object.lastRevisionId = message.lastRevisionId;
                        return object;
                    };
    
                    /**
                     * Converts this SchemaSettings to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    SchemaSettings.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for SchemaSettings
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.SchemaSettings
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    SchemaSettings.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.SchemaSettings";
                    };
    
                    return SchemaSettings;
                })();
    
                v1.Topic = (function() {
    
                    /**
                     * Properties of a Topic.
                     * @memberof google.pubsub.v1
                     * @interface ITopic
                     * @property {string|null} [name] Topic name
                     * @property {Object.<string,string>|null} [labels] Topic labels
                     * @property {google.pubsub.v1.IMessageStoragePolicy|null} [messageStoragePolicy] Topic messageStoragePolicy
                     * @property {string|null} [kmsKeyName] Topic kmsKeyName
                     * @property {google.pubsub.v1.ISchemaSettings|null} [schemaSettings] Topic schemaSettings
                     * @property {boolean|null} [satisfiesPzs] Topic satisfiesPzs
                     * @property {google.protobuf.IDuration|null} [messageRetentionDuration] Topic messageRetentionDuration
                     */
    
                    /**
                     * Constructs a new Topic.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Topic.
                     * @implements ITopic
                     * @constructor
                     * @param {google.pubsub.v1.ITopic=} [properties] Properties to set
                     */
                    function Topic(properties) {
                        this.labels = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Topic name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.name = "";
    
                    /**
                     * Topic labels.
                     * @member {Object.<string,string>} labels
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.labels = $util.emptyObject;
    
                    /**
                     * Topic messageStoragePolicy.
                     * @member {google.pubsub.v1.IMessageStoragePolicy|null|undefined} messageStoragePolicy
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.messageStoragePolicy = null;
    
                    /**
                     * Topic kmsKeyName.
                     * @member {string} kmsKeyName
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.kmsKeyName = "";
    
                    /**
                     * Topic schemaSettings.
                     * @member {google.pubsub.v1.ISchemaSettings|null|undefined} schemaSettings
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.schemaSettings = null;
    
                    /**
                     * Topic satisfiesPzs.
                     * @member {boolean} satisfiesPzs
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.satisfiesPzs = false;
    
                    /**
                     * Topic messageRetentionDuration.
                     * @member {google.protobuf.IDuration|null|undefined} messageRetentionDuration
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     */
                    Topic.prototype.messageRetentionDuration = null;
    
                    /**
                     * Creates a new Topic instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {google.pubsub.v1.ITopic=} [properties] Properties to set
                     * @returns {google.pubsub.v1.Topic} Topic instance
                     */
                    Topic.create = function create(properties) {
                        return new Topic(properties);
                    };
    
                    /**
                     * Encodes the specified Topic message. Does not implicitly {@link google.pubsub.v1.Topic.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {google.pubsub.v1.ITopic} message Topic message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Topic.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                            for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                        if (message.messageStoragePolicy != null && Object.hasOwnProperty.call(message, "messageStoragePolicy"))
                            $root.google.pubsub.v1.MessageStoragePolicy.encode(message.messageStoragePolicy, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.kmsKeyName != null && Object.hasOwnProperty.call(message, "kmsKeyName"))
                            writer.uint32(/* id 5, wireType 2 =*/42).string(message.kmsKeyName);
                        if (message.schemaSettings != null && Object.hasOwnProperty.call(message, "schemaSettings"))
                            $root.google.pubsub.v1.SchemaSettings.encode(message.schemaSettings, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.satisfiesPzs != null && Object.hasOwnProperty.call(message, "satisfiesPzs"))
                            writer.uint32(/* id 7, wireType 0 =*/56).bool(message.satisfiesPzs);
                        if (message.messageRetentionDuration != null && Object.hasOwnProperty.call(message, "messageRetentionDuration"))
                            $root.google.protobuf.Duration.encode(message.messageRetentionDuration, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Topic message, length delimited. Does not implicitly {@link google.pubsub.v1.Topic.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {google.pubsub.v1.ITopic} message Topic message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Topic.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Topic message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.Topic} Topic
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Topic.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.Topic(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                }
                            case 3: {
                                    message.messageStoragePolicy = $root.google.pubsub.v1.MessageStoragePolicy.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.kmsKeyName = reader.string();
                                    break;
                                }
                            case 6: {
                                    message.schemaSettings = $root.google.pubsub.v1.SchemaSettings.decode(reader, reader.uint32());
                                    break;
                                }
                            case 7: {
                                    message.satisfiesPzs = reader.bool();
                                    break;
                                }
                            case 8: {
                                    message.messageRetentionDuration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Topic message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.Topic} Topic
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Topic.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Topic message.
                     * @function verify
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Topic.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.labels != null && message.hasOwnProperty("labels")) {
                            if (!$util.isObject(message.labels))
                                return "labels: object expected";
                            var key = Object.keys(message.labels);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.labels[key[i]]))
                                    return "labels: string{k:string} expected";
                        }
                        if (message.messageStoragePolicy != null && message.hasOwnProperty("messageStoragePolicy")) {
                            var error = $root.google.pubsub.v1.MessageStoragePolicy.verify(message.messageStoragePolicy);
                            if (error)
                                return "messageStoragePolicy." + error;
                        }
                        if (message.kmsKeyName != null && message.hasOwnProperty("kmsKeyName"))
                            if (!$util.isString(message.kmsKeyName))
                                return "kmsKeyName: string expected";
                        if (message.schemaSettings != null && message.hasOwnProperty("schemaSettings")) {
                            var error = $root.google.pubsub.v1.SchemaSettings.verify(message.schemaSettings);
                            if (error)
                                return "schemaSettings." + error;
                        }
                        if (message.satisfiesPzs != null && message.hasOwnProperty("satisfiesPzs"))
                            if (typeof message.satisfiesPzs !== "boolean")
                                return "satisfiesPzs: boolean expected";
                        if (message.messageRetentionDuration != null && message.hasOwnProperty("messageRetentionDuration")) {
                            var error = $root.google.protobuf.Duration.verify(message.messageRetentionDuration);
                            if (error)
                                return "messageRetentionDuration." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Topic message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.Topic} Topic
                     */
                    Topic.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.Topic)
                            return object;
                        var message = new $root.google.pubsub.v1.Topic();
                        if (object.name != null)
                            message.name = String(object.name);
                        if (object.labels) {
                            if (typeof object.labels !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.labels: object expected");
                            message.labels = {};
                            for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                message.labels[keys[i]] = String(object.labels[keys[i]]);
                        }
                        if (object.messageStoragePolicy != null) {
                            if (typeof object.messageStoragePolicy !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.messageStoragePolicy: object expected");
                            message.messageStoragePolicy = $root.google.pubsub.v1.MessageStoragePolicy.fromObject(object.messageStoragePolicy);
                        }
                        if (object.kmsKeyName != null)
                            message.kmsKeyName = String(object.kmsKeyName);
                        if (object.schemaSettings != null) {
                            if (typeof object.schemaSettings !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.schemaSettings: object expected");
                            message.schemaSettings = $root.google.pubsub.v1.SchemaSettings.fromObject(object.schemaSettings);
                        }
                        if (object.satisfiesPzs != null)
                            message.satisfiesPzs = Boolean(object.satisfiesPzs);
                        if (object.messageRetentionDuration != null) {
                            if (typeof object.messageRetentionDuration !== "object")
                                throw TypeError(".google.pubsub.v1.Topic.messageRetentionDuration: object expected");
                            message.messageRetentionDuration = $root.google.protobuf.Duration.fromObject(object.messageRetentionDuration);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Topic message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {google.pubsub.v1.Topic} message Topic
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Topic.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.labels = {};
                        if (options.defaults) {
                            object.name = "";
                            object.messageStoragePolicy = null;
                            object.kmsKeyName = "";
                            object.schemaSettings = null;
                            object.satisfiesPzs = false;
                            object.messageRetentionDuration = null;
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        var keys2;
                        if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                            object.labels = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.labels[keys2[j]] = message.labels[keys2[j]];
                        }
                        if (message.messageStoragePolicy != null && message.hasOwnProperty("messageStoragePolicy"))
                            object.messageStoragePolicy = $root.google.pubsub.v1.MessageStoragePolicy.toObject(message.messageStoragePolicy, options);
                        if (message.kmsKeyName != null && message.hasOwnProperty("kmsKeyName"))
                            object.kmsKeyName = message.kmsKeyName;
                        if (message.schemaSettings != null && message.hasOwnProperty("schemaSettings"))
                            object.schemaSettings = $root.google.pubsub.v1.SchemaSettings.toObject(message.schemaSettings, options);
                        if (message.satisfiesPzs != null && message.hasOwnProperty("satisfiesPzs"))
                            object.satisfiesPzs = message.satisfiesPzs;
                        if (message.messageRetentionDuration != null && message.hasOwnProperty("messageRetentionDuration"))
                            object.messageRetentionDuration = $root.google.protobuf.Duration.toObject(message.messageRetentionDuration, options);
                        return object;
                    };
    
                    /**
                     * Converts this Topic to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.Topic
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Topic.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for Topic
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.Topic
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    Topic.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.Topic";
                    };
    
                    return Topic;
                })();
    
                v1.PubsubMessage = (function() {
    
                    /**
                     * Properties of a PubsubMessage.
                     * @memberof google.pubsub.v1
                     * @interface IPubsubMessage
                     * @property {Uint8Array|null} [data] PubsubMessage data
                     * @property {Object.<string,string>|null} [attributes] PubsubMessage attributes
                     * @property {string|null} [messageId] PubsubMessage messageId
                     * @property {google.protobuf.ITimestamp|null} [publishTime] PubsubMessage publishTime
                     * @property {string|null} [orderingKey] PubsubMessage orderingKey
                     */
    
                    /**
                     * Constructs a new PubsubMessage.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PubsubMessage.
                     * @implements IPubsubMessage
                     * @constructor
                     * @param {google.pubsub.v1.IPubsubMessage=} [properties] Properties to set
                     */
                    function PubsubMessage(properties) {
                        this.attributes = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PubsubMessage data.
                     * @member {Uint8Array} data
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.data = $util.newBuffer([]);
    
                    /**
                     * PubsubMessage attributes.
                     * @member {Object.<string,string>} attributes
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.attributes = $util.emptyObject;
    
                    /**
                     * PubsubMessage messageId.
                     * @member {string} messageId
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.messageId = "";
    
                    /**
                     * PubsubMessage publishTime.
                     * @member {google.protobuf.ITimestamp|null|undefined} publishTime
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.publishTime = null;
    
                    /**
                     * PubsubMessage orderingKey.
                     * @member {string} orderingKey
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     */
                    PubsubMessage.prototype.orderingKey = "";
    
                    /**
                     * Creates a new PubsubMessage instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {google.pubsub.v1.IPubsubMessage=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PubsubMessage} PubsubMessage instance
                     */
                    PubsubMessage.create = function create(properties) {
                        return new PubsubMessage(properties);
                    };
    
                    /**
                     * Encodes the specified PubsubMessage message. Does not implicitly {@link google.pubsub.v1.PubsubMessage.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {google.pubsub.v1.IPubsubMessage} message PubsubMessage message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PubsubMessage.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.data != null && Object.hasOwnProperty.call(message, "data"))
                            writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.data);
                        if (message.attributes != null && Object.hasOwnProperty.call(message, "attributes"))
                            for (var keys = Object.keys(message.attributes), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.attributes[keys[i]]).ldelim();
                        if (message.messageId != null && Object.hasOwnProperty.call(message, "messageId"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.messageId);
                        if (message.publishTime != null && Object.hasOwnProperty.call(message, "publishTime"))
                            $root.google.protobuf.Timestamp.encode(message.publishTime, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.orderingKey != null && Object.hasOwnProperty.call(message, "orderingKey"))
                            writer.uint32(/* id 5, wireType 2 =*/42).string(message.orderingKey);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PubsubMessage message, length delimited. Does not implicitly {@link google.pubsub.v1.PubsubMessage.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {google.pubsub.v1.IPubsubMessage} message PubsubMessage message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PubsubMessage.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PubsubMessage message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PubsubMessage} PubsubMessage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PubsubMessage.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PubsubMessage(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.data = reader.bytes();
                                    break;
                                }
                            case 2: {
                                    if (message.attributes === $util.emptyObject)
                                        message.attributes = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.attributes[key] = value;
                                    break;
                                }
                            case 3: {
                                    message.messageId = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.publishTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.orderingKey = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PubsubMessage message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PubsubMessage} PubsubMessage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PubsubMessage.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PubsubMessage message.
                     * @function verify
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PubsubMessage.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.data != null && message.hasOwnProperty("data"))
                            if (!(message.data && typeof message.data.length === "number" || $util.isString(message.data)))
                                return "data: buffer expected";
                        if (message.attributes != null && message.hasOwnProperty("attributes")) {
                            if (!$util.isObject(message.attributes))
                                return "attributes: object expected";
                            var key = Object.keys(message.attributes);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.attributes[key[i]]))
                                    return "attributes: string{k:string} expected";
                        }
                        if (message.messageId != null && message.hasOwnProperty("messageId"))
                            if (!$util.isString(message.messageId))
                                return "messageId: string expected";
                        if (message.publishTime != null && message.hasOwnProperty("publishTime")) {
                            var error = $root.google.protobuf.Timestamp.verify(message.publishTime);
                            if (error)
                                return "publishTime." + error;
                        }
                        if (message.orderingKey != null && message.hasOwnProperty("orderingKey"))
                            if (!$util.isString(message.orderingKey))
                                return "orderingKey: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a PubsubMessage message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PubsubMessage} PubsubMessage
                     */
                    PubsubMessage.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PubsubMessage)
                            return object;
                        var message = new $root.google.pubsub.v1.PubsubMessage();
                        if (object.data != null)
                            if (typeof object.data === "string")
                                $util.base64.decode(object.data, message.data = $util.newBuffer($util.base64.length(object.data)), 0);
                            else if (object.data.length >= 0)
                                message.data = object.data;
                        if (object.attributes) {
                            if (typeof object.attributes !== "object")
                                throw TypeError(".google.pubsub.v1.PubsubMessage.attributes: object expected");
                            message.attributes = {};
                            for (var keys = Object.keys(object.attributes), i = 0; i < keys.length; ++i)
                                message.attributes[keys[i]] = String(object.attributes[keys[i]]);
                        }
                        if (object.messageId != null)
                            message.messageId = String(object.messageId);
                        if (object.publishTime != null) {
                            if (typeof object.publishTime !== "object")
                                throw TypeError(".google.pubsub.v1.PubsubMessage.publishTime: object expected");
                            message.publishTime = $root.google.protobuf.Timestamp.fromObject(object.publishTime);
                        }
                        if (object.orderingKey != null)
                            message.orderingKey = String(object.orderingKey);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PubsubMessage message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {google.pubsub.v1.PubsubMessage} message PubsubMessage
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PubsubMessage.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.attributes = {};
                        if (options.defaults) {
                            if (options.bytes === String)
                                object.data = "";
                            else {
                                object.data = [];
                                if (options.bytes !== Array)
                                    object.data = $util.newBuffer(object.data);
                            }
                            object.messageId = "";
                            object.publishTime = null;
                            object.orderingKey = "";
                        }
                        if (message.data != null && message.hasOwnProperty("data"))
                            object.data = options.bytes === String ? $util.base64.encode(message.data, 0, message.data.length) : options.bytes === Array ? Array.prototype.slice.call(message.data) : message.data;
                        var keys2;
                        if (message.attributes && (keys2 = Object.keys(message.attributes)).length) {
                            object.attributes = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.attributes[keys2[j]] = message.attributes[keys2[j]];
                        }
                        if (message.messageId != null && message.hasOwnProperty("messageId"))
                            object.messageId = message.messageId;
                        if (message.publishTime != null && message.hasOwnProperty("publishTime"))
                            object.publishTime = $root.google.protobuf.Timestamp.toObject(message.publishTime, options);
                        if (message.orderingKey != null && message.hasOwnProperty("orderingKey"))
                            object.orderingKey = message.orderingKey;
                        return object;
                    };
    
                    /**
                     * Converts this PubsubMessage to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PubsubMessage.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PubsubMessage
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PubsubMessage
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PubsubMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PubsubMessage";
                    };
    
                    return PubsubMessage;
                })();
    
                v1.GetTopicRequest = (function() {
    
                    /**
                     * Properties of a GetTopicRequest.
                     * @memberof google.pubsub.v1
                     * @interface IGetTopicRequest
                     * @property {string|null} [topic] GetTopicRequest topic
                     */
    
                    /**
                     * Constructs a new GetTopicRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a GetTopicRequest.
                     * @implements IGetTopicRequest
                     * @constructor
                     * @param {google.pubsub.v1.IGetTopicRequest=} [properties] Properties to set
                     */
                    function GetTopicRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * GetTopicRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @instance
                     */
                    GetTopicRequest.prototype.topic = "";
    
                    /**
                     * Creates a new GetTopicRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IGetTopicRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.GetTopicRequest} GetTopicRequest instance
                     */
                    GetTopicRequest.create = function create(properties) {
                        return new GetTopicRequest(properties);
                    };
    
                    /**
                     * Encodes the specified GetTopicRequest message. Does not implicitly {@link google.pubsub.v1.GetTopicRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IGetTopicRequest} message GetTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetTopicRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified GetTopicRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.GetTopicRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IGetTopicRequest} message GetTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetTopicRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a GetTopicRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.GetTopicRequest} GetTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetTopicRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.GetTopicRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a GetTopicRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.GetTopicRequest} GetTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetTopicRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a GetTopicRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    GetTopicRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a GetTopicRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.GetTopicRequest} GetTopicRequest
                     */
                    GetTopicRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.GetTopicRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.GetTopicRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a GetTopicRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {google.pubsub.v1.GetTopicRequest} message GetTopicRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    GetTopicRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.topic = "";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        return object;
                    };
    
                    /**
                     * Converts this GetTopicRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    GetTopicRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for GetTopicRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.GetTopicRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    GetTopicRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.GetTopicRequest";
                    };
    
                    return GetTopicRequest;
                })();
    
                v1.UpdateTopicRequest = (function() {
    
                    /**
                     * Properties of an UpdateTopicRequest.
                     * @memberof google.pubsub.v1
                     * @interface IUpdateTopicRequest
                     * @property {google.pubsub.v1.ITopic|null} [topic] UpdateTopicRequest topic
                     * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateTopicRequest updateMask
                     */
    
                    /**
                     * Constructs a new UpdateTopicRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an UpdateTopicRequest.
                     * @implements IUpdateTopicRequest
                     * @constructor
                     * @param {google.pubsub.v1.IUpdateTopicRequest=} [properties] Properties to set
                     */
                    function UpdateTopicRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * UpdateTopicRequest topic.
                     * @member {google.pubsub.v1.ITopic|null|undefined} topic
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @instance
                     */
                    UpdateTopicRequest.prototype.topic = null;
    
                    /**
                     * UpdateTopicRequest updateMask.
                     * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @instance
                     */
                    UpdateTopicRequest.prototype.updateMask = null;
    
                    /**
                     * Creates a new UpdateTopicRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateTopicRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.UpdateTopicRequest} UpdateTopicRequest instance
                     */
                    UpdateTopicRequest.create = function create(properties) {
                        return new UpdateTopicRequest(properties);
                    };
    
                    /**
                     * Encodes the specified UpdateTopicRequest message. Does not implicitly {@link google.pubsub.v1.UpdateTopicRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateTopicRequest} message UpdateTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateTopicRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            $root.google.pubsub.v1.Topic.encode(message.topic, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                            $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified UpdateTopicRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.UpdateTopicRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateTopicRequest} message UpdateTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateTopicRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an UpdateTopicRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.UpdateTopicRequest} UpdateTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateTopicRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.UpdateTopicRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = $root.google.pubsub.v1.Topic.decode(reader, reader.uint32());
                                    break;
                                }
                            case 2: {
                                    message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an UpdateTopicRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.UpdateTopicRequest} UpdateTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateTopicRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an UpdateTopicRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    UpdateTopicRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic")) {
                            var error = $root.google.pubsub.v1.Topic.verify(message.topic);
                            if (error)
                                return "topic." + error;
                        }
                        if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                            var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                            if (error)
                                return "updateMask." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates an UpdateTopicRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.UpdateTopicRequest} UpdateTopicRequest
                     */
                    UpdateTopicRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.UpdateTopicRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.UpdateTopicRequest();
                        if (object.topic != null) {
                            if (typeof object.topic !== "object")
                                throw TypeError(".google.pubsub.v1.UpdateTopicRequest.topic: object expected");
                            message.topic = $root.google.pubsub.v1.Topic.fromObject(object.topic);
                        }
                        if (object.updateMask != null) {
                            if (typeof object.updateMask !== "object")
                                throw TypeError(".google.pubsub.v1.UpdateTopicRequest.updateMask: object expected");
                            message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an UpdateTopicRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {google.pubsub.v1.UpdateTopicRequest} message UpdateTopicRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    UpdateTopicRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.topic = null;
                            object.updateMask = null;
                        }
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = $root.google.pubsub.v1.Topic.toObject(message.topic, options);
                        if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                            object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                        return object;
                    };
    
                    /**
                     * Converts this UpdateTopicRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    UpdateTopicRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for UpdateTopicRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.UpdateTopicRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    UpdateTopicRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.UpdateTopicRequest";
                    };
    
                    return UpdateTopicRequest;
                })();
    
                v1.PublishRequest = (function() {
    
                    /**
                     * Properties of a PublishRequest.
                     * @memberof google.pubsub.v1
                     * @interface IPublishRequest
                     * @property {string|null} [topic] PublishRequest topic
                     * @property {Array.<google.pubsub.v1.IPubsubMessage>|null} [messages] PublishRequest messages
                     */
    
                    /**
                     * Constructs a new PublishRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PublishRequest.
                     * @implements IPublishRequest
                     * @constructor
                     * @param {google.pubsub.v1.IPublishRequest=} [properties] Properties to set
                     */
                    function PublishRequest(properties) {
                        this.messages = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PublishRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.PublishRequest
                     * @instance
                     */
                    PublishRequest.prototype.topic = "";
    
                    /**
                     * PublishRequest messages.
                     * @member {Array.<google.pubsub.v1.IPubsubMessage>} messages
                     * @memberof google.pubsub.v1.PublishRequest
                     * @instance
                     */
                    PublishRequest.prototype.messages = $util.emptyArray;
    
                    /**
                     * Creates a new PublishRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {google.pubsub.v1.IPublishRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PublishRequest} PublishRequest instance
                     */
                    PublishRequest.create = function create(properties) {
                        return new PublishRequest(properties);
                    };
    
                    /**
                     * Encodes the specified PublishRequest message. Does not implicitly {@link google.pubsub.v1.PublishRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {google.pubsub.v1.IPublishRequest} message PublishRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PublishRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        if (message.messages != null && message.messages.length)
                            for (var i = 0; i < message.messages.length; ++i)
                                $root.google.pubsub.v1.PubsubMessage.encode(message.messages[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PublishRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.PublishRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {google.pubsub.v1.IPublishRequest} message PublishRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PublishRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PublishRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PublishRequest} PublishRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PublishRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PublishRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 2: {
                                    if (!(message.messages && message.messages.length))
                                        message.messages = [];
                                    message.messages.push($root.google.pubsub.v1.PubsubMessage.decode(reader, reader.uint32()));
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PublishRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PublishRequest} PublishRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PublishRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PublishRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PublishRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.messages != null && message.hasOwnProperty("messages")) {
                            if (!Array.isArray(message.messages))
                                return "messages: array expected";
                            for (var i = 0; i < message.messages.length; ++i) {
                                var error = $root.google.pubsub.v1.PubsubMessage.verify(message.messages[i]);
                                if (error)
                                    return "messages." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a PublishRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PublishRequest} PublishRequest
                     */
                    PublishRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PublishRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.PublishRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.messages) {
                            if (!Array.isArray(object.messages))
                                throw TypeError(".google.pubsub.v1.PublishRequest.messages: array expected");
                            message.messages = [];
                            for (var i = 0; i < object.messages.length; ++i) {
                                if (typeof object.messages[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.PublishRequest.messages: object expected");
                                message.messages[i] = $root.google.pubsub.v1.PubsubMessage.fromObject(object.messages[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PublishRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {google.pubsub.v1.PublishRequest} message PublishRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PublishRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.messages = [];
                        if (options.defaults)
                            object.topic = "";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.messages && message.messages.length) {
                            object.messages = [];
                            for (var j = 0; j < message.messages.length; ++j)
                                object.messages[j] = $root.google.pubsub.v1.PubsubMessage.toObject(message.messages[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this PublishRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PublishRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PublishRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PublishRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PublishRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PublishRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PublishRequest";
                    };
    
                    return PublishRequest;
                })();
    
                v1.PublishResponse = (function() {
    
                    /**
                     * Properties of a PublishResponse.
                     * @memberof google.pubsub.v1
                     * @interface IPublishResponse
                     * @property {Array.<string>|null} [messageIds] PublishResponse messageIds
                     */
    
                    /**
                     * Constructs a new PublishResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PublishResponse.
                     * @implements IPublishResponse
                     * @constructor
                     * @param {google.pubsub.v1.IPublishResponse=} [properties] Properties to set
                     */
                    function PublishResponse(properties) {
                        this.messageIds = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PublishResponse messageIds.
                     * @member {Array.<string>} messageIds
                     * @memberof google.pubsub.v1.PublishResponse
                     * @instance
                     */
                    PublishResponse.prototype.messageIds = $util.emptyArray;
    
                    /**
                     * Creates a new PublishResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {google.pubsub.v1.IPublishResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PublishResponse} PublishResponse instance
                     */
                    PublishResponse.create = function create(properties) {
                        return new PublishResponse(properties);
                    };
    
                    /**
                     * Encodes the specified PublishResponse message. Does not implicitly {@link google.pubsub.v1.PublishResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {google.pubsub.v1.IPublishResponse} message PublishResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PublishResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.messageIds != null && message.messageIds.length)
                            for (var i = 0; i < message.messageIds.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.messageIds[i]);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PublishResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.PublishResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {google.pubsub.v1.IPublishResponse} message PublishResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PublishResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PublishResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PublishResponse} PublishResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PublishResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PublishResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.messageIds && message.messageIds.length))
                                        message.messageIds = [];
                                    message.messageIds.push(reader.string());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PublishResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PublishResponse} PublishResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PublishResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PublishResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PublishResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.messageIds != null && message.hasOwnProperty("messageIds")) {
                            if (!Array.isArray(message.messageIds))
                                return "messageIds: array expected";
                            for (var i = 0; i < message.messageIds.length; ++i)
                                if (!$util.isString(message.messageIds[i]))
                                    return "messageIds: string[] expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a PublishResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PublishResponse} PublishResponse
                     */
                    PublishResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PublishResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.PublishResponse();
                        if (object.messageIds) {
                            if (!Array.isArray(object.messageIds))
                                throw TypeError(".google.pubsub.v1.PublishResponse.messageIds: array expected");
                            message.messageIds = [];
                            for (var i = 0; i < object.messageIds.length; ++i)
                                message.messageIds[i] = String(object.messageIds[i]);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PublishResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {google.pubsub.v1.PublishResponse} message PublishResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PublishResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.messageIds = [];
                        if (message.messageIds && message.messageIds.length) {
                            object.messageIds = [];
                            for (var j = 0; j < message.messageIds.length; ++j)
                                object.messageIds[j] = message.messageIds[j];
                        }
                        return object;
                    };
    
                    /**
                     * Converts this PublishResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PublishResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PublishResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PublishResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PublishResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PublishResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PublishResponse";
                    };
    
                    return PublishResponse;
                })();
    
                v1.ListTopicsRequest = (function() {
    
                    /**
                     * Properties of a ListTopicsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicsRequest
                     * @property {string|null} [project] ListTopicsRequest project
                     * @property {number|null} [pageSize] ListTopicsRequest pageSize
                     * @property {string|null} [pageToken] ListTopicsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListTopicsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicsRequest.
                     * @implements IListTopicsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicsRequest=} [properties] Properties to set
                     */
                    function ListTopicsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicsRequest project.
                     * @member {string} project
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @instance
                     */
                    ListTopicsRequest.prototype.project = "";
    
                    /**
                     * ListTopicsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @instance
                     */
                    ListTopicsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListTopicsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @instance
                     */
                    ListTopicsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListTopicsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicsRequest} ListTopicsRequest instance
                     */
                    ListTopicsRequest.create = function create(properties) {
                        return new ListTopicsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicsRequest message. Does not implicitly {@link google.pubsub.v1.ListTopicsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicsRequest} message ListTopicsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.project);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicsRequest} message ListTopicsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicsRequest} ListTopicsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicsRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.project = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicsRequest} ListTopicsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.project != null && message.hasOwnProperty("project"))
                            if (!$util.isString(message.project))
                                return "project: string expected";
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicsRequest} ListTopicsRequest
                     */
                    ListTopicsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicsRequest();
                        if (object.project != null)
                            message.project = String(object.project);
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {google.pubsub.v1.ListTopicsRequest} message ListTopicsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.project = "";
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.project != null && message.hasOwnProperty("project"))
                            object.project = message.project;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicsRequest";
                    };
    
                    return ListTopicsRequest;
                })();
    
                v1.ListTopicsResponse = (function() {
    
                    /**
                     * Properties of a ListTopicsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicsResponse
                     * @property {Array.<google.pubsub.v1.ITopic>|null} [topics] ListTopicsResponse topics
                     * @property {string|null} [nextPageToken] ListTopicsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListTopicsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicsResponse.
                     * @implements IListTopicsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicsResponse=} [properties] Properties to set
                     */
                    function ListTopicsResponse(properties) {
                        this.topics = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicsResponse topics.
                     * @member {Array.<google.pubsub.v1.ITopic>} topics
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @instance
                     */
                    ListTopicsResponse.prototype.topics = $util.emptyArray;
    
                    /**
                     * ListTopicsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @instance
                     */
                    ListTopicsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListTopicsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicsResponse} ListTopicsResponse instance
                     */
                    ListTopicsResponse.create = function create(properties) {
                        return new ListTopicsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicsResponse message. Does not implicitly {@link google.pubsub.v1.ListTopicsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicsResponse} message ListTopicsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topics != null && message.topics.length)
                            for (var i = 0; i < message.topics.length; ++i)
                                $root.google.pubsub.v1.Topic.encode(message.topics[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicsResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicsResponse} message ListTopicsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicsResponse} ListTopicsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicsResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.topics && message.topics.length))
                                        message.topics = [];
                                    message.topics.push($root.google.pubsub.v1.Topic.decode(reader, reader.uint32()));
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicsResponse} ListTopicsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicsResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topics != null && message.hasOwnProperty("topics")) {
                            if (!Array.isArray(message.topics))
                                return "topics: array expected";
                            for (var i = 0; i < message.topics.length; ++i) {
                                var error = $root.google.pubsub.v1.Topic.verify(message.topics[i]);
                                if (error)
                                    return "topics." + error;
                            }
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicsResponse} ListTopicsResponse
                     */
                    ListTopicsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicsResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicsResponse();
                        if (object.topics) {
                            if (!Array.isArray(object.topics))
                                throw TypeError(".google.pubsub.v1.ListTopicsResponse.topics: array expected");
                            message.topics = [];
                            for (var i = 0; i < object.topics.length; ++i) {
                                if (typeof object.topics[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.ListTopicsResponse.topics: object expected");
                                message.topics[i] = $root.google.pubsub.v1.Topic.fromObject(object.topics[i]);
                            }
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {google.pubsub.v1.ListTopicsResponse} message ListTopicsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.topics = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.topics && message.topics.length) {
                            object.topics = [];
                            for (var j = 0; j < message.topics.length; ++j)
                                object.topics[j] = $root.google.pubsub.v1.Topic.toObject(message.topics[j], options);
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicsResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicsResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicsResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicsResponse";
                    };
    
                    return ListTopicsResponse;
                })();
    
                v1.ListTopicSubscriptionsRequest = (function() {
    
                    /**
                     * Properties of a ListTopicSubscriptionsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicSubscriptionsRequest
                     * @property {string|null} [topic] ListTopicSubscriptionsRequest topic
                     * @property {number|null} [pageSize] ListTopicSubscriptionsRequest pageSize
                     * @property {string|null} [pageToken] ListTopicSubscriptionsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListTopicSubscriptionsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicSubscriptionsRequest.
                     * @implements IListTopicSubscriptionsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest=} [properties] Properties to set
                     */
                    function ListTopicSubscriptionsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicSubscriptionsRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @instance
                     */
                    ListTopicSubscriptionsRequest.prototype.topic = "";
    
                    /**
                     * ListTopicSubscriptionsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @instance
                     */
                    ListTopicSubscriptionsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListTopicSubscriptionsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @instance
                     */
                    ListTopicSubscriptionsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListTopicSubscriptionsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsRequest} ListTopicSubscriptionsRequest instance
                     */
                    ListTopicSubscriptionsRequest.create = function create(properties) {
                        return new ListTopicSubscriptionsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicSubscriptionsRequest message. Does not implicitly {@link google.pubsub.v1.ListTopicSubscriptionsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest} message ListTopicSubscriptionsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSubscriptionsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicSubscriptionsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicSubscriptionsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsRequest} message ListTopicSubscriptionsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSubscriptionsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicSubscriptionsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsRequest} ListTopicSubscriptionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSubscriptionsRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicSubscriptionsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicSubscriptionsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsRequest} ListTopicSubscriptionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSubscriptionsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicSubscriptionsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicSubscriptionsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicSubscriptionsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsRequest} ListTopicSubscriptionsRequest
                     */
                    ListTopicSubscriptionsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicSubscriptionsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicSubscriptionsRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicSubscriptionsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.ListTopicSubscriptionsRequest} message ListTopicSubscriptionsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicSubscriptionsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.topic = "";
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicSubscriptionsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicSubscriptionsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicSubscriptionsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicSubscriptionsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicSubscriptionsRequest";
                    };
    
                    return ListTopicSubscriptionsRequest;
                })();
    
                v1.ListTopicSubscriptionsResponse = (function() {
    
                    /**
                     * Properties of a ListTopicSubscriptionsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicSubscriptionsResponse
                     * @property {Array.<string>|null} [subscriptions] ListTopicSubscriptionsResponse subscriptions
                     * @property {string|null} [nextPageToken] ListTopicSubscriptionsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListTopicSubscriptionsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicSubscriptionsResponse.
                     * @implements IListTopicSubscriptionsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicSubscriptionsResponse=} [properties] Properties to set
                     */
                    function ListTopicSubscriptionsResponse(properties) {
                        this.subscriptions = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicSubscriptionsResponse subscriptions.
                     * @member {Array.<string>} subscriptions
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @instance
                     */
                    ListTopicSubscriptionsResponse.prototype.subscriptions = $util.emptyArray;
    
                    /**
                     * ListTopicSubscriptionsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @instance
                     */
                    ListTopicSubscriptionsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListTopicSubscriptionsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsResponse} ListTopicSubscriptionsResponse instance
                     */
                    ListTopicSubscriptionsResponse.create = function create(properties) {
                        return new ListTopicSubscriptionsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicSubscriptionsResponse message. Does not implicitly {@link google.pubsub.v1.ListTopicSubscriptionsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsResponse} message ListTopicSubscriptionsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSubscriptionsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscriptions != null && message.subscriptions.length)
                            for (var i = 0; i < message.subscriptions.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscriptions[i]);
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicSubscriptionsResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicSubscriptionsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSubscriptionsResponse} message ListTopicSubscriptionsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSubscriptionsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicSubscriptionsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsResponse} ListTopicSubscriptionsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSubscriptionsResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicSubscriptionsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.subscriptions && message.subscriptions.length))
                                        message.subscriptions = [];
                                    message.subscriptions.push(reader.string());
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicSubscriptionsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsResponse} ListTopicSubscriptionsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSubscriptionsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicSubscriptionsResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicSubscriptionsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscriptions != null && message.hasOwnProperty("subscriptions")) {
                            if (!Array.isArray(message.subscriptions))
                                return "subscriptions: array expected";
                            for (var i = 0; i < message.subscriptions.length; ++i)
                                if (!$util.isString(message.subscriptions[i]))
                                    return "subscriptions: string[] expected";
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicSubscriptionsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicSubscriptionsResponse} ListTopicSubscriptionsResponse
                     */
                    ListTopicSubscriptionsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicSubscriptionsResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicSubscriptionsResponse();
                        if (object.subscriptions) {
                            if (!Array.isArray(object.subscriptions))
                                throw TypeError(".google.pubsub.v1.ListTopicSubscriptionsResponse.subscriptions: array expected");
                            message.subscriptions = [];
                            for (var i = 0; i < object.subscriptions.length; ++i)
                                message.subscriptions[i] = String(object.subscriptions[i]);
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicSubscriptionsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.ListTopicSubscriptionsResponse} message ListTopicSubscriptionsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicSubscriptionsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.subscriptions = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.subscriptions && message.subscriptions.length) {
                            object.subscriptions = [];
                            for (var j = 0; j < message.subscriptions.length; ++j)
                                object.subscriptions[j] = message.subscriptions[j];
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicSubscriptionsResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicSubscriptionsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicSubscriptionsResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicSubscriptionsResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicSubscriptionsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicSubscriptionsResponse";
                    };
    
                    return ListTopicSubscriptionsResponse;
                })();
    
                v1.ListTopicSnapshotsRequest = (function() {
    
                    /**
                     * Properties of a ListTopicSnapshotsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicSnapshotsRequest
                     * @property {string|null} [topic] ListTopicSnapshotsRequest topic
                     * @property {number|null} [pageSize] ListTopicSnapshotsRequest pageSize
                     * @property {string|null} [pageToken] ListTopicSnapshotsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListTopicSnapshotsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicSnapshotsRequest.
                     * @implements IListTopicSnapshotsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest=} [properties] Properties to set
                     */
                    function ListTopicSnapshotsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicSnapshotsRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @instance
                     */
                    ListTopicSnapshotsRequest.prototype.topic = "";
    
                    /**
                     * ListTopicSnapshotsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @instance
                     */
                    ListTopicSnapshotsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListTopicSnapshotsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @instance
                     */
                    ListTopicSnapshotsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListTopicSnapshotsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicSnapshotsRequest} ListTopicSnapshotsRequest instance
                     */
                    ListTopicSnapshotsRequest.create = function create(properties) {
                        return new ListTopicSnapshotsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicSnapshotsRequest message. Does not implicitly {@link google.pubsub.v1.ListTopicSnapshotsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest} message ListTopicSnapshotsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSnapshotsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicSnapshotsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicSnapshotsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsRequest} message ListTopicSnapshotsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSnapshotsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicSnapshotsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicSnapshotsRequest} ListTopicSnapshotsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSnapshotsRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicSnapshotsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicSnapshotsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicSnapshotsRequest} ListTopicSnapshotsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSnapshotsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicSnapshotsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicSnapshotsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicSnapshotsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicSnapshotsRequest} ListTopicSnapshotsRequest
                     */
                    ListTopicSnapshotsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicSnapshotsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicSnapshotsRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicSnapshotsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.ListTopicSnapshotsRequest} message ListTopicSnapshotsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicSnapshotsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.topic = "";
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicSnapshotsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicSnapshotsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicSnapshotsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicSnapshotsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicSnapshotsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicSnapshotsRequest";
                    };
    
                    return ListTopicSnapshotsRequest;
                })();
    
                v1.ListTopicSnapshotsResponse = (function() {
    
                    /**
                     * Properties of a ListTopicSnapshotsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListTopicSnapshotsResponse
                     * @property {Array.<string>|null} [snapshots] ListTopicSnapshotsResponse snapshots
                     * @property {string|null} [nextPageToken] ListTopicSnapshotsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListTopicSnapshotsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListTopicSnapshotsResponse.
                     * @implements IListTopicSnapshotsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListTopicSnapshotsResponse=} [properties] Properties to set
                     */
                    function ListTopicSnapshotsResponse(properties) {
                        this.snapshots = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListTopicSnapshotsResponse snapshots.
                     * @member {Array.<string>} snapshots
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @instance
                     */
                    ListTopicSnapshotsResponse.prototype.snapshots = $util.emptyArray;
    
                    /**
                     * ListTopicSnapshotsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @instance
                     */
                    ListTopicSnapshotsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListTopicSnapshotsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListTopicSnapshotsResponse} ListTopicSnapshotsResponse instance
                     */
                    ListTopicSnapshotsResponse.create = function create(properties) {
                        return new ListTopicSnapshotsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListTopicSnapshotsResponse message. Does not implicitly {@link google.pubsub.v1.ListTopicSnapshotsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsResponse} message ListTopicSnapshotsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSnapshotsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.snapshots != null && message.snapshots.length)
                            for (var i = 0; i < message.snapshots.length; ++i)
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.snapshots[i]);
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListTopicSnapshotsResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListTopicSnapshotsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListTopicSnapshotsResponse} message ListTopicSnapshotsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListTopicSnapshotsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListTopicSnapshotsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListTopicSnapshotsResponse} ListTopicSnapshotsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSnapshotsResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListTopicSnapshotsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.snapshots && message.snapshots.length))
                                        message.snapshots = [];
                                    message.snapshots.push(reader.string());
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListTopicSnapshotsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListTopicSnapshotsResponse} ListTopicSnapshotsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListTopicSnapshotsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListTopicSnapshotsResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListTopicSnapshotsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.snapshots != null && message.hasOwnProperty("snapshots")) {
                            if (!Array.isArray(message.snapshots))
                                return "snapshots: array expected";
                            for (var i = 0; i < message.snapshots.length; ++i)
                                if (!$util.isString(message.snapshots[i]))
                                    return "snapshots: string[] expected";
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListTopicSnapshotsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListTopicSnapshotsResponse} ListTopicSnapshotsResponse
                     */
                    ListTopicSnapshotsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListTopicSnapshotsResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListTopicSnapshotsResponse();
                        if (object.snapshots) {
                            if (!Array.isArray(object.snapshots))
                                throw TypeError(".google.pubsub.v1.ListTopicSnapshotsResponse.snapshots: array expected");
                            message.snapshots = [];
                            for (var i = 0; i < object.snapshots.length; ++i)
                                message.snapshots[i] = String(object.snapshots[i]);
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListTopicSnapshotsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.ListTopicSnapshotsResponse} message ListTopicSnapshotsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListTopicSnapshotsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.snapshots = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.snapshots && message.snapshots.length) {
                            object.snapshots = [];
                            for (var j = 0; j < message.snapshots.length; ++j)
                                object.snapshots[j] = message.snapshots[j];
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListTopicSnapshotsResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListTopicSnapshotsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListTopicSnapshotsResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListTopicSnapshotsResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListTopicSnapshotsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListTopicSnapshotsResponse";
                    };
    
                    return ListTopicSnapshotsResponse;
                })();
    
                v1.DeleteTopicRequest = (function() {
    
                    /**
                     * Properties of a DeleteTopicRequest.
                     * @memberof google.pubsub.v1
                     * @interface IDeleteTopicRequest
                     * @property {string|null} [topic] DeleteTopicRequest topic
                     */
    
                    /**
                     * Constructs a new DeleteTopicRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DeleteTopicRequest.
                     * @implements IDeleteTopicRequest
                     * @constructor
                     * @param {google.pubsub.v1.IDeleteTopicRequest=} [properties] Properties to set
                     */
                    function DeleteTopicRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DeleteTopicRequest topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @instance
                     */
                    DeleteTopicRequest.prototype.topic = "";
    
                    /**
                     * Creates a new DeleteTopicRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteTopicRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DeleteTopicRequest} DeleteTopicRequest instance
                     */
                    DeleteTopicRequest.create = function create(properties) {
                        return new DeleteTopicRequest(properties);
                    };
    
                    /**
                     * Encodes the specified DeleteTopicRequest message. Does not implicitly {@link google.pubsub.v1.DeleteTopicRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteTopicRequest} message DeleteTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeleteTopicRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.topic);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DeleteTopicRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.DeleteTopicRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteTopicRequest} message DeleteTopicRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeleteTopicRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DeleteTopicRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DeleteTopicRequest} DeleteTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeleteTopicRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DeleteTopicRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.topic = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DeleteTopicRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DeleteTopicRequest} DeleteTopicRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeleteTopicRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DeleteTopicRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DeleteTopicRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a DeleteTopicRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DeleteTopicRequest} DeleteTopicRequest
                     */
                    DeleteTopicRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DeleteTopicRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.DeleteTopicRequest();
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a DeleteTopicRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {google.pubsub.v1.DeleteTopicRequest} message DeleteTopicRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DeleteTopicRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.topic = "";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        return object;
                    };
    
                    /**
                     * Converts this DeleteTopicRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DeleteTopicRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DeleteTopicRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DeleteTopicRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DeleteTopicRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DeleteTopicRequest";
                    };
    
                    return DeleteTopicRequest;
                })();
    
                v1.DetachSubscriptionRequest = (function() {
    
                    /**
                     * Properties of a DetachSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @interface IDetachSubscriptionRequest
                     * @property {string|null} [subscription] DetachSubscriptionRequest subscription
                     */
    
                    /**
                     * Constructs a new DetachSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DetachSubscriptionRequest.
                     * @implements IDetachSubscriptionRequest
                     * @constructor
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest=} [properties] Properties to set
                     */
                    function DetachSubscriptionRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DetachSubscriptionRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @instance
                     */
                    DetachSubscriptionRequest.prototype.subscription = "";
    
                    /**
                     * Creates a new DetachSubscriptionRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DetachSubscriptionRequest} DetachSubscriptionRequest instance
                     */
                    DetachSubscriptionRequest.create = function create(properties) {
                        return new DetachSubscriptionRequest(properties);
                    };
    
                    /**
                     * Encodes the specified DetachSubscriptionRequest message. Does not implicitly {@link google.pubsub.v1.DetachSubscriptionRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest} message DetachSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DetachSubscriptionRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DetachSubscriptionRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.DetachSubscriptionRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionRequest} message DetachSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DetachSubscriptionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DetachSubscriptionRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DetachSubscriptionRequest} DetachSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DetachSubscriptionRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DetachSubscriptionRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DetachSubscriptionRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DetachSubscriptionRequest} DetachSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DetachSubscriptionRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DetachSubscriptionRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DetachSubscriptionRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a DetachSubscriptionRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DetachSubscriptionRequest} DetachSubscriptionRequest
                     */
                    DetachSubscriptionRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DetachSubscriptionRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.DetachSubscriptionRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a DetachSubscriptionRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.DetachSubscriptionRequest} message DetachSubscriptionRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DetachSubscriptionRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.subscription = "";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        return object;
                    };
    
                    /**
                     * Converts this DetachSubscriptionRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DetachSubscriptionRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DetachSubscriptionRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DetachSubscriptionRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DetachSubscriptionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DetachSubscriptionRequest";
                    };
    
                    return DetachSubscriptionRequest;
                })();
    
                v1.DetachSubscriptionResponse = (function() {
    
                    /**
                     * Properties of a DetachSubscriptionResponse.
                     * @memberof google.pubsub.v1
                     * @interface IDetachSubscriptionResponse
                     */
    
                    /**
                     * Constructs a new DetachSubscriptionResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DetachSubscriptionResponse.
                     * @implements IDetachSubscriptionResponse
                     * @constructor
                     * @param {google.pubsub.v1.IDetachSubscriptionResponse=} [properties] Properties to set
                     */
                    function DetachSubscriptionResponse(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Creates a new DetachSubscriptionResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DetachSubscriptionResponse} DetachSubscriptionResponse instance
                     */
                    DetachSubscriptionResponse.create = function create(properties) {
                        return new DetachSubscriptionResponse(properties);
                    };
    
                    /**
                     * Encodes the specified DetachSubscriptionResponse message. Does not implicitly {@link google.pubsub.v1.DetachSubscriptionResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionResponse} message DetachSubscriptionResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DetachSubscriptionResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DetachSubscriptionResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.DetachSubscriptionResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {google.pubsub.v1.IDetachSubscriptionResponse} message DetachSubscriptionResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DetachSubscriptionResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DetachSubscriptionResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DetachSubscriptionResponse} DetachSubscriptionResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DetachSubscriptionResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DetachSubscriptionResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DetachSubscriptionResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DetachSubscriptionResponse} DetachSubscriptionResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DetachSubscriptionResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DetachSubscriptionResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DetachSubscriptionResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        return null;
                    };
    
                    /**
                     * Creates a DetachSubscriptionResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DetachSubscriptionResponse} DetachSubscriptionResponse
                     */
                    DetachSubscriptionResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DetachSubscriptionResponse)
                            return object;
                        return new $root.google.pubsub.v1.DetachSubscriptionResponse();
                    };
    
                    /**
                     * Creates a plain object from a DetachSubscriptionResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {google.pubsub.v1.DetachSubscriptionResponse} message DetachSubscriptionResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DetachSubscriptionResponse.toObject = function toObject() {
                        return {};
                    };
    
                    /**
                     * Converts this DetachSubscriptionResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DetachSubscriptionResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DetachSubscriptionResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DetachSubscriptionResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DetachSubscriptionResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DetachSubscriptionResponse";
                    };
    
                    return DetachSubscriptionResponse;
                })();
    
                v1.Subscriber = (function() {
    
                    /**
                     * Constructs a new Subscriber service.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Subscriber
                     * @extends $protobuf.rpc.Service
                     * @constructor
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     */
                    function Subscriber(rpcImpl, requestDelimited, responseDelimited) {
                        $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                    }
    
                    (Subscriber.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = Subscriber;
    
                    /**
                     * Creates new Subscriber service using the specified rpc implementation.
                     * @function create
                     * @memberof google.pubsub.v1.Subscriber
                     * @static
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     * @returns {Subscriber} RPC service. Useful where requests and/or responses are streamed.
                     */
                    Subscriber.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                        return new this(rpcImpl, requestDelimited, responseDelimited);
                    };
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|createSubscription}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef CreateSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Subscription} [response] Subscription
                     */
    
                    /**
                     * Calls CreateSubscription.
                     * @function createSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ISubscription} request Subscription message or plain object
                     * @param {google.pubsub.v1.Subscriber.CreateSubscriptionCallback} callback Node-style callback called with the error, if any, and Subscription
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.createSubscription = function createSubscription(request, callback) {
                        return this.rpcCall(createSubscription, $root.google.pubsub.v1.Subscription, $root.google.pubsub.v1.Subscription, request, callback);
                    }, "name", { value: "CreateSubscription" });
    
                    /**
                     * Calls CreateSubscription.
                     * @function createSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ISubscription} request Subscription message or plain object
                     * @returns {Promise<google.pubsub.v1.Subscription>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|getSubscription}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef GetSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Subscription} [response] Subscription
                     */
    
                    /**
                     * Calls GetSubscription.
                     * @function getSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IGetSubscriptionRequest} request GetSubscriptionRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.GetSubscriptionCallback} callback Node-style callback called with the error, if any, and Subscription
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.getSubscription = function getSubscription(request, callback) {
                        return this.rpcCall(getSubscription, $root.google.pubsub.v1.GetSubscriptionRequest, $root.google.pubsub.v1.Subscription, request, callback);
                    }, "name", { value: "GetSubscription" });
    
                    /**
                     * Calls GetSubscription.
                     * @function getSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IGetSubscriptionRequest} request GetSubscriptionRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Subscription>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|updateSubscription}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef UpdateSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Subscription} [response] Subscription
                     */
    
                    /**
                     * Calls UpdateSubscription.
                     * @function updateSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest} request UpdateSubscriptionRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.UpdateSubscriptionCallback} callback Node-style callback called with the error, if any, and Subscription
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.updateSubscription = function updateSubscription(request, callback) {
                        return this.rpcCall(updateSubscription, $root.google.pubsub.v1.UpdateSubscriptionRequest, $root.google.pubsub.v1.Subscription, request, callback);
                    }, "name", { value: "UpdateSubscription" });
    
                    /**
                     * Calls UpdateSubscription.
                     * @function updateSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest} request UpdateSubscriptionRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Subscription>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|listSubscriptions}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef ListSubscriptionsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListSubscriptionsResponse} [response] ListSubscriptionsResponse
                     */
    
                    /**
                     * Calls ListSubscriptions.
                     * @function listSubscriptions
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IListSubscriptionsRequest} request ListSubscriptionsRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.ListSubscriptionsCallback} callback Node-style callback called with the error, if any, and ListSubscriptionsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.listSubscriptions = function listSubscriptions(request, callback) {
                        return this.rpcCall(listSubscriptions, $root.google.pubsub.v1.ListSubscriptionsRequest, $root.google.pubsub.v1.ListSubscriptionsResponse, request, callback);
                    }, "name", { value: "ListSubscriptions" });
    
                    /**
                     * Calls ListSubscriptions.
                     * @function listSubscriptions
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IListSubscriptionsRequest} request ListSubscriptionsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListSubscriptionsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|deleteSubscription}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef DeleteSubscriptionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls DeleteSubscription.
                     * @function deleteSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSubscriptionRequest} request DeleteSubscriptionRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.DeleteSubscriptionCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.deleteSubscription = function deleteSubscription(request, callback) {
                        return this.rpcCall(deleteSubscription, $root.google.pubsub.v1.DeleteSubscriptionRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "DeleteSubscription" });
    
                    /**
                     * Calls DeleteSubscription.
                     * @function deleteSubscription
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSubscriptionRequest} request DeleteSubscriptionRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|modifyAckDeadline}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef ModifyAckDeadlineCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls ModifyAckDeadline.
                     * @function modifyAckDeadline
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IModifyAckDeadlineRequest} request ModifyAckDeadlineRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.ModifyAckDeadlineCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.modifyAckDeadline = function modifyAckDeadline(request, callback) {
                        return this.rpcCall(modifyAckDeadline, $root.google.pubsub.v1.ModifyAckDeadlineRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "ModifyAckDeadline" });
    
                    /**
                     * Calls ModifyAckDeadline.
                     * @function modifyAckDeadline
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IModifyAckDeadlineRequest} request ModifyAckDeadlineRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|acknowledge}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef AcknowledgeCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls Acknowledge.
                     * @function acknowledge
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IAcknowledgeRequest} request AcknowledgeRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.AcknowledgeCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.acknowledge = function acknowledge(request, callback) {
                        return this.rpcCall(acknowledge, $root.google.pubsub.v1.AcknowledgeRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "Acknowledge" });
    
                    /**
                     * Calls Acknowledge.
                     * @function acknowledge
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IAcknowledgeRequest} request AcknowledgeRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|pull}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef PullCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.PullResponse} [response] PullResponse
                     */
    
                    /**
                     * Calls Pull.
                     * @function pull
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IPullRequest} request PullRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.PullCallback} callback Node-style callback called with the error, if any, and PullResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.pull = function pull(request, callback) {
                        return this.rpcCall(pull, $root.google.pubsub.v1.PullRequest, $root.google.pubsub.v1.PullResponse, request, callback);
                    }, "name", { value: "Pull" });
    
                    /**
                     * Calls Pull.
                     * @function pull
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IPullRequest} request PullRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.PullResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|streamingPull}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef StreamingPullCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.StreamingPullResponse} [response] StreamingPullResponse
                     */
    
                    /**
                     * Calls StreamingPull.
                     * @function streamingPull
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IStreamingPullRequest} request StreamingPullRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.StreamingPullCallback} callback Node-style callback called with the error, if any, and StreamingPullResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.streamingPull = function streamingPull(request, callback) {
                        return this.rpcCall(streamingPull, $root.google.pubsub.v1.StreamingPullRequest, $root.google.pubsub.v1.StreamingPullResponse, request, callback);
                    }, "name", { value: "StreamingPull" });
    
                    /**
                     * Calls StreamingPull.
                     * @function streamingPull
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IStreamingPullRequest} request StreamingPullRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.StreamingPullResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|modifyPushConfig}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef ModifyPushConfigCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls ModifyPushConfig.
                     * @function modifyPushConfig
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IModifyPushConfigRequest} request ModifyPushConfigRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.ModifyPushConfigCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.modifyPushConfig = function modifyPushConfig(request, callback) {
                        return this.rpcCall(modifyPushConfig, $root.google.pubsub.v1.ModifyPushConfigRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "ModifyPushConfig" });
    
                    /**
                     * Calls ModifyPushConfig.
                     * @function modifyPushConfig
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IModifyPushConfigRequest} request ModifyPushConfigRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|getSnapshot}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef GetSnapshotCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Snapshot} [response] Snapshot
                     */
    
                    /**
                     * Calls GetSnapshot.
                     * @function getSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IGetSnapshotRequest} request GetSnapshotRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.GetSnapshotCallback} callback Node-style callback called with the error, if any, and Snapshot
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.getSnapshot = function getSnapshot(request, callback) {
                        return this.rpcCall(getSnapshot, $root.google.pubsub.v1.GetSnapshotRequest, $root.google.pubsub.v1.Snapshot, request, callback);
                    }, "name", { value: "GetSnapshot" });
    
                    /**
                     * Calls GetSnapshot.
                     * @function getSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IGetSnapshotRequest} request GetSnapshotRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Snapshot>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|listSnapshots}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef ListSnapshotsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListSnapshotsResponse} [response] ListSnapshotsResponse
                     */
    
                    /**
                     * Calls ListSnapshots.
                     * @function listSnapshots
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IListSnapshotsRequest} request ListSnapshotsRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.ListSnapshotsCallback} callback Node-style callback called with the error, if any, and ListSnapshotsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.listSnapshots = function listSnapshots(request, callback) {
                        return this.rpcCall(listSnapshots, $root.google.pubsub.v1.ListSnapshotsRequest, $root.google.pubsub.v1.ListSnapshotsResponse, request, callback);
                    }, "name", { value: "ListSnapshots" });
    
                    /**
                     * Calls ListSnapshots.
                     * @function listSnapshots
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IListSnapshotsRequest} request ListSnapshotsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListSnapshotsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|createSnapshot}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef CreateSnapshotCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Snapshot} [response] Snapshot
                     */
    
                    /**
                     * Calls CreateSnapshot.
                     * @function createSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ICreateSnapshotRequest} request CreateSnapshotRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.CreateSnapshotCallback} callback Node-style callback called with the error, if any, and Snapshot
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.createSnapshot = function createSnapshot(request, callback) {
                        return this.rpcCall(createSnapshot, $root.google.pubsub.v1.CreateSnapshotRequest, $root.google.pubsub.v1.Snapshot, request, callback);
                    }, "name", { value: "CreateSnapshot" });
    
                    /**
                     * Calls CreateSnapshot.
                     * @function createSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ICreateSnapshotRequest} request CreateSnapshotRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Snapshot>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|updateSnapshot}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef UpdateSnapshotCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Snapshot} [response] Snapshot
                     */
    
                    /**
                     * Calls UpdateSnapshot.
                     * @function updateSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IUpdateSnapshotRequest} request UpdateSnapshotRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.UpdateSnapshotCallback} callback Node-style callback called with the error, if any, and Snapshot
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.updateSnapshot = function updateSnapshot(request, callback) {
                        return this.rpcCall(updateSnapshot, $root.google.pubsub.v1.UpdateSnapshotRequest, $root.google.pubsub.v1.Snapshot, request, callback);
                    }, "name", { value: "UpdateSnapshot" });
    
                    /**
                     * Calls UpdateSnapshot.
                     * @function updateSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IUpdateSnapshotRequest} request UpdateSnapshotRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Snapshot>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|deleteSnapshot}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef DeleteSnapshotCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls DeleteSnapshot.
                     * @function deleteSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSnapshotRequest} request DeleteSnapshotRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.DeleteSnapshotCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.deleteSnapshot = function deleteSnapshot(request, callback) {
                        return this.rpcCall(deleteSnapshot, $root.google.pubsub.v1.DeleteSnapshotRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "DeleteSnapshot" });
    
                    /**
                     * Calls DeleteSnapshot.
                     * @function deleteSnapshot
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSnapshotRequest} request DeleteSnapshotRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.Subscriber|seek}.
                     * @memberof google.pubsub.v1.Subscriber
                     * @typedef SeekCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.SeekResponse} [response] SeekResponse
                     */
    
                    /**
                     * Calls Seek.
                     * @function seek
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ISeekRequest} request SeekRequest message or plain object
                     * @param {google.pubsub.v1.Subscriber.SeekCallback} callback Node-style callback called with the error, if any, and SeekResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(Subscriber.prototype.seek = function seek(request, callback) {
                        return this.rpcCall(seek, $root.google.pubsub.v1.SeekRequest, $root.google.pubsub.v1.SeekResponse, request, callback);
                    }, "name", { value: "Seek" });
    
                    /**
                     * Calls Seek.
                     * @function seek
                     * @memberof google.pubsub.v1.Subscriber
                     * @instance
                     * @param {google.pubsub.v1.ISeekRequest} request SeekRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.SeekResponse>} Promise
                     * @variation 2
                     */
    
                    return Subscriber;
                })();
    
                v1.Subscription = (function() {
    
                    /**
                     * Properties of a Subscription.
                     * @memberof google.pubsub.v1
                     * @interface ISubscription
                     * @property {string|null} [name] Subscription name
                     * @property {string|null} [topic] Subscription topic
                     * @property {google.pubsub.v1.IPushConfig|null} [pushConfig] Subscription pushConfig
                     * @property {google.pubsub.v1.IBigQueryConfig|null} [bigqueryConfig] Subscription bigqueryConfig
                     * @property {google.pubsub.v1.ICloudStorageConfig|null} [cloudStorageConfig] Subscription cloudStorageConfig
                     * @property {number|null} [ackDeadlineSeconds] Subscription ackDeadlineSeconds
                     * @property {boolean|null} [retainAckedMessages] Subscription retainAckedMessages
                     * @property {google.protobuf.IDuration|null} [messageRetentionDuration] Subscription messageRetentionDuration
                     * @property {Object.<string,string>|null} [labels] Subscription labels
                     * @property {boolean|null} [enableMessageOrdering] Subscription enableMessageOrdering
                     * @property {google.pubsub.v1.IExpirationPolicy|null} [expirationPolicy] Subscription expirationPolicy
                     * @property {string|null} [filter] Subscription filter
                     * @property {google.pubsub.v1.IDeadLetterPolicy|null} [deadLetterPolicy] Subscription deadLetterPolicy
                     * @property {google.pubsub.v1.IRetryPolicy|null} [retryPolicy] Subscription retryPolicy
                     * @property {boolean|null} [detached] Subscription detached
                     * @property {boolean|null} [enableExactlyOnceDelivery] Subscription enableExactlyOnceDelivery
                     * @property {google.protobuf.IDuration|null} [topicMessageRetentionDuration] Subscription topicMessageRetentionDuration
                     * @property {google.pubsub.v1.Subscription.State|null} [state] Subscription state
                     */
    
                    /**
                     * Constructs a new Subscription.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Subscription.
                     * @implements ISubscription
                     * @constructor
                     * @param {google.pubsub.v1.ISubscription=} [properties] Properties to set
                     */
                    function Subscription(properties) {
                        this.labels = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Subscription name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.name = "";
    
                    /**
                     * Subscription topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.topic = "";
    
                    /**
                     * Subscription pushConfig.
                     * @member {google.pubsub.v1.IPushConfig|null|undefined} pushConfig
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.pushConfig = null;
    
                    /**
                     * Subscription bigqueryConfig.
                     * @member {google.pubsub.v1.IBigQueryConfig|null|undefined} bigqueryConfig
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.bigqueryConfig = null;
    
                    /**
                     * Subscription cloudStorageConfig.
                     * @member {google.pubsub.v1.ICloudStorageConfig|null|undefined} cloudStorageConfig
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.cloudStorageConfig = null;
    
                    /**
                     * Subscription ackDeadlineSeconds.
                     * @member {number} ackDeadlineSeconds
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.ackDeadlineSeconds = 0;
    
                    /**
                     * Subscription retainAckedMessages.
                     * @member {boolean} retainAckedMessages
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.retainAckedMessages = false;
    
                    /**
                     * Subscription messageRetentionDuration.
                     * @member {google.protobuf.IDuration|null|undefined} messageRetentionDuration
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.messageRetentionDuration = null;
    
                    /**
                     * Subscription labels.
                     * @member {Object.<string,string>} labels
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.labels = $util.emptyObject;
    
                    /**
                     * Subscription enableMessageOrdering.
                     * @member {boolean} enableMessageOrdering
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.enableMessageOrdering = false;
    
                    /**
                     * Subscription expirationPolicy.
                     * @member {google.pubsub.v1.IExpirationPolicy|null|undefined} expirationPolicy
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.expirationPolicy = null;
    
                    /**
                     * Subscription filter.
                     * @member {string} filter
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.filter = "";
    
                    /**
                     * Subscription deadLetterPolicy.
                     * @member {google.pubsub.v1.IDeadLetterPolicy|null|undefined} deadLetterPolicy
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.deadLetterPolicy = null;
    
                    /**
                     * Subscription retryPolicy.
                     * @member {google.pubsub.v1.IRetryPolicy|null|undefined} retryPolicy
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.retryPolicy = null;
    
                    /**
                     * Subscription detached.
                     * @member {boolean} detached
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.detached = false;
    
                    /**
                     * Subscription enableExactlyOnceDelivery.
                     * @member {boolean} enableExactlyOnceDelivery
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.enableExactlyOnceDelivery = false;
    
                    /**
                     * Subscription topicMessageRetentionDuration.
                     * @member {google.protobuf.IDuration|null|undefined} topicMessageRetentionDuration
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.topicMessageRetentionDuration = null;
    
                    /**
                     * Subscription state.
                     * @member {google.pubsub.v1.Subscription.State} state
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     */
                    Subscription.prototype.state = 0;
    
                    /**
                     * Creates a new Subscription instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {google.pubsub.v1.ISubscription=} [properties] Properties to set
                     * @returns {google.pubsub.v1.Subscription} Subscription instance
                     */
                    Subscription.create = function create(properties) {
                        return new Subscription(properties);
                    };
    
                    /**
                     * Encodes the specified Subscription message. Does not implicitly {@link google.pubsub.v1.Subscription.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {google.pubsub.v1.ISubscription} message Subscription message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Subscription.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.topic);
                        if (message.pushConfig != null && Object.hasOwnProperty.call(message, "pushConfig"))
                            $root.google.pubsub.v1.PushConfig.encode(message.pushConfig, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.ackDeadlineSeconds != null && Object.hasOwnProperty.call(message, "ackDeadlineSeconds"))
                            writer.uint32(/* id 5, wireType 0 =*/40).int32(message.ackDeadlineSeconds);
                        if (message.retainAckedMessages != null && Object.hasOwnProperty.call(message, "retainAckedMessages"))
                            writer.uint32(/* id 7, wireType 0 =*/56).bool(message.retainAckedMessages);
                        if (message.messageRetentionDuration != null && Object.hasOwnProperty.call(message, "messageRetentionDuration"))
                            $root.google.protobuf.Duration.encode(message.messageRetentionDuration, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                        if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                            for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 9, wireType 2 =*/74).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                        if (message.enableMessageOrdering != null && Object.hasOwnProperty.call(message, "enableMessageOrdering"))
                            writer.uint32(/* id 10, wireType 0 =*/80).bool(message.enableMessageOrdering);
                        if (message.expirationPolicy != null && Object.hasOwnProperty.call(message, "expirationPolicy"))
                            $root.google.pubsub.v1.ExpirationPolicy.encode(message.expirationPolicy, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                        if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                            writer.uint32(/* id 12, wireType 2 =*/98).string(message.filter);
                        if (message.deadLetterPolicy != null && Object.hasOwnProperty.call(message, "deadLetterPolicy"))
                            $root.google.pubsub.v1.DeadLetterPolicy.encode(message.deadLetterPolicy, writer.uint32(/* id 13, wireType 2 =*/106).fork()).ldelim();
                        if (message.retryPolicy != null && Object.hasOwnProperty.call(message, "retryPolicy"))
                            $root.google.pubsub.v1.RetryPolicy.encode(message.retryPolicy, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
                        if (message.detached != null && Object.hasOwnProperty.call(message, "detached"))
                            writer.uint32(/* id 15, wireType 0 =*/120).bool(message.detached);
                        if (message.enableExactlyOnceDelivery != null && Object.hasOwnProperty.call(message, "enableExactlyOnceDelivery"))
                            writer.uint32(/* id 16, wireType 0 =*/128).bool(message.enableExactlyOnceDelivery);
                        if (message.topicMessageRetentionDuration != null && Object.hasOwnProperty.call(message, "topicMessageRetentionDuration"))
                            $root.google.protobuf.Duration.encode(message.topicMessageRetentionDuration, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
                        if (message.bigqueryConfig != null && Object.hasOwnProperty.call(message, "bigqueryConfig"))
                            $root.google.pubsub.v1.BigQueryConfig.encode(message.bigqueryConfig, writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
                        if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                            writer.uint32(/* id 19, wireType 0 =*/152).int32(message.state);
                        if (message.cloudStorageConfig != null && Object.hasOwnProperty.call(message, "cloudStorageConfig"))
                            $root.google.pubsub.v1.CloudStorageConfig.encode(message.cloudStorageConfig, writer.uint32(/* id 22, wireType 2 =*/178).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Subscription message, length delimited. Does not implicitly {@link google.pubsub.v1.Subscription.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {google.pubsub.v1.ISubscription} message Subscription message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Subscription.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Subscription message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.Subscription} Subscription
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Subscription.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.Subscription(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.pushConfig = $root.google.pubsub.v1.PushConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 18: {
                                    message.bigqueryConfig = $root.google.pubsub.v1.BigQueryConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 22: {
                                    message.cloudStorageConfig = $root.google.pubsub.v1.CloudStorageConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.ackDeadlineSeconds = reader.int32();
                                    break;
                                }
                            case 7: {
                                    message.retainAckedMessages = reader.bool();
                                    break;
                                }
                            case 8: {
                                    message.messageRetentionDuration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 9: {
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                }
                            case 10: {
                                    message.enableMessageOrdering = reader.bool();
                                    break;
                                }
                            case 11: {
                                    message.expirationPolicy = $root.google.pubsub.v1.ExpirationPolicy.decode(reader, reader.uint32());
                                    break;
                                }
                            case 12: {
                                    message.filter = reader.string();
                                    break;
                                }
                            case 13: {
                                    message.deadLetterPolicy = $root.google.pubsub.v1.DeadLetterPolicy.decode(reader, reader.uint32());
                                    break;
                                }
                            case 14: {
                                    message.retryPolicy = $root.google.pubsub.v1.RetryPolicy.decode(reader, reader.uint32());
                                    break;
                                }
                            case 15: {
                                    message.detached = reader.bool();
                                    break;
                                }
                            case 16: {
                                    message.enableExactlyOnceDelivery = reader.bool();
                                    break;
                                }
                            case 17: {
                                    message.topicMessageRetentionDuration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 19: {
                                    message.state = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Subscription message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.Subscription} Subscription
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Subscription.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Subscription message.
                     * @function verify
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Subscription.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.pushConfig != null && message.hasOwnProperty("pushConfig")) {
                            var error = $root.google.pubsub.v1.PushConfig.verify(message.pushConfig);
                            if (error)
                                return "pushConfig." + error;
                        }
                        if (message.bigqueryConfig != null && message.hasOwnProperty("bigqueryConfig")) {
                            var error = $root.google.pubsub.v1.BigQueryConfig.verify(message.bigqueryConfig);
                            if (error)
                                return "bigqueryConfig." + error;
                        }
                        if (message.cloudStorageConfig != null && message.hasOwnProperty("cloudStorageConfig")) {
                            var error = $root.google.pubsub.v1.CloudStorageConfig.verify(message.cloudStorageConfig);
                            if (error)
                                return "cloudStorageConfig." + error;
                        }
                        if (message.ackDeadlineSeconds != null && message.hasOwnProperty("ackDeadlineSeconds"))
                            if (!$util.isInteger(message.ackDeadlineSeconds))
                                return "ackDeadlineSeconds: integer expected";
                        if (message.retainAckedMessages != null && message.hasOwnProperty("retainAckedMessages"))
                            if (typeof message.retainAckedMessages !== "boolean")
                                return "retainAckedMessages: boolean expected";
                        if (message.messageRetentionDuration != null && message.hasOwnProperty("messageRetentionDuration")) {
                            var error = $root.google.protobuf.Duration.verify(message.messageRetentionDuration);
                            if (error)
                                return "messageRetentionDuration." + error;
                        }
                        if (message.labels != null && message.hasOwnProperty("labels")) {
                            if (!$util.isObject(message.labels))
                                return "labels: object expected";
                            var key = Object.keys(message.labels);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.labels[key[i]]))
                                    return "labels: string{k:string} expected";
                        }
                        if (message.enableMessageOrdering != null && message.hasOwnProperty("enableMessageOrdering"))
                            if (typeof message.enableMessageOrdering !== "boolean")
                                return "enableMessageOrdering: boolean expected";
                        if (message.expirationPolicy != null && message.hasOwnProperty("expirationPolicy")) {
                            var error = $root.google.pubsub.v1.ExpirationPolicy.verify(message.expirationPolicy);
                            if (error)
                                return "expirationPolicy." + error;
                        }
                        if (message.filter != null && message.hasOwnProperty("filter"))
                            if (!$util.isString(message.filter))
                                return "filter: string expected";
                        if (message.deadLetterPolicy != null && message.hasOwnProperty("deadLetterPolicy")) {
                            var error = $root.google.pubsub.v1.DeadLetterPolicy.verify(message.deadLetterPolicy);
                            if (error)
                                return "deadLetterPolicy." + error;
                        }
                        if (message.retryPolicy != null && message.hasOwnProperty("retryPolicy")) {
                            var error = $root.google.pubsub.v1.RetryPolicy.verify(message.retryPolicy);
                            if (error)
                                return "retryPolicy." + error;
                        }
                        if (message.detached != null && message.hasOwnProperty("detached"))
                            if (typeof message.detached !== "boolean")
                                return "detached: boolean expected";
                        if (message.enableExactlyOnceDelivery != null && message.hasOwnProperty("enableExactlyOnceDelivery"))
                            if (typeof message.enableExactlyOnceDelivery !== "boolean")
                                return "enableExactlyOnceDelivery: boolean expected";
                        if (message.topicMessageRetentionDuration != null && message.hasOwnProperty("topicMessageRetentionDuration")) {
                            var error = $root.google.protobuf.Duration.verify(message.topicMessageRetentionDuration);
                            if (error)
                                return "topicMessageRetentionDuration." + error;
                        }
                        if (message.state != null && message.hasOwnProperty("state"))
                            switch (message.state) {
                            default:
                                return "state: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        return null;
                    };
    
                    /**
                     * Creates a Subscription message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.Subscription} Subscription
                     */
                    Subscription.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.Subscription)
                            return object;
                        var message = new $root.google.pubsub.v1.Subscription();
                        if (object.name != null)
                            message.name = String(object.name);
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.pushConfig != null) {
                            if (typeof object.pushConfig !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.pushConfig: object expected");
                            message.pushConfig = $root.google.pubsub.v1.PushConfig.fromObject(object.pushConfig);
                        }
                        if (object.bigqueryConfig != null) {
                            if (typeof object.bigqueryConfig !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.bigqueryConfig: object expected");
                            message.bigqueryConfig = $root.google.pubsub.v1.BigQueryConfig.fromObject(object.bigqueryConfig);
                        }
                        if (object.cloudStorageConfig != null) {
                            if (typeof object.cloudStorageConfig !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.cloudStorageConfig: object expected");
                            message.cloudStorageConfig = $root.google.pubsub.v1.CloudStorageConfig.fromObject(object.cloudStorageConfig);
                        }
                        if (object.ackDeadlineSeconds != null)
                            message.ackDeadlineSeconds = object.ackDeadlineSeconds | 0;
                        if (object.retainAckedMessages != null)
                            message.retainAckedMessages = Boolean(object.retainAckedMessages);
                        if (object.messageRetentionDuration != null) {
                            if (typeof object.messageRetentionDuration !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.messageRetentionDuration: object expected");
                            message.messageRetentionDuration = $root.google.protobuf.Duration.fromObject(object.messageRetentionDuration);
                        }
                        if (object.labels) {
                            if (typeof object.labels !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.labels: object expected");
                            message.labels = {};
                            for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                message.labels[keys[i]] = String(object.labels[keys[i]]);
                        }
                        if (object.enableMessageOrdering != null)
                            message.enableMessageOrdering = Boolean(object.enableMessageOrdering);
                        if (object.expirationPolicy != null) {
                            if (typeof object.expirationPolicy !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.expirationPolicy: object expected");
                            message.expirationPolicy = $root.google.pubsub.v1.ExpirationPolicy.fromObject(object.expirationPolicy);
                        }
                        if (object.filter != null)
                            message.filter = String(object.filter);
                        if (object.deadLetterPolicy != null) {
                            if (typeof object.deadLetterPolicy !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.deadLetterPolicy: object expected");
                            message.deadLetterPolicy = $root.google.pubsub.v1.DeadLetterPolicy.fromObject(object.deadLetterPolicy);
                        }
                        if (object.retryPolicy != null) {
                            if (typeof object.retryPolicy !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.retryPolicy: object expected");
                            message.retryPolicy = $root.google.pubsub.v1.RetryPolicy.fromObject(object.retryPolicy);
                        }
                        if (object.detached != null)
                            message.detached = Boolean(object.detached);
                        if (object.enableExactlyOnceDelivery != null)
                            message.enableExactlyOnceDelivery = Boolean(object.enableExactlyOnceDelivery);
                        if (object.topicMessageRetentionDuration != null) {
                            if (typeof object.topicMessageRetentionDuration !== "object")
                                throw TypeError(".google.pubsub.v1.Subscription.topicMessageRetentionDuration: object expected");
                            message.topicMessageRetentionDuration = $root.google.protobuf.Duration.fromObject(object.topicMessageRetentionDuration);
                        }
                        switch (object.state) {
                        default:
                            if (typeof object.state === "number") {
                                message.state = object.state;
                                break;
                            }
                            break;
                        case "STATE_UNSPECIFIED":
                        case 0:
                            message.state = 0;
                            break;
                        case "ACTIVE":
                        case 1:
                            message.state = 1;
                            break;
                        case "RESOURCE_ERROR":
                        case 2:
                            message.state = 2;
                            break;
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Subscription message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {google.pubsub.v1.Subscription} message Subscription
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Subscription.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.labels = {};
                        if (options.defaults) {
                            object.name = "";
                            object.topic = "";
                            object.pushConfig = null;
                            object.ackDeadlineSeconds = 0;
                            object.retainAckedMessages = false;
                            object.messageRetentionDuration = null;
                            object.enableMessageOrdering = false;
                            object.expirationPolicy = null;
                            object.filter = "";
                            object.deadLetterPolicy = null;
                            object.retryPolicy = null;
                            object.detached = false;
                            object.enableExactlyOnceDelivery = false;
                            object.topicMessageRetentionDuration = null;
                            object.bigqueryConfig = null;
                            object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                            object.cloudStorageConfig = null;
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.pushConfig != null && message.hasOwnProperty("pushConfig"))
                            object.pushConfig = $root.google.pubsub.v1.PushConfig.toObject(message.pushConfig, options);
                        if (message.ackDeadlineSeconds != null && message.hasOwnProperty("ackDeadlineSeconds"))
                            object.ackDeadlineSeconds = message.ackDeadlineSeconds;
                        if (message.retainAckedMessages != null && message.hasOwnProperty("retainAckedMessages"))
                            object.retainAckedMessages = message.retainAckedMessages;
                        if (message.messageRetentionDuration != null && message.hasOwnProperty("messageRetentionDuration"))
                            object.messageRetentionDuration = $root.google.protobuf.Duration.toObject(message.messageRetentionDuration, options);
                        var keys2;
                        if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                            object.labels = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.labels[keys2[j]] = message.labels[keys2[j]];
                        }
                        if (message.enableMessageOrdering != null && message.hasOwnProperty("enableMessageOrdering"))
                            object.enableMessageOrdering = message.enableMessageOrdering;
                        if (message.expirationPolicy != null && message.hasOwnProperty("expirationPolicy"))
                            object.expirationPolicy = $root.google.pubsub.v1.ExpirationPolicy.toObject(message.expirationPolicy, options);
                        if (message.filter != null && message.hasOwnProperty("filter"))
                            object.filter = message.filter;
                        if (message.deadLetterPolicy != null && message.hasOwnProperty("deadLetterPolicy"))
                            object.deadLetterPolicy = $root.google.pubsub.v1.DeadLetterPolicy.toObject(message.deadLetterPolicy, options);
                        if (message.retryPolicy != null && message.hasOwnProperty("retryPolicy"))
                            object.retryPolicy = $root.google.pubsub.v1.RetryPolicy.toObject(message.retryPolicy, options);
                        if (message.detached != null && message.hasOwnProperty("detached"))
                            object.detached = message.detached;
                        if (message.enableExactlyOnceDelivery != null && message.hasOwnProperty("enableExactlyOnceDelivery"))
                            object.enableExactlyOnceDelivery = message.enableExactlyOnceDelivery;
                        if (message.topicMessageRetentionDuration != null && message.hasOwnProperty("topicMessageRetentionDuration"))
                            object.topicMessageRetentionDuration = $root.google.protobuf.Duration.toObject(message.topicMessageRetentionDuration, options);
                        if (message.bigqueryConfig != null && message.hasOwnProperty("bigqueryConfig"))
                            object.bigqueryConfig = $root.google.pubsub.v1.BigQueryConfig.toObject(message.bigqueryConfig, options);
                        if (message.state != null && message.hasOwnProperty("state"))
                            object.state = options.enums === String ? $root.google.pubsub.v1.Subscription.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.Subscription.State[message.state] : message.state;
                        if (message.cloudStorageConfig != null && message.hasOwnProperty("cloudStorageConfig"))
                            object.cloudStorageConfig = $root.google.pubsub.v1.CloudStorageConfig.toObject(message.cloudStorageConfig, options);
                        return object;
                    };
    
                    /**
                     * Converts this Subscription to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.Subscription
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Subscription.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for Subscription
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.Subscription
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    Subscription.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.Subscription";
                    };
    
                    /**
                     * State enum.
                     * @name google.pubsub.v1.Subscription.State
                     * @enum {number}
                     * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                     * @property {number} ACTIVE=1 ACTIVE value
                     * @property {number} RESOURCE_ERROR=2 RESOURCE_ERROR value
                     */
                    Subscription.State = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ACTIVE"] = 1;
                        values[valuesById[2] = "RESOURCE_ERROR"] = 2;
                        return values;
                    })();
    
                    return Subscription;
                })();
    
                v1.RetryPolicy = (function() {
    
                    /**
                     * Properties of a RetryPolicy.
                     * @memberof google.pubsub.v1
                     * @interface IRetryPolicy
                     * @property {google.protobuf.IDuration|null} [minimumBackoff] RetryPolicy minimumBackoff
                     * @property {google.protobuf.IDuration|null} [maximumBackoff] RetryPolicy maximumBackoff
                     */
    
                    /**
                     * Constructs a new RetryPolicy.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a RetryPolicy.
                     * @implements IRetryPolicy
                     * @constructor
                     * @param {google.pubsub.v1.IRetryPolicy=} [properties] Properties to set
                     */
                    function RetryPolicy(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * RetryPolicy minimumBackoff.
                     * @member {google.protobuf.IDuration|null|undefined} minimumBackoff
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @instance
                     */
                    RetryPolicy.prototype.minimumBackoff = null;
    
                    /**
                     * RetryPolicy maximumBackoff.
                     * @member {google.protobuf.IDuration|null|undefined} maximumBackoff
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @instance
                     */
                    RetryPolicy.prototype.maximumBackoff = null;
    
                    /**
                     * Creates a new RetryPolicy instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {google.pubsub.v1.IRetryPolicy=} [properties] Properties to set
                     * @returns {google.pubsub.v1.RetryPolicy} RetryPolicy instance
                     */
                    RetryPolicy.create = function create(properties) {
                        return new RetryPolicy(properties);
                    };
    
                    /**
                     * Encodes the specified RetryPolicy message. Does not implicitly {@link google.pubsub.v1.RetryPolicy.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {google.pubsub.v1.IRetryPolicy} message RetryPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RetryPolicy.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.minimumBackoff != null && Object.hasOwnProperty.call(message, "minimumBackoff"))
                            $root.google.protobuf.Duration.encode(message.minimumBackoff, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.maximumBackoff != null && Object.hasOwnProperty.call(message, "maximumBackoff"))
                            $root.google.protobuf.Duration.encode(message.maximumBackoff, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified RetryPolicy message, length delimited. Does not implicitly {@link google.pubsub.v1.RetryPolicy.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {google.pubsub.v1.IRetryPolicy} message RetryPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    RetryPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a RetryPolicy message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.RetryPolicy} RetryPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RetryPolicy.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.RetryPolicy();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.minimumBackoff = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 2: {
                                    message.maximumBackoff = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a RetryPolicy message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.RetryPolicy} RetryPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    RetryPolicy.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a RetryPolicy message.
                     * @function verify
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    RetryPolicy.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.minimumBackoff != null && message.hasOwnProperty("minimumBackoff")) {
                            var error = $root.google.protobuf.Duration.verify(message.minimumBackoff);
                            if (error)
                                return "minimumBackoff." + error;
                        }
                        if (message.maximumBackoff != null && message.hasOwnProperty("maximumBackoff")) {
                            var error = $root.google.protobuf.Duration.verify(message.maximumBackoff);
                            if (error)
                                return "maximumBackoff." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a RetryPolicy message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.RetryPolicy} RetryPolicy
                     */
                    RetryPolicy.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.RetryPolicy)
                            return object;
                        var message = new $root.google.pubsub.v1.RetryPolicy();
                        if (object.minimumBackoff != null) {
                            if (typeof object.minimumBackoff !== "object")
                                throw TypeError(".google.pubsub.v1.RetryPolicy.minimumBackoff: object expected");
                            message.minimumBackoff = $root.google.protobuf.Duration.fromObject(object.minimumBackoff);
                        }
                        if (object.maximumBackoff != null) {
                            if (typeof object.maximumBackoff !== "object")
                                throw TypeError(".google.pubsub.v1.RetryPolicy.maximumBackoff: object expected");
                            message.maximumBackoff = $root.google.protobuf.Duration.fromObject(object.maximumBackoff);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a RetryPolicy message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {google.pubsub.v1.RetryPolicy} message RetryPolicy
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    RetryPolicy.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.minimumBackoff = null;
                            object.maximumBackoff = null;
                        }
                        if (message.minimumBackoff != null && message.hasOwnProperty("minimumBackoff"))
                            object.minimumBackoff = $root.google.protobuf.Duration.toObject(message.minimumBackoff, options);
                        if (message.maximumBackoff != null && message.hasOwnProperty("maximumBackoff"))
                            object.maximumBackoff = $root.google.protobuf.Duration.toObject(message.maximumBackoff, options);
                        return object;
                    };
    
                    /**
                     * Converts this RetryPolicy to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    RetryPolicy.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for RetryPolicy
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.RetryPolicy
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    RetryPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.RetryPolicy";
                    };
    
                    return RetryPolicy;
                })();
    
                v1.DeadLetterPolicy = (function() {
    
                    /**
                     * Properties of a DeadLetterPolicy.
                     * @memberof google.pubsub.v1
                     * @interface IDeadLetterPolicy
                     * @property {string|null} [deadLetterTopic] DeadLetterPolicy deadLetterTopic
                     * @property {number|null} [maxDeliveryAttempts] DeadLetterPolicy maxDeliveryAttempts
                     */
    
                    /**
                     * Constructs a new DeadLetterPolicy.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DeadLetterPolicy.
                     * @implements IDeadLetterPolicy
                     * @constructor
                     * @param {google.pubsub.v1.IDeadLetterPolicy=} [properties] Properties to set
                     */
                    function DeadLetterPolicy(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DeadLetterPolicy deadLetterTopic.
                     * @member {string} deadLetterTopic
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @instance
                     */
                    DeadLetterPolicy.prototype.deadLetterTopic = "";
    
                    /**
                     * DeadLetterPolicy maxDeliveryAttempts.
                     * @member {number} maxDeliveryAttempts
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @instance
                     */
                    DeadLetterPolicy.prototype.maxDeliveryAttempts = 0;
    
                    /**
                     * Creates a new DeadLetterPolicy instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {google.pubsub.v1.IDeadLetterPolicy=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DeadLetterPolicy} DeadLetterPolicy instance
                     */
                    DeadLetterPolicy.create = function create(properties) {
                        return new DeadLetterPolicy(properties);
                    };
    
                    /**
                     * Encodes the specified DeadLetterPolicy message. Does not implicitly {@link google.pubsub.v1.DeadLetterPolicy.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {google.pubsub.v1.IDeadLetterPolicy} message DeadLetterPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeadLetterPolicy.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.deadLetterTopic != null && Object.hasOwnProperty.call(message, "deadLetterTopic"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.deadLetterTopic);
                        if (message.maxDeliveryAttempts != null && Object.hasOwnProperty.call(message, "maxDeliveryAttempts"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.maxDeliveryAttempts);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DeadLetterPolicy message, length delimited. Does not implicitly {@link google.pubsub.v1.DeadLetterPolicy.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {google.pubsub.v1.IDeadLetterPolicy} message DeadLetterPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeadLetterPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DeadLetterPolicy message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DeadLetterPolicy} DeadLetterPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeadLetterPolicy.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DeadLetterPolicy();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.deadLetterTopic = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.maxDeliveryAttempts = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DeadLetterPolicy message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DeadLetterPolicy} DeadLetterPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeadLetterPolicy.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DeadLetterPolicy message.
                     * @function verify
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DeadLetterPolicy.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.deadLetterTopic != null && message.hasOwnProperty("deadLetterTopic"))
                            if (!$util.isString(message.deadLetterTopic))
                                return "deadLetterTopic: string expected";
                        if (message.maxDeliveryAttempts != null && message.hasOwnProperty("maxDeliveryAttempts"))
                            if (!$util.isInteger(message.maxDeliveryAttempts))
                                return "maxDeliveryAttempts: integer expected";
                        return null;
                    };
    
                    /**
                     * Creates a DeadLetterPolicy message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DeadLetterPolicy} DeadLetterPolicy
                     */
                    DeadLetterPolicy.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DeadLetterPolicy)
                            return object;
                        var message = new $root.google.pubsub.v1.DeadLetterPolicy();
                        if (object.deadLetterTopic != null)
                            message.deadLetterTopic = String(object.deadLetterTopic);
                        if (object.maxDeliveryAttempts != null)
                            message.maxDeliveryAttempts = object.maxDeliveryAttempts | 0;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a DeadLetterPolicy message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {google.pubsub.v1.DeadLetterPolicy} message DeadLetterPolicy
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DeadLetterPolicy.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.deadLetterTopic = "";
                            object.maxDeliveryAttempts = 0;
                        }
                        if (message.deadLetterTopic != null && message.hasOwnProperty("deadLetterTopic"))
                            object.deadLetterTopic = message.deadLetterTopic;
                        if (message.maxDeliveryAttempts != null && message.hasOwnProperty("maxDeliveryAttempts"))
                            object.maxDeliveryAttempts = message.maxDeliveryAttempts;
                        return object;
                    };
    
                    /**
                     * Converts this DeadLetterPolicy to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DeadLetterPolicy.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DeadLetterPolicy
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DeadLetterPolicy
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DeadLetterPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DeadLetterPolicy";
                    };
    
                    return DeadLetterPolicy;
                })();
    
                v1.ExpirationPolicy = (function() {
    
                    /**
                     * Properties of an ExpirationPolicy.
                     * @memberof google.pubsub.v1
                     * @interface IExpirationPolicy
                     * @property {google.protobuf.IDuration|null} [ttl] ExpirationPolicy ttl
                     */
    
                    /**
                     * Constructs a new ExpirationPolicy.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an ExpirationPolicy.
                     * @implements IExpirationPolicy
                     * @constructor
                     * @param {google.pubsub.v1.IExpirationPolicy=} [properties] Properties to set
                     */
                    function ExpirationPolicy(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ExpirationPolicy ttl.
                     * @member {google.protobuf.IDuration|null|undefined} ttl
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @instance
                     */
                    ExpirationPolicy.prototype.ttl = null;
    
                    /**
                     * Creates a new ExpirationPolicy instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {google.pubsub.v1.IExpirationPolicy=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ExpirationPolicy} ExpirationPolicy instance
                     */
                    ExpirationPolicy.create = function create(properties) {
                        return new ExpirationPolicy(properties);
                    };
    
                    /**
                     * Encodes the specified ExpirationPolicy message. Does not implicitly {@link google.pubsub.v1.ExpirationPolicy.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {google.pubsub.v1.IExpirationPolicy} message ExpirationPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ExpirationPolicy.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.ttl != null && Object.hasOwnProperty.call(message, "ttl"))
                            $root.google.protobuf.Duration.encode(message.ttl, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ExpirationPolicy message, length delimited. Does not implicitly {@link google.pubsub.v1.ExpirationPolicy.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {google.pubsub.v1.IExpirationPolicy} message ExpirationPolicy message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ExpirationPolicy.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an ExpirationPolicy message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ExpirationPolicy} ExpirationPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ExpirationPolicy.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ExpirationPolicy();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.ttl = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an ExpirationPolicy message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ExpirationPolicy} ExpirationPolicy
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ExpirationPolicy.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an ExpirationPolicy message.
                     * @function verify
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ExpirationPolicy.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.ttl != null && message.hasOwnProperty("ttl")) {
                            var error = $root.google.protobuf.Duration.verify(message.ttl);
                            if (error)
                                return "ttl." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates an ExpirationPolicy message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ExpirationPolicy} ExpirationPolicy
                     */
                    ExpirationPolicy.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ExpirationPolicy)
                            return object;
                        var message = new $root.google.pubsub.v1.ExpirationPolicy();
                        if (object.ttl != null) {
                            if (typeof object.ttl !== "object")
                                throw TypeError(".google.pubsub.v1.ExpirationPolicy.ttl: object expected");
                            message.ttl = $root.google.protobuf.Duration.fromObject(object.ttl);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an ExpirationPolicy message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {google.pubsub.v1.ExpirationPolicy} message ExpirationPolicy
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ExpirationPolicy.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.ttl = null;
                        if (message.ttl != null && message.hasOwnProperty("ttl"))
                            object.ttl = $root.google.protobuf.Duration.toObject(message.ttl, options);
                        return object;
                    };
    
                    /**
                     * Converts this ExpirationPolicy to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ExpirationPolicy.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ExpirationPolicy
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ExpirationPolicy
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ExpirationPolicy.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ExpirationPolicy";
                    };
    
                    return ExpirationPolicy;
                })();
    
                v1.PushConfig = (function() {
    
                    /**
                     * Properties of a PushConfig.
                     * @memberof google.pubsub.v1
                     * @interface IPushConfig
                     * @property {string|null} [pushEndpoint] PushConfig pushEndpoint
                     * @property {Object.<string,string>|null} [attributes] PushConfig attributes
                     * @property {google.pubsub.v1.PushConfig.IOidcToken|null} [oidcToken] PushConfig oidcToken
                     * @property {google.pubsub.v1.PushConfig.IPubsubWrapper|null} [pubsubWrapper] PushConfig pubsubWrapper
                     * @property {google.pubsub.v1.PushConfig.INoWrapper|null} [noWrapper] PushConfig noWrapper
                     */
    
                    /**
                     * Constructs a new PushConfig.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PushConfig.
                     * @implements IPushConfig
                     * @constructor
                     * @param {google.pubsub.v1.IPushConfig=} [properties] Properties to set
                     */
                    function PushConfig(properties) {
                        this.attributes = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PushConfig pushEndpoint.
                     * @member {string} pushEndpoint
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.pushEndpoint = "";
    
                    /**
                     * PushConfig attributes.
                     * @member {Object.<string,string>} attributes
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.attributes = $util.emptyObject;
    
                    /**
                     * PushConfig oidcToken.
                     * @member {google.pubsub.v1.PushConfig.IOidcToken|null|undefined} oidcToken
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.oidcToken = null;
    
                    /**
                     * PushConfig pubsubWrapper.
                     * @member {google.pubsub.v1.PushConfig.IPubsubWrapper|null|undefined} pubsubWrapper
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.pubsubWrapper = null;
    
                    /**
                     * PushConfig noWrapper.
                     * @member {google.pubsub.v1.PushConfig.INoWrapper|null|undefined} noWrapper
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    PushConfig.prototype.noWrapper = null;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * PushConfig authenticationMethod.
                     * @member {"oidcToken"|undefined} authenticationMethod
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    Object.defineProperty(PushConfig.prototype, "authenticationMethod", {
                        get: $util.oneOfGetter($oneOfFields = ["oidcToken"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * PushConfig wrapper.
                     * @member {"pubsubWrapper"|"noWrapper"|undefined} wrapper
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     */
                    Object.defineProperty(PushConfig.prototype, "wrapper", {
                        get: $util.oneOfGetter($oneOfFields = ["pubsubWrapper", "noWrapper"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new PushConfig instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {google.pubsub.v1.IPushConfig=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PushConfig} PushConfig instance
                     */
                    PushConfig.create = function create(properties) {
                        return new PushConfig(properties);
                    };
    
                    /**
                     * Encodes the specified PushConfig message. Does not implicitly {@link google.pubsub.v1.PushConfig.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {google.pubsub.v1.IPushConfig} message PushConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PushConfig.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.pushEndpoint != null && Object.hasOwnProperty.call(message, "pushEndpoint"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.pushEndpoint);
                        if (message.attributes != null && Object.hasOwnProperty.call(message, "attributes"))
                            for (var keys = Object.keys(message.attributes), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 2, wireType 2 =*/18).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.attributes[keys[i]]).ldelim();
                        if (message.oidcToken != null && Object.hasOwnProperty.call(message, "oidcToken"))
                            $root.google.pubsub.v1.PushConfig.OidcToken.encode(message.oidcToken, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.pubsubWrapper != null && Object.hasOwnProperty.call(message, "pubsubWrapper"))
                            $root.google.pubsub.v1.PushConfig.PubsubWrapper.encode(message.pubsubWrapper, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.noWrapper != null && Object.hasOwnProperty.call(message, "noWrapper"))
                            $root.google.pubsub.v1.PushConfig.NoWrapper.encode(message.noWrapper, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PushConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.PushConfig.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {google.pubsub.v1.IPushConfig} message PushConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PushConfig.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PushConfig message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PushConfig} PushConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PushConfig.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PushConfig(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.pushEndpoint = reader.string();
                                    break;
                                }
                            case 2: {
                                    if (message.attributes === $util.emptyObject)
                                        message.attributes = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.attributes[key] = value;
                                    break;
                                }
                            case 3: {
                                    message.oidcToken = $root.google.pubsub.v1.PushConfig.OidcToken.decode(reader, reader.uint32());
                                    break;
                                }
                            case 4: {
                                    message.pubsubWrapper = $root.google.pubsub.v1.PushConfig.PubsubWrapper.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.noWrapper = $root.google.pubsub.v1.PushConfig.NoWrapper.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PushConfig message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PushConfig} PushConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PushConfig.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PushConfig message.
                     * @function verify
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PushConfig.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.pushEndpoint != null && message.hasOwnProperty("pushEndpoint"))
                            if (!$util.isString(message.pushEndpoint))
                                return "pushEndpoint: string expected";
                        if (message.attributes != null && message.hasOwnProperty("attributes")) {
                            if (!$util.isObject(message.attributes))
                                return "attributes: object expected";
                            var key = Object.keys(message.attributes);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.attributes[key[i]]))
                                    return "attributes: string{k:string} expected";
                        }
                        if (message.oidcToken != null && message.hasOwnProperty("oidcToken")) {
                            properties.authenticationMethod = 1;
                            {
                                var error = $root.google.pubsub.v1.PushConfig.OidcToken.verify(message.oidcToken);
                                if (error)
                                    return "oidcToken." + error;
                            }
                        }
                        if (message.pubsubWrapper != null && message.hasOwnProperty("pubsubWrapper")) {
                            properties.wrapper = 1;
                            {
                                var error = $root.google.pubsub.v1.PushConfig.PubsubWrapper.verify(message.pubsubWrapper);
                                if (error)
                                    return "pubsubWrapper." + error;
                            }
                        }
                        if (message.noWrapper != null && message.hasOwnProperty("noWrapper")) {
                            if (properties.wrapper === 1)
                                return "wrapper: multiple values";
                            properties.wrapper = 1;
                            {
                                var error = $root.google.pubsub.v1.PushConfig.NoWrapper.verify(message.noWrapper);
                                if (error)
                                    return "noWrapper." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a PushConfig message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PushConfig} PushConfig
                     */
                    PushConfig.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PushConfig)
                            return object;
                        var message = new $root.google.pubsub.v1.PushConfig();
                        if (object.pushEndpoint != null)
                            message.pushEndpoint = String(object.pushEndpoint);
                        if (object.attributes) {
                            if (typeof object.attributes !== "object")
                                throw TypeError(".google.pubsub.v1.PushConfig.attributes: object expected");
                            message.attributes = {};
                            for (var keys = Object.keys(object.attributes), i = 0; i < keys.length; ++i)
                                message.attributes[keys[i]] = String(object.attributes[keys[i]]);
                        }
                        if (object.oidcToken != null) {
                            if (typeof object.oidcToken !== "object")
                                throw TypeError(".google.pubsub.v1.PushConfig.oidcToken: object expected");
                            message.oidcToken = $root.google.pubsub.v1.PushConfig.OidcToken.fromObject(object.oidcToken);
                        }
                        if (object.pubsubWrapper != null) {
                            if (typeof object.pubsubWrapper !== "object")
                                throw TypeError(".google.pubsub.v1.PushConfig.pubsubWrapper: object expected");
                            message.pubsubWrapper = $root.google.pubsub.v1.PushConfig.PubsubWrapper.fromObject(object.pubsubWrapper);
                        }
                        if (object.noWrapper != null) {
                            if (typeof object.noWrapper !== "object")
                                throw TypeError(".google.pubsub.v1.PushConfig.noWrapper: object expected");
                            message.noWrapper = $root.google.pubsub.v1.PushConfig.NoWrapper.fromObject(object.noWrapper);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PushConfig message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {google.pubsub.v1.PushConfig} message PushConfig
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PushConfig.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.attributes = {};
                        if (options.defaults)
                            object.pushEndpoint = "";
                        if (message.pushEndpoint != null && message.hasOwnProperty("pushEndpoint"))
                            object.pushEndpoint = message.pushEndpoint;
                        var keys2;
                        if (message.attributes && (keys2 = Object.keys(message.attributes)).length) {
                            object.attributes = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.attributes[keys2[j]] = message.attributes[keys2[j]];
                        }
                        if (message.oidcToken != null && message.hasOwnProperty("oidcToken")) {
                            object.oidcToken = $root.google.pubsub.v1.PushConfig.OidcToken.toObject(message.oidcToken, options);
                            if (options.oneofs)
                                object.authenticationMethod = "oidcToken";
                        }
                        if (message.pubsubWrapper != null && message.hasOwnProperty("pubsubWrapper")) {
                            object.pubsubWrapper = $root.google.pubsub.v1.PushConfig.PubsubWrapper.toObject(message.pubsubWrapper, options);
                            if (options.oneofs)
                                object.wrapper = "pubsubWrapper";
                        }
                        if (message.noWrapper != null && message.hasOwnProperty("noWrapper")) {
                            object.noWrapper = $root.google.pubsub.v1.PushConfig.NoWrapper.toObject(message.noWrapper, options);
                            if (options.oneofs)
                                object.wrapper = "noWrapper";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this PushConfig to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PushConfig
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PushConfig.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PushConfig
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PushConfig
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PushConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PushConfig";
                    };
    
                    PushConfig.OidcToken = (function() {
    
                        /**
                         * Properties of an OidcToken.
                         * @memberof google.pubsub.v1.PushConfig
                         * @interface IOidcToken
                         * @property {string|null} [serviceAccountEmail] OidcToken serviceAccountEmail
                         * @property {string|null} [audience] OidcToken audience
                         */
    
                        /**
                         * Constructs a new OidcToken.
                         * @memberof google.pubsub.v1.PushConfig
                         * @classdesc Represents an OidcToken.
                         * @implements IOidcToken
                         * @constructor
                         * @param {google.pubsub.v1.PushConfig.IOidcToken=} [properties] Properties to set
                         */
                        function OidcToken(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * OidcToken serviceAccountEmail.
                         * @member {string} serviceAccountEmail
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @instance
                         */
                        OidcToken.prototype.serviceAccountEmail = "";
    
                        /**
                         * OidcToken audience.
                         * @member {string} audience
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @instance
                         */
                        OidcToken.prototype.audience = "";
    
                        /**
                         * Creates a new OidcToken instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IOidcToken=} [properties] Properties to set
                         * @returns {google.pubsub.v1.PushConfig.OidcToken} OidcToken instance
                         */
                        OidcToken.create = function create(properties) {
                            return new OidcToken(properties);
                        };
    
                        /**
                         * Encodes the specified OidcToken message. Does not implicitly {@link google.pubsub.v1.PushConfig.OidcToken.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IOidcToken} message OidcToken message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OidcToken.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.serviceAccountEmail != null && Object.hasOwnProperty.call(message, "serviceAccountEmail"))
                                writer.uint32(/* id 1, wireType 2 =*/10).string(message.serviceAccountEmail);
                            if (message.audience != null && Object.hasOwnProperty.call(message, "audience"))
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.audience);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified OidcToken message, length delimited. Does not implicitly {@link google.pubsub.v1.PushConfig.OidcToken.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IOidcToken} message OidcToken message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OidcToken.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an OidcToken message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.PushConfig.OidcToken} OidcToken
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OidcToken.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PushConfig.OidcToken();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.serviceAccountEmail = reader.string();
                                        break;
                                    }
                                case 2: {
                                        message.audience = reader.string();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an OidcToken message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.PushConfig.OidcToken} OidcToken
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OidcToken.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an OidcToken message.
                         * @function verify
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OidcToken.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.serviceAccountEmail != null && message.hasOwnProperty("serviceAccountEmail"))
                                if (!$util.isString(message.serviceAccountEmail))
                                    return "serviceAccountEmail: string expected";
                            if (message.audience != null && message.hasOwnProperty("audience"))
                                if (!$util.isString(message.audience))
                                    return "audience: string expected";
                            return null;
                        };
    
                        /**
                         * Creates an OidcToken message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.PushConfig.OidcToken} OidcToken
                         */
                        OidcToken.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.PushConfig.OidcToken)
                                return object;
                            var message = new $root.google.pubsub.v1.PushConfig.OidcToken();
                            if (object.serviceAccountEmail != null)
                                message.serviceAccountEmail = String(object.serviceAccountEmail);
                            if (object.audience != null)
                                message.audience = String(object.audience);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an OidcToken message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {google.pubsub.v1.PushConfig.OidcToken} message OidcToken
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OidcToken.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.serviceAccountEmail = "";
                                object.audience = "";
                            }
                            if (message.serviceAccountEmail != null && message.hasOwnProperty("serviceAccountEmail"))
                                object.serviceAccountEmail = message.serviceAccountEmail;
                            if (message.audience != null && message.hasOwnProperty("audience"))
                                object.audience = message.audience;
                            return object;
                        };
    
                        /**
                         * Converts this OidcToken to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OidcToken.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for OidcToken
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.PushConfig.OidcToken
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        OidcToken.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.PushConfig.OidcToken";
                        };
    
                        return OidcToken;
                    })();
    
                    PushConfig.PubsubWrapper = (function() {
    
                        /**
                         * Properties of a PubsubWrapper.
                         * @memberof google.pubsub.v1.PushConfig
                         * @interface IPubsubWrapper
                         */
    
                        /**
                         * Constructs a new PubsubWrapper.
                         * @memberof google.pubsub.v1.PushConfig
                         * @classdesc Represents a PubsubWrapper.
                         * @implements IPubsubWrapper
                         * @constructor
                         * @param {google.pubsub.v1.PushConfig.IPubsubWrapper=} [properties] Properties to set
                         */
                        function PubsubWrapper(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new PubsubWrapper instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IPubsubWrapper=} [properties] Properties to set
                         * @returns {google.pubsub.v1.PushConfig.PubsubWrapper} PubsubWrapper instance
                         */
                        PubsubWrapper.create = function create(properties) {
                            return new PubsubWrapper(properties);
                        };
    
                        /**
                         * Encodes the specified PubsubWrapper message. Does not implicitly {@link google.pubsub.v1.PushConfig.PubsubWrapper.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IPubsubWrapper} message PubsubWrapper message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PubsubWrapper.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified PubsubWrapper message, length delimited. Does not implicitly {@link google.pubsub.v1.PushConfig.PubsubWrapper.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.IPubsubWrapper} message PubsubWrapper message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        PubsubWrapper.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a PubsubWrapper message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.PushConfig.PubsubWrapper} PubsubWrapper
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PubsubWrapper.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PushConfig.PubsubWrapper();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a PubsubWrapper message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.PushConfig.PubsubWrapper} PubsubWrapper
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        PubsubWrapper.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a PubsubWrapper message.
                         * @function verify
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        PubsubWrapper.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a PubsubWrapper message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.PushConfig.PubsubWrapper} PubsubWrapper
                         */
                        PubsubWrapper.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.PushConfig.PubsubWrapper)
                                return object;
                            return new $root.google.pubsub.v1.PushConfig.PubsubWrapper();
                        };
    
                        /**
                         * Creates a plain object from a PubsubWrapper message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.PubsubWrapper} message PubsubWrapper
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        PubsubWrapper.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this PubsubWrapper to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        PubsubWrapper.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for PubsubWrapper
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.PushConfig.PubsubWrapper
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        PubsubWrapper.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.PushConfig.PubsubWrapper";
                        };
    
                        return PubsubWrapper;
                    })();
    
                    PushConfig.NoWrapper = (function() {
    
                        /**
                         * Properties of a NoWrapper.
                         * @memberof google.pubsub.v1.PushConfig
                         * @interface INoWrapper
                         * @property {boolean|null} [writeMetadata] NoWrapper writeMetadata
                         */
    
                        /**
                         * Constructs a new NoWrapper.
                         * @memberof google.pubsub.v1.PushConfig
                         * @classdesc Represents a NoWrapper.
                         * @implements INoWrapper
                         * @constructor
                         * @param {google.pubsub.v1.PushConfig.INoWrapper=} [properties] Properties to set
                         */
                        function NoWrapper(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * NoWrapper writeMetadata.
                         * @member {boolean} writeMetadata
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @instance
                         */
                        NoWrapper.prototype.writeMetadata = false;
    
                        /**
                         * Creates a new NoWrapper instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.INoWrapper=} [properties] Properties to set
                         * @returns {google.pubsub.v1.PushConfig.NoWrapper} NoWrapper instance
                         */
                        NoWrapper.create = function create(properties) {
                            return new NoWrapper(properties);
                        };
    
                        /**
                         * Encodes the specified NoWrapper message. Does not implicitly {@link google.pubsub.v1.PushConfig.NoWrapper.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.INoWrapper} message NoWrapper message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        NoWrapper.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.writeMetadata != null && Object.hasOwnProperty.call(message, "writeMetadata"))
                                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.writeMetadata);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified NoWrapper message, length delimited. Does not implicitly {@link google.pubsub.v1.PushConfig.NoWrapper.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.INoWrapper} message NoWrapper message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        NoWrapper.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a NoWrapper message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.PushConfig.NoWrapper} NoWrapper
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        NoWrapper.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PushConfig.NoWrapper();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.writeMetadata = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a NoWrapper message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.PushConfig.NoWrapper} NoWrapper
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        NoWrapper.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a NoWrapper message.
                         * @function verify
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        NoWrapper.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                                if (typeof message.writeMetadata !== "boolean")
                                    return "writeMetadata: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a NoWrapper message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.PushConfig.NoWrapper} NoWrapper
                         */
                        NoWrapper.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.PushConfig.NoWrapper)
                                return object;
                            var message = new $root.google.pubsub.v1.PushConfig.NoWrapper();
                            if (object.writeMetadata != null)
                                message.writeMetadata = Boolean(object.writeMetadata);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a NoWrapper message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {google.pubsub.v1.PushConfig.NoWrapper} message NoWrapper
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        NoWrapper.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.writeMetadata = false;
                            if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                                object.writeMetadata = message.writeMetadata;
                            return object;
                        };
    
                        /**
                         * Converts this NoWrapper to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        NoWrapper.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for NoWrapper
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.PushConfig.NoWrapper
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        NoWrapper.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.PushConfig.NoWrapper";
                        };
    
                        return NoWrapper;
                    })();
    
                    return PushConfig;
                })();
    
                v1.BigQueryConfig = (function() {
    
                    /**
                     * Properties of a BigQueryConfig.
                     * @memberof google.pubsub.v1
                     * @interface IBigQueryConfig
                     * @property {string|null} [table] BigQueryConfig table
                     * @property {boolean|null} [useTopicSchema] BigQueryConfig useTopicSchema
                     * @property {boolean|null} [writeMetadata] BigQueryConfig writeMetadata
                     * @property {boolean|null} [dropUnknownFields] BigQueryConfig dropUnknownFields
                     * @property {google.pubsub.v1.BigQueryConfig.State|null} [state] BigQueryConfig state
                     */
    
                    /**
                     * Constructs a new BigQueryConfig.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a BigQueryConfig.
                     * @implements IBigQueryConfig
                     * @constructor
                     * @param {google.pubsub.v1.IBigQueryConfig=} [properties] Properties to set
                     */
                    function BigQueryConfig(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * BigQueryConfig table.
                     * @member {string} table
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.table = "";
    
                    /**
                     * BigQueryConfig useTopicSchema.
                     * @member {boolean} useTopicSchema
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.useTopicSchema = false;
    
                    /**
                     * BigQueryConfig writeMetadata.
                     * @member {boolean} writeMetadata
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.writeMetadata = false;
    
                    /**
                     * BigQueryConfig dropUnknownFields.
                     * @member {boolean} dropUnknownFields
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.dropUnknownFields = false;
    
                    /**
                     * BigQueryConfig state.
                     * @member {google.pubsub.v1.BigQueryConfig.State} state
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     */
                    BigQueryConfig.prototype.state = 0;
    
                    /**
                     * Creates a new BigQueryConfig instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {google.pubsub.v1.IBigQueryConfig=} [properties] Properties to set
                     * @returns {google.pubsub.v1.BigQueryConfig} BigQueryConfig instance
                     */
                    BigQueryConfig.create = function create(properties) {
                        return new BigQueryConfig(properties);
                    };
    
                    /**
                     * Encodes the specified BigQueryConfig message. Does not implicitly {@link google.pubsub.v1.BigQueryConfig.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {google.pubsub.v1.IBigQueryConfig} message BigQueryConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    BigQueryConfig.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.table != null && Object.hasOwnProperty.call(message, "table"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.table);
                        if (message.useTopicSchema != null && Object.hasOwnProperty.call(message, "useTopicSchema"))
                            writer.uint32(/* id 2, wireType 0 =*/16).bool(message.useTopicSchema);
                        if (message.writeMetadata != null && Object.hasOwnProperty.call(message, "writeMetadata"))
                            writer.uint32(/* id 3, wireType 0 =*/24).bool(message.writeMetadata);
                        if (message.dropUnknownFields != null && Object.hasOwnProperty.call(message, "dropUnknownFields"))
                            writer.uint32(/* id 4, wireType 0 =*/32).bool(message.dropUnknownFields);
                        if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                            writer.uint32(/* id 5, wireType 0 =*/40).int32(message.state);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified BigQueryConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.BigQueryConfig.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {google.pubsub.v1.IBigQueryConfig} message BigQueryConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    BigQueryConfig.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a BigQueryConfig message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.BigQueryConfig} BigQueryConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    BigQueryConfig.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.BigQueryConfig();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.table = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.useTopicSchema = reader.bool();
                                    break;
                                }
                            case 3: {
                                    message.writeMetadata = reader.bool();
                                    break;
                                }
                            case 4: {
                                    message.dropUnknownFields = reader.bool();
                                    break;
                                }
                            case 5: {
                                    message.state = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a BigQueryConfig message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.BigQueryConfig} BigQueryConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    BigQueryConfig.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a BigQueryConfig message.
                     * @function verify
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    BigQueryConfig.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.table != null && message.hasOwnProperty("table"))
                            if (!$util.isString(message.table))
                                return "table: string expected";
                        if (message.useTopicSchema != null && message.hasOwnProperty("useTopicSchema"))
                            if (typeof message.useTopicSchema !== "boolean")
                                return "useTopicSchema: boolean expected";
                        if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                            if (typeof message.writeMetadata !== "boolean")
                                return "writeMetadata: boolean expected";
                        if (message.dropUnknownFields != null && message.hasOwnProperty("dropUnknownFields"))
                            if (typeof message.dropUnknownFields !== "boolean")
                                return "dropUnknownFields: boolean expected";
                        if (message.state != null && message.hasOwnProperty("state"))
                            switch (message.state) {
                            default:
                                return "state: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                            case 4:
                                break;
                            }
                        return null;
                    };
    
                    /**
                     * Creates a BigQueryConfig message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.BigQueryConfig} BigQueryConfig
                     */
                    BigQueryConfig.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.BigQueryConfig)
                            return object;
                        var message = new $root.google.pubsub.v1.BigQueryConfig();
                        if (object.table != null)
                            message.table = String(object.table);
                        if (object.useTopicSchema != null)
                            message.useTopicSchema = Boolean(object.useTopicSchema);
                        if (object.writeMetadata != null)
                            message.writeMetadata = Boolean(object.writeMetadata);
                        if (object.dropUnknownFields != null)
                            message.dropUnknownFields = Boolean(object.dropUnknownFields);
                        switch (object.state) {
                        default:
                            if (typeof object.state === "number") {
                                message.state = object.state;
                                break;
                            }
                            break;
                        case "STATE_UNSPECIFIED":
                        case 0:
                            message.state = 0;
                            break;
                        case "ACTIVE":
                        case 1:
                            message.state = 1;
                            break;
                        case "PERMISSION_DENIED":
                        case 2:
                            message.state = 2;
                            break;
                        case "NOT_FOUND":
                        case 3:
                            message.state = 3;
                            break;
                        case "SCHEMA_MISMATCH":
                        case 4:
                            message.state = 4;
                            break;
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a BigQueryConfig message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {google.pubsub.v1.BigQueryConfig} message BigQueryConfig
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    BigQueryConfig.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.table = "";
                            object.useTopicSchema = false;
                            object.writeMetadata = false;
                            object.dropUnknownFields = false;
                            object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                        }
                        if (message.table != null && message.hasOwnProperty("table"))
                            object.table = message.table;
                        if (message.useTopicSchema != null && message.hasOwnProperty("useTopicSchema"))
                            object.useTopicSchema = message.useTopicSchema;
                        if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                            object.writeMetadata = message.writeMetadata;
                        if (message.dropUnknownFields != null && message.hasOwnProperty("dropUnknownFields"))
                            object.dropUnknownFields = message.dropUnknownFields;
                        if (message.state != null && message.hasOwnProperty("state"))
                            object.state = options.enums === String ? $root.google.pubsub.v1.BigQueryConfig.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.BigQueryConfig.State[message.state] : message.state;
                        return object;
                    };
    
                    /**
                     * Converts this BigQueryConfig to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    BigQueryConfig.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for BigQueryConfig
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.BigQueryConfig
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    BigQueryConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.BigQueryConfig";
                    };
    
                    /**
                     * State enum.
                     * @name google.pubsub.v1.BigQueryConfig.State
                     * @enum {number}
                     * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                     * @property {number} ACTIVE=1 ACTIVE value
                     * @property {number} PERMISSION_DENIED=2 PERMISSION_DENIED value
                     * @property {number} NOT_FOUND=3 NOT_FOUND value
                     * @property {number} SCHEMA_MISMATCH=4 SCHEMA_MISMATCH value
                     */
                    BigQueryConfig.State = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ACTIVE"] = 1;
                        values[valuesById[2] = "PERMISSION_DENIED"] = 2;
                        values[valuesById[3] = "NOT_FOUND"] = 3;
                        values[valuesById[4] = "SCHEMA_MISMATCH"] = 4;
                        return values;
                    })();
    
                    return BigQueryConfig;
                })();
    
                v1.CloudStorageConfig = (function() {
    
                    /**
                     * Properties of a CloudStorageConfig.
                     * @memberof google.pubsub.v1
                     * @interface ICloudStorageConfig
                     * @property {string|null} [bucket] CloudStorageConfig bucket
                     * @property {string|null} [filenamePrefix] CloudStorageConfig filenamePrefix
                     * @property {string|null} [filenameSuffix] CloudStorageConfig filenameSuffix
                     * @property {google.pubsub.v1.CloudStorageConfig.ITextConfig|null} [textConfig] CloudStorageConfig textConfig
                     * @property {google.pubsub.v1.CloudStorageConfig.IAvroConfig|null} [avroConfig] CloudStorageConfig avroConfig
                     * @property {google.protobuf.IDuration|null} [maxDuration] CloudStorageConfig maxDuration
                     * @property {number|Long|null} [maxBytes] CloudStorageConfig maxBytes
                     * @property {google.pubsub.v1.CloudStorageConfig.State|null} [state] CloudStorageConfig state
                     */
    
                    /**
                     * Constructs a new CloudStorageConfig.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a CloudStorageConfig.
                     * @implements ICloudStorageConfig
                     * @constructor
                     * @param {google.pubsub.v1.ICloudStorageConfig=} [properties] Properties to set
                     */
                    function CloudStorageConfig(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * CloudStorageConfig bucket.
                     * @member {string} bucket
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.bucket = "";
    
                    /**
                     * CloudStorageConfig filenamePrefix.
                     * @member {string} filenamePrefix
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.filenamePrefix = "";
    
                    /**
                     * CloudStorageConfig filenameSuffix.
                     * @member {string} filenameSuffix
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.filenameSuffix = "";
    
                    /**
                     * CloudStorageConfig textConfig.
                     * @member {google.pubsub.v1.CloudStorageConfig.ITextConfig|null|undefined} textConfig
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.textConfig = null;
    
                    /**
                     * CloudStorageConfig avroConfig.
                     * @member {google.pubsub.v1.CloudStorageConfig.IAvroConfig|null|undefined} avroConfig
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.avroConfig = null;
    
                    /**
                     * CloudStorageConfig maxDuration.
                     * @member {google.protobuf.IDuration|null|undefined} maxDuration
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.maxDuration = null;
    
                    /**
                     * CloudStorageConfig maxBytes.
                     * @member {number|Long} maxBytes
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.maxBytes = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * CloudStorageConfig state.
                     * @member {google.pubsub.v1.CloudStorageConfig.State} state
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    CloudStorageConfig.prototype.state = 0;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * CloudStorageConfig outputFormat.
                     * @member {"textConfig"|"avroConfig"|undefined} outputFormat
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     */
                    Object.defineProperty(CloudStorageConfig.prototype, "outputFormat", {
                        get: $util.oneOfGetter($oneOfFields = ["textConfig", "avroConfig"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new CloudStorageConfig instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {google.pubsub.v1.ICloudStorageConfig=} [properties] Properties to set
                     * @returns {google.pubsub.v1.CloudStorageConfig} CloudStorageConfig instance
                     */
                    CloudStorageConfig.create = function create(properties) {
                        return new CloudStorageConfig(properties);
                    };
    
                    /**
                     * Encodes the specified CloudStorageConfig message. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {google.pubsub.v1.ICloudStorageConfig} message CloudStorageConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CloudStorageConfig.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.bucket != null && Object.hasOwnProperty.call(message, "bucket"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.bucket);
                        if (message.filenamePrefix != null && Object.hasOwnProperty.call(message, "filenamePrefix"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.filenamePrefix);
                        if (message.filenameSuffix != null && Object.hasOwnProperty.call(message, "filenameSuffix"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.filenameSuffix);
                        if (message.textConfig != null && Object.hasOwnProperty.call(message, "textConfig"))
                            $root.google.pubsub.v1.CloudStorageConfig.TextConfig.encode(message.textConfig, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.avroConfig != null && Object.hasOwnProperty.call(message, "avroConfig"))
                            $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.encode(message.avroConfig, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        if (message.maxDuration != null && Object.hasOwnProperty.call(message, "maxDuration"))
                            $root.google.protobuf.Duration.encode(message.maxDuration, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        if (message.maxBytes != null && Object.hasOwnProperty.call(message, "maxBytes"))
                            writer.uint32(/* id 7, wireType 0 =*/56).int64(message.maxBytes);
                        if (message.state != null && Object.hasOwnProperty.call(message, "state"))
                            writer.uint32(/* id 9, wireType 0 =*/72).int32(message.state);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified CloudStorageConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {google.pubsub.v1.ICloudStorageConfig} message CloudStorageConfig message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CloudStorageConfig.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a CloudStorageConfig message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.CloudStorageConfig} CloudStorageConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CloudStorageConfig.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.CloudStorageConfig();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.bucket = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.filenamePrefix = reader.string();
                                    break;
                                }
                            case 3: {
                                    message.filenameSuffix = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.textConfig = $root.google.pubsub.v1.CloudStorageConfig.TextConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 5: {
                                    message.avroConfig = $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            case 6: {
                                    message.maxDuration = $root.google.protobuf.Duration.decode(reader, reader.uint32());
                                    break;
                                }
                            case 7: {
                                    message.maxBytes = reader.int64();
                                    break;
                                }
                            case 9: {
                                    message.state = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a CloudStorageConfig message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.CloudStorageConfig} CloudStorageConfig
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CloudStorageConfig.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a CloudStorageConfig message.
                     * @function verify
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    CloudStorageConfig.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.bucket != null && message.hasOwnProperty("bucket"))
                            if (!$util.isString(message.bucket))
                                return "bucket: string expected";
                        if (message.filenamePrefix != null && message.hasOwnProperty("filenamePrefix"))
                            if (!$util.isString(message.filenamePrefix))
                                return "filenamePrefix: string expected";
                        if (message.filenameSuffix != null && message.hasOwnProperty("filenameSuffix"))
                            if (!$util.isString(message.filenameSuffix))
                                return "filenameSuffix: string expected";
                        if (message.textConfig != null && message.hasOwnProperty("textConfig")) {
                            properties.outputFormat = 1;
                            {
                                var error = $root.google.pubsub.v1.CloudStorageConfig.TextConfig.verify(message.textConfig);
                                if (error)
                                    return "textConfig." + error;
                            }
                        }
                        if (message.avroConfig != null && message.hasOwnProperty("avroConfig")) {
                            if (properties.outputFormat === 1)
                                return "outputFormat: multiple values";
                            properties.outputFormat = 1;
                            {
                                var error = $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.verify(message.avroConfig);
                                if (error)
                                    return "avroConfig." + error;
                            }
                        }
                        if (message.maxDuration != null && message.hasOwnProperty("maxDuration")) {
                            var error = $root.google.protobuf.Duration.verify(message.maxDuration);
                            if (error)
                                return "maxDuration." + error;
                        }
                        if (message.maxBytes != null && message.hasOwnProperty("maxBytes"))
                            if (!$util.isInteger(message.maxBytes) && !(message.maxBytes && $util.isInteger(message.maxBytes.low) && $util.isInteger(message.maxBytes.high)))
                                return "maxBytes: integer|Long expected";
                        if (message.state != null && message.hasOwnProperty("state"))
                            switch (message.state) {
                            default:
                                return "state: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                            case 3:
                                break;
                            }
                        return null;
                    };
    
                    /**
                     * Creates a CloudStorageConfig message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.CloudStorageConfig} CloudStorageConfig
                     */
                    CloudStorageConfig.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.CloudStorageConfig)
                            return object;
                        var message = new $root.google.pubsub.v1.CloudStorageConfig();
                        if (object.bucket != null)
                            message.bucket = String(object.bucket);
                        if (object.filenamePrefix != null)
                            message.filenamePrefix = String(object.filenamePrefix);
                        if (object.filenameSuffix != null)
                            message.filenameSuffix = String(object.filenameSuffix);
                        if (object.textConfig != null) {
                            if (typeof object.textConfig !== "object")
                                throw TypeError(".google.pubsub.v1.CloudStorageConfig.textConfig: object expected");
                            message.textConfig = $root.google.pubsub.v1.CloudStorageConfig.TextConfig.fromObject(object.textConfig);
                        }
                        if (object.avroConfig != null) {
                            if (typeof object.avroConfig !== "object")
                                throw TypeError(".google.pubsub.v1.CloudStorageConfig.avroConfig: object expected");
                            message.avroConfig = $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.fromObject(object.avroConfig);
                        }
                        if (object.maxDuration != null) {
                            if (typeof object.maxDuration !== "object")
                                throw TypeError(".google.pubsub.v1.CloudStorageConfig.maxDuration: object expected");
                            message.maxDuration = $root.google.protobuf.Duration.fromObject(object.maxDuration);
                        }
                        if (object.maxBytes != null)
                            if ($util.Long)
                                (message.maxBytes = $util.Long.fromValue(object.maxBytes)).unsigned = false;
                            else if (typeof object.maxBytes === "string")
                                message.maxBytes = parseInt(object.maxBytes, 10);
                            else if (typeof object.maxBytes === "number")
                                message.maxBytes = object.maxBytes;
                            else if (typeof object.maxBytes === "object")
                                message.maxBytes = new $util.LongBits(object.maxBytes.low >>> 0, object.maxBytes.high >>> 0).toNumber();
                        switch (object.state) {
                        default:
                            if (typeof object.state === "number") {
                                message.state = object.state;
                                break;
                            }
                            break;
                        case "STATE_UNSPECIFIED":
                        case 0:
                            message.state = 0;
                            break;
                        case "ACTIVE":
                        case 1:
                            message.state = 1;
                            break;
                        case "PERMISSION_DENIED":
                        case 2:
                            message.state = 2;
                            break;
                        case "NOT_FOUND":
                        case 3:
                            message.state = 3;
                            break;
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a CloudStorageConfig message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {google.pubsub.v1.CloudStorageConfig} message CloudStorageConfig
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    CloudStorageConfig.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.bucket = "";
                            object.filenamePrefix = "";
                            object.filenameSuffix = "";
                            object.maxDuration = null;
                            if ($util.Long) {
                                var long = new $util.Long(0, 0, false);
                                object.maxBytes = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                            } else
                                object.maxBytes = options.longs === String ? "0" : 0;
                            object.state = options.enums === String ? "STATE_UNSPECIFIED" : 0;
                        }
                        if (message.bucket != null && message.hasOwnProperty("bucket"))
                            object.bucket = message.bucket;
                        if (message.filenamePrefix != null && message.hasOwnProperty("filenamePrefix"))
                            object.filenamePrefix = message.filenamePrefix;
                        if (message.filenameSuffix != null && message.hasOwnProperty("filenameSuffix"))
                            object.filenameSuffix = message.filenameSuffix;
                        if (message.textConfig != null && message.hasOwnProperty("textConfig")) {
                            object.textConfig = $root.google.pubsub.v1.CloudStorageConfig.TextConfig.toObject(message.textConfig, options);
                            if (options.oneofs)
                                object.outputFormat = "textConfig";
                        }
                        if (message.avroConfig != null && message.hasOwnProperty("avroConfig")) {
                            object.avroConfig = $root.google.pubsub.v1.CloudStorageConfig.AvroConfig.toObject(message.avroConfig, options);
                            if (options.oneofs)
                                object.outputFormat = "avroConfig";
                        }
                        if (message.maxDuration != null && message.hasOwnProperty("maxDuration"))
                            object.maxDuration = $root.google.protobuf.Duration.toObject(message.maxDuration, options);
                        if (message.maxBytes != null && message.hasOwnProperty("maxBytes"))
                            if (typeof message.maxBytes === "number")
                                object.maxBytes = options.longs === String ? String(message.maxBytes) : message.maxBytes;
                            else
                                object.maxBytes = options.longs === String ? $util.Long.prototype.toString.call(message.maxBytes) : options.longs === Number ? new $util.LongBits(message.maxBytes.low >>> 0, message.maxBytes.high >>> 0).toNumber() : message.maxBytes;
                        if (message.state != null && message.hasOwnProperty("state"))
                            object.state = options.enums === String ? $root.google.pubsub.v1.CloudStorageConfig.State[message.state] === undefined ? message.state : $root.google.pubsub.v1.CloudStorageConfig.State[message.state] : message.state;
                        return object;
                    };
    
                    /**
                     * Converts this CloudStorageConfig to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    CloudStorageConfig.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for CloudStorageConfig
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.CloudStorageConfig
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    CloudStorageConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.CloudStorageConfig";
                    };
    
                    CloudStorageConfig.TextConfig = (function() {
    
                        /**
                         * Properties of a TextConfig.
                         * @memberof google.pubsub.v1.CloudStorageConfig
                         * @interface ITextConfig
                         */
    
                        /**
                         * Constructs a new TextConfig.
                         * @memberof google.pubsub.v1.CloudStorageConfig
                         * @classdesc Represents a TextConfig.
                         * @implements ITextConfig
                         * @constructor
                         * @param {google.pubsub.v1.CloudStorageConfig.ITextConfig=} [properties] Properties to set
                         */
                        function TextConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * Creates a new TextConfig instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.ITextConfig=} [properties] Properties to set
                         * @returns {google.pubsub.v1.CloudStorageConfig.TextConfig} TextConfig instance
                         */
                        TextConfig.create = function create(properties) {
                            return new TextConfig(properties);
                        };
    
                        /**
                         * Encodes the specified TextConfig message. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.TextConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.ITextConfig} message TextConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TextConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };
    
                        /**
                         * Encodes the specified TextConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.TextConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.ITextConfig} message TextConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        TextConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a TextConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.CloudStorageConfig.TextConfig} TextConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TextConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.CloudStorageConfig.TextConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a TextConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.CloudStorageConfig.TextConfig} TextConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        TextConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a TextConfig message.
                         * @function verify
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        TextConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };
    
                        /**
                         * Creates a TextConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.CloudStorageConfig.TextConfig} TextConfig
                         */
                        TextConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.CloudStorageConfig.TextConfig)
                                return object;
                            return new $root.google.pubsub.v1.CloudStorageConfig.TextConfig();
                        };
    
                        /**
                         * Creates a plain object from a TextConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.TextConfig} message TextConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        TextConfig.toObject = function toObject() {
                            return {};
                        };
    
                        /**
                         * Converts this TextConfig to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        TextConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for TextConfig
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.CloudStorageConfig.TextConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        TextConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.CloudStorageConfig.TextConfig";
                        };
    
                        return TextConfig;
                    })();
    
                    CloudStorageConfig.AvroConfig = (function() {
    
                        /**
                         * Properties of an AvroConfig.
                         * @memberof google.pubsub.v1.CloudStorageConfig
                         * @interface IAvroConfig
                         * @property {boolean|null} [writeMetadata] AvroConfig writeMetadata
                         */
    
                        /**
                         * Constructs a new AvroConfig.
                         * @memberof google.pubsub.v1.CloudStorageConfig
                         * @classdesc Represents an AvroConfig.
                         * @implements IAvroConfig
                         * @constructor
                         * @param {google.pubsub.v1.CloudStorageConfig.IAvroConfig=} [properties] Properties to set
                         */
                        function AvroConfig(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AvroConfig writeMetadata.
                         * @member {boolean} writeMetadata
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @instance
                         */
                        AvroConfig.prototype.writeMetadata = false;
    
                        /**
                         * Creates a new AvroConfig instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.IAvroConfig=} [properties] Properties to set
                         * @returns {google.pubsub.v1.CloudStorageConfig.AvroConfig} AvroConfig instance
                         */
                        AvroConfig.create = function create(properties) {
                            return new AvroConfig(properties);
                        };
    
                        /**
                         * Encodes the specified AvroConfig message. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.AvroConfig.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.IAvroConfig} message AvroConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AvroConfig.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.writeMetadata != null && Object.hasOwnProperty.call(message, "writeMetadata"))
                                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.writeMetadata);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AvroConfig message, length delimited. Does not implicitly {@link google.pubsub.v1.CloudStorageConfig.AvroConfig.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.IAvroConfig} message AvroConfig message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AvroConfig.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AvroConfig message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.CloudStorageConfig.AvroConfig} AvroConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AvroConfig.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.CloudStorageConfig.AvroConfig();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.writeMetadata = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AvroConfig message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.CloudStorageConfig.AvroConfig} AvroConfig
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AvroConfig.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AvroConfig message.
                         * @function verify
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AvroConfig.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                                if (typeof message.writeMetadata !== "boolean")
                                    return "writeMetadata: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates an AvroConfig message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.CloudStorageConfig.AvroConfig} AvroConfig
                         */
                        AvroConfig.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.CloudStorageConfig.AvroConfig)
                                return object;
                            var message = new $root.google.pubsub.v1.CloudStorageConfig.AvroConfig();
                            if (object.writeMetadata != null)
                                message.writeMetadata = Boolean(object.writeMetadata);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AvroConfig message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {google.pubsub.v1.CloudStorageConfig.AvroConfig} message AvroConfig
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AvroConfig.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.writeMetadata = false;
                            if (message.writeMetadata != null && message.hasOwnProperty("writeMetadata"))
                                object.writeMetadata = message.writeMetadata;
                            return object;
                        };
    
                        /**
                         * Converts this AvroConfig to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AvroConfig.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AvroConfig
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.CloudStorageConfig.AvroConfig
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AvroConfig.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.CloudStorageConfig.AvroConfig";
                        };
    
                        return AvroConfig;
                    })();
    
                    /**
                     * State enum.
                     * @name google.pubsub.v1.CloudStorageConfig.State
                     * @enum {number}
                     * @property {number} STATE_UNSPECIFIED=0 STATE_UNSPECIFIED value
                     * @property {number} ACTIVE=1 ACTIVE value
                     * @property {number} PERMISSION_DENIED=2 PERMISSION_DENIED value
                     * @property {number} NOT_FOUND=3 NOT_FOUND value
                     */
                    CloudStorageConfig.State = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "STATE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "ACTIVE"] = 1;
                        values[valuesById[2] = "PERMISSION_DENIED"] = 2;
                        values[valuesById[3] = "NOT_FOUND"] = 3;
                        return values;
                    })();
    
                    return CloudStorageConfig;
                })();
    
                v1.ReceivedMessage = (function() {
    
                    /**
                     * Properties of a ReceivedMessage.
                     * @memberof google.pubsub.v1
                     * @interface IReceivedMessage
                     * @property {string|null} [ackId] ReceivedMessage ackId
                     * @property {google.pubsub.v1.IPubsubMessage|null} [message] ReceivedMessage message
                     * @property {number|null} [deliveryAttempt] ReceivedMessage deliveryAttempt
                     */
    
                    /**
                     * Constructs a new ReceivedMessage.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ReceivedMessage.
                     * @implements IReceivedMessage
                     * @constructor
                     * @param {google.pubsub.v1.IReceivedMessage=} [properties] Properties to set
                     */
                    function ReceivedMessage(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ReceivedMessage ackId.
                     * @member {string} ackId
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @instance
                     */
                    ReceivedMessage.prototype.ackId = "";
    
                    /**
                     * ReceivedMessage message.
                     * @member {google.pubsub.v1.IPubsubMessage|null|undefined} message
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @instance
                     */
                    ReceivedMessage.prototype.message = null;
    
                    /**
                     * ReceivedMessage deliveryAttempt.
                     * @member {number} deliveryAttempt
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @instance
                     */
                    ReceivedMessage.prototype.deliveryAttempt = 0;
    
                    /**
                     * Creates a new ReceivedMessage instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {google.pubsub.v1.IReceivedMessage=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ReceivedMessage} ReceivedMessage instance
                     */
                    ReceivedMessage.create = function create(properties) {
                        return new ReceivedMessage(properties);
                    };
    
                    /**
                     * Encodes the specified ReceivedMessage message. Does not implicitly {@link google.pubsub.v1.ReceivedMessage.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {google.pubsub.v1.IReceivedMessage} message ReceivedMessage message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReceivedMessage.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.ackId != null && Object.hasOwnProperty.call(message, "ackId"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.ackId);
                        if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                            $root.google.pubsub.v1.PubsubMessage.encode(message.message, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.deliveryAttempt != null && Object.hasOwnProperty.call(message, "deliveryAttempt"))
                            writer.uint32(/* id 3, wireType 0 =*/24).int32(message.deliveryAttempt);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ReceivedMessage message, length delimited. Does not implicitly {@link google.pubsub.v1.ReceivedMessage.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {google.pubsub.v1.IReceivedMessage} message ReceivedMessage message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReceivedMessage.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ReceivedMessage message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ReceivedMessage} ReceivedMessage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReceivedMessage.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ReceivedMessage();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.ackId = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.message = $root.google.pubsub.v1.PubsubMessage.decode(reader, reader.uint32());
                                    break;
                                }
                            case 3: {
                                    message.deliveryAttempt = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ReceivedMessage message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ReceivedMessage} ReceivedMessage
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReceivedMessage.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ReceivedMessage message.
                     * @function verify
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ReceivedMessage.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.ackId != null && message.hasOwnProperty("ackId"))
                            if (!$util.isString(message.ackId))
                                return "ackId: string expected";
                        if (message.message != null && message.hasOwnProperty("message")) {
                            var error = $root.google.pubsub.v1.PubsubMessage.verify(message.message);
                            if (error)
                                return "message." + error;
                        }
                        if (message.deliveryAttempt != null && message.hasOwnProperty("deliveryAttempt"))
                            if (!$util.isInteger(message.deliveryAttempt))
                                return "deliveryAttempt: integer expected";
                        return null;
                    };
    
                    /**
                     * Creates a ReceivedMessage message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ReceivedMessage} ReceivedMessage
                     */
                    ReceivedMessage.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ReceivedMessage)
                            return object;
                        var message = new $root.google.pubsub.v1.ReceivedMessage();
                        if (object.ackId != null)
                            message.ackId = String(object.ackId);
                        if (object.message != null) {
                            if (typeof object.message !== "object")
                                throw TypeError(".google.pubsub.v1.ReceivedMessage.message: object expected");
                            message.message = $root.google.pubsub.v1.PubsubMessage.fromObject(object.message);
                        }
                        if (object.deliveryAttempt != null)
                            message.deliveryAttempt = object.deliveryAttempt | 0;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ReceivedMessage message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {google.pubsub.v1.ReceivedMessage} message ReceivedMessage
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ReceivedMessage.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.ackId = "";
                            object.message = null;
                            object.deliveryAttempt = 0;
                        }
                        if (message.ackId != null && message.hasOwnProperty("ackId"))
                            object.ackId = message.ackId;
                        if (message.message != null && message.hasOwnProperty("message"))
                            object.message = $root.google.pubsub.v1.PubsubMessage.toObject(message.message, options);
                        if (message.deliveryAttempt != null && message.hasOwnProperty("deliveryAttempt"))
                            object.deliveryAttempt = message.deliveryAttempt;
                        return object;
                    };
    
                    /**
                     * Converts this ReceivedMessage to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ReceivedMessage.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ReceivedMessage
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ReceivedMessage
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ReceivedMessage.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ReceivedMessage";
                    };
    
                    return ReceivedMessage;
                })();
    
                v1.GetSubscriptionRequest = (function() {
    
                    /**
                     * Properties of a GetSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @interface IGetSubscriptionRequest
                     * @property {string|null} [subscription] GetSubscriptionRequest subscription
                     */
    
                    /**
                     * Constructs a new GetSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a GetSubscriptionRequest.
                     * @implements IGetSubscriptionRequest
                     * @constructor
                     * @param {google.pubsub.v1.IGetSubscriptionRequest=} [properties] Properties to set
                     */
                    function GetSubscriptionRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * GetSubscriptionRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @instance
                     */
                    GetSubscriptionRequest.prototype.subscription = "";
    
                    /**
                     * Creates a new GetSubscriptionRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSubscriptionRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.GetSubscriptionRequest} GetSubscriptionRequest instance
                     */
                    GetSubscriptionRequest.create = function create(properties) {
                        return new GetSubscriptionRequest(properties);
                    };
    
                    /**
                     * Encodes the specified GetSubscriptionRequest message. Does not implicitly {@link google.pubsub.v1.GetSubscriptionRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSubscriptionRequest} message GetSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetSubscriptionRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified GetSubscriptionRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.GetSubscriptionRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSubscriptionRequest} message GetSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetSubscriptionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a GetSubscriptionRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.GetSubscriptionRequest} GetSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetSubscriptionRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.GetSubscriptionRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a GetSubscriptionRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.GetSubscriptionRequest} GetSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetSubscriptionRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a GetSubscriptionRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    GetSubscriptionRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a GetSubscriptionRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.GetSubscriptionRequest} GetSubscriptionRequest
                     */
                    GetSubscriptionRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.GetSubscriptionRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.GetSubscriptionRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a GetSubscriptionRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.GetSubscriptionRequest} message GetSubscriptionRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    GetSubscriptionRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.subscription = "";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        return object;
                    };
    
                    /**
                     * Converts this GetSubscriptionRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    GetSubscriptionRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for GetSubscriptionRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.GetSubscriptionRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    GetSubscriptionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.GetSubscriptionRequest";
                    };
    
                    return GetSubscriptionRequest;
                })();
    
                v1.UpdateSubscriptionRequest = (function() {
    
                    /**
                     * Properties of an UpdateSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @interface IUpdateSubscriptionRequest
                     * @property {google.pubsub.v1.ISubscription|null} [subscription] UpdateSubscriptionRequest subscription
                     * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateSubscriptionRequest updateMask
                     */
    
                    /**
                     * Constructs a new UpdateSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an UpdateSubscriptionRequest.
                     * @implements IUpdateSubscriptionRequest
                     * @constructor
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest=} [properties] Properties to set
                     */
                    function UpdateSubscriptionRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * UpdateSubscriptionRequest subscription.
                     * @member {google.pubsub.v1.ISubscription|null|undefined} subscription
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @instance
                     */
                    UpdateSubscriptionRequest.prototype.subscription = null;
    
                    /**
                     * UpdateSubscriptionRequest updateMask.
                     * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @instance
                     */
                    UpdateSubscriptionRequest.prototype.updateMask = null;
    
                    /**
                     * Creates a new UpdateSubscriptionRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.UpdateSubscriptionRequest} UpdateSubscriptionRequest instance
                     */
                    UpdateSubscriptionRequest.create = function create(properties) {
                        return new UpdateSubscriptionRequest(properties);
                    };
    
                    /**
                     * Encodes the specified UpdateSubscriptionRequest message. Does not implicitly {@link google.pubsub.v1.UpdateSubscriptionRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest} message UpdateSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateSubscriptionRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            $root.google.pubsub.v1.Subscription.encode(message.subscription, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                            $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified UpdateSubscriptionRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.UpdateSubscriptionRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSubscriptionRequest} message UpdateSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateSubscriptionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an UpdateSubscriptionRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.UpdateSubscriptionRequest} UpdateSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateSubscriptionRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.UpdateSubscriptionRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = $root.google.pubsub.v1.Subscription.decode(reader, reader.uint32());
                                    break;
                                }
                            case 2: {
                                    message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an UpdateSubscriptionRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.UpdateSubscriptionRequest} UpdateSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateSubscriptionRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an UpdateSubscriptionRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    UpdateSubscriptionRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription")) {
                            var error = $root.google.pubsub.v1.Subscription.verify(message.subscription);
                            if (error)
                                return "subscription." + error;
                        }
                        if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                            var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                            if (error)
                                return "updateMask." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates an UpdateSubscriptionRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.UpdateSubscriptionRequest} UpdateSubscriptionRequest
                     */
                    UpdateSubscriptionRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.UpdateSubscriptionRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.UpdateSubscriptionRequest();
                        if (object.subscription != null) {
                            if (typeof object.subscription !== "object")
                                throw TypeError(".google.pubsub.v1.UpdateSubscriptionRequest.subscription: object expected");
                            message.subscription = $root.google.pubsub.v1.Subscription.fromObject(object.subscription);
                        }
                        if (object.updateMask != null) {
                            if (typeof object.updateMask !== "object")
                                throw TypeError(".google.pubsub.v1.UpdateSubscriptionRequest.updateMask: object expected");
                            message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an UpdateSubscriptionRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.UpdateSubscriptionRequest} message UpdateSubscriptionRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    UpdateSubscriptionRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.subscription = null;
                            object.updateMask = null;
                        }
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = $root.google.pubsub.v1.Subscription.toObject(message.subscription, options);
                        if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                            object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                        return object;
                    };
    
                    /**
                     * Converts this UpdateSubscriptionRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    UpdateSubscriptionRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for UpdateSubscriptionRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.UpdateSubscriptionRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    UpdateSubscriptionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.UpdateSubscriptionRequest";
                    };
    
                    return UpdateSubscriptionRequest;
                })();
    
                v1.ListSubscriptionsRequest = (function() {
    
                    /**
                     * Properties of a ListSubscriptionsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListSubscriptionsRequest
                     * @property {string|null} [project] ListSubscriptionsRequest project
                     * @property {number|null} [pageSize] ListSubscriptionsRequest pageSize
                     * @property {string|null} [pageToken] ListSubscriptionsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListSubscriptionsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListSubscriptionsRequest.
                     * @implements IListSubscriptionsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListSubscriptionsRequest=} [properties] Properties to set
                     */
                    function ListSubscriptionsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListSubscriptionsRequest project.
                     * @member {string} project
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @instance
                     */
                    ListSubscriptionsRequest.prototype.project = "";
    
                    /**
                     * ListSubscriptionsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @instance
                     */
                    ListSubscriptionsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListSubscriptionsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @instance
                     */
                    ListSubscriptionsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListSubscriptionsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSubscriptionsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListSubscriptionsRequest} ListSubscriptionsRequest instance
                     */
                    ListSubscriptionsRequest.create = function create(properties) {
                        return new ListSubscriptionsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListSubscriptionsRequest message. Does not implicitly {@link google.pubsub.v1.ListSubscriptionsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSubscriptionsRequest} message ListSubscriptionsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSubscriptionsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.project);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListSubscriptionsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListSubscriptionsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSubscriptionsRequest} message ListSubscriptionsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSubscriptionsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListSubscriptionsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListSubscriptionsRequest} ListSubscriptionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSubscriptionsRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListSubscriptionsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.project = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListSubscriptionsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListSubscriptionsRequest} ListSubscriptionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSubscriptionsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListSubscriptionsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListSubscriptionsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.project != null && message.hasOwnProperty("project"))
                            if (!$util.isString(message.project))
                                return "project: string expected";
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListSubscriptionsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListSubscriptionsRequest} ListSubscriptionsRequest
                     */
                    ListSubscriptionsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListSubscriptionsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListSubscriptionsRequest();
                        if (object.project != null)
                            message.project = String(object.project);
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListSubscriptionsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {google.pubsub.v1.ListSubscriptionsRequest} message ListSubscriptionsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListSubscriptionsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.project = "";
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.project != null && message.hasOwnProperty("project"))
                            object.project = message.project;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListSubscriptionsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListSubscriptionsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListSubscriptionsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListSubscriptionsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListSubscriptionsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListSubscriptionsRequest";
                    };
    
                    return ListSubscriptionsRequest;
                })();
    
                v1.ListSubscriptionsResponse = (function() {
    
                    /**
                     * Properties of a ListSubscriptionsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListSubscriptionsResponse
                     * @property {Array.<google.pubsub.v1.ISubscription>|null} [subscriptions] ListSubscriptionsResponse subscriptions
                     * @property {string|null} [nextPageToken] ListSubscriptionsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListSubscriptionsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListSubscriptionsResponse.
                     * @implements IListSubscriptionsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListSubscriptionsResponse=} [properties] Properties to set
                     */
                    function ListSubscriptionsResponse(properties) {
                        this.subscriptions = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListSubscriptionsResponse subscriptions.
                     * @member {Array.<google.pubsub.v1.ISubscription>} subscriptions
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @instance
                     */
                    ListSubscriptionsResponse.prototype.subscriptions = $util.emptyArray;
    
                    /**
                     * ListSubscriptionsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @instance
                     */
                    ListSubscriptionsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListSubscriptionsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListSubscriptionsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListSubscriptionsResponse} ListSubscriptionsResponse instance
                     */
                    ListSubscriptionsResponse.create = function create(properties) {
                        return new ListSubscriptionsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListSubscriptionsResponse message. Does not implicitly {@link google.pubsub.v1.ListSubscriptionsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListSubscriptionsResponse} message ListSubscriptionsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSubscriptionsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscriptions != null && message.subscriptions.length)
                            for (var i = 0; i < message.subscriptions.length; ++i)
                                $root.google.pubsub.v1.Subscription.encode(message.subscriptions[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListSubscriptionsResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListSubscriptionsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListSubscriptionsResponse} message ListSubscriptionsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSubscriptionsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListSubscriptionsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListSubscriptionsResponse} ListSubscriptionsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSubscriptionsResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListSubscriptionsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.subscriptions && message.subscriptions.length))
                                        message.subscriptions = [];
                                    message.subscriptions.push($root.google.pubsub.v1.Subscription.decode(reader, reader.uint32()));
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListSubscriptionsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListSubscriptionsResponse} ListSubscriptionsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSubscriptionsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListSubscriptionsResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListSubscriptionsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscriptions != null && message.hasOwnProperty("subscriptions")) {
                            if (!Array.isArray(message.subscriptions))
                                return "subscriptions: array expected";
                            for (var i = 0; i < message.subscriptions.length; ++i) {
                                var error = $root.google.pubsub.v1.Subscription.verify(message.subscriptions[i]);
                                if (error)
                                    return "subscriptions." + error;
                            }
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListSubscriptionsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListSubscriptionsResponse} ListSubscriptionsResponse
                     */
                    ListSubscriptionsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListSubscriptionsResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListSubscriptionsResponse();
                        if (object.subscriptions) {
                            if (!Array.isArray(object.subscriptions))
                                throw TypeError(".google.pubsub.v1.ListSubscriptionsResponse.subscriptions: array expected");
                            message.subscriptions = [];
                            for (var i = 0; i < object.subscriptions.length; ++i) {
                                if (typeof object.subscriptions[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.ListSubscriptionsResponse.subscriptions: object expected");
                                message.subscriptions[i] = $root.google.pubsub.v1.Subscription.fromObject(object.subscriptions[i]);
                            }
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListSubscriptionsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {google.pubsub.v1.ListSubscriptionsResponse} message ListSubscriptionsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListSubscriptionsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.subscriptions = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.subscriptions && message.subscriptions.length) {
                            object.subscriptions = [];
                            for (var j = 0; j < message.subscriptions.length; ++j)
                                object.subscriptions[j] = $root.google.pubsub.v1.Subscription.toObject(message.subscriptions[j], options);
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListSubscriptionsResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListSubscriptionsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListSubscriptionsResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListSubscriptionsResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListSubscriptionsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListSubscriptionsResponse";
                    };
    
                    return ListSubscriptionsResponse;
                })();
    
                v1.DeleteSubscriptionRequest = (function() {
    
                    /**
                     * Properties of a DeleteSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @interface IDeleteSubscriptionRequest
                     * @property {string|null} [subscription] DeleteSubscriptionRequest subscription
                     */
    
                    /**
                     * Constructs a new DeleteSubscriptionRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DeleteSubscriptionRequest.
                     * @implements IDeleteSubscriptionRequest
                     * @constructor
                     * @param {google.pubsub.v1.IDeleteSubscriptionRequest=} [properties] Properties to set
                     */
                    function DeleteSubscriptionRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DeleteSubscriptionRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @instance
                     */
                    DeleteSubscriptionRequest.prototype.subscription = "";
    
                    /**
                     * Creates a new DeleteSubscriptionRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteSubscriptionRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DeleteSubscriptionRequest} DeleteSubscriptionRequest instance
                     */
                    DeleteSubscriptionRequest.create = function create(properties) {
                        return new DeleteSubscriptionRequest(properties);
                    };
    
                    /**
                     * Encodes the specified DeleteSubscriptionRequest message. Does not implicitly {@link google.pubsub.v1.DeleteSubscriptionRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteSubscriptionRequest} message DeleteSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeleteSubscriptionRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DeleteSubscriptionRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.DeleteSubscriptionRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteSubscriptionRequest} message DeleteSubscriptionRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeleteSubscriptionRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DeleteSubscriptionRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DeleteSubscriptionRequest} DeleteSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeleteSubscriptionRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DeleteSubscriptionRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DeleteSubscriptionRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DeleteSubscriptionRequest} DeleteSubscriptionRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeleteSubscriptionRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DeleteSubscriptionRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DeleteSubscriptionRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a DeleteSubscriptionRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DeleteSubscriptionRequest} DeleteSubscriptionRequest
                     */
                    DeleteSubscriptionRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DeleteSubscriptionRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.DeleteSubscriptionRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a DeleteSubscriptionRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {google.pubsub.v1.DeleteSubscriptionRequest} message DeleteSubscriptionRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DeleteSubscriptionRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.subscription = "";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        return object;
                    };
    
                    /**
                     * Converts this DeleteSubscriptionRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DeleteSubscriptionRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DeleteSubscriptionRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DeleteSubscriptionRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DeleteSubscriptionRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DeleteSubscriptionRequest";
                    };
    
                    return DeleteSubscriptionRequest;
                })();
    
                v1.ModifyPushConfigRequest = (function() {
    
                    /**
                     * Properties of a ModifyPushConfigRequest.
                     * @memberof google.pubsub.v1
                     * @interface IModifyPushConfigRequest
                     * @property {string|null} [subscription] ModifyPushConfigRequest subscription
                     * @property {google.pubsub.v1.IPushConfig|null} [pushConfig] ModifyPushConfigRequest pushConfig
                     */
    
                    /**
                     * Constructs a new ModifyPushConfigRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ModifyPushConfigRequest.
                     * @implements IModifyPushConfigRequest
                     * @constructor
                     * @param {google.pubsub.v1.IModifyPushConfigRequest=} [properties] Properties to set
                     */
                    function ModifyPushConfigRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ModifyPushConfigRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @instance
                     */
                    ModifyPushConfigRequest.prototype.subscription = "";
    
                    /**
                     * ModifyPushConfigRequest pushConfig.
                     * @member {google.pubsub.v1.IPushConfig|null|undefined} pushConfig
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @instance
                     */
                    ModifyPushConfigRequest.prototype.pushConfig = null;
    
                    /**
                     * Creates a new ModifyPushConfigRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {google.pubsub.v1.IModifyPushConfigRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ModifyPushConfigRequest} ModifyPushConfigRequest instance
                     */
                    ModifyPushConfigRequest.create = function create(properties) {
                        return new ModifyPushConfigRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ModifyPushConfigRequest message. Does not implicitly {@link google.pubsub.v1.ModifyPushConfigRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {google.pubsub.v1.IModifyPushConfigRequest} message ModifyPushConfigRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ModifyPushConfigRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        if (message.pushConfig != null && Object.hasOwnProperty.call(message, "pushConfig"))
                            $root.google.pubsub.v1.PushConfig.encode(message.pushConfig, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ModifyPushConfigRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ModifyPushConfigRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {google.pubsub.v1.IModifyPushConfigRequest} message ModifyPushConfigRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ModifyPushConfigRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ModifyPushConfigRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ModifyPushConfigRequest} ModifyPushConfigRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ModifyPushConfigRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ModifyPushConfigRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pushConfig = $root.google.pubsub.v1.PushConfig.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ModifyPushConfigRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ModifyPushConfigRequest} ModifyPushConfigRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ModifyPushConfigRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ModifyPushConfigRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ModifyPushConfigRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        if (message.pushConfig != null && message.hasOwnProperty("pushConfig")) {
                            var error = $root.google.pubsub.v1.PushConfig.verify(message.pushConfig);
                            if (error)
                                return "pushConfig." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a ModifyPushConfigRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ModifyPushConfigRequest} ModifyPushConfigRequest
                     */
                    ModifyPushConfigRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ModifyPushConfigRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ModifyPushConfigRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        if (object.pushConfig != null) {
                            if (typeof object.pushConfig !== "object")
                                throw TypeError(".google.pubsub.v1.ModifyPushConfigRequest.pushConfig: object expected");
                            message.pushConfig = $root.google.pubsub.v1.PushConfig.fromObject(object.pushConfig);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ModifyPushConfigRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {google.pubsub.v1.ModifyPushConfigRequest} message ModifyPushConfigRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ModifyPushConfigRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.subscription = "";
                            object.pushConfig = null;
                        }
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        if (message.pushConfig != null && message.hasOwnProperty("pushConfig"))
                            object.pushConfig = $root.google.pubsub.v1.PushConfig.toObject(message.pushConfig, options);
                        return object;
                    };
    
                    /**
                     * Converts this ModifyPushConfigRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ModifyPushConfigRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ModifyPushConfigRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ModifyPushConfigRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ModifyPushConfigRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ModifyPushConfigRequest";
                    };
    
                    return ModifyPushConfigRequest;
                })();
    
                v1.PullRequest = (function() {
    
                    /**
                     * Properties of a PullRequest.
                     * @memberof google.pubsub.v1
                     * @interface IPullRequest
                     * @property {string|null} [subscription] PullRequest subscription
                     * @property {boolean|null} [returnImmediately] PullRequest returnImmediately
                     * @property {number|null} [maxMessages] PullRequest maxMessages
                     */
    
                    /**
                     * Constructs a new PullRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PullRequest.
                     * @implements IPullRequest
                     * @constructor
                     * @param {google.pubsub.v1.IPullRequest=} [properties] Properties to set
                     */
                    function PullRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PullRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.PullRequest
                     * @instance
                     */
                    PullRequest.prototype.subscription = "";
    
                    /**
                     * PullRequest returnImmediately.
                     * @member {boolean} returnImmediately
                     * @memberof google.pubsub.v1.PullRequest
                     * @instance
                     */
                    PullRequest.prototype.returnImmediately = false;
    
                    /**
                     * PullRequest maxMessages.
                     * @member {number} maxMessages
                     * @memberof google.pubsub.v1.PullRequest
                     * @instance
                     */
                    PullRequest.prototype.maxMessages = 0;
    
                    /**
                     * Creates a new PullRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {google.pubsub.v1.IPullRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PullRequest} PullRequest instance
                     */
                    PullRequest.create = function create(properties) {
                        return new PullRequest(properties);
                    };
    
                    /**
                     * Encodes the specified PullRequest message. Does not implicitly {@link google.pubsub.v1.PullRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {google.pubsub.v1.IPullRequest} message PullRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PullRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        if (message.returnImmediately != null && Object.hasOwnProperty.call(message, "returnImmediately"))
                            writer.uint32(/* id 2, wireType 0 =*/16).bool(message.returnImmediately);
                        if (message.maxMessages != null && Object.hasOwnProperty.call(message, "maxMessages"))
                            writer.uint32(/* id 3, wireType 0 =*/24).int32(message.maxMessages);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PullRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.PullRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {google.pubsub.v1.IPullRequest} message PullRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PullRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PullRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PullRequest} PullRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PullRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PullRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.returnImmediately = reader.bool();
                                    break;
                                }
                            case 3: {
                                    message.maxMessages = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PullRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PullRequest} PullRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PullRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PullRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PullRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        if (message.returnImmediately != null && message.hasOwnProperty("returnImmediately"))
                            if (typeof message.returnImmediately !== "boolean")
                                return "returnImmediately: boolean expected";
                        if (message.maxMessages != null && message.hasOwnProperty("maxMessages"))
                            if (!$util.isInteger(message.maxMessages))
                                return "maxMessages: integer expected";
                        return null;
                    };
    
                    /**
                     * Creates a PullRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PullRequest} PullRequest
                     */
                    PullRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PullRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.PullRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        if (object.returnImmediately != null)
                            message.returnImmediately = Boolean(object.returnImmediately);
                        if (object.maxMessages != null)
                            message.maxMessages = object.maxMessages | 0;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PullRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {google.pubsub.v1.PullRequest} message PullRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PullRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.subscription = "";
                            object.returnImmediately = false;
                            object.maxMessages = 0;
                        }
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        if (message.returnImmediately != null && message.hasOwnProperty("returnImmediately"))
                            object.returnImmediately = message.returnImmediately;
                        if (message.maxMessages != null && message.hasOwnProperty("maxMessages"))
                            object.maxMessages = message.maxMessages;
                        return object;
                    };
    
                    /**
                     * Converts this PullRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PullRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PullRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PullRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PullRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PullRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PullRequest";
                    };
    
                    return PullRequest;
                })();
    
                v1.PullResponse = (function() {
    
                    /**
                     * Properties of a PullResponse.
                     * @memberof google.pubsub.v1
                     * @interface IPullResponse
                     * @property {Array.<google.pubsub.v1.IReceivedMessage>|null} [receivedMessages] PullResponse receivedMessages
                     */
    
                    /**
                     * Constructs a new PullResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a PullResponse.
                     * @implements IPullResponse
                     * @constructor
                     * @param {google.pubsub.v1.IPullResponse=} [properties] Properties to set
                     */
                    function PullResponse(properties) {
                        this.receivedMessages = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * PullResponse receivedMessages.
                     * @member {Array.<google.pubsub.v1.IReceivedMessage>} receivedMessages
                     * @memberof google.pubsub.v1.PullResponse
                     * @instance
                     */
                    PullResponse.prototype.receivedMessages = $util.emptyArray;
    
                    /**
                     * Creates a new PullResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {google.pubsub.v1.IPullResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.PullResponse} PullResponse instance
                     */
                    PullResponse.create = function create(properties) {
                        return new PullResponse(properties);
                    };
    
                    /**
                     * Encodes the specified PullResponse message. Does not implicitly {@link google.pubsub.v1.PullResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {google.pubsub.v1.IPullResponse} message PullResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PullResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.receivedMessages != null && message.receivedMessages.length)
                            for (var i = 0; i < message.receivedMessages.length; ++i)
                                $root.google.pubsub.v1.ReceivedMessage.encode(message.receivedMessages[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified PullResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.PullResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {google.pubsub.v1.IPullResponse} message PullResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    PullResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a PullResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.PullResponse} PullResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PullResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.PullResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.receivedMessages && message.receivedMessages.length))
                                        message.receivedMessages = [];
                                    message.receivedMessages.push($root.google.pubsub.v1.ReceivedMessage.decode(reader, reader.uint32()));
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a PullResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.PullResponse} PullResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    PullResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a PullResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    PullResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.receivedMessages != null && message.hasOwnProperty("receivedMessages")) {
                            if (!Array.isArray(message.receivedMessages))
                                return "receivedMessages: array expected";
                            for (var i = 0; i < message.receivedMessages.length; ++i) {
                                var error = $root.google.pubsub.v1.ReceivedMessage.verify(message.receivedMessages[i]);
                                if (error)
                                    return "receivedMessages." + error;
                            }
                        }
                        return null;
                    };
    
                    /**
                     * Creates a PullResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.PullResponse} PullResponse
                     */
                    PullResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.PullResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.PullResponse();
                        if (object.receivedMessages) {
                            if (!Array.isArray(object.receivedMessages))
                                throw TypeError(".google.pubsub.v1.PullResponse.receivedMessages: array expected");
                            message.receivedMessages = [];
                            for (var i = 0; i < object.receivedMessages.length; ++i) {
                                if (typeof object.receivedMessages[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.PullResponse.receivedMessages: object expected");
                                message.receivedMessages[i] = $root.google.pubsub.v1.ReceivedMessage.fromObject(object.receivedMessages[i]);
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a PullResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {google.pubsub.v1.PullResponse} message PullResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    PullResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.receivedMessages = [];
                        if (message.receivedMessages && message.receivedMessages.length) {
                            object.receivedMessages = [];
                            for (var j = 0; j < message.receivedMessages.length; ++j)
                                object.receivedMessages[j] = $root.google.pubsub.v1.ReceivedMessage.toObject(message.receivedMessages[j], options);
                        }
                        return object;
                    };
    
                    /**
                     * Converts this PullResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.PullResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    PullResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for PullResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.PullResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    PullResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.PullResponse";
                    };
    
                    return PullResponse;
                })();
    
                v1.ModifyAckDeadlineRequest = (function() {
    
                    /**
                     * Properties of a ModifyAckDeadlineRequest.
                     * @memberof google.pubsub.v1
                     * @interface IModifyAckDeadlineRequest
                     * @property {string|null} [subscription] ModifyAckDeadlineRequest subscription
                     * @property {Array.<string>|null} [ackIds] ModifyAckDeadlineRequest ackIds
                     * @property {number|null} [ackDeadlineSeconds] ModifyAckDeadlineRequest ackDeadlineSeconds
                     */
    
                    /**
                     * Constructs a new ModifyAckDeadlineRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ModifyAckDeadlineRequest.
                     * @implements IModifyAckDeadlineRequest
                     * @constructor
                     * @param {google.pubsub.v1.IModifyAckDeadlineRequest=} [properties] Properties to set
                     */
                    function ModifyAckDeadlineRequest(properties) {
                        this.ackIds = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ModifyAckDeadlineRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @instance
                     */
                    ModifyAckDeadlineRequest.prototype.subscription = "";
    
                    /**
                     * ModifyAckDeadlineRequest ackIds.
                     * @member {Array.<string>} ackIds
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @instance
                     */
                    ModifyAckDeadlineRequest.prototype.ackIds = $util.emptyArray;
    
                    /**
                     * ModifyAckDeadlineRequest ackDeadlineSeconds.
                     * @member {number} ackDeadlineSeconds
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @instance
                     */
                    ModifyAckDeadlineRequest.prototype.ackDeadlineSeconds = 0;
    
                    /**
                     * Creates a new ModifyAckDeadlineRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {google.pubsub.v1.IModifyAckDeadlineRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ModifyAckDeadlineRequest} ModifyAckDeadlineRequest instance
                     */
                    ModifyAckDeadlineRequest.create = function create(properties) {
                        return new ModifyAckDeadlineRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ModifyAckDeadlineRequest message. Does not implicitly {@link google.pubsub.v1.ModifyAckDeadlineRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {google.pubsub.v1.IModifyAckDeadlineRequest} message ModifyAckDeadlineRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ModifyAckDeadlineRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        if (message.ackDeadlineSeconds != null && Object.hasOwnProperty.call(message, "ackDeadlineSeconds"))
                            writer.uint32(/* id 3, wireType 0 =*/24).int32(message.ackDeadlineSeconds);
                        if (message.ackIds != null && message.ackIds.length)
                            for (var i = 0; i < message.ackIds.length; ++i)
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.ackIds[i]);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ModifyAckDeadlineRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ModifyAckDeadlineRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {google.pubsub.v1.IModifyAckDeadlineRequest} message ModifyAckDeadlineRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ModifyAckDeadlineRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ModifyAckDeadlineRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ModifyAckDeadlineRequest} ModifyAckDeadlineRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ModifyAckDeadlineRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ModifyAckDeadlineRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            case 4: {
                                    if (!(message.ackIds && message.ackIds.length))
                                        message.ackIds = [];
                                    message.ackIds.push(reader.string());
                                    break;
                                }
                            case 3: {
                                    message.ackDeadlineSeconds = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ModifyAckDeadlineRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ModifyAckDeadlineRequest} ModifyAckDeadlineRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ModifyAckDeadlineRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ModifyAckDeadlineRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ModifyAckDeadlineRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        if (message.ackIds != null && message.hasOwnProperty("ackIds")) {
                            if (!Array.isArray(message.ackIds))
                                return "ackIds: array expected";
                            for (var i = 0; i < message.ackIds.length; ++i)
                                if (!$util.isString(message.ackIds[i]))
                                    return "ackIds: string[] expected";
                        }
                        if (message.ackDeadlineSeconds != null && message.hasOwnProperty("ackDeadlineSeconds"))
                            if (!$util.isInteger(message.ackDeadlineSeconds))
                                return "ackDeadlineSeconds: integer expected";
                        return null;
                    };
    
                    /**
                     * Creates a ModifyAckDeadlineRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ModifyAckDeadlineRequest} ModifyAckDeadlineRequest
                     */
                    ModifyAckDeadlineRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ModifyAckDeadlineRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ModifyAckDeadlineRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        if (object.ackIds) {
                            if (!Array.isArray(object.ackIds))
                                throw TypeError(".google.pubsub.v1.ModifyAckDeadlineRequest.ackIds: array expected");
                            message.ackIds = [];
                            for (var i = 0; i < object.ackIds.length; ++i)
                                message.ackIds[i] = String(object.ackIds[i]);
                        }
                        if (object.ackDeadlineSeconds != null)
                            message.ackDeadlineSeconds = object.ackDeadlineSeconds | 0;
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ModifyAckDeadlineRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {google.pubsub.v1.ModifyAckDeadlineRequest} message ModifyAckDeadlineRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ModifyAckDeadlineRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.ackIds = [];
                        if (options.defaults) {
                            object.subscription = "";
                            object.ackDeadlineSeconds = 0;
                        }
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        if (message.ackDeadlineSeconds != null && message.hasOwnProperty("ackDeadlineSeconds"))
                            object.ackDeadlineSeconds = message.ackDeadlineSeconds;
                        if (message.ackIds && message.ackIds.length) {
                            object.ackIds = [];
                            for (var j = 0; j < message.ackIds.length; ++j)
                                object.ackIds[j] = message.ackIds[j];
                        }
                        return object;
                    };
    
                    /**
                     * Converts this ModifyAckDeadlineRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ModifyAckDeadlineRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ModifyAckDeadlineRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ModifyAckDeadlineRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ModifyAckDeadlineRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ModifyAckDeadlineRequest";
                    };
    
                    return ModifyAckDeadlineRequest;
                })();
    
                v1.AcknowledgeRequest = (function() {
    
                    /**
                     * Properties of an AcknowledgeRequest.
                     * @memberof google.pubsub.v1
                     * @interface IAcknowledgeRequest
                     * @property {string|null} [subscription] AcknowledgeRequest subscription
                     * @property {Array.<string>|null} [ackIds] AcknowledgeRequest ackIds
                     */
    
                    /**
                     * Constructs a new AcknowledgeRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an AcknowledgeRequest.
                     * @implements IAcknowledgeRequest
                     * @constructor
                     * @param {google.pubsub.v1.IAcknowledgeRequest=} [properties] Properties to set
                     */
                    function AcknowledgeRequest(properties) {
                        this.ackIds = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * AcknowledgeRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @instance
                     */
                    AcknowledgeRequest.prototype.subscription = "";
    
                    /**
                     * AcknowledgeRequest ackIds.
                     * @member {Array.<string>} ackIds
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @instance
                     */
                    AcknowledgeRequest.prototype.ackIds = $util.emptyArray;
    
                    /**
                     * Creates a new AcknowledgeRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {google.pubsub.v1.IAcknowledgeRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.AcknowledgeRequest} AcknowledgeRequest instance
                     */
                    AcknowledgeRequest.create = function create(properties) {
                        return new AcknowledgeRequest(properties);
                    };
    
                    /**
                     * Encodes the specified AcknowledgeRequest message. Does not implicitly {@link google.pubsub.v1.AcknowledgeRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {google.pubsub.v1.IAcknowledgeRequest} message AcknowledgeRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    AcknowledgeRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        if (message.ackIds != null && message.ackIds.length)
                            for (var i = 0; i < message.ackIds.length; ++i)
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.ackIds[i]);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified AcknowledgeRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.AcknowledgeRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {google.pubsub.v1.IAcknowledgeRequest} message AcknowledgeRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    AcknowledgeRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an AcknowledgeRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.AcknowledgeRequest} AcknowledgeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    AcknowledgeRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.AcknowledgeRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            case 2: {
                                    if (!(message.ackIds && message.ackIds.length))
                                        message.ackIds = [];
                                    message.ackIds.push(reader.string());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an AcknowledgeRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.AcknowledgeRequest} AcknowledgeRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    AcknowledgeRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an AcknowledgeRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    AcknowledgeRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        if (message.ackIds != null && message.hasOwnProperty("ackIds")) {
                            if (!Array.isArray(message.ackIds))
                                return "ackIds: array expected";
                            for (var i = 0; i < message.ackIds.length; ++i)
                                if (!$util.isString(message.ackIds[i]))
                                    return "ackIds: string[] expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates an AcknowledgeRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.AcknowledgeRequest} AcknowledgeRequest
                     */
                    AcknowledgeRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.AcknowledgeRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.AcknowledgeRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        if (object.ackIds) {
                            if (!Array.isArray(object.ackIds))
                                throw TypeError(".google.pubsub.v1.AcknowledgeRequest.ackIds: array expected");
                            message.ackIds = [];
                            for (var i = 0; i < object.ackIds.length; ++i)
                                message.ackIds[i] = String(object.ackIds[i]);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an AcknowledgeRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {google.pubsub.v1.AcknowledgeRequest} message AcknowledgeRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    AcknowledgeRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.ackIds = [];
                        if (options.defaults)
                            object.subscription = "";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        if (message.ackIds && message.ackIds.length) {
                            object.ackIds = [];
                            for (var j = 0; j < message.ackIds.length; ++j)
                                object.ackIds[j] = message.ackIds[j];
                        }
                        return object;
                    };
    
                    /**
                     * Converts this AcknowledgeRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    AcknowledgeRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for AcknowledgeRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.AcknowledgeRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    AcknowledgeRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.AcknowledgeRequest";
                    };
    
                    return AcknowledgeRequest;
                })();
    
                v1.StreamingPullRequest = (function() {
    
                    /**
                     * Properties of a StreamingPullRequest.
                     * @memberof google.pubsub.v1
                     * @interface IStreamingPullRequest
                     * @property {string|null} [subscription] StreamingPullRequest subscription
                     * @property {Array.<string>|null} [ackIds] StreamingPullRequest ackIds
                     * @property {Array.<number>|null} [modifyDeadlineSeconds] StreamingPullRequest modifyDeadlineSeconds
                     * @property {Array.<string>|null} [modifyDeadlineAckIds] StreamingPullRequest modifyDeadlineAckIds
                     * @property {number|null} [streamAckDeadlineSeconds] StreamingPullRequest streamAckDeadlineSeconds
                     * @property {string|null} [clientId] StreamingPullRequest clientId
                     * @property {number|Long|null} [maxOutstandingMessages] StreamingPullRequest maxOutstandingMessages
                     * @property {number|Long|null} [maxOutstandingBytes] StreamingPullRequest maxOutstandingBytes
                     */
    
                    /**
                     * Constructs a new StreamingPullRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a StreamingPullRequest.
                     * @implements IStreamingPullRequest
                     * @constructor
                     * @param {google.pubsub.v1.IStreamingPullRequest=} [properties] Properties to set
                     */
                    function StreamingPullRequest(properties) {
                        this.ackIds = [];
                        this.modifyDeadlineSeconds = [];
                        this.modifyDeadlineAckIds = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * StreamingPullRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     */
                    StreamingPullRequest.prototype.subscription = "";
    
                    /**
                     * StreamingPullRequest ackIds.
                     * @member {Array.<string>} ackIds
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     */
                    StreamingPullRequest.prototype.ackIds = $util.emptyArray;
    
                    /**
                     * StreamingPullRequest modifyDeadlineSeconds.
                     * @member {Array.<number>} modifyDeadlineSeconds
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     */
                    StreamingPullRequest.prototype.modifyDeadlineSeconds = $util.emptyArray;
    
                    /**
                     * StreamingPullRequest modifyDeadlineAckIds.
                     * @member {Array.<string>} modifyDeadlineAckIds
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     */
                    StreamingPullRequest.prototype.modifyDeadlineAckIds = $util.emptyArray;
    
                    /**
                     * StreamingPullRequest streamAckDeadlineSeconds.
                     * @member {number} streamAckDeadlineSeconds
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     */
                    StreamingPullRequest.prototype.streamAckDeadlineSeconds = 0;
    
                    /**
                     * StreamingPullRequest clientId.
                     * @member {string} clientId
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     */
                    StreamingPullRequest.prototype.clientId = "";
    
                    /**
                     * StreamingPullRequest maxOutstandingMessages.
                     * @member {number|Long} maxOutstandingMessages
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     */
                    StreamingPullRequest.prototype.maxOutstandingMessages = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * StreamingPullRequest maxOutstandingBytes.
                     * @member {number|Long} maxOutstandingBytes
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     */
                    StreamingPullRequest.prototype.maxOutstandingBytes = $util.Long ? $util.Long.fromBits(0,0,false) : 0;
    
                    /**
                     * Creates a new StreamingPullRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {google.pubsub.v1.IStreamingPullRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.StreamingPullRequest} StreamingPullRequest instance
                     */
                    StreamingPullRequest.create = function create(properties) {
                        return new StreamingPullRequest(properties);
                    };
    
                    /**
                     * Encodes the specified StreamingPullRequest message. Does not implicitly {@link google.pubsub.v1.StreamingPullRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {google.pubsub.v1.IStreamingPullRequest} message StreamingPullRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    StreamingPullRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        if (message.ackIds != null && message.ackIds.length)
                            for (var i = 0; i < message.ackIds.length; ++i)
                                writer.uint32(/* id 2, wireType 2 =*/18).string(message.ackIds[i]);
                        if (message.modifyDeadlineSeconds != null && message.modifyDeadlineSeconds.length) {
                            writer.uint32(/* id 3, wireType 2 =*/26).fork();
                            for (var i = 0; i < message.modifyDeadlineSeconds.length; ++i)
                                writer.int32(message.modifyDeadlineSeconds[i]);
                            writer.ldelim();
                        }
                        if (message.modifyDeadlineAckIds != null && message.modifyDeadlineAckIds.length)
                            for (var i = 0; i < message.modifyDeadlineAckIds.length; ++i)
                                writer.uint32(/* id 4, wireType 2 =*/34).string(message.modifyDeadlineAckIds[i]);
                        if (message.streamAckDeadlineSeconds != null && Object.hasOwnProperty.call(message, "streamAckDeadlineSeconds"))
                            writer.uint32(/* id 5, wireType 0 =*/40).int32(message.streamAckDeadlineSeconds);
                        if (message.clientId != null && Object.hasOwnProperty.call(message, "clientId"))
                            writer.uint32(/* id 6, wireType 2 =*/50).string(message.clientId);
                        if (message.maxOutstandingMessages != null && Object.hasOwnProperty.call(message, "maxOutstandingMessages"))
                            writer.uint32(/* id 7, wireType 0 =*/56).int64(message.maxOutstandingMessages);
                        if (message.maxOutstandingBytes != null && Object.hasOwnProperty.call(message, "maxOutstandingBytes"))
                            writer.uint32(/* id 8, wireType 0 =*/64).int64(message.maxOutstandingBytes);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified StreamingPullRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.StreamingPullRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {google.pubsub.v1.IStreamingPullRequest} message StreamingPullRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    StreamingPullRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a StreamingPullRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.StreamingPullRequest} StreamingPullRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    StreamingPullRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.StreamingPullRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            case 2: {
                                    if (!(message.ackIds && message.ackIds.length))
                                        message.ackIds = [];
                                    message.ackIds.push(reader.string());
                                    break;
                                }
                            case 3: {
                                    if (!(message.modifyDeadlineSeconds && message.modifyDeadlineSeconds.length))
                                        message.modifyDeadlineSeconds = [];
                                    if ((tag & 7) === 2) {
                                        var end2 = reader.uint32() + reader.pos;
                                        while (reader.pos < end2)
                                            message.modifyDeadlineSeconds.push(reader.int32());
                                    } else
                                        message.modifyDeadlineSeconds.push(reader.int32());
                                    break;
                                }
                            case 4: {
                                    if (!(message.modifyDeadlineAckIds && message.modifyDeadlineAckIds.length))
                                        message.modifyDeadlineAckIds = [];
                                    message.modifyDeadlineAckIds.push(reader.string());
                                    break;
                                }
                            case 5: {
                                    message.streamAckDeadlineSeconds = reader.int32();
                                    break;
                                }
                            case 6: {
                                    message.clientId = reader.string();
                                    break;
                                }
                            case 7: {
                                    message.maxOutstandingMessages = reader.int64();
                                    break;
                                }
                            case 8: {
                                    message.maxOutstandingBytes = reader.int64();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a StreamingPullRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.StreamingPullRequest} StreamingPullRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    StreamingPullRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a StreamingPullRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    StreamingPullRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        if (message.ackIds != null && message.hasOwnProperty("ackIds")) {
                            if (!Array.isArray(message.ackIds))
                                return "ackIds: array expected";
                            for (var i = 0; i < message.ackIds.length; ++i)
                                if (!$util.isString(message.ackIds[i]))
                                    return "ackIds: string[] expected";
                        }
                        if (message.modifyDeadlineSeconds != null && message.hasOwnProperty("modifyDeadlineSeconds")) {
                            if (!Array.isArray(message.modifyDeadlineSeconds))
                                return "modifyDeadlineSeconds: array expected";
                            for (var i = 0; i < message.modifyDeadlineSeconds.length; ++i)
                                if (!$util.isInteger(message.modifyDeadlineSeconds[i]))
                                    return "modifyDeadlineSeconds: integer[] expected";
                        }
                        if (message.modifyDeadlineAckIds != null && message.hasOwnProperty("modifyDeadlineAckIds")) {
                            if (!Array.isArray(message.modifyDeadlineAckIds))
                                return "modifyDeadlineAckIds: array expected";
                            for (var i = 0; i < message.modifyDeadlineAckIds.length; ++i)
                                if (!$util.isString(message.modifyDeadlineAckIds[i]))
                                    return "modifyDeadlineAckIds: string[] expected";
                        }
                        if (message.streamAckDeadlineSeconds != null && message.hasOwnProperty("streamAckDeadlineSeconds"))
                            if (!$util.isInteger(message.streamAckDeadlineSeconds))
                                return "streamAckDeadlineSeconds: integer expected";
                        if (message.clientId != null && message.hasOwnProperty("clientId"))
                            if (!$util.isString(message.clientId))
                                return "clientId: string expected";
                        if (message.maxOutstandingMessages != null && message.hasOwnProperty("maxOutstandingMessages"))
                            if (!$util.isInteger(message.maxOutstandingMessages) && !(message.maxOutstandingMessages && $util.isInteger(message.maxOutstandingMessages.low) && $util.isInteger(message.maxOutstandingMessages.high)))
                                return "maxOutstandingMessages: integer|Long expected";
                        if (message.maxOutstandingBytes != null && message.hasOwnProperty("maxOutstandingBytes"))
                            if (!$util.isInteger(message.maxOutstandingBytes) && !(message.maxOutstandingBytes && $util.isInteger(message.maxOutstandingBytes.low) && $util.isInteger(message.maxOutstandingBytes.high)))
                                return "maxOutstandingBytes: integer|Long expected";
                        return null;
                    };
    
                    /**
                     * Creates a StreamingPullRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.StreamingPullRequest} StreamingPullRequest
                     */
                    StreamingPullRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.StreamingPullRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.StreamingPullRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        if (object.ackIds) {
                            if (!Array.isArray(object.ackIds))
                                throw TypeError(".google.pubsub.v1.StreamingPullRequest.ackIds: array expected");
                            message.ackIds = [];
                            for (var i = 0; i < object.ackIds.length; ++i)
                                message.ackIds[i] = String(object.ackIds[i]);
                        }
                        if (object.modifyDeadlineSeconds) {
                            if (!Array.isArray(object.modifyDeadlineSeconds))
                                throw TypeError(".google.pubsub.v1.StreamingPullRequest.modifyDeadlineSeconds: array expected");
                            message.modifyDeadlineSeconds = [];
                            for (var i = 0; i < object.modifyDeadlineSeconds.length; ++i)
                                message.modifyDeadlineSeconds[i] = object.modifyDeadlineSeconds[i] | 0;
                        }
                        if (object.modifyDeadlineAckIds) {
                            if (!Array.isArray(object.modifyDeadlineAckIds))
                                throw TypeError(".google.pubsub.v1.StreamingPullRequest.modifyDeadlineAckIds: array expected");
                            message.modifyDeadlineAckIds = [];
                            for (var i = 0; i < object.modifyDeadlineAckIds.length; ++i)
                                message.modifyDeadlineAckIds[i] = String(object.modifyDeadlineAckIds[i]);
                        }
                        if (object.streamAckDeadlineSeconds != null)
                            message.streamAckDeadlineSeconds = object.streamAckDeadlineSeconds | 0;
                        if (object.clientId != null)
                            message.clientId = String(object.clientId);
                        if (object.maxOutstandingMessages != null)
                            if ($util.Long)
                                (message.maxOutstandingMessages = $util.Long.fromValue(object.maxOutstandingMessages)).unsigned = false;
                            else if (typeof object.maxOutstandingMessages === "string")
                                message.maxOutstandingMessages = parseInt(object.maxOutstandingMessages, 10);
                            else if (typeof object.maxOutstandingMessages === "number")
                                message.maxOutstandingMessages = object.maxOutstandingMessages;
                            else if (typeof object.maxOutstandingMessages === "object")
                                message.maxOutstandingMessages = new $util.LongBits(object.maxOutstandingMessages.low >>> 0, object.maxOutstandingMessages.high >>> 0).toNumber();
                        if (object.maxOutstandingBytes != null)
                            if ($util.Long)
                                (message.maxOutstandingBytes = $util.Long.fromValue(object.maxOutstandingBytes)).unsigned = false;
                            else if (typeof object.maxOutstandingBytes === "string")
                                message.maxOutstandingBytes = parseInt(object.maxOutstandingBytes, 10);
                            else if (typeof object.maxOutstandingBytes === "number")
                                message.maxOutstandingBytes = object.maxOutstandingBytes;
                            else if (typeof object.maxOutstandingBytes === "object")
                                message.maxOutstandingBytes = new $util.LongBits(object.maxOutstandingBytes.low >>> 0, object.maxOutstandingBytes.high >>> 0).toNumber();
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a StreamingPullRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {google.pubsub.v1.StreamingPullRequest} message StreamingPullRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    StreamingPullRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults) {
                            object.ackIds = [];
                            object.modifyDeadlineSeconds = [];
                            object.modifyDeadlineAckIds = [];
                        }
                        if (options.defaults) {
                            object.subscription = "";
                            object.streamAckDeadlineSeconds = 0;
                            object.clientId = "";
                            if ($util.Long) {
                                var long = new $util.Long(0, 0, false);
                                object.maxOutstandingMessages = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                            } else
                                object.maxOutstandingMessages = options.longs === String ? "0" : 0;
                            if ($util.Long) {
                                var long = new $util.Long(0, 0, false);
                                object.maxOutstandingBytes = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                            } else
                                object.maxOutstandingBytes = options.longs === String ? "0" : 0;
                        }
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        if (message.ackIds && message.ackIds.length) {
                            object.ackIds = [];
                            for (var j = 0; j < message.ackIds.length; ++j)
                                object.ackIds[j] = message.ackIds[j];
                        }
                        if (message.modifyDeadlineSeconds && message.modifyDeadlineSeconds.length) {
                            object.modifyDeadlineSeconds = [];
                            for (var j = 0; j < message.modifyDeadlineSeconds.length; ++j)
                                object.modifyDeadlineSeconds[j] = message.modifyDeadlineSeconds[j];
                        }
                        if (message.modifyDeadlineAckIds && message.modifyDeadlineAckIds.length) {
                            object.modifyDeadlineAckIds = [];
                            for (var j = 0; j < message.modifyDeadlineAckIds.length; ++j)
                                object.modifyDeadlineAckIds[j] = message.modifyDeadlineAckIds[j];
                        }
                        if (message.streamAckDeadlineSeconds != null && message.hasOwnProperty("streamAckDeadlineSeconds"))
                            object.streamAckDeadlineSeconds = message.streamAckDeadlineSeconds;
                        if (message.clientId != null && message.hasOwnProperty("clientId"))
                            object.clientId = message.clientId;
                        if (message.maxOutstandingMessages != null && message.hasOwnProperty("maxOutstandingMessages"))
                            if (typeof message.maxOutstandingMessages === "number")
                                object.maxOutstandingMessages = options.longs === String ? String(message.maxOutstandingMessages) : message.maxOutstandingMessages;
                            else
                                object.maxOutstandingMessages = options.longs === String ? $util.Long.prototype.toString.call(message.maxOutstandingMessages) : options.longs === Number ? new $util.LongBits(message.maxOutstandingMessages.low >>> 0, message.maxOutstandingMessages.high >>> 0).toNumber() : message.maxOutstandingMessages;
                        if (message.maxOutstandingBytes != null && message.hasOwnProperty("maxOutstandingBytes"))
                            if (typeof message.maxOutstandingBytes === "number")
                                object.maxOutstandingBytes = options.longs === String ? String(message.maxOutstandingBytes) : message.maxOutstandingBytes;
                            else
                                object.maxOutstandingBytes = options.longs === String ? $util.Long.prototype.toString.call(message.maxOutstandingBytes) : options.longs === Number ? new $util.LongBits(message.maxOutstandingBytes.low >>> 0, message.maxOutstandingBytes.high >>> 0).toNumber() : message.maxOutstandingBytes;
                        return object;
                    };
    
                    /**
                     * Converts this StreamingPullRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    StreamingPullRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for StreamingPullRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.StreamingPullRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    StreamingPullRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.StreamingPullRequest";
                    };
    
                    return StreamingPullRequest;
                })();
    
                v1.StreamingPullResponse = (function() {
    
                    /**
                     * Properties of a StreamingPullResponse.
                     * @memberof google.pubsub.v1
                     * @interface IStreamingPullResponse
                     * @property {Array.<google.pubsub.v1.IReceivedMessage>|null} [receivedMessages] StreamingPullResponse receivedMessages
                     * @property {google.pubsub.v1.StreamingPullResponse.IAcknowledgeConfirmation|null} [acknowledgeConfirmation] StreamingPullResponse acknowledgeConfirmation
                     * @property {google.pubsub.v1.StreamingPullResponse.IModifyAckDeadlineConfirmation|null} [modifyAckDeadlineConfirmation] StreamingPullResponse modifyAckDeadlineConfirmation
                     * @property {google.pubsub.v1.StreamingPullResponse.ISubscriptionProperties|null} [subscriptionProperties] StreamingPullResponse subscriptionProperties
                     */
    
                    /**
                     * Constructs a new StreamingPullResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a StreamingPullResponse.
                     * @implements IStreamingPullResponse
                     * @constructor
                     * @param {google.pubsub.v1.IStreamingPullResponse=} [properties] Properties to set
                     */
                    function StreamingPullResponse(properties) {
                        this.receivedMessages = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * StreamingPullResponse receivedMessages.
                     * @member {Array.<google.pubsub.v1.IReceivedMessage>} receivedMessages
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @instance
                     */
                    StreamingPullResponse.prototype.receivedMessages = $util.emptyArray;
    
                    /**
                     * StreamingPullResponse acknowledgeConfirmation.
                     * @member {google.pubsub.v1.StreamingPullResponse.IAcknowledgeConfirmation|null|undefined} acknowledgeConfirmation
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @instance
                     */
                    StreamingPullResponse.prototype.acknowledgeConfirmation = null;
    
                    /**
                     * StreamingPullResponse modifyAckDeadlineConfirmation.
                     * @member {google.pubsub.v1.StreamingPullResponse.IModifyAckDeadlineConfirmation|null|undefined} modifyAckDeadlineConfirmation
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @instance
                     */
                    StreamingPullResponse.prototype.modifyAckDeadlineConfirmation = null;
    
                    /**
                     * StreamingPullResponse subscriptionProperties.
                     * @member {google.pubsub.v1.StreamingPullResponse.ISubscriptionProperties|null|undefined} subscriptionProperties
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @instance
                     */
                    StreamingPullResponse.prototype.subscriptionProperties = null;
    
                    /**
                     * Creates a new StreamingPullResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {google.pubsub.v1.IStreamingPullResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.StreamingPullResponse} StreamingPullResponse instance
                     */
                    StreamingPullResponse.create = function create(properties) {
                        return new StreamingPullResponse(properties);
                    };
    
                    /**
                     * Encodes the specified StreamingPullResponse message. Does not implicitly {@link google.pubsub.v1.StreamingPullResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {google.pubsub.v1.IStreamingPullResponse} message StreamingPullResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    StreamingPullResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.receivedMessages != null && message.receivedMessages.length)
                            for (var i = 0; i < message.receivedMessages.length; ++i)
                                $root.google.pubsub.v1.ReceivedMessage.encode(message.receivedMessages[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.modifyAckDeadlineConfirmation != null && Object.hasOwnProperty.call(message, "modifyAckDeadlineConfirmation"))
                            $root.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.encode(message.modifyAckDeadlineConfirmation, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.subscriptionProperties != null && Object.hasOwnProperty.call(message, "subscriptionProperties"))
                            $root.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.encode(message.subscriptionProperties, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                        if (message.acknowledgeConfirmation != null && Object.hasOwnProperty.call(message, "acknowledgeConfirmation"))
                            $root.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.encode(message.acknowledgeConfirmation, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified StreamingPullResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.StreamingPullResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {google.pubsub.v1.IStreamingPullResponse} message StreamingPullResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    StreamingPullResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a StreamingPullResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.StreamingPullResponse} StreamingPullResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    StreamingPullResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.StreamingPullResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.receivedMessages && message.receivedMessages.length))
                                        message.receivedMessages = [];
                                    message.receivedMessages.push($root.google.pubsub.v1.ReceivedMessage.decode(reader, reader.uint32()));
                                    break;
                                }
                            case 5: {
                                    message.acknowledgeConfirmation = $root.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.decode(reader, reader.uint32());
                                    break;
                                }
                            case 3: {
                                    message.modifyAckDeadlineConfirmation = $root.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.decode(reader, reader.uint32());
                                    break;
                                }
                            case 4: {
                                    message.subscriptionProperties = $root.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a StreamingPullResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.StreamingPullResponse} StreamingPullResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    StreamingPullResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a StreamingPullResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    StreamingPullResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.receivedMessages != null && message.hasOwnProperty("receivedMessages")) {
                            if (!Array.isArray(message.receivedMessages))
                                return "receivedMessages: array expected";
                            for (var i = 0; i < message.receivedMessages.length; ++i) {
                                var error = $root.google.pubsub.v1.ReceivedMessage.verify(message.receivedMessages[i]);
                                if (error)
                                    return "receivedMessages." + error;
                            }
                        }
                        if (message.acknowledgeConfirmation != null && message.hasOwnProperty("acknowledgeConfirmation")) {
                            var error = $root.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.verify(message.acknowledgeConfirmation);
                            if (error)
                                return "acknowledgeConfirmation." + error;
                        }
                        if (message.modifyAckDeadlineConfirmation != null && message.hasOwnProperty("modifyAckDeadlineConfirmation")) {
                            var error = $root.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.verify(message.modifyAckDeadlineConfirmation);
                            if (error)
                                return "modifyAckDeadlineConfirmation." + error;
                        }
                        if (message.subscriptionProperties != null && message.hasOwnProperty("subscriptionProperties")) {
                            var error = $root.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.verify(message.subscriptionProperties);
                            if (error)
                                return "subscriptionProperties." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a StreamingPullResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.StreamingPullResponse} StreamingPullResponse
                     */
                    StreamingPullResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.StreamingPullResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.StreamingPullResponse();
                        if (object.receivedMessages) {
                            if (!Array.isArray(object.receivedMessages))
                                throw TypeError(".google.pubsub.v1.StreamingPullResponse.receivedMessages: array expected");
                            message.receivedMessages = [];
                            for (var i = 0; i < object.receivedMessages.length; ++i) {
                                if (typeof object.receivedMessages[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.StreamingPullResponse.receivedMessages: object expected");
                                message.receivedMessages[i] = $root.google.pubsub.v1.ReceivedMessage.fromObject(object.receivedMessages[i]);
                            }
                        }
                        if (object.acknowledgeConfirmation != null) {
                            if (typeof object.acknowledgeConfirmation !== "object")
                                throw TypeError(".google.pubsub.v1.StreamingPullResponse.acknowledgeConfirmation: object expected");
                            message.acknowledgeConfirmation = $root.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.fromObject(object.acknowledgeConfirmation);
                        }
                        if (object.modifyAckDeadlineConfirmation != null) {
                            if (typeof object.modifyAckDeadlineConfirmation !== "object")
                                throw TypeError(".google.pubsub.v1.StreamingPullResponse.modifyAckDeadlineConfirmation: object expected");
                            message.modifyAckDeadlineConfirmation = $root.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.fromObject(object.modifyAckDeadlineConfirmation);
                        }
                        if (object.subscriptionProperties != null) {
                            if (typeof object.subscriptionProperties !== "object")
                                throw TypeError(".google.pubsub.v1.StreamingPullResponse.subscriptionProperties: object expected");
                            message.subscriptionProperties = $root.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.fromObject(object.subscriptionProperties);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a StreamingPullResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {google.pubsub.v1.StreamingPullResponse} message StreamingPullResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    StreamingPullResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.receivedMessages = [];
                        if (options.defaults) {
                            object.modifyAckDeadlineConfirmation = null;
                            object.subscriptionProperties = null;
                            object.acknowledgeConfirmation = null;
                        }
                        if (message.receivedMessages && message.receivedMessages.length) {
                            object.receivedMessages = [];
                            for (var j = 0; j < message.receivedMessages.length; ++j)
                                object.receivedMessages[j] = $root.google.pubsub.v1.ReceivedMessage.toObject(message.receivedMessages[j], options);
                        }
                        if (message.modifyAckDeadlineConfirmation != null && message.hasOwnProperty("modifyAckDeadlineConfirmation"))
                            object.modifyAckDeadlineConfirmation = $root.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.toObject(message.modifyAckDeadlineConfirmation, options);
                        if (message.subscriptionProperties != null && message.hasOwnProperty("subscriptionProperties"))
                            object.subscriptionProperties = $root.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.toObject(message.subscriptionProperties, options);
                        if (message.acknowledgeConfirmation != null && message.hasOwnProperty("acknowledgeConfirmation"))
                            object.acknowledgeConfirmation = $root.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.toObject(message.acknowledgeConfirmation, options);
                        return object;
                    };
    
                    /**
                     * Converts this StreamingPullResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    StreamingPullResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for StreamingPullResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.StreamingPullResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    StreamingPullResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.StreamingPullResponse";
                    };
    
                    StreamingPullResponse.AcknowledgeConfirmation = (function() {
    
                        /**
                         * Properties of an AcknowledgeConfirmation.
                         * @memberof google.pubsub.v1.StreamingPullResponse
                         * @interface IAcknowledgeConfirmation
                         * @property {Array.<string>|null} [ackIds] AcknowledgeConfirmation ackIds
                         * @property {Array.<string>|null} [invalidAckIds] AcknowledgeConfirmation invalidAckIds
                         * @property {Array.<string>|null} [unorderedAckIds] AcknowledgeConfirmation unorderedAckIds
                         * @property {Array.<string>|null} [temporaryFailedAckIds] AcknowledgeConfirmation temporaryFailedAckIds
                         */
    
                        /**
                         * Constructs a new AcknowledgeConfirmation.
                         * @memberof google.pubsub.v1.StreamingPullResponse
                         * @classdesc Represents an AcknowledgeConfirmation.
                         * @implements IAcknowledgeConfirmation
                         * @constructor
                         * @param {google.pubsub.v1.StreamingPullResponse.IAcknowledgeConfirmation=} [properties] Properties to set
                         */
                        function AcknowledgeConfirmation(properties) {
                            this.ackIds = [];
                            this.invalidAckIds = [];
                            this.unorderedAckIds = [];
                            this.temporaryFailedAckIds = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * AcknowledgeConfirmation ackIds.
                         * @member {Array.<string>} ackIds
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @instance
                         */
                        AcknowledgeConfirmation.prototype.ackIds = $util.emptyArray;
    
                        /**
                         * AcknowledgeConfirmation invalidAckIds.
                         * @member {Array.<string>} invalidAckIds
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @instance
                         */
                        AcknowledgeConfirmation.prototype.invalidAckIds = $util.emptyArray;
    
                        /**
                         * AcknowledgeConfirmation unorderedAckIds.
                         * @member {Array.<string>} unorderedAckIds
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @instance
                         */
                        AcknowledgeConfirmation.prototype.unorderedAckIds = $util.emptyArray;
    
                        /**
                         * AcknowledgeConfirmation temporaryFailedAckIds.
                         * @member {Array.<string>} temporaryFailedAckIds
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @instance
                         */
                        AcknowledgeConfirmation.prototype.temporaryFailedAckIds = $util.emptyArray;
    
                        /**
                         * Creates a new AcknowledgeConfirmation instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.IAcknowledgeConfirmation=} [properties] Properties to set
                         * @returns {google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation} AcknowledgeConfirmation instance
                         */
                        AcknowledgeConfirmation.create = function create(properties) {
                            return new AcknowledgeConfirmation(properties);
                        };
    
                        /**
                         * Encodes the specified AcknowledgeConfirmation message. Does not implicitly {@link google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.IAcknowledgeConfirmation} message AcknowledgeConfirmation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AcknowledgeConfirmation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.ackIds != null && message.ackIds.length)
                                for (var i = 0; i < message.ackIds.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.ackIds[i]);
                            if (message.invalidAckIds != null && message.invalidAckIds.length)
                                for (var i = 0; i < message.invalidAckIds.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.invalidAckIds[i]);
                            if (message.unorderedAckIds != null && message.unorderedAckIds.length)
                                for (var i = 0; i < message.unorderedAckIds.length; ++i)
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.unorderedAckIds[i]);
                            if (message.temporaryFailedAckIds != null && message.temporaryFailedAckIds.length)
                                for (var i = 0; i < message.temporaryFailedAckIds.length; ++i)
                                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.temporaryFailedAckIds[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified AcknowledgeConfirmation message, length delimited. Does not implicitly {@link google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.IAcknowledgeConfirmation} message AcknowledgeConfirmation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AcknowledgeConfirmation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes an AcknowledgeConfirmation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation} AcknowledgeConfirmation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AcknowledgeConfirmation.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.ackIds && message.ackIds.length))
                                            message.ackIds = [];
                                        message.ackIds.push(reader.string());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.invalidAckIds && message.invalidAckIds.length))
                                            message.invalidAckIds = [];
                                        message.invalidAckIds.push(reader.string());
                                        break;
                                    }
                                case 3: {
                                        if (!(message.unorderedAckIds && message.unorderedAckIds.length))
                                            message.unorderedAckIds = [];
                                        message.unorderedAckIds.push(reader.string());
                                        break;
                                    }
                                case 4: {
                                        if (!(message.temporaryFailedAckIds && message.temporaryFailedAckIds.length))
                                            message.temporaryFailedAckIds = [];
                                        message.temporaryFailedAckIds.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes an AcknowledgeConfirmation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation} AcknowledgeConfirmation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AcknowledgeConfirmation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies an AcknowledgeConfirmation message.
                         * @function verify
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AcknowledgeConfirmation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.ackIds != null && message.hasOwnProperty("ackIds")) {
                                if (!Array.isArray(message.ackIds))
                                    return "ackIds: array expected";
                                for (var i = 0; i < message.ackIds.length; ++i)
                                    if (!$util.isString(message.ackIds[i]))
                                        return "ackIds: string[] expected";
                            }
                            if (message.invalidAckIds != null && message.hasOwnProperty("invalidAckIds")) {
                                if (!Array.isArray(message.invalidAckIds))
                                    return "invalidAckIds: array expected";
                                for (var i = 0; i < message.invalidAckIds.length; ++i)
                                    if (!$util.isString(message.invalidAckIds[i]))
                                        return "invalidAckIds: string[] expected";
                            }
                            if (message.unorderedAckIds != null && message.hasOwnProperty("unorderedAckIds")) {
                                if (!Array.isArray(message.unorderedAckIds))
                                    return "unorderedAckIds: array expected";
                                for (var i = 0; i < message.unorderedAckIds.length; ++i)
                                    if (!$util.isString(message.unorderedAckIds[i]))
                                        return "unorderedAckIds: string[] expected";
                            }
                            if (message.temporaryFailedAckIds != null && message.hasOwnProperty("temporaryFailedAckIds")) {
                                if (!Array.isArray(message.temporaryFailedAckIds))
                                    return "temporaryFailedAckIds: array expected";
                                for (var i = 0; i < message.temporaryFailedAckIds.length; ++i)
                                    if (!$util.isString(message.temporaryFailedAckIds[i]))
                                        return "temporaryFailedAckIds: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates an AcknowledgeConfirmation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation} AcknowledgeConfirmation
                         */
                        AcknowledgeConfirmation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation)
                                return object;
                            var message = new $root.google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation();
                            if (object.ackIds) {
                                if (!Array.isArray(object.ackIds))
                                    throw TypeError(".google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.ackIds: array expected");
                                message.ackIds = [];
                                for (var i = 0; i < object.ackIds.length; ++i)
                                    message.ackIds[i] = String(object.ackIds[i]);
                            }
                            if (object.invalidAckIds) {
                                if (!Array.isArray(object.invalidAckIds))
                                    throw TypeError(".google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.invalidAckIds: array expected");
                                message.invalidAckIds = [];
                                for (var i = 0; i < object.invalidAckIds.length; ++i)
                                    message.invalidAckIds[i] = String(object.invalidAckIds[i]);
                            }
                            if (object.unorderedAckIds) {
                                if (!Array.isArray(object.unorderedAckIds))
                                    throw TypeError(".google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.unorderedAckIds: array expected");
                                message.unorderedAckIds = [];
                                for (var i = 0; i < object.unorderedAckIds.length; ++i)
                                    message.unorderedAckIds[i] = String(object.unorderedAckIds[i]);
                            }
                            if (object.temporaryFailedAckIds) {
                                if (!Array.isArray(object.temporaryFailedAckIds))
                                    throw TypeError(".google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation.temporaryFailedAckIds: array expected");
                                message.temporaryFailedAckIds = [];
                                for (var i = 0; i < object.temporaryFailedAckIds.length; ++i)
                                    message.temporaryFailedAckIds[i] = String(object.temporaryFailedAckIds[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from an AcknowledgeConfirmation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation} message AcknowledgeConfirmation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AcknowledgeConfirmation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.ackIds = [];
                                object.invalidAckIds = [];
                                object.unorderedAckIds = [];
                                object.temporaryFailedAckIds = [];
                            }
                            if (message.ackIds && message.ackIds.length) {
                                object.ackIds = [];
                                for (var j = 0; j < message.ackIds.length; ++j)
                                    object.ackIds[j] = message.ackIds[j];
                            }
                            if (message.invalidAckIds && message.invalidAckIds.length) {
                                object.invalidAckIds = [];
                                for (var j = 0; j < message.invalidAckIds.length; ++j)
                                    object.invalidAckIds[j] = message.invalidAckIds[j];
                            }
                            if (message.unorderedAckIds && message.unorderedAckIds.length) {
                                object.unorderedAckIds = [];
                                for (var j = 0; j < message.unorderedAckIds.length; ++j)
                                    object.unorderedAckIds[j] = message.unorderedAckIds[j];
                            }
                            if (message.temporaryFailedAckIds && message.temporaryFailedAckIds.length) {
                                object.temporaryFailedAckIds = [];
                                for (var j = 0; j < message.temporaryFailedAckIds.length; ++j)
                                    object.temporaryFailedAckIds[j] = message.temporaryFailedAckIds[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this AcknowledgeConfirmation to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AcknowledgeConfirmation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for AcknowledgeConfirmation
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        AcknowledgeConfirmation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.StreamingPullResponse.AcknowledgeConfirmation";
                        };
    
                        return AcknowledgeConfirmation;
                    })();
    
                    StreamingPullResponse.ModifyAckDeadlineConfirmation = (function() {
    
                        /**
                         * Properties of a ModifyAckDeadlineConfirmation.
                         * @memberof google.pubsub.v1.StreamingPullResponse
                         * @interface IModifyAckDeadlineConfirmation
                         * @property {Array.<string>|null} [ackIds] ModifyAckDeadlineConfirmation ackIds
                         * @property {Array.<string>|null} [invalidAckIds] ModifyAckDeadlineConfirmation invalidAckIds
                         * @property {Array.<string>|null} [temporaryFailedAckIds] ModifyAckDeadlineConfirmation temporaryFailedAckIds
                         */
    
                        /**
                         * Constructs a new ModifyAckDeadlineConfirmation.
                         * @memberof google.pubsub.v1.StreamingPullResponse
                         * @classdesc Represents a ModifyAckDeadlineConfirmation.
                         * @implements IModifyAckDeadlineConfirmation
                         * @constructor
                         * @param {google.pubsub.v1.StreamingPullResponse.IModifyAckDeadlineConfirmation=} [properties] Properties to set
                         */
                        function ModifyAckDeadlineConfirmation(properties) {
                            this.ackIds = [];
                            this.invalidAckIds = [];
                            this.temporaryFailedAckIds = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * ModifyAckDeadlineConfirmation ackIds.
                         * @member {Array.<string>} ackIds
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @instance
                         */
                        ModifyAckDeadlineConfirmation.prototype.ackIds = $util.emptyArray;
    
                        /**
                         * ModifyAckDeadlineConfirmation invalidAckIds.
                         * @member {Array.<string>} invalidAckIds
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @instance
                         */
                        ModifyAckDeadlineConfirmation.prototype.invalidAckIds = $util.emptyArray;
    
                        /**
                         * ModifyAckDeadlineConfirmation temporaryFailedAckIds.
                         * @member {Array.<string>} temporaryFailedAckIds
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @instance
                         */
                        ModifyAckDeadlineConfirmation.prototype.temporaryFailedAckIds = $util.emptyArray;
    
                        /**
                         * Creates a new ModifyAckDeadlineConfirmation instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.IModifyAckDeadlineConfirmation=} [properties] Properties to set
                         * @returns {google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation} ModifyAckDeadlineConfirmation instance
                         */
                        ModifyAckDeadlineConfirmation.create = function create(properties) {
                            return new ModifyAckDeadlineConfirmation(properties);
                        };
    
                        /**
                         * Encodes the specified ModifyAckDeadlineConfirmation message. Does not implicitly {@link google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.IModifyAckDeadlineConfirmation} message ModifyAckDeadlineConfirmation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ModifyAckDeadlineConfirmation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.ackIds != null && message.ackIds.length)
                                for (var i = 0; i < message.ackIds.length; ++i)
                                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.ackIds[i]);
                            if (message.invalidAckIds != null && message.invalidAckIds.length)
                                for (var i = 0; i < message.invalidAckIds.length; ++i)
                                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.invalidAckIds[i]);
                            if (message.temporaryFailedAckIds != null && message.temporaryFailedAckIds.length)
                                for (var i = 0; i < message.temporaryFailedAckIds.length; ++i)
                                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.temporaryFailedAckIds[i]);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified ModifyAckDeadlineConfirmation message, length delimited. Does not implicitly {@link google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.IModifyAckDeadlineConfirmation} message ModifyAckDeadlineConfirmation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ModifyAckDeadlineConfirmation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a ModifyAckDeadlineConfirmation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation} ModifyAckDeadlineConfirmation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ModifyAckDeadlineConfirmation.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        if (!(message.ackIds && message.ackIds.length))
                                            message.ackIds = [];
                                        message.ackIds.push(reader.string());
                                        break;
                                    }
                                case 2: {
                                        if (!(message.invalidAckIds && message.invalidAckIds.length))
                                            message.invalidAckIds = [];
                                        message.invalidAckIds.push(reader.string());
                                        break;
                                    }
                                case 3: {
                                        if (!(message.temporaryFailedAckIds && message.temporaryFailedAckIds.length))
                                            message.temporaryFailedAckIds = [];
                                        message.temporaryFailedAckIds.push(reader.string());
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a ModifyAckDeadlineConfirmation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation} ModifyAckDeadlineConfirmation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ModifyAckDeadlineConfirmation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a ModifyAckDeadlineConfirmation message.
                         * @function verify
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ModifyAckDeadlineConfirmation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.ackIds != null && message.hasOwnProperty("ackIds")) {
                                if (!Array.isArray(message.ackIds))
                                    return "ackIds: array expected";
                                for (var i = 0; i < message.ackIds.length; ++i)
                                    if (!$util.isString(message.ackIds[i]))
                                        return "ackIds: string[] expected";
                            }
                            if (message.invalidAckIds != null && message.hasOwnProperty("invalidAckIds")) {
                                if (!Array.isArray(message.invalidAckIds))
                                    return "invalidAckIds: array expected";
                                for (var i = 0; i < message.invalidAckIds.length; ++i)
                                    if (!$util.isString(message.invalidAckIds[i]))
                                        return "invalidAckIds: string[] expected";
                            }
                            if (message.temporaryFailedAckIds != null && message.hasOwnProperty("temporaryFailedAckIds")) {
                                if (!Array.isArray(message.temporaryFailedAckIds))
                                    return "temporaryFailedAckIds: array expected";
                                for (var i = 0; i < message.temporaryFailedAckIds.length; ++i)
                                    if (!$util.isString(message.temporaryFailedAckIds[i]))
                                        return "temporaryFailedAckIds: string[] expected";
                            }
                            return null;
                        };
    
                        /**
                         * Creates a ModifyAckDeadlineConfirmation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation} ModifyAckDeadlineConfirmation
                         */
                        ModifyAckDeadlineConfirmation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation)
                                return object;
                            var message = new $root.google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation();
                            if (object.ackIds) {
                                if (!Array.isArray(object.ackIds))
                                    throw TypeError(".google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.ackIds: array expected");
                                message.ackIds = [];
                                for (var i = 0; i < object.ackIds.length; ++i)
                                    message.ackIds[i] = String(object.ackIds[i]);
                            }
                            if (object.invalidAckIds) {
                                if (!Array.isArray(object.invalidAckIds))
                                    throw TypeError(".google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.invalidAckIds: array expected");
                                message.invalidAckIds = [];
                                for (var i = 0; i < object.invalidAckIds.length; ++i)
                                    message.invalidAckIds[i] = String(object.invalidAckIds[i]);
                            }
                            if (object.temporaryFailedAckIds) {
                                if (!Array.isArray(object.temporaryFailedAckIds))
                                    throw TypeError(".google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation.temporaryFailedAckIds: array expected");
                                message.temporaryFailedAckIds = [];
                                for (var i = 0; i < object.temporaryFailedAckIds.length; ++i)
                                    message.temporaryFailedAckIds[i] = String(object.temporaryFailedAckIds[i]);
                            }
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a ModifyAckDeadlineConfirmation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation} message ModifyAckDeadlineConfirmation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ModifyAckDeadlineConfirmation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults) {
                                object.ackIds = [];
                                object.invalidAckIds = [];
                                object.temporaryFailedAckIds = [];
                            }
                            if (message.ackIds && message.ackIds.length) {
                                object.ackIds = [];
                                for (var j = 0; j < message.ackIds.length; ++j)
                                    object.ackIds[j] = message.ackIds[j];
                            }
                            if (message.invalidAckIds && message.invalidAckIds.length) {
                                object.invalidAckIds = [];
                                for (var j = 0; j < message.invalidAckIds.length; ++j)
                                    object.invalidAckIds[j] = message.invalidAckIds[j];
                            }
                            if (message.temporaryFailedAckIds && message.temporaryFailedAckIds.length) {
                                object.temporaryFailedAckIds = [];
                                for (var j = 0; j < message.temporaryFailedAckIds.length; ++j)
                                    object.temporaryFailedAckIds[j] = message.temporaryFailedAckIds[j];
                            }
                            return object;
                        };
    
                        /**
                         * Converts this ModifyAckDeadlineConfirmation to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ModifyAckDeadlineConfirmation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for ModifyAckDeadlineConfirmation
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        ModifyAckDeadlineConfirmation.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.StreamingPullResponse.ModifyAckDeadlineConfirmation";
                        };
    
                        return ModifyAckDeadlineConfirmation;
                    })();
    
                    StreamingPullResponse.SubscriptionProperties = (function() {
    
                        /**
                         * Properties of a SubscriptionProperties.
                         * @memberof google.pubsub.v1.StreamingPullResponse
                         * @interface ISubscriptionProperties
                         * @property {boolean|null} [exactlyOnceDeliveryEnabled] SubscriptionProperties exactlyOnceDeliveryEnabled
                         * @property {boolean|null} [messageOrderingEnabled] SubscriptionProperties messageOrderingEnabled
                         */
    
                        /**
                         * Constructs a new SubscriptionProperties.
                         * @memberof google.pubsub.v1.StreamingPullResponse
                         * @classdesc Represents a SubscriptionProperties.
                         * @implements ISubscriptionProperties
                         * @constructor
                         * @param {google.pubsub.v1.StreamingPullResponse.ISubscriptionProperties=} [properties] Properties to set
                         */
                        function SubscriptionProperties(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }
    
                        /**
                         * SubscriptionProperties exactlyOnceDeliveryEnabled.
                         * @member {boolean} exactlyOnceDeliveryEnabled
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @instance
                         */
                        SubscriptionProperties.prototype.exactlyOnceDeliveryEnabled = false;
    
                        /**
                         * SubscriptionProperties messageOrderingEnabled.
                         * @member {boolean} messageOrderingEnabled
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @instance
                         */
                        SubscriptionProperties.prototype.messageOrderingEnabled = false;
    
                        /**
                         * Creates a new SubscriptionProperties instance using the specified properties.
                         * @function create
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.ISubscriptionProperties=} [properties] Properties to set
                         * @returns {google.pubsub.v1.StreamingPullResponse.SubscriptionProperties} SubscriptionProperties instance
                         */
                        SubscriptionProperties.create = function create(properties) {
                            return new SubscriptionProperties(properties);
                        };
    
                        /**
                         * Encodes the specified SubscriptionProperties message. Does not implicitly {@link google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.verify|verify} messages.
                         * @function encode
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.ISubscriptionProperties} message SubscriptionProperties message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SubscriptionProperties.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.exactlyOnceDeliveryEnabled != null && Object.hasOwnProperty.call(message, "exactlyOnceDeliveryEnabled"))
                                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.exactlyOnceDeliveryEnabled);
                            if (message.messageOrderingEnabled != null && Object.hasOwnProperty.call(message, "messageOrderingEnabled"))
                                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.messageOrderingEnabled);
                            return writer;
                        };
    
                        /**
                         * Encodes the specified SubscriptionProperties message, length delimited. Does not implicitly {@link google.pubsub.v1.StreamingPullResponse.SubscriptionProperties.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.ISubscriptionProperties} message SubscriptionProperties message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        SubscriptionProperties.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };
    
                        /**
                         * Decodes a SubscriptionProperties message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.pubsub.v1.StreamingPullResponse.SubscriptionProperties} SubscriptionProperties
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SubscriptionProperties.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 1: {
                                        message.exactlyOnceDeliveryEnabled = reader.bool();
                                        break;
                                    }
                                case 2: {
                                        message.messageOrderingEnabled = reader.bool();
                                        break;
                                    }
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };
    
                        /**
                         * Decodes a SubscriptionProperties message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.pubsub.v1.StreamingPullResponse.SubscriptionProperties} SubscriptionProperties
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        SubscriptionProperties.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };
    
                        /**
                         * Verifies a SubscriptionProperties message.
                         * @function verify
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        SubscriptionProperties.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.exactlyOnceDeliveryEnabled != null && message.hasOwnProperty("exactlyOnceDeliveryEnabled"))
                                if (typeof message.exactlyOnceDeliveryEnabled !== "boolean")
                                    return "exactlyOnceDeliveryEnabled: boolean expected";
                            if (message.messageOrderingEnabled != null && message.hasOwnProperty("messageOrderingEnabled"))
                                if (typeof message.messageOrderingEnabled !== "boolean")
                                    return "messageOrderingEnabled: boolean expected";
                            return null;
                        };
    
                        /**
                         * Creates a SubscriptionProperties message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.pubsub.v1.StreamingPullResponse.SubscriptionProperties} SubscriptionProperties
                         */
                        SubscriptionProperties.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties)
                                return object;
                            var message = new $root.google.pubsub.v1.StreamingPullResponse.SubscriptionProperties();
                            if (object.exactlyOnceDeliveryEnabled != null)
                                message.exactlyOnceDeliveryEnabled = Boolean(object.exactlyOnceDeliveryEnabled);
                            if (object.messageOrderingEnabled != null)
                                message.messageOrderingEnabled = Boolean(object.messageOrderingEnabled);
                            return message;
                        };
    
                        /**
                         * Creates a plain object from a SubscriptionProperties message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {google.pubsub.v1.StreamingPullResponse.SubscriptionProperties} message SubscriptionProperties
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        SubscriptionProperties.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.exactlyOnceDeliveryEnabled = false;
                                object.messageOrderingEnabled = false;
                            }
                            if (message.exactlyOnceDeliveryEnabled != null && message.hasOwnProperty("exactlyOnceDeliveryEnabled"))
                                object.exactlyOnceDeliveryEnabled = message.exactlyOnceDeliveryEnabled;
                            if (message.messageOrderingEnabled != null && message.hasOwnProperty("messageOrderingEnabled"))
                                object.messageOrderingEnabled = message.messageOrderingEnabled;
                            return object;
                        };
    
                        /**
                         * Converts this SubscriptionProperties to JSON.
                         * @function toJSON
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        SubscriptionProperties.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };
    
                        /**
                         * Gets the default type url for SubscriptionProperties
                         * @function getTypeUrl
                         * @memberof google.pubsub.v1.StreamingPullResponse.SubscriptionProperties
                         * @static
                         * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                         * @returns {string} The default type url
                         */
                        SubscriptionProperties.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                            if (typeUrlPrefix === undefined) {
                                typeUrlPrefix = "type.googleapis.com";
                            }
                            return typeUrlPrefix + "/google.pubsub.v1.StreamingPullResponse.SubscriptionProperties";
                        };
    
                        return SubscriptionProperties;
                    })();
    
                    return StreamingPullResponse;
                })();
    
                v1.CreateSnapshotRequest = (function() {
    
                    /**
                     * Properties of a CreateSnapshotRequest.
                     * @memberof google.pubsub.v1
                     * @interface ICreateSnapshotRequest
                     * @property {string|null} [name] CreateSnapshotRequest name
                     * @property {string|null} [subscription] CreateSnapshotRequest subscription
                     * @property {Object.<string,string>|null} [labels] CreateSnapshotRequest labels
                     */
    
                    /**
                     * Constructs a new CreateSnapshotRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a CreateSnapshotRequest.
                     * @implements ICreateSnapshotRequest
                     * @constructor
                     * @param {google.pubsub.v1.ICreateSnapshotRequest=} [properties] Properties to set
                     */
                    function CreateSnapshotRequest(properties) {
                        this.labels = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * CreateSnapshotRequest name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @instance
                     */
                    CreateSnapshotRequest.prototype.name = "";
    
                    /**
                     * CreateSnapshotRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @instance
                     */
                    CreateSnapshotRequest.prototype.subscription = "";
    
                    /**
                     * CreateSnapshotRequest labels.
                     * @member {Object.<string,string>} labels
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @instance
                     */
                    CreateSnapshotRequest.prototype.labels = $util.emptyObject;
    
                    /**
                     * Creates a new CreateSnapshotRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.ICreateSnapshotRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.CreateSnapshotRequest} CreateSnapshotRequest instance
                     */
                    CreateSnapshotRequest.create = function create(properties) {
                        return new CreateSnapshotRequest(properties);
                    };
    
                    /**
                     * Encodes the specified CreateSnapshotRequest message. Does not implicitly {@link google.pubsub.v1.CreateSnapshotRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.ICreateSnapshotRequest} message CreateSnapshotRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CreateSnapshotRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.subscription);
                        if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                            for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 3, wireType 2 =*/26).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified CreateSnapshotRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.CreateSnapshotRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.ICreateSnapshotRequest} message CreateSnapshotRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CreateSnapshotRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a CreateSnapshotRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.CreateSnapshotRequest} CreateSnapshotRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CreateSnapshotRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.CreateSnapshotRequest(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            case 3: {
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a CreateSnapshotRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.CreateSnapshotRequest} CreateSnapshotRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CreateSnapshotRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a CreateSnapshotRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    CreateSnapshotRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        if (message.labels != null && message.hasOwnProperty("labels")) {
                            if (!$util.isObject(message.labels))
                                return "labels: object expected";
                            var key = Object.keys(message.labels);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.labels[key[i]]))
                                    return "labels: string{k:string} expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a CreateSnapshotRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.CreateSnapshotRequest} CreateSnapshotRequest
                     */
                    CreateSnapshotRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.CreateSnapshotRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.CreateSnapshotRequest();
                        if (object.name != null)
                            message.name = String(object.name);
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        if (object.labels) {
                            if (typeof object.labels !== "object")
                                throw TypeError(".google.pubsub.v1.CreateSnapshotRequest.labels: object expected");
                            message.labels = {};
                            for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                message.labels[keys[i]] = String(object.labels[keys[i]]);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a CreateSnapshotRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.CreateSnapshotRequest} message CreateSnapshotRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    CreateSnapshotRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.labels = {};
                        if (options.defaults) {
                            object.name = "";
                            object.subscription = "";
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        var keys2;
                        if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                            object.labels = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.labels[keys2[j]] = message.labels[keys2[j]];
                        }
                        return object;
                    };
    
                    /**
                     * Converts this CreateSnapshotRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    CreateSnapshotRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for CreateSnapshotRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.CreateSnapshotRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    CreateSnapshotRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.CreateSnapshotRequest";
                    };
    
                    return CreateSnapshotRequest;
                })();
    
                v1.UpdateSnapshotRequest = (function() {
    
                    /**
                     * Properties of an UpdateSnapshotRequest.
                     * @memberof google.pubsub.v1
                     * @interface IUpdateSnapshotRequest
                     * @property {google.pubsub.v1.ISnapshot|null} [snapshot] UpdateSnapshotRequest snapshot
                     * @property {google.protobuf.IFieldMask|null} [updateMask] UpdateSnapshotRequest updateMask
                     */
    
                    /**
                     * Constructs a new UpdateSnapshotRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents an UpdateSnapshotRequest.
                     * @implements IUpdateSnapshotRequest
                     * @constructor
                     * @param {google.pubsub.v1.IUpdateSnapshotRequest=} [properties] Properties to set
                     */
                    function UpdateSnapshotRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * UpdateSnapshotRequest snapshot.
                     * @member {google.pubsub.v1.ISnapshot|null|undefined} snapshot
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @instance
                     */
                    UpdateSnapshotRequest.prototype.snapshot = null;
    
                    /**
                     * UpdateSnapshotRequest updateMask.
                     * @member {google.protobuf.IFieldMask|null|undefined} updateMask
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @instance
                     */
                    UpdateSnapshotRequest.prototype.updateMask = null;
    
                    /**
                     * Creates a new UpdateSnapshotRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSnapshotRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.UpdateSnapshotRequest} UpdateSnapshotRequest instance
                     */
                    UpdateSnapshotRequest.create = function create(properties) {
                        return new UpdateSnapshotRequest(properties);
                    };
    
                    /**
                     * Encodes the specified UpdateSnapshotRequest message. Does not implicitly {@link google.pubsub.v1.UpdateSnapshotRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSnapshotRequest} message UpdateSnapshotRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateSnapshotRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.snapshot != null && Object.hasOwnProperty.call(message, "snapshot"))
                            $root.google.pubsub.v1.Snapshot.encode(message.snapshot, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.updateMask != null && Object.hasOwnProperty.call(message, "updateMask"))
                            $root.google.protobuf.FieldMask.encode(message.updateMask, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified UpdateSnapshotRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.UpdateSnapshotRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IUpdateSnapshotRequest} message UpdateSnapshotRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    UpdateSnapshotRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes an UpdateSnapshotRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.UpdateSnapshotRequest} UpdateSnapshotRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateSnapshotRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.UpdateSnapshotRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.snapshot = $root.google.pubsub.v1.Snapshot.decode(reader, reader.uint32());
                                    break;
                                }
                            case 2: {
                                    message.updateMask = $root.google.protobuf.FieldMask.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes an UpdateSnapshotRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.UpdateSnapshotRequest} UpdateSnapshotRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    UpdateSnapshotRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies an UpdateSnapshotRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    UpdateSnapshotRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.snapshot != null && message.hasOwnProperty("snapshot")) {
                            var error = $root.google.pubsub.v1.Snapshot.verify(message.snapshot);
                            if (error)
                                return "snapshot." + error;
                        }
                        if (message.updateMask != null && message.hasOwnProperty("updateMask")) {
                            var error = $root.google.protobuf.FieldMask.verify(message.updateMask);
                            if (error)
                                return "updateMask." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates an UpdateSnapshotRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.UpdateSnapshotRequest} UpdateSnapshotRequest
                     */
                    UpdateSnapshotRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.UpdateSnapshotRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.UpdateSnapshotRequest();
                        if (object.snapshot != null) {
                            if (typeof object.snapshot !== "object")
                                throw TypeError(".google.pubsub.v1.UpdateSnapshotRequest.snapshot: object expected");
                            message.snapshot = $root.google.pubsub.v1.Snapshot.fromObject(object.snapshot);
                        }
                        if (object.updateMask != null) {
                            if (typeof object.updateMask !== "object")
                                throw TypeError(".google.pubsub.v1.UpdateSnapshotRequest.updateMask: object expected");
                            message.updateMask = $root.google.protobuf.FieldMask.fromObject(object.updateMask);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from an UpdateSnapshotRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.UpdateSnapshotRequest} message UpdateSnapshotRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    UpdateSnapshotRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.snapshot = null;
                            object.updateMask = null;
                        }
                        if (message.snapshot != null && message.hasOwnProperty("snapshot"))
                            object.snapshot = $root.google.pubsub.v1.Snapshot.toObject(message.snapshot, options);
                        if (message.updateMask != null && message.hasOwnProperty("updateMask"))
                            object.updateMask = $root.google.protobuf.FieldMask.toObject(message.updateMask, options);
                        return object;
                    };
    
                    /**
                     * Converts this UpdateSnapshotRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    UpdateSnapshotRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for UpdateSnapshotRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.UpdateSnapshotRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    UpdateSnapshotRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.UpdateSnapshotRequest";
                    };
    
                    return UpdateSnapshotRequest;
                })();
    
                v1.Snapshot = (function() {
    
                    /**
                     * Properties of a Snapshot.
                     * @memberof google.pubsub.v1
                     * @interface ISnapshot
                     * @property {string|null} [name] Snapshot name
                     * @property {string|null} [topic] Snapshot topic
                     * @property {google.protobuf.ITimestamp|null} [expireTime] Snapshot expireTime
                     * @property {Object.<string,string>|null} [labels] Snapshot labels
                     */
    
                    /**
                     * Constructs a new Snapshot.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Snapshot.
                     * @implements ISnapshot
                     * @constructor
                     * @param {google.pubsub.v1.ISnapshot=} [properties] Properties to set
                     */
                    function Snapshot(properties) {
                        this.labels = {};
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Snapshot name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.Snapshot
                     * @instance
                     */
                    Snapshot.prototype.name = "";
    
                    /**
                     * Snapshot topic.
                     * @member {string} topic
                     * @memberof google.pubsub.v1.Snapshot
                     * @instance
                     */
                    Snapshot.prototype.topic = "";
    
                    /**
                     * Snapshot expireTime.
                     * @member {google.protobuf.ITimestamp|null|undefined} expireTime
                     * @memberof google.pubsub.v1.Snapshot
                     * @instance
                     */
                    Snapshot.prototype.expireTime = null;
    
                    /**
                     * Snapshot labels.
                     * @member {Object.<string,string>} labels
                     * @memberof google.pubsub.v1.Snapshot
                     * @instance
                     */
                    Snapshot.prototype.labels = $util.emptyObject;
    
                    /**
                     * Creates a new Snapshot instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {google.pubsub.v1.ISnapshot=} [properties] Properties to set
                     * @returns {google.pubsub.v1.Snapshot} Snapshot instance
                     */
                    Snapshot.create = function create(properties) {
                        return new Snapshot(properties);
                    };
    
                    /**
                     * Encodes the specified Snapshot message. Does not implicitly {@link google.pubsub.v1.Snapshot.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {google.pubsub.v1.ISnapshot} message Snapshot message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Snapshot.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.topic != null && Object.hasOwnProperty.call(message, "topic"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.topic);
                        if (message.expireTime != null && Object.hasOwnProperty.call(message, "expireTime"))
                            $root.google.protobuf.Timestamp.encode(message.expireTime, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        if (message.labels != null && Object.hasOwnProperty.call(message, "labels"))
                            for (var keys = Object.keys(message.labels), i = 0; i < keys.length; ++i)
                                writer.uint32(/* id 4, wireType 2 =*/34).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]).uint32(/* id 2, wireType 2 =*/18).string(message.labels[keys[i]]).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Snapshot message, length delimited. Does not implicitly {@link google.pubsub.v1.Snapshot.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {google.pubsub.v1.ISnapshot} message Snapshot message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Snapshot.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Snapshot message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.Snapshot} Snapshot
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Snapshot.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.Snapshot(), key, value;
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.topic = reader.string();
                                    break;
                                }
                            case 3: {
                                    message.expireTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                }
                            case 4: {
                                    if (message.labels === $util.emptyObject)
                                        message.labels = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = "";
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = reader.string();
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.labels[key] = value;
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Snapshot message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.Snapshot} Snapshot
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Snapshot.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Snapshot message.
                     * @function verify
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Snapshot.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            if (!$util.isString(message.topic))
                                return "topic: string expected";
                        if (message.expireTime != null && message.hasOwnProperty("expireTime")) {
                            var error = $root.google.protobuf.Timestamp.verify(message.expireTime);
                            if (error)
                                return "expireTime." + error;
                        }
                        if (message.labels != null && message.hasOwnProperty("labels")) {
                            if (!$util.isObject(message.labels))
                                return "labels: object expected";
                            var key = Object.keys(message.labels);
                            for (var i = 0; i < key.length; ++i)
                                if (!$util.isString(message.labels[key[i]]))
                                    return "labels: string{k:string} expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Snapshot message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.Snapshot} Snapshot
                     */
                    Snapshot.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.Snapshot)
                            return object;
                        var message = new $root.google.pubsub.v1.Snapshot();
                        if (object.name != null)
                            message.name = String(object.name);
                        if (object.topic != null)
                            message.topic = String(object.topic);
                        if (object.expireTime != null) {
                            if (typeof object.expireTime !== "object")
                                throw TypeError(".google.pubsub.v1.Snapshot.expireTime: object expected");
                            message.expireTime = $root.google.protobuf.Timestamp.fromObject(object.expireTime);
                        }
                        if (object.labels) {
                            if (typeof object.labels !== "object")
                                throw TypeError(".google.pubsub.v1.Snapshot.labels: object expected");
                            message.labels = {};
                            for (var keys = Object.keys(object.labels), i = 0; i < keys.length; ++i)
                                message.labels[keys[i]] = String(object.labels[keys[i]]);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Snapshot message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {google.pubsub.v1.Snapshot} message Snapshot
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Snapshot.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.objects || options.defaults)
                            object.labels = {};
                        if (options.defaults) {
                            object.name = "";
                            object.topic = "";
                            object.expireTime = null;
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        if (message.topic != null && message.hasOwnProperty("topic"))
                            object.topic = message.topic;
                        if (message.expireTime != null && message.hasOwnProperty("expireTime"))
                            object.expireTime = $root.google.protobuf.Timestamp.toObject(message.expireTime, options);
                        var keys2;
                        if (message.labels && (keys2 = Object.keys(message.labels)).length) {
                            object.labels = {};
                            for (var j = 0; j < keys2.length; ++j)
                                object.labels[keys2[j]] = message.labels[keys2[j]];
                        }
                        return object;
                    };
    
                    /**
                     * Converts this Snapshot to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.Snapshot
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Snapshot.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for Snapshot
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.Snapshot
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    Snapshot.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.Snapshot";
                    };
    
                    return Snapshot;
                })();
    
                v1.GetSnapshotRequest = (function() {
    
                    /**
                     * Properties of a GetSnapshotRequest.
                     * @memberof google.pubsub.v1
                     * @interface IGetSnapshotRequest
                     * @property {string|null} [snapshot] GetSnapshotRequest snapshot
                     */
    
                    /**
                     * Constructs a new GetSnapshotRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a GetSnapshotRequest.
                     * @implements IGetSnapshotRequest
                     * @constructor
                     * @param {google.pubsub.v1.IGetSnapshotRequest=} [properties] Properties to set
                     */
                    function GetSnapshotRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * GetSnapshotRequest snapshot.
                     * @member {string} snapshot
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @instance
                     */
                    GetSnapshotRequest.prototype.snapshot = "";
    
                    /**
                     * Creates a new GetSnapshotRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSnapshotRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.GetSnapshotRequest} GetSnapshotRequest instance
                     */
                    GetSnapshotRequest.create = function create(properties) {
                        return new GetSnapshotRequest(properties);
                    };
    
                    /**
                     * Encodes the specified GetSnapshotRequest message. Does not implicitly {@link google.pubsub.v1.GetSnapshotRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSnapshotRequest} message GetSnapshotRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetSnapshotRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.snapshot != null && Object.hasOwnProperty.call(message, "snapshot"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.snapshot);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified GetSnapshotRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.GetSnapshotRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSnapshotRequest} message GetSnapshotRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetSnapshotRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a GetSnapshotRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.GetSnapshotRequest} GetSnapshotRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetSnapshotRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.GetSnapshotRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.snapshot = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a GetSnapshotRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.GetSnapshotRequest} GetSnapshotRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetSnapshotRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a GetSnapshotRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    GetSnapshotRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.snapshot != null && message.hasOwnProperty("snapshot"))
                            if (!$util.isString(message.snapshot))
                                return "snapshot: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a GetSnapshotRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.GetSnapshotRequest} GetSnapshotRequest
                     */
                    GetSnapshotRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.GetSnapshotRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.GetSnapshotRequest();
                        if (object.snapshot != null)
                            message.snapshot = String(object.snapshot);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a GetSnapshotRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.GetSnapshotRequest} message GetSnapshotRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    GetSnapshotRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.snapshot = "";
                        if (message.snapshot != null && message.hasOwnProperty("snapshot"))
                            object.snapshot = message.snapshot;
                        return object;
                    };
    
                    /**
                     * Converts this GetSnapshotRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    GetSnapshotRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for GetSnapshotRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.GetSnapshotRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    GetSnapshotRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.GetSnapshotRequest";
                    };
    
                    return GetSnapshotRequest;
                })();
    
                v1.ListSnapshotsRequest = (function() {
    
                    /**
                     * Properties of a ListSnapshotsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListSnapshotsRequest
                     * @property {string|null} [project] ListSnapshotsRequest project
                     * @property {number|null} [pageSize] ListSnapshotsRequest pageSize
                     * @property {string|null} [pageToken] ListSnapshotsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListSnapshotsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListSnapshotsRequest.
                     * @implements IListSnapshotsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListSnapshotsRequest=} [properties] Properties to set
                     */
                    function ListSnapshotsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListSnapshotsRequest project.
                     * @member {string} project
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @instance
                     */
                    ListSnapshotsRequest.prototype.project = "";
    
                    /**
                     * ListSnapshotsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @instance
                     */
                    ListSnapshotsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListSnapshotsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @instance
                     */
                    ListSnapshotsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListSnapshotsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSnapshotsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListSnapshotsRequest} ListSnapshotsRequest instance
                     */
                    ListSnapshotsRequest.create = function create(properties) {
                        return new ListSnapshotsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListSnapshotsRequest message. Does not implicitly {@link google.pubsub.v1.ListSnapshotsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSnapshotsRequest} message ListSnapshotsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSnapshotsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.project);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListSnapshotsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListSnapshotsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSnapshotsRequest} message ListSnapshotsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSnapshotsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListSnapshotsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListSnapshotsRequest} ListSnapshotsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSnapshotsRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListSnapshotsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.project = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListSnapshotsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListSnapshotsRequest} ListSnapshotsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSnapshotsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListSnapshotsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListSnapshotsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.project != null && message.hasOwnProperty("project"))
                            if (!$util.isString(message.project))
                                return "project: string expected";
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListSnapshotsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListSnapshotsRequest} ListSnapshotsRequest
                     */
                    ListSnapshotsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListSnapshotsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListSnapshotsRequest();
                        if (object.project != null)
                            message.project = String(object.project);
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListSnapshotsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {google.pubsub.v1.ListSnapshotsRequest} message ListSnapshotsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListSnapshotsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.project = "";
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.project != null && message.hasOwnProperty("project"))
                            object.project = message.project;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListSnapshotsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListSnapshotsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListSnapshotsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListSnapshotsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListSnapshotsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListSnapshotsRequest";
                    };
    
                    return ListSnapshotsRequest;
                })();
    
                v1.ListSnapshotsResponse = (function() {
    
                    /**
                     * Properties of a ListSnapshotsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListSnapshotsResponse
                     * @property {Array.<google.pubsub.v1.ISnapshot>|null} [snapshots] ListSnapshotsResponse snapshots
                     * @property {string|null} [nextPageToken] ListSnapshotsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListSnapshotsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListSnapshotsResponse.
                     * @implements IListSnapshotsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListSnapshotsResponse=} [properties] Properties to set
                     */
                    function ListSnapshotsResponse(properties) {
                        this.snapshots = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListSnapshotsResponse snapshots.
                     * @member {Array.<google.pubsub.v1.ISnapshot>} snapshots
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @instance
                     */
                    ListSnapshotsResponse.prototype.snapshots = $util.emptyArray;
    
                    /**
                     * ListSnapshotsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @instance
                     */
                    ListSnapshotsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListSnapshotsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListSnapshotsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListSnapshotsResponse} ListSnapshotsResponse instance
                     */
                    ListSnapshotsResponse.create = function create(properties) {
                        return new ListSnapshotsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListSnapshotsResponse message. Does not implicitly {@link google.pubsub.v1.ListSnapshotsResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListSnapshotsResponse} message ListSnapshotsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSnapshotsResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.snapshots != null && message.snapshots.length)
                            for (var i = 0; i < message.snapshots.length; ++i)
                                $root.google.pubsub.v1.Snapshot.encode(message.snapshots[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListSnapshotsResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListSnapshotsResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.IListSnapshotsResponse} message ListSnapshotsResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSnapshotsResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListSnapshotsResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListSnapshotsResponse} ListSnapshotsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSnapshotsResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListSnapshotsResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.snapshots && message.snapshots.length))
                                        message.snapshots = [];
                                    message.snapshots.push($root.google.pubsub.v1.Snapshot.decode(reader, reader.uint32()));
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListSnapshotsResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListSnapshotsResponse} ListSnapshotsResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSnapshotsResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListSnapshotsResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListSnapshotsResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.snapshots != null && message.hasOwnProperty("snapshots")) {
                            if (!Array.isArray(message.snapshots))
                                return "snapshots: array expected";
                            for (var i = 0; i < message.snapshots.length; ++i) {
                                var error = $root.google.pubsub.v1.Snapshot.verify(message.snapshots[i]);
                                if (error)
                                    return "snapshots." + error;
                            }
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListSnapshotsResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListSnapshotsResponse} ListSnapshotsResponse
                     */
                    ListSnapshotsResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListSnapshotsResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListSnapshotsResponse();
                        if (object.snapshots) {
                            if (!Array.isArray(object.snapshots))
                                throw TypeError(".google.pubsub.v1.ListSnapshotsResponse.snapshots: array expected");
                            message.snapshots = [];
                            for (var i = 0; i < object.snapshots.length; ++i) {
                                if (typeof object.snapshots[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.ListSnapshotsResponse.snapshots: object expected");
                                message.snapshots[i] = $root.google.pubsub.v1.Snapshot.fromObject(object.snapshots[i]);
                            }
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListSnapshotsResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {google.pubsub.v1.ListSnapshotsResponse} message ListSnapshotsResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListSnapshotsResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.snapshots = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.snapshots && message.snapshots.length) {
                            object.snapshots = [];
                            for (var j = 0; j < message.snapshots.length; ++j)
                                object.snapshots[j] = $root.google.pubsub.v1.Snapshot.toObject(message.snapshots[j], options);
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListSnapshotsResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListSnapshotsResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListSnapshotsResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListSnapshotsResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListSnapshotsResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListSnapshotsResponse";
                    };
    
                    return ListSnapshotsResponse;
                })();
    
                v1.DeleteSnapshotRequest = (function() {
    
                    /**
                     * Properties of a DeleteSnapshotRequest.
                     * @memberof google.pubsub.v1
                     * @interface IDeleteSnapshotRequest
                     * @property {string|null} [snapshot] DeleteSnapshotRequest snapshot
                     */
    
                    /**
                     * Constructs a new DeleteSnapshotRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a DeleteSnapshotRequest.
                     * @implements IDeleteSnapshotRequest
                     * @constructor
                     * @param {google.pubsub.v1.IDeleteSnapshotRequest=} [properties] Properties to set
                     */
                    function DeleteSnapshotRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * DeleteSnapshotRequest snapshot.
                     * @member {string} snapshot
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @instance
                     */
                    DeleteSnapshotRequest.prototype.snapshot = "";
    
                    /**
                     * Creates a new DeleteSnapshotRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteSnapshotRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.DeleteSnapshotRequest} DeleteSnapshotRequest instance
                     */
                    DeleteSnapshotRequest.create = function create(properties) {
                        return new DeleteSnapshotRequest(properties);
                    };
    
                    /**
                     * Encodes the specified DeleteSnapshotRequest message. Does not implicitly {@link google.pubsub.v1.DeleteSnapshotRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteSnapshotRequest} message DeleteSnapshotRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeleteSnapshotRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.snapshot != null && Object.hasOwnProperty.call(message, "snapshot"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.snapshot);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified DeleteSnapshotRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.DeleteSnapshotRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.IDeleteSnapshotRequest} message DeleteSnapshotRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    DeleteSnapshotRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a DeleteSnapshotRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.DeleteSnapshotRequest} DeleteSnapshotRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeleteSnapshotRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.DeleteSnapshotRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.snapshot = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a DeleteSnapshotRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.DeleteSnapshotRequest} DeleteSnapshotRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    DeleteSnapshotRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a DeleteSnapshotRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    DeleteSnapshotRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.snapshot != null && message.hasOwnProperty("snapshot"))
                            if (!$util.isString(message.snapshot))
                                return "snapshot: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a DeleteSnapshotRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.DeleteSnapshotRequest} DeleteSnapshotRequest
                     */
                    DeleteSnapshotRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.DeleteSnapshotRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.DeleteSnapshotRequest();
                        if (object.snapshot != null)
                            message.snapshot = String(object.snapshot);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a DeleteSnapshotRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {google.pubsub.v1.DeleteSnapshotRequest} message DeleteSnapshotRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    DeleteSnapshotRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.snapshot = "";
                        if (message.snapshot != null && message.hasOwnProperty("snapshot"))
                            object.snapshot = message.snapshot;
                        return object;
                    };
    
                    /**
                     * Converts this DeleteSnapshotRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    DeleteSnapshotRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for DeleteSnapshotRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.DeleteSnapshotRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    DeleteSnapshotRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.DeleteSnapshotRequest";
                    };
    
                    return DeleteSnapshotRequest;
                })();
    
                v1.SeekRequest = (function() {
    
                    /**
                     * Properties of a SeekRequest.
                     * @memberof google.pubsub.v1
                     * @interface ISeekRequest
                     * @property {string|null} [subscription] SeekRequest subscription
                     * @property {google.protobuf.ITimestamp|null} [time] SeekRequest time
                     * @property {string|null} [snapshot] SeekRequest snapshot
                     */
    
                    /**
                     * Constructs a new SeekRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a SeekRequest.
                     * @implements ISeekRequest
                     * @constructor
                     * @param {google.pubsub.v1.ISeekRequest=} [properties] Properties to set
                     */
                    function SeekRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * SeekRequest subscription.
                     * @member {string} subscription
                     * @memberof google.pubsub.v1.SeekRequest
                     * @instance
                     */
                    SeekRequest.prototype.subscription = "";
    
                    /**
                     * SeekRequest time.
                     * @member {google.protobuf.ITimestamp|null|undefined} time
                     * @memberof google.pubsub.v1.SeekRequest
                     * @instance
                     */
                    SeekRequest.prototype.time = null;
    
                    /**
                     * SeekRequest snapshot.
                     * @member {string|null|undefined} snapshot
                     * @memberof google.pubsub.v1.SeekRequest
                     * @instance
                     */
                    SeekRequest.prototype.snapshot = null;
    
                    // OneOf field names bound to virtual getters and setters
                    var $oneOfFields;
    
                    /**
                     * SeekRequest target.
                     * @member {"time"|"snapshot"|undefined} target
                     * @memberof google.pubsub.v1.SeekRequest
                     * @instance
                     */
                    Object.defineProperty(SeekRequest.prototype, "target", {
                        get: $util.oneOfGetter($oneOfFields = ["time", "snapshot"]),
                        set: $util.oneOfSetter($oneOfFields)
                    });
    
                    /**
                     * Creates a new SeekRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {google.pubsub.v1.ISeekRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.SeekRequest} SeekRequest instance
                     */
                    SeekRequest.create = function create(properties) {
                        return new SeekRequest(properties);
                    };
    
                    /**
                     * Encodes the specified SeekRequest message. Does not implicitly {@link google.pubsub.v1.SeekRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {google.pubsub.v1.ISeekRequest} message SeekRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SeekRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.subscription != null && Object.hasOwnProperty.call(message, "subscription"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.subscription);
                        if (message.time != null && Object.hasOwnProperty.call(message, "time"))
                            $root.google.protobuf.Timestamp.encode(message.time, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.snapshot != null && Object.hasOwnProperty.call(message, "snapshot"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.snapshot);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified SeekRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.SeekRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {google.pubsub.v1.ISeekRequest} message SeekRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SeekRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a SeekRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.SeekRequest} SeekRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SeekRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.SeekRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.subscription = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.time = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                }
                            case 3: {
                                    message.snapshot = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a SeekRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.SeekRequest} SeekRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SeekRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a SeekRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    SeekRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        var properties = {};
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            if (!$util.isString(message.subscription))
                                return "subscription: string expected";
                        if (message.time != null && message.hasOwnProperty("time")) {
                            properties.target = 1;
                            {
                                var error = $root.google.protobuf.Timestamp.verify(message.time);
                                if (error)
                                    return "time." + error;
                            }
                        }
                        if (message.snapshot != null && message.hasOwnProperty("snapshot")) {
                            if (properties.target === 1)
                                return "target: multiple values";
                            properties.target = 1;
                            if (!$util.isString(message.snapshot))
                                return "snapshot: string expected";
                        }
                        return null;
                    };
    
                    /**
                     * Creates a SeekRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.SeekRequest} SeekRequest
                     */
                    SeekRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.SeekRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.SeekRequest();
                        if (object.subscription != null)
                            message.subscription = String(object.subscription);
                        if (object.time != null) {
                            if (typeof object.time !== "object")
                                throw TypeError(".google.pubsub.v1.SeekRequest.time: object expected");
                            message.time = $root.google.protobuf.Timestamp.fromObject(object.time);
                        }
                        if (object.snapshot != null)
                            message.snapshot = String(object.snapshot);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a SeekRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {google.pubsub.v1.SeekRequest} message SeekRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    SeekRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults)
                            object.subscription = "";
                        if (message.subscription != null && message.hasOwnProperty("subscription"))
                            object.subscription = message.subscription;
                        if (message.time != null && message.hasOwnProperty("time")) {
                            object.time = $root.google.protobuf.Timestamp.toObject(message.time, options);
                            if (options.oneofs)
                                object.target = "time";
                        }
                        if (message.snapshot != null && message.hasOwnProperty("snapshot")) {
                            object.snapshot = message.snapshot;
                            if (options.oneofs)
                                object.target = "snapshot";
                        }
                        return object;
                    };
    
                    /**
                     * Converts this SeekRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.SeekRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    SeekRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for SeekRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.SeekRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    SeekRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.SeekRequest";
                    };
    
                    return SeekRequest;
                })();
    
                v1.SeekResponse = (function() {
    
                    /**
                     * Properties of a SeekResponse.
                     * @memberof google.pubsub.v1
                     * @interface ISeekResponse
                     */
    
                    /**
                     * Constructs a new SeekResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a SeekResponse.
                     * @implements ISeekResponse
                     * @constructor
                     * @param {google.pubsub.v1.ISeekResponse=} [properties] Properties to set
                     */
                    function SeekResponse(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Creates a new SeekResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {google.pubsub.v1.ISeekResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.SeekResponse} SeekResponse instance
                     */
                    SeekResponse.create = function create(properties) {
                        return new SeekResponse(properties);
                    };
    
                    /**
                     * Encodes the specified SeekResponse message. Does not implicitly {@link google.pubsub.v1.SeekResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {google.pubsub.v1.ISeekResponse} message SeekResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SeekResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified SeekResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.SeekResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {google.pubsub.v1.ISeekResponse} message SeekResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    SeekResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a SeekResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.SeekResponse} SeekResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SeekResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.SeekResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a SeekResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.SeekResponse} SeekResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    SeekResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a SeekResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    SeekResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        return null;
                    };
    
                    /**
                     * Creates a SeekResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.SeekResponse} SeekResponse
                     */
                    SeekResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.SeekResponse)
                            return object;
                        return new $root.google.pubsub.v1.SeekResponse();
                    };
    
                    /**
                     * Creates a plain object from a SeekResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {google.pubsub.v1.SeekResponse} message SeekResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    SeekResponse.toObject = function toObject() {
                        return {};
                    };
    
                    /**
                     * Converts this SeekResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.SeekResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    SeekResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for SeekResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.SeekResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    SeekResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.SeekResponse";
                    };
    
                    return SeekResponse;
                })();
    
                v1.SchemaService = (function() {
    
                    /**
                     * Constructs a new SchemaService service.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a SchemaService
                     * @extends $protobuf.rpc.Service
                     * @constructor
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     */
                    function SchemaService(rpcImpl, requestDelimited, responseDelimited) {
                        $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                    }
    
                    (SchemaService.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = SchemaService;
    
                    /**
                     * Creates new SchemaService service using the specified rpc implementation.
                     * @function create
                     * @memberof google.pubsub.v1.SchemaService
                     * @static
                     * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                     * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                     * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                     * @returns {SchemaService} RPC service. Useful where requests and/or responses are streamed.
                     */
                    SchemaService.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                        return new this(rpcImpl, requestDelimited, responseDelimited);
                    };
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|createSchema}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef CreateSchemaCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Schema} [response] Schema
                     */
    
                    /**
                     * Calls CreateSchema.
                     * @function createSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.ICreateSchemaRequest} request CreateSchemaRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.CreateSchemaCallback} callback Node-style callback called with the error, if any, and Schema
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.createSchema = function createSchema(request, callback) {
                        return this.rpcCall(createSchema, $root.google.pubsub.v1.CreateSchemaRequest, $root.google.pubsub.v1.Schema, request, callback);
                    }, "name", { value: "CreateSchema" });
    
                    /**
                     * Calls CreateSchema.
                     * @function createSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.ICreateSchemaRequest} request CreateSchemaRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Schema>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|getSchema}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef GetSchemaCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Schema} [response] Schema
                     */
    
                    /**
                     * Calls GetSchema.
                     * @function getSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IGetSchemaRequest} request GetSchemaRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.GetSchemaCallback} callback Node-style callback called with the error, if any, and Schema
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.getSchema = function getSchema(request, callback) {
                        return this.rpcCall(getSchema, $root.google.pubsub.v1.GetSchemaRequest, $root.google.pubsub.v1.Schema, request, callback);
                    }, "name", { value: "GetSchema" });
    
                    /**
                     * Calls GetSchema.
                     * @function getSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IGetSchemaRequest} request GetSchemaRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Schema>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|listSchemas}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef ListSchemasCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListSchemasResponse} [response] ListSchemasResponse
                     */
    
                    /**
                     * Calls ListSchemas.
                     * @function listSchemas
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IListSchemasRequest} request ListSchemasRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.ListSchemasCallback} callback Node-style callback called with the error, if any, and ListSchemasResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.listSchemas = function listSchemas(request, callback) {
                        return this.rpcCall(listSchemas, $root.google.pubsub.v1.ListSchemasRequest, $root.google.pubsub.v1.ListSchemasResponse, request, callback);
                    }, "name", { value: "ListSchemas" });
    
                    /**
                     * Calls ListSchemas.
                     * @function listSchemas
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IListSchemasRequest} request ListSchemasRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListSchemasResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|listSchemaRevisions}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef ListSchemaRevisionsCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ListSchemaRevisionsResponse} [response] ListSchemaRevisionsResponse
                     */
    
                    /**
                     * Calls ListSchemaRevisions.
                     * @function listSchemaRevisions
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IListSchemaRevisionsRequest} request ListSchemaRevisionsRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.ListSchemaRevisionsCallback} callback Node-style callback called with the error, if any, and ListSchemaRevisionsResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.listSchemaRevisions = function listSchemaRevisions(request, callback) {
                        return this.rpcCall(listSchemaRevisions, $root.google.pubsub.v1.ListSchemaRevisionsRequest, $root.google.pubsub.v1.ListSchemaRevisionsResponse, request, callback);
                    }, "name", { value: "ListSchemaRevisions" });
    
                    /**
                     * Calls ListSchemaRevisions.
                     * @function listSchemaRevisions
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IListSchemaRevisionsRequest} request ListSchemaRevisionsRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ListSchemaRevisionsResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|commitSchema}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef CommitSchemaCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Schema} [response] Schema
                     */
    
                    /**
                     * Calls CommitSchema.
                     * @function commitSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.ICommitSchemaRequest} request CommitSchemaRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.CommitSchemaCallback} callback Node-style callback called with the error, if any, and Schema
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.commitSchema = function commitSchema(request, callback) {
                        return this.rpcCall(commitSchema, $root.google.pubsub.v1.CommitSchemaRequest, $root.google.pubsub.v1.Schema, request, callback);
                    }, "name", { value: "CommitSchema" });
    
                    /**
                     * Calls CommitSchema.
                     * @function commitSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.ICommitSchemaRequest} request CommitSchemaRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Schema>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|rollbackSchema}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef RollbackSchemaCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Schema} [response] Schema
                     */
    
                    /**
                     * Calls RollbackSchema.
                     * @function rollbackSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IRollbackSchemaRequest} request RollbackSchemaRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.RollbackSchemaCallback} callback Node-style callback called with the error, if any, and Schema
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.rollbackSchema = function rollbackSchema(request, callback) {
                        return this.rpcCall(rollbackSchema, $root.google.pubsub.v1.RollbackSchemaRequest, $root.google.pubsub.v1.Schema, request, callback);
                    }, "name", { value: "RollbackSchema" });
    
                    /**
                     * Calls RollbackSchema.
                     * @function rollbackSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IRollbackSchemaRequest} request RollbackSchemaRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Schema>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|deleteSchemaRevision}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef DeleteSchemaRevisionCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.Schema} [response] Schema
                     */
    
                    /**
                     * Calls DeleteSchemaRevision.
                     * @function deleteSchemaRevision
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSchemaRevisionRequest} request DeleteSchemaRevisionRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.DeleteSchemaRevisionCallback} callback Node-style callback called with the error, if any, and Schema
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.deleteSchemaRevision = function deleteSchemaRevision(request, callback) {
                        return this.rpcCall(deleteSchemaRevision, $root.google.pubsub.v1.DeleteSchemaRevisionRequest, $root.google.pubsub.v1.Schema, request, callback);
                    }, "name", { value: "DeleteSchemaRevision" });
    
                    /**
                     * Calls DeleteSchemaRevision.
                     * @function deleteSchemaRevision
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSchemaRevisionRequest} request DeleteSchemaRevisionRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.Schema>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|deleteSchema}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef DeleteSchemaCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.protobuf.Empty} [response] Empty
                     */
    
                    /**
                     * Calls DeleteSchema.
                     * @function deleteSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSchemaRequest} request DeleteSchemaRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.DeleteSchemaCallback} callback Node-style callback called with the error, if any, and Empty
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.deleteSchema = function deleteSchema(request, callback) {
                        return this.rpcCall(deleteSchema, $root.google.pubsub.v1.DeleteSchemaRequest, $root.google.protobuf.Empty, request, callback);
                    }, "name", { value: "DeleteSchema" });
    
                    /**
                     * Calls DeleteSchema.
                     * @function deleteSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IDeleteSchemaRequest} request DeleteSchemaRequest message or plain object
                     * @returns {Promise<google.protobuf.Empty>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|validateSchema}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef ValidateSchemaCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ValidateSchemaResponse} [response] ValidateSchemaResponse
                     */
    
                    /**
                     * Calls ValidateSchema.
                     * @function validateSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IValidateSchemaRequest} request ValidateSchemaRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.ValidateSchemaCallback} callback Node-style callback called with the error, if any, and ValidateSchemaResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.validateSchema = function validateSchema(request, callback) {
                        return this.rpcCall(validateSchema, $root.google.pubsub.v1.ValidateSchemaRequest, $root.google.pubsub.v1.ValidateSchemaResponse, request, callback);
                    }, "name", { value: "ValidateSchema" });
    
                    /**
                     * Calls ValidateSchema.
                     * @function validateSchema
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IValidateSchemaRequest} request ValidateSchemaRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ValidateSchemaResponse>} Promise
                     * @variation 2
                     */
    
                    /**
                     * Callback as used by {@link google.pubsub.v1.SchemaService|validateMessage}.
                     * @memberof google.pubsub.v1.SchemaService
                     * @typedef ValidateMessageCallback
                     * @type {function}
                     * @param {Error|null} error Error, if any
                     * @param {google.pubsub.v1.ValidateMessageResponse} [response] ValidateMessageResponse
                     */
    
                    /**
                     * Calls ValidateMessage.
                     * @function validateMessage
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IValidateMessageRequest} request ValidateMessageRequest message or plain object
                     * @param {google.pubsub.v1.SchemaService.ValidateMessageCallback} callback Node-style callback called with the error, if any, and ValidateMessageResponse
                     * @returns {undefined}
                     * @variation 1
                     */
                    Object.defineProperty(SchemaService.prototype.validateMessage = function validateMessage(request, callback) {
                        return this.rpcCall(validateMessage, $root.google.pubsub.v1.ValidateMessageRequest, $root.google.pubsub.v1.ValidateMessageResponse, request, callback);
                    }, "name", { value: "ValidateMessage" });
    
                    /**
                     * Calls ValidateMessage.
                     * @function validateMessage
                     * @memberof google.pubsub.v1.SchemaService
                     * @instance
                     * @param {google.pubsub.v1.IValidateMessageRequest} request ValidateMessageRequest message or plain object
                     * @returns {Promise<google.pubsub.v1.ValidateMessageResponse>} Promise
                     * @variation 2
                     */
    
                    return SchemaService;
                })();
    
                v1.Schema = (function() {
    
                    /**
                     * Properties of a Schema.
                     * @memberof google.pubsub.v1
                     * @interface ISchema
                     * @property {string|null} [name] Schema name
                     * @property {google.pubsub.v1.Schema.Type|null} [type] Schema type
                     * @property {string|null} [definition] Schema definition
                     * @property {string|null} [revisionId] Schema revisionId
                     * @property {google.protobuf.ITimestamp|null} [revisionCreateTime] Schema revisionCreateTime
                     */
    
                    /**
                     * Constructs a new Schema.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a Schema.
                     * @implements ISchema
                     * @constructor
                     * @param {google.pubsub.v1.ISchema=} [properties] Properties to set
                     */
                    function Schema(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * Schema name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.Schema
                     * @instance
                     */
                    Schema.prototype.name = "";
    
                    /**
                     * Schema type.
                     * @member {google.pubsub.v1.Schema.Type} type
                     * @memberof google.pubsub.v1.Schema
                     * @instance
                     */
                    Schema.prototype.type = 0;
    
                    /**
                     * Schema definition.
                     * @member {string} definition
                     * @memberof google.pubsub.v1.Schema
                     * @instance
                     */
                    Schema.prototype.definition = "";
    
                    /**
                     * Schema revisionId.
                     * @member {string} revisionId
                     * @memberof google.pubsub.v1.Schema
                     * @instance
                     */
                    Schema.prototype.revisionId = "";
    
                    /**
                     * Schema revisionCreateTime.
                     * @member {google.protobuf.ITimestamp|null|undefined} revisionCreateTime
                     * @memberof google.pubsub.v1.Schema
                     * @instance
                     */
                    Schema.prototype.revisionCreateTime = null;
    
                    /**
                     * Creates a new Schema instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {google.pubsub.v1.ISchema=} [properties] Properties to set
                     * @returns {google.pubsub.v1.Schema} Schema instance
                     */
                    Schema.create = function create(properties) {
                        return new Schema(properties);
                    };
    
                    /**
                     * Encodes the specified Schema message. Does not implicitly {@link google.pubsub.v1.Schema.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {google.pubsub.v1.ISchema} message Schema message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Schema.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.type);
                        if (message.definition != null && Object.hasOwnProperty.call(message, "definition"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.definition);
                        if (message.revisionId != null && Object.hasOwnProperty.call(message, "revisionId"))
                            writer.uint32(/* id 4, wireType 2 =*/34).string(message.revisionId);
                        if (message.revisionCreateTime != null && Object.hasOwnProperty.call(message, "revisionCreateTime"))
                            $root.google.protobuf.Timestamp.encode(message.revisionCreateTime, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                        return writer;
                    };
    
                    /**
                     * Encodes the specified Schema message, length delimited. Does not implicitly {@link google.pubsub.v1.Schema.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {google.pubsub.v1.ISchema} message Schema message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    Schema.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a Schema message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.Schema} Schema
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Schema.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.Schema();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.type = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.definition = reader.string();
                                    break;
                                }
                            case 4: {
                                    message.revisionId = reader.string();
                                    break;
                                }
                            case 6: {
                                    message.revisionCreateTime = $root.google.protobuf.Timestamp.decode(reader, reader.uint32());
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a Schema message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.Schema} Schema
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    Schema.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a Schema message.
                     * @function verify
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    Schema.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.type != null && message.hasOwnProperty("type"))
                            switch (message.type) {
                            default:
                                return "type: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        if (message.definition != null && message.hasOwnProperty("definition"))
                            if (!$util.isString(message.definition))
                                return "definition: string expected";
                        if (message.revisionId != null && message.hasOwnProperty("revisionId"))
                            if (!$util.isString(message.revisionId))
                                return "revisionId: string expected";
                        if (message.revisionCreateTime != null && message.hasOwnProperty("revisionCreateTime")) {
                            var error = $root.google.protobuf.Timestamp.verify(message.revisionCreateTime);
                            if (error)
                                return "revisionCreateTime." + error;
                        }
                        return null;
                    };
    
                    /**
                     * Creates a Schema message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.Schema} Schema
                     */
                    Schema.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.Schema)
                            return object;
                        var message = new $root.google.pubsub.v1.Schema();
                        if (object.name != null)
                            message.name = String(object.name);
                        switch (object.type) {
                        default:
                            if (typeof object.type === "number") {
                                message.type = object.type;
                                break;
                            }
                            break;
                        case "TYPE_UNSPECIFIED":
                        case 0:
                            message.type = 0;
                            break;
                        case "PROTOCOL_BUFFER":
                        case 1:
                            message.type = 1;
                            break;
                        case "AVRO":
                        case 2:
                            message.type = 2;
                            break;
                        }
                        if (object.definition != null)
                            message.definition = String(object.definition);
                        if (object.revisionId != null)
                            message.revisionId = String(object.revisionId);
                        if (object.revisionCreateTime != null) {
                            if (typeof object.revisionCreateTime !== "object")
                                throw TypeError(".google.pubsub.v1.Schema.revisionCreateTime: object expected");
                            message.revisionCreateTime = $root.google.protobuf.Timestamp.fromObject(object.revisionCreateTime);
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a Schema message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {google.pubsub.v1.Schema} message Schema
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    Schema.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.name = "";
                            object.type = options.enums === String ? "TYPE_UNSPECIFIED" : 0;
                            object.definition = "";
                            object.revisionId = "";
                            object.revisionCreateTime = null;
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        if (message.type != null && message.hasOwnProperty("type"))
                            object.type = options.enums === String ? $root.google.pubsub.v1.Schema.Type[message.type] === undefined ? message.type : $root.google.pubsub.v1.Schema.Type[message.type] : message.type;
                        if (message.definition != null && message.hasOwnProperty("definition"))
                            object.definition = message.definition;
                        if (message.revisionId != null && message.hasOwnProperty("revisionId"))
                            object.revisionId = message.revisionId;
                        if (message.revisionCreateTime != null && message.hasOwnProperty("revisionCreateTime"))
                            object.revisionCreateTime = $root.google.protobuf.Timestamp.toObject(message.revisionCreateTime, options);
                        return object;
                    };
    
                    /**
                     * Converts this Schema to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.Schema
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    Schema.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for Schema
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.Schema
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    Schema.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.Schema";
                    };
    
                    /**
                     * Type enum.
                     * @name google.pubsub.v1.Schema.Type
                     * @enum {number}
                     * @property {number} TYPE_UNSPECIFIED=0 TYPE_UNSPECIFIED value
                     * @property {number} PROTOCOL_BUFFER=1 PROTOCOL_BUFFER value
                     * @property {number} AVRO=2 AVRO value
                     */
                    Schema.Type = (function() {
                        var valuesById = {}, values = Object.create(valuesById);
                        values[valuesById[0] = "TYPE_UNSPECIFIED"] = 0;
                        values[valuesById[1] = "PROTOCOL_BUFFER"] = 1;
                        values[valuesById[2] = "AVRO"] = 2;
                        return values;
                    })();
    
                    return Schema;
                })();
    
                /**
                 * SchemaView enum.
                 * @name google.pubsub.v1.SchemaView
                 * @enum {number}
                 * @property {number} SCHEMA_VIEW_UNSPECIFIED=0 SCHEMA_VIEW_UNSPECIFIED value
                 * @property {number} BASIC=1 BASIC value
                 * @property {number} FULL=2 FULL value
                 */
                v1.SchemaView = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "SCHEMA_VIEW_UNSPECIFIED"] = 0;
                    values[valuesById[1] = "BASIC"] = 1;
                    values[valuesById[2] = "FULL"] = 2;
                    return values;
                })();
    
                v1.CreateSchemaRequest = (function() {
    
                    /**
                     * Properties of a CreateSchemaRequest.
                     * @memberof google.pubsub.v1
                     * @interface ICreateSchemaRequest
                     * @property {string|null} [parent] CreateSchemaRequest parent
                     * @property {google.pubsub.v1.ISchema|null} [schema] CreateSchemaRequest schema
                     * @property {string|null} [schemaId] CreateSchemaRequest schemaId
                     */
    
                    /**
                     * Constructs a new CreateSchemaRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a CreateSchemaRequest.
                     * @implements ICreateSchemaRequest
                     * @constructor
                     * @param {google.pubsub.v1.ICreateSchemaRequest=} [properties] Properties to set
                     */
                    function CreateSchemaRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * CreateSchemaRequest parent.
                     * @member {string} parent
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @instance
                     */
                    CreateSchemaRequest.prototype.parent = "";
    
                    /**
                     * CreateSchemaRequest schema.
                     * @member {google.pubsub.v1.ISchema|null|undefined} schema
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @instance
                     */
                    CreateSchemaRequest.prototype.schema = null;
    
                    /**
                     * CreateSchemaRequest schemaId.
                     * @member {string} schemaId
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @instance
                     */
                    CreateSchemaRequest.prototype.schemaId = "";
    
                    /**
                     * Creates a new CreateSchemaRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {google.pubsub.v1.ICreateSchemaRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.CreateSchemaRequest} CreateSchemaRequest instance
                     */
                    CreateSchemaRequest.create = function create(properties) {
                        return new CreateSchemaRequest(properties);
                    };
    
                    /**
                     * Encodes the specified CreateSchemaRequest message. Does not implicitly {@link google.pubsub.v1.CreateSchemaRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {google.pubsub.v1.ICreateSchemaRequest} message CreateSchemaRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CreateSchemaRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                        if (message.schema != null && Object.hasOwnProperty.call(message, "schema"))
                            $root.google.pubsub.v1.Schema.encode(message.schema, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                        if (message.schemaId != null && Object.hasOwnProperty.call(message, "schemaId"))
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.schemaId);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified CreateSchemaRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.CreateSchemaRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {google.pubsub.v1.ICreateSchemaRequest} message CreateSchemaRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    CreateSchemaRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a CreateSchemaRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.CreateSchemaRequest} CreateSchemaRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CreateSchemaRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.CreateSchemaRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.parent = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.schema = $root.google.pubsub.v1.Schema.decode(reader, reader.uint32());
                                    break;
                                }
                            case 3: {
                                    message.schemaId = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a CreateSchemaRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.CreateSchemaRequest} CreateSchemaRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    CreateSchemaRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a CreateSchemaRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    CreateSchemaRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.parent != null && message.hasOwnProperty("parent"))
                            if (!$util.isString(message.parent))
                                return "parent: string expected";
                        if (message.schema != null && message.hasOwnProperty("schema")) {
                            var error = $root.google.pubsub.v1.Schema.verify(message.schema);
                            if (error)
                                return "schema." + error;
                        }
                        if (message.schemaId != null && message.hasOwnProperty("schemaId"))
                            if (!$util.isString(message.schemaId))
                                return "schemaId: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a CreateSchemaRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.CreateSchemaRequest} CreateSchemaRequest
                     */
                    CreateSchemaRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.CreateSchemaRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.CreateSchemaRequest();
                        if (object.parent != null)
                            message.parent = String(object.parent);
                        if (object.schema != null) {
                            if (typeof object.schema !== "object")
                                throw TypeError(".google.pubsub.v1.CreateSchemaRequest.schema: object expected");
                            message.schema = $root.google.pubsub.v1.Schema.fromObject(object.schema);
                        }
                        if (object.schemaId != null)
                            message.schemaId = String(object.schemaId);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a CreateSchemaRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {google.pubsub.v1.CreateSchemaRequest} message CreateSchemaRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    CreateSchemaRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.parent = "";
                            object.schema = null;
                            object.schemaId = "";
                        }
                        if (message.parent != null && message.hasOwnProperty("parent"))
                            object.parent = message.parent;
                        if (message.schema != null && message.hasOwnProperty("schema"))
                            object.schema = $root.google.pubsub.v1.Schema.toObject(message.schema, options);
                        if (message.schemaId != null && message.hasOwnProperty("schemaId"))
                            object.schemaId = message.schemaId;
                        return object;
                    };
    
                    /**
                     * Converts this CreateSchemaRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    CreateSchemaRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for CreateSchemaRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.CreateSchemaRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    CreateSchemaRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.CreateSchemaRequest";
                    };
    
                    return CreateSchemaRequest;
                })();
    
                v1.GetSchemaRequest = (function() {
    
                    /**
                     * Properties of a GetSchemaRequest.
                     * @memberof google.pubsub.v1
                     * @interface IGetSchemaRequest
                     * @property {string|null} [name] GetSchemaRequest name
                     * @property {google.pubsub.v1.SchemaView|null} [view] GetSchemaRequest view
                     */
    
                    /**
                     * Constructs a new GetSchemaRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a GetSchemaRequest.
                     * @implements IGetSchemaRequest
                     * @constructor
                     * @param {google.pubsub.v1.IGetSchemaRequest=} [properties] Properties to set
                     */
                    function GetSchemaRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * GetSchemaRequest name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @instance
                     */
                    GetSchemaRequest.prototype.name = "";
    
                    /**
                     * GetSchemaRequest view.
                     * @member {google.pubsub.v1.SchemaView} view
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @instance
                     */
                    GetSchemaRequest.prototype.view = 0;
    
                    /**
                     * Creates a new GetSchemaRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSchemaRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.GetSchemaRequest} GetSchemaRequest instance
                     */
                    GetSchemaRequest.create = function create(properties) {
                        return new GetSchemaRequest(properties);
                    };
    
                    /**
                     * Encodes the specified GetSchemaRequest message. Does not implicitly {@link google.pubsub.v1.GetSchemaRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSchemaRequest} message GetSchemaRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetSchemaRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.view != null && Object.hasOwnProperty.call(message, "view"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.view);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified GetSchemaRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.GetSchemaRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {google.pubsub.v1.IGetSchemaRequest} message GetSchemaRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    GetSchemaRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a GetSchemaRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.GetSchemaRequest} GetSchemaRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetSchemaRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.GetSchemaRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.view = reader.int32();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a GetSchemaRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.GetSchemaRequest} GetSchemaRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    GetSchemaRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a GetSchemaRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    GetSchemaRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.view != null && message.hasOwnProperty("view"))
                            switch (message.view) {
                            default:
                                return "view: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        return null;
                    };
    
                    /**
                     * Creates a GetSchemaRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.GetSchemaRequest} GetSchemaRequest
                     */
                    GetSchemaRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.GetSchemaRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.GetSchemaRequest();
                        if (object.name != null)
                            message.name = String(object.name);
                        switch (object.view) {
                        default:
                            if (typeof object.view === "number") {
                                message.view = object.view;
                                break;
                            }
                            break;
                        case "SCHEMA_VIEW_UNSPECIFIED":
                        case 0:
                            message.view = 0;
                            break;
                        case "BASIC":
                        case 1:
                            message.view = 1;
                            break;
                        case "FULL":
                        case 2:
                            message.view = 2;
                            break;
                        }
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a GetSchemaRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {google.pubsub.v1.GetSchemaRequest} message GetSchemaRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    GetSchemaRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.name = "";
                            object.view = options.enums === String ? "SCHEMA_VIEW_UNSPECIFIED" : 0;
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        if (message.view != null && message.hasOwnProperty("view"))
                            object.view = options.enums === String ? $root.google.pubsub.v1.SchemaView[message.view] === undefined ? message.view : $root.google.pubsub.v1.SchemaView[message.view] : message.view;
                        return object;
                    };
    
                    /**
                     * Converts this GetSchemaRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    GetSchemaRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for GetSchemaRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.GetSchemaRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    GetSchemaRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.GetSchemaRequest";
                    };
    
                    return GetSchemaRequest;
                })();
    
                v1.ListSchemasRequest = (function() {
    
                    /**
                     * Properties of a ListSchemasRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListSchemasRequest
                     * @property {string|null} [parent] ListSchemasRequest parent
                     * @property {google.pubsub.v1.SchemaView|null} [view] ListSchemasRequest view
                     * @property {number|null} [pageSize] ListSchemasRequest pageSize
                     * @property {string|null} [pageToken] ListSchemasRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListSchemasRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListSchemasRequest.
                     * @implements IListSchemasRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListSchemasRequest=} [properties] Properties to set
                     */
                    function ListSchemasRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListSchemasRequest parent.
                     * @member {string} parent
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @instance
                     */
                    ListSchemasRequest.prototype.parent = "";
    
                    /**
                     * ListSchemasRequest view.
                     * @member {google.pubsub.v1.SchemaView} view
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @instance
                     */
                    ListSchemasRequest.prototype.view = 0;
    
                    /**
                     * ListSchemasRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @instance
                     */
                    ListSchemasRequest.prototype.pageSize = 0;
    
                    /**
                     * ListSchemasRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @instance
                     */
                    ListSchemasRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListSchemasRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {google.pubsub.v1.IListSchemasRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListSchemasRequest} ListSchemasRequest instance
                     */
                    ListSchemasRequest.create = function create(properties) {
                        return new ListSchemasRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListSchemasRequest message. Does not implicitly {@link google.pubsub.v1.ListSchemasRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {google.pubsub.v1.IListSchemasRequest} message ListSchemasRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSchemasRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.parent != null && Object.hasOwnProperty.call(message, "parent"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.parent);
                        if (message.view != null && Object.hasOwnProperty.call(message, "view"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.view);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 3, wireType 0 =*/24).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 4, wireType 2 =*/34).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListSchemasRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListSchemasRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {google.pubsub.v1.IListSchemasRequest} message ListSchemasRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSchemasRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListSchemasRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListSchemasRequest} ListSchemasRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSchemasRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListSchemasRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.parent = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.view = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 4: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListSchemasRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListSchemasRequest} ListSchemasRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSchemasRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListSchemasRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListSchemasRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.parent != null && message.hasOwnProperty("parent"))
                            if (!$util.isString(message.parent))
                                return "parent: string expected";
                        if (message.view != null && message.hasOwnProperty("view"))
                            switch (message.view) {
                            default:
                                return "view: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListSchemasRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListSchemasRequest} ListSchemasRequest
                     */
                    ListSchemasRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListSchemasRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListSchemasRequest();
                        if (object.parent != null)
                            message.parent = String(object.parent);
                        switch (object.view) {
                        default:
                            if (typeof object.view === "number") {
                                message.view = object.view;
                                break;
                            }
                            break;
                        case "SCHEMA_VIEW_UNSPECIFIED":
                        case 0:
                            message.view = 0;
                            break;
                        case "BASIC":
                        case 1:
                            message.view = 1;
                            break;
                        case "FULL":
                        case 2:
                            message.view = 2;
                            break;
                        }
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListSchemasRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {google.pubsub.v1.ListSchemasRequest} message ListSchemasRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListSchemasRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.parent = "";
                            object.view = options.enums === String ? "SCHEMA_VIEW_UNSPECIFIED" : 0;
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.parent != null && message.hasOwnProperty("parent"))
                            object.parent = message.parent;
                        if (message.view != null && message.hasOwnProperty("view"))
                            object.view = options.enums === String ? $root.google.pubsub.v1.SchemaView[message.view] === undefined ? message.view : $root.google.pubsub.v1.SchemaView[message.view] : message.view;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListSchemasRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListSchemasRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListSchemasRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListSchemasRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListSchemasRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListSchemasRequest";
                    };
    
                    return ListSchemasRequest;
                })();
    
                v1.ListSchemasResponse = (function() {
    
                    /**
                     * Properties of a ListSchemasResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListSchemasResponse
                     * @property {Array.<google.pubsub.v1.ISchema>|null} [schemas] ListSchemasResponse schemas
                     * @property {string|null} [nextPageToken] ListSchemasResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListSchemasResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListSchemasResponse.
                     * @implements IListSchemasResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListSchemasResponse=} [properties] Properties to set
                     */
                    function ListSchemasResponse(properties) {
                        this.schemas = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListSchemasResponse schemas.
                     * @member {Array.<google.pubsub.v1.ISchema>} schemas
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @instance
                     */
                    ListSchemasResponse.prototype.schemas = $util.emptyArray;
    
                    /**
                     * ListSchemasResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @instance
                     */
                    ListSchemasResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListSchemasResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {google.pubsub.v1.IListSchemasResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListSchemasResponse} ListSchemasResponse instance
                     */
                    ListSchemasResponse.create = function create(properties) {
                        return new ListSchemasResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListSchemasResponse message. Does not implicitly {@link google.pubsub.v1.ListSchemasResponse.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {google.pubsub.v1.IListSchemasResponse} message ListSchemasResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSchemasResponse.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.schemas != null && message.schemas.length)
                            for (var i = 0; i < message.schemas.length; ++i)
                                $root.google.pubsub.v1.Schema.encode(message.schemas[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                        if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                            writer.uint32(/* id 2, wireType 2 =*/18).string(message.nextPageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListSchemasResponse message, length delimited. Does not implicitly {@link google.pubsub.v1.ListSchemasResponse.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {google.pubsub.v1.IListSchemasResponse} message ListSchemasResponse message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSchemasResponse.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListSchemasResponse message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListSchemasResponse} ListSchemasResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSchemasResponse.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListSchemasResponse();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    if (!(message.schemas && message.schemas.length))
                                        message.schemas = [];
                                    message.schemas.push($root.google.pubsub.v1.Schema.decode(reader, reader.uint32()));
                                    break;
                                }
                            case 2: {
                                    message.nextPageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListSchemasResponse message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListSchemasResponse} ListSchemasResponse
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSchemasResponse.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListSchemasResponse message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListSchemasResponse.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.schemas != null && message.hasOwnProperty("schemas")) {
                            if (!Array.isArray(message.schemas))
                                return "schemas: array expected";
                            for (var i = 0; i < message.schemas.length; ++i) {
                                var error = $root.google.pubsub.v1.Schema.verify(message.schemas[i]);
                                if (error)
                                    return "schemas." + error;
                            }
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            if (!$util.isString(message.nextPageToken))
                                return "nextPageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListSchemasResponse message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListSchemasResponse} ListSchemasResponse
                     */
                    ListSchemasResponse.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListSchemasResponse)
                            return object;
                        var message = new $root.google.pubsub.v1.ListSchemasResponse();
                        if (object.schemas) {
                            if (!Array.isArray(object.schemas))
                                throw TypeError(".google.pubsub.v1.ListSchemasResponse.schemas: array expected");
                            message.schemas = [];
                            for (var i = 0; i < object.schemas.length; ++i) {
                                if (typeof object.schemas[i] !== "object")
                                    throw TypeError(".google.pubsub.v1.ListSchemasResponse.schemas: object expected");
                                message.schemas[i] = $root.google.pubsub.v1.Schema.fromObject(object.schemas[i]);
                            }
                        }
                        if (object.nextPageToken != null)
                            message.nextPageToken = String(object.nextPageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListSchemasResponse message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {google.pubsub.v1.ListSchemasResponse} message ListSchemasResponse
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListSchemasResponse.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.arrays || options.defaults)
                            object.schemas = [];
                        if (options.defaults)
                            object.nextPageToken = "";
                        if (message.schemas && message.schemas.length) {
                            object.schemas = [];
                            for (var j = 0; j < message.schemas.length; ++j)
                                object.schemas[j] = $root.google.pubsub.v1.Schema.toObject(message.schemas[j], options);
                        }
                        if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken"))
                            object.nextPageToken = message.nextPageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListSchemasResponse to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListSchemasResponse.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListSchemasResponse
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListSchemasResponse
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListSchemasResponse.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListSchemasResponse";
                    };
    
                    return ListSchemasResponse;
                })();
    
                v1.ListSchemaRevisionsRequest = (function() {
    
                    /**
                     * Properties of a ListSchemaRevisionsRequest.
                     * @memberof google.pubsub.v1
                     * @interface IListSchemaRevisionsRequest
                     * @property {string|null} [name] ListSchemaRevisionsRequest name
                     * @property {google.pubsub.v1.SchemaView|null} [view] ListSchemaRevisionsRequest view
                     * @property {number|null} [pageSize] ListSchemaRevisionsRequest pageSize
                     * @property {string|null} [pageToken] ListSchemaRevisionsRequest pageToken
                     */
    
                    /**
                     * Constructs a new ListSchemaRevisionsRequest.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListSchemaRevisionsRequest.
                     * @implements IListSchemaRevisionsRequest
                     * @constructor
                     * @param {google.pubsub.v1.IListSchemaRevisionsRequest=} [properties] Properties to set
                     */
                    function ListSchemaRevisionsRequest(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListSchemaRevisionsRequest name.
                     * @member {string} name
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @instance
                     */
                    ListSchemaRevisionsRequest.prototype.name = "";
    
                    /**
                     * ListSchemaRevisionsRequest view.
                     * @member {google.pubsub.v1.SchemaView} view
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @instance
                     */
                    ListSchemaRevisionsRequest.prototype.view = 0;
    
                    /**
                     * ListSchemaRevisionsRequest pageSize.
                     * @member {number} pageSize
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @instance
                     */
                    ListSchemaRevisionsRequest.prototype.pageSize = 0;
    
                    /**
                     * ListSchemaRevisionsRequest pageToken.
                     * @member {string} pageToken
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @instance
                     */
                    ListSchemaRevisionsRequest.prototype.pageToken = "";
    
                    /**
                     * Creates a new ListSchemaRevisionsRequest instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSchemaRevisionsRequest=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListSchemaRevisionsRequest} ListSchemaRevisionsRequest instance
                     */
                    ListSchemaRevisionsRequest.create = function create(properties) {
                        return new ListSchemaRevisionsRequest(properties);
                    };
    
                    /**
                     * Encodes the specified ListSchemaRevisionsRequest message. Does not implicitly {@link google.pubsub.v1.ListSchemaRevisionsRequest.verify|verify} messages.
                     * @function encode
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSchemaRevisionsRequest} message ListSchemaRevisionsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSchemaRevisionsRequest.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                            writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                        if (message.view != null && Object.hasOwnProperty.call(message, "view"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.view);
                        if (message.pageSize != null && Object.hasOwnProperty.call(message, "pageSize"))
                            writer.uint32(/* id 3, wireType 0 =*/24).int32(message.pageSize);
                        if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                            writer.uint32(/* id 4, wireType 2 =*/34).string(message.pageToken);
                        return writer;
                    };
    
                    /**
                     * Encodes the specified ListSchemaRevisionsRequest message, length delimited. Does not implicitly {@link google.pubsub.v1.ListSchemaRevisionsRequest.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {google.pubsub.v1.IListSchemaRevisionsRequest} message ListSchemaRevisionsRequest message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ListSchemaRevisionsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };
    
                    /**
                     * Decodes a ListSchemaRevisionsRequest message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.pubsub.v1.ListSchemaRevisionsRequest} ListSchemaRevisionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSchemaRevisionsRequest.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.pubsub.v1.ListSchemaRevisionsRequest();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1: {
                                    message.name = reader.string();
                                    break;
                                }
                            case 2: {
                                    message.view = reader.int32();
                                    break;
                                }
                            case 3: {
                                    message.pageSize = reader.int32();
                                    break;
                                }
                            case 4: {
                                    message.pageToken = reader.string();
                                    break;
                                }
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };
    
                    /**
                     * Decodes a ListSchemaRevisionsRequest message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.pubsub.v1.ListSchemaRevisionsRequest} ListSchemaRevisionsRequest
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ListSchemaRevisionsRequest.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };
    
                    /**
                     * Verifies a ListSchemaRevisionsRequest message.
                     * @function verify
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ListSchemaRevisionsRequest.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.name != null && message.hasOwnProperty("name"))
                            if (!$util.isString(message.name))
                                return "name: string expected";
                        if (message.view != null && message.hasOwnProperty("view"))
                            switch (message.view) {
                            default:
                                return "view: enum value expected";
                            case 0:
                            case 1:
                            case 2:
                                break;
                            }
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            if (!$util.isInteger(message.pageSize))
                                return "pageSize: integer expected";
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            if (!$util.isString(message.pageToken))
                                return "pageToken: string expected";
                        return null;
                    };
    
                    /**
                     * Creates a ListSchemaRevisionsRequest message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.pubsub.v1.ListSchemaRevisionsRequest} ListSchemaRevisionsRequest
                     */
                    ListSchemaRevisionsRequest.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.pubsub.v1.ListSchemaRevisionsRequest)
                            return object;
                        var message = new $root.google.pubsub.v1.ListSchemaRevisionsRequest();
                        if (object.name != null)
                            message.name = String(object.name);
                        switch (object.view) {
                        default:
                            if (typeof object.view === "number") {
                                message.view = object.view;
                                break;
                            }
                            break;
                        case "SCHEMA_VIEW_UNSPECIFIED":
                        case 0:
                            message.view = 0;
                            break;
                        case "BASIC":
                        case 1:
                            message.view = 1;
                            break;
                        case "FULL":
                        case 2:
                            message.view = 2;
                            break;
                        }
                        if (object.pageSize != null)
                            message.pageSize = object.pageSize | 0;
                        if (object.pageToken != null)
                            message.pageToken = String(object.pageToken);
                        return message;
                    };
    
                    /**
                     * Creates a plain object from a ListSchemaRevisionsRequest message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {google.pubsub.v1.ListSchemaRevisionsRequest} message ListSchemaRevisionsRequest
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ListSchemaRevisionsRequest.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.name = "";
                            object.view = options.enums === String ? "SCHEMA_VIEW_UNSPECIFIED" : 0;
                            object.pageSize = 0;
                            object.pageToken = "";
                        }
                        if (message.name != null && message.hasOwnProperty("name"))
                            object.name = message.name;
                        if (message.view != null && message.hasOwnProperty("view"))
                            object.view = options.enums === String ? $root.google.pubsub.v1.SchemaView[message.view] === undefined ? message.view : $root.google.pubsub.v1.SchemaView[message.view] : message.view;
                        if (message.pageSize != null && message.hasOwnProperty("pageSize"))
                            object.pageSize = message.pageSize;
                        if (message.pageToken != null && message.hasOwnProperty("pageToken"))
                            object.pageToken = message.pageToken;
                        return object;
                    };
    
                    /**
                     * Converts this ListSchemaRevisionsRequest to JSON.
                     * @function toJSON
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ListSchemaRevisionsRequest.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };
    
                    /**
                     * Gets the default type url for ListSchemaRevisionsRequest
                     * @function getTypeUrl
                     * @memberof google.pubsub.v1.ListSchemaRevisionsRequest
                     * @static
                     * @param {string} [typeUrlPrefix] your custom typeUrlPrefix(default "type.googleapis.com")
                     * @returns {string} The default type url
                     */
                    ListSchemaRevisionsRequest.getTypeUrl = function getTypeUrl(typeUrlPrefix) {
                        if (typeUrlPrefix === undefined) {
                            typeUrlPrefix = "type.googleapis.com";
                        }
                        return typeUrlPrefix + "/google.pubsub.v1.ListSchemaRevisionsRequest";
                    };
    
                    return ListSchemaRevisionsRequest;
                })();
    
                v1.ListSchemaRevisionsResponse = (function() {
    
                    /**
                     * Properties of a ListSchemaRevisionsResponse.
                     * @memberof google.pubsub.v1
                     * @interface IListSchemaRevisionsResponse
                     * @property {Array.<google.pubsub.v1.ISchema>|null} [schemas] ListSchemaRevisionsResponse schemas
                     * @property {string|null} [nextPageToken] ListSchemaRevisionsResponse nextPageToken
                     */
    
                    /**
                     * Constructs a new ListSchemaRevisionsResponse.
                     * @memberof google.pubsub.v1
                     * @classdesc Represents a ListSchemaRevisionsResponse.
                     * @implements IListSchemaRevisionsResponse
                     * @constructor
                     * @param {google.pubsub.v1.IListSchemaRevisionsResponse=} [properties] Properties to set
                     */
                    function ListSchemaRevisionsResponse(properties) {
                        this.schemas = [];
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }
    
                    /**
                     * ListSchemaRevisionsResponse schemas.
                     * @member {Array.<google.pubsub.v1.ISchema>} schemas
                     * @memberof google.pubsub.v1.ListSchemaRevisionsResponse
                     * @instance
                     */
                    ListSchemaRevisionsResponse.prototype.schemas = $util.emptyArray;
    
                    /**
                     * ListSchemaRevisionsResponse nextPageToken.
                     * @member {string} nextPageToken
                     * @memberof google.pubsub.v1.ListSchemaRevisionsResponse
                     * @instance
                     */
                    ListSchemaRevisionsResponse.prototype.nextPageToken = "";
    
                    /**
                     * Creates a new ListSchemaRevisionsResponse instance using the specified properties.
                     * @function create
                     * @memberof google.pubsub.v1.ListSchemaRevisionsResponse
                     * @static
                     * @param {google.pubsub.v1.IListSchemaRevisionsResponse=} [properties] Properties to set
                     * @returns {google.pubsub.v1.ListSchemaRevisionsResponse} ListSchemaRevisionsResponse instance
                     */
                    ListSchemaRevisionsResponse.create = function create(properties) {
                        return new ListSchemaRevisionsResponse(properties);
                    };
    
                    /**
                     * Encodes the specified ListSchemaRevisionsResponse message. Does not implicitly {@link google.pubsub.v1.ListSchemaRevisionsResponse.verify|verify} messages.
           