"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConfig = exports.getDevModeHandle = exports.ɵcodegenFunctionsDirectory = exports.ɵcodegenPublicDirectory = exports.build = exports.discover = exports.type = exports.support = exports.name = void 0;
const fs_extra_1 = require("fs-extra");
const promises_1 = require("fs/promises");
const path_1 = require("path");
const semver_1 = require("semver");
const cross_spawn_1 = require("cross-spawn");
const utils_1 = require("../utils");
const utils_2 = require("./utils");
exports.name = "Nuxt";
exports.support = "experimental";
exports.type = 4;
const utils_3 = require("./utils");
const DEFAULT_BUILD_SCRIPT = ["nuxt build", "nuxi build"];
async function discover(dir) {
    if (!(await (0, fs_extra_1.pathExists)((0, path_1.join)(dir, "package.json"))))
        return;
    const anyConfigFileExists = await (0, utils_3.nuxtConfigFilesExist)(dir);
    const nuxtVersion = (0, utils_2.getNuxtVersion)(dir);
    if (!anyConfigFileExists && !nuxtVersion)
        return;
    if (nuxtVersion && (0, semver_1.lt)(nuxtVersion, "3.0.0-0"))
        return;
    const { dir: { public: publicDirectory }, } = await getConfig(dir);
    return { publicDirectory, mayWantBackend: true };
}
exports.discover = discover;
async function build(root) {
    const { buildNuxt } = await (0, utils_1.relativeRequire)(root, "@nuxt/kit");
    const nuxtApp = await getNuxt3App(root);
    await (0, utils_1.warnIfCustomBuildScript)(root, exports.name, DEFAULT_BUILD_SCRIPT);
    await buildNuxt(nuxtApp);
    return { wantsBackend: true };
}
exports.build = build;
async function getNuxt3App(cwd) {
    const { loadNuxt } = await (0, utils_1.relativeRequire)(cwd, "@nuxt/kit");
    return await loadNuxt({
        cwd,
        overrides: {
            nitro: { preset: "node" },
        },
    });
}
async function ɵcodegenPublicDirectory(root, dest) {
    const distPath = (0, path_1.join)(root, ".output", "public");
    await (0, fs_extra_1.copy)(distPath, dest);
}
exports.ɵcodegenPublicDirectory = ɵcodegenPublicDirectory;
async function ɵcodegenFunctionsDirectory(sourceDir, destDir) {
    const packageJsonBuffer = await (0, promises_1.readFile)((0, path_1.join)(sourceDir, "package.json"));
    const packageJson = JSON.parse(packageJsonBuffer.toString());
    const outputPackageJsonBuffer = await (0, promises_1.readFile)((0, path_1.join)(sourceDir, ".output", "server", "package.json"));
    const outputPackageJson = JSON.parse(outputPackageJsonBuffer.toString());
    await (0, fs_extra_1.copy)((0, path_1.join)(sourceDir, ".output", "server"), destDir);
    return { packageJson: Object.assign(Object.assign({}, packageJson), outputPackageJson), frameworksEntry: "nuxt3" };
}
exports.ɵcodegenFunctionsDirectory = ɵcodegenFunctionsDirectory;
async function getDevModeHandle(cwd) {
    const host = new Promise((resolve) => {
        const cli = (0, utils_1.getNodeModuleBin)("nuxt", cwd);
        const serve = (0, cross_spawn_1.spawn)(cli, ["dev"], { cwd: cwd });
        serve.stdout.on("data", (data) => {
            process.stdout.write(data);
            const match = data.toString().match(/(http:\/\/.+:\d+)/);
            if (match)
                resolve(match[1]);
        });
        serve.stderr.on("data", (data) => {
            process.stderr.write(data);
        });
    });
    return (0, utils_1.simpleProxy)(await host);
}
exports.getDevModeHandle = getDevModeHandle;
async function getConfig(dir) {
    const { loadNuxtConfig } = await (0, utils_1.relativeRequire)(dir, "@nuxt/kit");
    return await loadNuxtConfig(dir);
}
exports.getConfig = getConfig;
