"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ɵcodegenPublicDirectory = exports.build = exports.discover = exports.support = exports.type = exports.name = void 0;
const cross_spawn_1 = require("cross-spawn");
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const js_yaml_1 = require("js-yaml");
const promises_1 = require("fs/promises");
const error_1 = require("../../error");
const utils_1 = require("./utils");
exports.name = "Flutter";
exports.type = 3;
exports.support = "experimental";
async function discover(dir) {
    var _a;
    if (!(await (0, fs_extra_1.pathExists)((0, path_1.join)(dir, "pubspec.yaml"))))
        return;
    if (!(await (0, fs_extra_1.pathExists)((0, path_1.join)(dir, "web"))))
        return;
    const pubSpecBuffer = await (0, promises_1.readFile)((0, path_1.join)(dir, "pubspec.yaml"));
    const pubSpec = (0, js_yaml_1.load)(pubSpecBuffer.toString());
    const usingFlutter = (_a = pubSpec.dependencies) === null || _a === void 0 ? void 0 : _a.flutter;
    if (!usingFlutter)
        return;
    return { mayWantBackend: false, publicDirectory: (0, path_1.join)(dir, "web") };
}
exports.discover = discover;
function build(cwd) {
    (0, utils_1.assertFlutterCliExists)();
    const build = (0, cross_spawn_1.sync)("flutter", ["build", "web"], { cwd, stdio: "inherit" });
    if (build.status)
        throw new error_1.FirebaseError("Unable to build your Flutter app");
    return Promise.resolve({ wantsBackend: false });
}
exports.build = build;
async function ɵcodegenPublicDirectory(sourceDir, destDir) {
    await (0, fs_extra_1.copy)((0, path_1.join)(sourceDir, "build", "web"), destDir);
}
exports.ɵcodegenPublicDirectory = ɵcodegenPublicDirectory;
