"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDevModeHandle = exports.ɵcodegenFunctionsDirectory = exports.ɵcodegenPublicDirectory = exports.build = exports.discover = exports.type = exports.support = exports.name = void 0;
const cross_spawn_1 = require("cross-spawn");
const fs_extra_1 = require("fs-extra");
const path_1 = require("path");
const error_1 = require("../../error");
const utils_1 = require("../utils");
const utils_2 = require("./utils");
exports.name = "Astro";
exports.support = "experimental";
exports.type = 2;
function getAstroVersion(cwd) {
    var _a;
    return (_a = (0, utils_1.findDependency)("astro", { cwd, depth: 0, omitDev: false })) === null || _a === void 0 ? void 0 : _a.version;
}
async function discover(dir) {
    if (!(0, fs_extra_1.existsSync)((0, path_1.join)(dir, "package.json")))
        return;
    if (!getAstroVersion(dir))
        return;
    const { output, publicDir: publicDirectory } = await (0, utils_2.getConfig)(dir);
    return {
        mayWantBackend: output === "server",
        publicDirectory,
    };
}
exports.discover = discover;
const DEFAULT_BUILD_SCRIPT = ["astro build"];
async function build(cwd) {
    const cli = (0, utils_1.getNodeModuleBin)("astro", cwd);
    await (0, utils_1.warnIfCustomBuildScript)(cwd, exports.name, DEFAULT_BUILD_SCRIPT);
    const { output, adapter } = await (0, utils_2.getConfig)(cwd);
    if (output === "server" && (adapter === null || adapter === void 0 ? void 0 : adapter.name) !== "@astrojs/node") {
        throw new error_1.FirebaseError("Deploying an Astro application with SSR on Firebase Hosting requires the @astrojs/node adapter.");
    }
    const build = (0, cross_spawn_1.sync)(cli, ["build"], { cwd, stdio: "inherit" });
    if (build.status)
        throw new error_1.FirebaseError("Unable to build your Astro app");
    return { wantsBackend: output === "server" };
}
exports.build = build;
async function ɵcodegenPublicDirectory(root, dest) {
    const { outDir, output } = await (0, utils_2.getConfig)(root);
    const assetPath = (0, path_1.join)(root, outDir, output === "server" ? "client" : "");
    await (0, fs_extra_1.copy)(assetPath, dest);
}
exports.ɵcodegenPublicDirectory = ɵcodegenPublicDirectory;
async function ɵcodegenFunctionsDirectory(sourceDir, destDir) {
    const { outDir } = await (0, utils_2.getConfig)(sourceDir);
    const packageJson = await (0, utils_1.readJSON)((0, path_1.join)(sourceDir, "package.json"));
    await (0, fs_extra_1.copy)((0, path_1.join)(sourceDir, outDir, "server"), (0, path_1.join)(destDir));
    return {
        packageJson,
        bootstrapScript: (0, utils_2.getBootstrapScript)(),
    };
}
exports.ɵcodegenFunctionsDirectory = ɵcodegenFunctionsDirectory;
async function getDevModeHandle(cwd) {
    const host = new Promise((resolve) => {
        const cli = (0, utils_1.getNodeModuleBin)("astro", cwd);
        const serve = (0, cross_spawn_1.spawn)(cli, ["dev"], { cwd });
        serve.stdout.on("data", (data) => {
            process.stdout.write(data);
            const match = data.toString().match(/(http:\/\/.+:\d+)/);
            if (match)
                resolve(match[1]);
        });
        serve.stderr.on("data", (data) => {
            process.stderr.write(data);
        });
    });
    return (0, utils_1.simpleProxy)(await host);
}
exports.getDevModeHandle = getDevModeHandle;
