"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAppName = exports.getProjectName = exports.ensureFileExists = exports.getEmails = exports.getTestersOrGroups = void 0;
const fs = require("fs-extra");
const error_1 = require("../error");
const projectUtils_1 = require("../projectUtils");
function getTestersOrGroups(value, file) {
    if (!value && file) {
        ensureFileExists(file);
        value = fs.readFileSync(file, "utf8");
    }
    if (value) {
        return splitter(value);
    }
    return [];
}
exports.getTestersOrGroups = getTestersOrGroups;
function getEmails(emails, file) {
    if (emails.length === 0) {
        ensureFileExists(file);
        const readFile = fs.readFileSync(file, "utf8");
        return splitter(readFile);
    }
    return emails;
}
exports.getEmails = getEmails;
function ensureFileExists(file, message = "") {
    if (!fs.existsSync(file)) {
        throw new error_1.FirebaseError(`File ${file} does not exist: ${message}`);
    }
}
exports.ensureFileExists = ensureFileExists;
function splitter(value) {
    return value
        .split(/[,\n]/)
        .map((entry) => entry.trim())
        .filter((entry) => !!entry);
}
async function getProjectName(options) {
    const projectNumber = await (0, projectUtils_1.needProjectNumber)(options);
    return `projects/${projectNumber}`;
}
exports.getProjectName = getProjectName;
function getAppName(options) {
    if (!options.app) {
        throw new error_1.FirebaseError("set the --app option to a valid Firebase app id and try again");
    }
    const appId = options.app;
    return `projects/${appId.split(":")[1]}/apps/${appId}`;
}
exports.getAppName = getAppName;
