// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import { test, expect } from "@finos/perspective-test";

test.beforeEach(async ({ page }) => {
    await page.goto("/rust/perspective-viewer/test/html/superstore.html");
    await page.evaluate(async () => {
        while (!window["__TEST_PERSPECTIVE_READY__"]) {
            await new Promise((x) => setTimeout(x, 10));
        }
    });

    await page.evaluate(async () => {
        await document.querySelector("perspective-viewer").restore({
            plugin: "Debug",
        });
    });
});

test.describe("Flush method", async () => {
    test("flush awaits settings view config field", async ({ page }) => {
        const old_config = await page.evaluate(async () => {
            const viewer = document.querySelector("perspective-viewer");
            return await viewer.save();
        });

        expect(old_config.settings).toBeFalsy();
        const config = await page.evaluate(async (columns) => {
            const viewer = document.querySelector("perspective-viewer");
            await viewer.getTable();
            viewer.restore({
                settings: true,
            });

            await viewer.flush();
            return await viewer.save();
        });

        expect(config).toEqual({
            ...old_config,
            settings: true,
        });
    });

    test("flush awaits view query fields", async ({ page }) => {
        const old_config = await page.evaluate(async () => {
            const viewer = document.querySelector("perspective-viewer");
            return await viewer.save();
        });

        expect(old_config.settings).toBeFalsy();
        const config = await page.evaluate(async (columns) => {
            const viewer = document.querySelector("perspective-viewer");
            await viewer.getTable();
            viewer.restore({
                settings: true,
                group_by: ["State", "City"],
                split_by: ["Category"],
            });

            await viewer.flush();
            return await viewer.save();
        });

        expect(config).toEqual({
            ...old_config,
            group_by: ["State", "City"],
            split_by: ["Category"],
            settings: true,
        });
    });
});
