// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

use std::sync::LazyLock;

use js_sys::Intl;
use perspective_js::json;
use perspective_js::utils::global::navigator;
use wasm_bindgen::JsValue;

pub trait ToFormattedString {
    fn to_formatted_string(&self) -> String;
}

struct UnsafeNumberFormat(Intl::NumberFormat);

unsafe impl Send for UnsafeNumberFormat {}
unsafe impl Sync for UnsafeNumberFormat {}

static NUMBER_FORMAT: LazyLock<UnsafeNumberFormat> = LazyLock::new(|| {
    let locale = navigator().languages();
    let opts = json!({});
    let number_format = Intl::NumberFormat::new(&locale, &opts);
    UnsafeNumberFormat(number_format)
});

impl UnsafeNumberFormat {}

impl ToFormattedString for u32 {
    fn to_formatted_string(&self) -> String {
        NUMBER_FORMAT
            .0
            .format()
            .call1(&NUMBER_FORMAT.0, &JsValue::from_f64(*self as f64))
            .unwrap()
            .as_string()
            .unwrap()
    }
}
