// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

use wasm_bindgen_test::*;
use web_sys::HtmlElement;
use yew::prelude::*;

use super::super::split_panel::{SplitPanel, SplitPanelMsg};
use crate::utils::{await_animation_frame, WeakScope};
use crate::*;

wasm_bindgen_test::wasm_bindgen_test_configure!(run_in_browser);

#[wasm_bindgen_test]
pub async fn test_resizes_larger() {
    let link: WeakScope<SplitPanel> = WeakScope::default();
    let panel_div = NodeRef::default();
    test_html! {
        <SplitPanel id="test" weak_link={ link.clone() }>
            <div ref={ panel_div.clone() } style="background-color: red"></div>
            <div style="background-color: green"></div>
        </SplitPanel>
    };

    await_animation_frame().await.unwrap();
    let split_panel = link.borrow().clone().unwrap();
    split_panel.send_message(SplitPanelMsg::StartResizing(0, 10));
    split_panel.send_message(SplitPanelMsg::MoveResizing(100));
    split_panel.send_message(SplitPanelMsg::StopResizing);
    await_animation_frame().await.unwrap();

    let width = panel_div.cast::<HtmlElement>().unwrap().offset_width();
    assert_eq!(width, 90);
}

#[wasm_bindgen_test]
pub async fn test_resizes_narrower() {
    let link: WeakScope<SplitPanel> = WeakScope::default();
    let panel_div = NodeRef::default();
    test_html! {
        <SplitPanel id="test" weak_link={ link.clone() }>
            <div ref={ panel_div.clone() } style="background-color: red"></div>
            <div style="background-color: green"></div>
        </SplitPanel>
    };

    await_animation_frame().await.unwrap();
    let split_panel = link.borrow().clone().unwrap();
    split_panel.send_message(SplitPanelMsg::StartResizing(0, 10));
    split_panel.send_message(SplitPanelMsg::MoveResizing(100));
    split_panel.send_message(SplitPanelMsg::StopResizing);
    await_animation_frame().await.unwrap();
    split_panel.send_message(SplitPanelMsg::StartResizing(0, 100));
    split_panel.send_message(SplitPanelMsg::MoveResizing(50));
    split_panel.send_message(SplitPanelMsg::StopResizing);
    await_animation_frame().await.unwrap();

    let width = panel_div.cast::<HtmlElement>().unwrap().offset_width();
    assert_eq!(width, 40);
}

#[wasm_bindgen_test]
pub async fn test_double_click_reset() {
    let link: WeakScope<SplitPanel> = WeakScope::default();
    let panel_div = NodeRef::default();
    test_html! {
        <SplitPanel id="test" weak_link={ link.clone() }>
            <div ref={ panel_div.clone() } style="background-color: red"></div>
            <div style="background-color: green"></div>
        </SplitPanel>
    };

    await_animation_frame().await.unwrap();
    let split_panel = link.borrow().clone().unwrap();
    split_panel.send_message(SplitPanelMsg::StartResizing(0, 10));
    split_panel.send_message(SplitPanelMsg::MoveResizing(100));
    split_panel.send_message(SplitPanelMsg::StopResizing);
    split_panel.send_message(SplitPanelMsg::Reset(0));

    let width = panel_div.cast::<HtmlElement>().unwrap().offset_width();
    assert_eq!(width, 0);
}
