// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import { test, expect } from "@finos/perspective-test";
import perspective from "./perspective_client";
import * as _ from "underscore";

var arrow_result = [
    {
        f32: 1.5,
        f64: 1.5,
        i64: 1,
        i32: 1,
        i16: 1,
        i8: 1,
        bool: true,
        char: "a",
        dict: "a",
        datetime: +new Date("2018-01-25"),
    },
    {
        f32: 2.5,
        f64: 2.5,
        i64: 2,
        i32: 2,
        i16: 2,
        i8: 2,
        bool: false,
        char: "b",
        dict: "b",
        datetime: +new Date("2018-01-26"),
    },
    {
        f32: 3.5,
        f64: 3.5,
        i64: 3,
        i32: 3,
        i16: 3,
        i8: 3,
        bool: true,
        char: "c",
        dict: "c",
        datetime: +new Date("2018-01-27"),
    },
    {
        f32: 4.5,
        f64: 4.5,
        i64: 4,
        i32: 4,
        i16: 4,
        i8: 4,
        bool: false,
        char: "d",
        dict: "d",
        datetime: +new Date("2018-01-28"),
    },
    {
        f32: 5.5,
        f64: 5.5,
        i64: 5,
        i32: 5,
        i16: 5,
        i8: 5,
        bool: true,
        char: "d",
        dict: "d",
        datetime: +new Date("2018-01-29"),
    },
];

((perspective) => {
    test.describe("Multiple Perspectives", function () {
        test("Constructs table using data generated by to_arrow()", async function () {
            let table = await perspective.table(arrow_result);
            let view = await table.view();
            let result = await view.to_arrow();

            let table2 = await perspective.table(result);
            let view2 = await table2.view();
            let result2 = await view2.to_json();

            expect(result2).toEqual(arrow_result);

            view.delete();
            view2.delete();
            table.delete();
            table2.delete();
        });

        test("Constructs table using data in random column order generated by to_arrow()", async function () {
            let table = await perspective.table(arrow_result);
            let columns = _.shuffle(await table.columns());
            let view = await table.view({
                columns: columns,
            });
            let result = await view.to_arrow();

            let table2 = await perspective.table(result);
            let columns2 = _.shuffle(await table2.columns());
            let view2 = await table2.view({
                columns: columns2,
            });
            let result2 = await view2.to_json();

            expect(result2).toEqual(arrow_result);

            view.delete();
            view2.delete();
            table.delete();
            table2.delete();
        });
    });
})(perspective);
