// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import { test, expect } from "@finos/perspective-test";
import perspective from "./perspective_client";

import { createRequire } from "node:module";

const require = createRequire(import.meta.url);

import * as fs from "node:fs";

const superstore_uncompressed = fs.readFileSync(
    require.resolve("superstore-arrow/superstore.arrow")
).buffer;

const superstore_lz4 = fs.readFileSync(
    require.resolve("superstore-arrow/superstore.lz4.arrow")
).buffer;

test.describe("Arrow IPC", function () {
    test.describe("to_arrow()", function () {
        test("to_arrow() compressed is serializable roundtrip", async () => {
            let table = await perspective.table(
                superstore_uncompressed.slice()
            );

            let view = await table.view();
            let arr = await view.to_arrow({ compression: "lz4" });
            expect(arr).toEqual(superstore_lz4);
            expect(arr.byteLength).toBeLessThan(
                superstore_uncompressed.byteLength
            );

            view.delete();
            table.delete();
            table = await perspective.table(arr);
            view = await table.view();
            let arr2 = await view.to_arrow({ compression: null });
            expect(arr2.byteLength).toBeGreaterThan(arr.byteLength);
            view.delete();
            table.delete();
        });
    });
});
