// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

export function cell_style_row_header(regularTable, td, metadata) {
    const is_not_empty =
        typeof metadata.value != undefined &&
        typeof metadata.value != null &&
        metadata.value?.toString()?.trim().length > 0;
    const is_leaf = metadata.row_header_x >= this._config.group_by.length;
    const next = regularTable.getMeta({
        dx: 0,
        dy: metadata.y - metadata.y0 + 1,
    });
    const is_collapse =
        next &&
        next.row_header &&
        typeof next.row_header[metadata.row_header_x + 1] !== "undefined";
    td.classList.toggle("psp-tree-label", is_not_empty && !is_leaf);
    td.classList.toggle(
        "psp-tree-label-expand",
        is_not_empty && !is_leaf && !is_collapse
    );
    td.classList.toggle(
        "psp-tree-label-collapse",
        is_not_empty && !is_leaf && is_collapse
    );
    td.classList.toggle("psp-tree-leaf", is_not_empty && is_leaf);
}
