// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import { select } from "d3";
import { getGroupValues, getSplitValues, getDataValues } from "./selectionData";
import { Settings } from "../types";

export function generateHtml(tooltipDiv, data, settings: Settings) {
    const tooltipValues = getGroupValues(data, settings)
        .concat(getSplitValues(data, settings))
        .concat(getDataValues(data, settings));
    addDataValues(tooltipDiv, tooltipValues);
}

function addDataValues(tooltipDiv, values) {
    tooltipDiv
        .select("#tooltip-values")
        .selectAll("li")
        .data(values)
        .join("li")
        .each(function (d) {
            select(this)
                .text(`${d.name}: `)
                .append("b")
                .text(formatNumber(d.value));
        });
}

const formatNumber = (value) =>
    value === null || value === undefined
        ? "-"
        : value.toLocaleString(undefined, {
              style: "decimal",
              minimumFractionDigits: 2,
              maximumFractionDigits: 2,
          });
