// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import * as fc from "d3fc";
import { tooltip } from "../tooltip/tooltip";
import { ScaleSequential, Settings } from "../types";

export function barSeries(
    settings: Settings,
    color: d3.ScaleOrdinal<string, unknown> | ScaleSequential
) {
    let series =
        settings.mainValues.length > 1
            ? fc.seriesSvgGrouped(fc.seriesSvgBar())
            : fc.seriesSvgBar();

    series = series.decorate((selection) => {
        tooltip().settings(settings)(selection);
        selection.style("fill", (d) => color(d.key));
    });

    return fc
        .autoBandwidth(minBandwidth(series))
        .crossValue((d) => d.crossValue)
        .mainValue((d) => (d.mainValue ? d.mainValue : 0))
        .baseValue((d) => d.baseValue);
}

const minBandwidth = (adaptee) => {
    const min = (arg) => {
        return adaptee(arg);
    };

    fc.rebindAll(min, adaptee);

    min.bandwidth = (...args) => {
        if (!args.length) {
            return adaptee.bandwidth();
        }
        adaptee.bandwidth(Math.max(args[0], 1));
        return min;
    };

    return min;
};
