// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import { labelFunction } from "../axis/axisLabel";
import { Settings } from "../types";

export interface SplitAndBasedData {
    key: string;
    crossValue: string;
    mainValue: number;
    baseValue: number;
    row: any;
}

export function splitAndBaseData(
    settings: Settings,
    data
): SplitAndBasedData[][] {
    const labelfn = labelFunction(settings);

    return data.map((col, i): SplitAndBasedData[] => {
        const baseValues = {};

        return Object.keys(col)
            .filter((key) => key !== "__ROW_PATH__")
            .map((key) => {
                // Keys are of the form "split1|split2|aggregate"
                const labels = key.split("|");
                // label="aggregate"
                const label = labels[labels.length - 1];
                const baseValue = baseValues[label] || 0;
                const value = baseValue + col[key];
                baseValues[label] = value;

                return {
                    key,
                    crossValue: labelfn(col, i),
                    mainValue: value,
                    baseValue: baseValue,
                    row: col,
                };
            });
    });
}
