// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import { rebindAll } from "d3fc";

const MIN_BANDWIDTH = 1;

export interface MinBandwidth {
    (arg: any): any;
    bandwidth(): number;
    bandwidth(...args: any[]): any;
}

// NOTE: Can the minBandwidth in barSeries.ts be merged with this?

export default (adaptee: d3.ScaleBand<string>): MinBandwidth => {
    const minBandwidth: Partial<MinBandwidth> = (arg) => {
        return adaptee(arg);
    };

    rebindAll(minBandwidth, adaptee);

    minBandwidth.bandwidth = (...args: any[]): any => {
        if (!args.length) {
            return Math.max(adaptee.bandwidth(), MIN_BANDWIDTH);
        }
        // NOTE: d3.ScaleBand only has a getter for .bandwidth? (no args...);
        //       I'm not sure this can be set.
        // @ts-ignore
        adaptee.bandwidth(...args);
        return minBandwidth;
    };

    return minBandwidth as MinBandwidth;
};
