// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

import { DomainTuple } from "../types";

export default (domain1: DomainTuple, domain2: DomainTuple) => {
    if (!isMatchable(domain1) || !isMatchable(domain2)) return;

    const ratio1 = originRatio(domain1);
    const ratio2 = originRatio(domain2);

    if (ratio1 > ratio2) {
        domain2[0] = adjustLowerBound(domain2, ratio1);
    } else {
        domain1[0] = adjustLowerBound(domain1, ratio2);
    }
};

const isMatchable = (domain: DomainTuple) =>
    domain.length === 2 &&
    !isNaN(domain[0]) &&
    !isNaN(domain[1]) &&
    domain[0] !== domain[1];
const originRatio = (domain: DomainTuple) =>
    (0 - domain[0]) / (domain[1] - domain[0]);
const adjustLowerBound = (domain: DomainTuple, ratio: number) =>
    (ratio * domain[1]) / (ratio - 1);
