// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

exports.ResolvePlugin = function ResolvePlugin(options) {
    return {
        name: "resolve",
        setup: (build) => {
            for (const moduleName of Object.keys(options)) {
                const moduleTarget = options[moduleName];
                const filter = new RegExp("^" + moduleName + "$");

                build.onResolve({ filter }, async (args) => {
                    if (args.resolveDir === "") {
                        return;
                    }

                    return {
                        path: args.path,
                        namespace: "resolve",
                        pluginData: {
                            resolveDir: args.resolveDir,
                            moduleName,
                        },
                    };
                });

                build.onLoad({ filter, namespace: "resolve" }, async (args) => {
                    const importerCode = `
                            export * from '${args.path.replace(
                                args.pluginData.moduleName,
                                moduleTarget
                            )}';
                            export { default } from '${args.path.replace(
                                args.pluginData.moduleName,
                                moduleTarget
                            )}';
                        `;
                    return {
                        contents: importerCode,
                        resolveDir: args.pluginData.resolveDir,
                    };
                });
            }
        },
    };
};
