// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

const esbuild = require("esbuild");

const CUTOFF_PERCENT = 0.02;

const DEFAULT_BUILD = {
    target: ["es2022"],
    bundle: true,
    minify: !process.env.PSP_DEBUG,
    sourcemap: true,
    metafile: true,
    entryNames: "[name]",
    chunkNames: "[name]",
    assetNames: "[name]",
};

exports.build = async function build(config) {
    const result = await esbuild.build({
        ...DEFAULT_BUILD,
        ...config,
    });

    if (result.metafile) {
        for (const output of Object.keys(result.metafile.outputs)) {
            const { inputs, bytes } = result.metafile.outputs[output];
            for (const input of Object.keys(inputs)) {
                if (inputs[input].bytesInOutput / bytes < CUTOFF_PERCENT) {
                    delete inputs[input];
                }
            }
        }

        const text = await esbuild.analyzeMetafile(result.metafile, {
            color: true,
        });

        console.log(text);
    }
};
