// ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
// ┃ ██████ ██████ ██████       █      █      █      █      █ █▄  ▀███ █       ┃
// ┃ ▄▄▄▄▄█ █▄▄▄▄▄ ▄▄▄▄▄█  ▀▀▀▀▀█▀▀▀▀▀ █ ▀▀▀▀▀█ ████████▌▐███ ███▄  ▀█ █ ▀▀▀▀▀ ┃
// ┃ █▀▀▀▀▀ █▀▀▀▀▀ █▀██▀▀ ▄▄▄▄▄ █ ▄▄▄▄▄█ ▄▄▄▄▄█ ████████▌▐███ █████▄   █ ▄▄▄▄▄ ┃
// ┃ █      ██████ █  ▀█▄       █ ██████      █      ███▌▐███ ███████▄ █       ┃
// ┣━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┫
// ┃ Copyright (c) 2017, the Perspective Authors.                              ┃
// ┃ ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌ ┃
// ┃ This file is part of the Perspective library, distributed under the terms ┃
// ┃ of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0). ┃
// ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛

// @ts-check

/** @type {import('@docusaurus/plugin-content-docs').SidebarsConfig} */
const sidebars = {
    // By default, Docusaurus generates a sidebar from the docs folder structure
    // tutorialSidebar: [{type: "autogenerated", dirName: "."}],
    tutorialSidebar: [
        // {
        //     type: "category",
        //     label: "Language Guides",
        //     items: ["js", "python"],
        // },
        {
            type: "category",
            label: "API",
            items: [
                "expressions",
                // "server",
                {
                    type: "link",
                    label: "`perspective` Rust API",
                    href: "https://docs.rs/perspective/latest/perspective/",
                },
                {
                    type: "link",
                    label: "`perspective-js` JavaScript API",
                    href: "https://docs.rs/perspective-js/latest/perspective_js/",
                },
                {
                    type: "link",
                    label: "`perspective-viewer` JavaScript API",
                    href: "https://docs.rs/perspective-viewer/latest/perspective_viewer/",
                },
                {
                    type: "link",
                    label: "`perspective-python` Python API",
                    href: "https://docs.rs/perspective-python/latest/perspective_python/",
                },
                {
                    type: "link",
                    label: "`perspective-server` Server API",
                    href: "https://docs.rs/perspective-server/latest/perspective_server/",
                },
            ],
        },
        // "development",
    ],

    // ["js", "python", "table", "view", "server", "development"],

    // But you can create a sidebar manually
    /*
  tutorialSidebar: [
    {
      type: 'category',
      label: 'Tutorial',
      items: ['hello'],
    },
  ],
   */
};

module.exports = sidebars;
