import React, { SVGProps } from "react";

export function ViewHideLight(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M15.9202 12.7988A4.0188 4.0188 0 0 0 16 12c0-2.2091-1.7909-4-4-4a4.018 4.018 0 0 0-.7988.0798l.9227.9227c1.5583.0633 2.8103 1.3153 2.8736 2.8736l.9227.9227Zm-6.527-2.2845A2.9864 2.9864 0 0 0 9 12c0 1.6569 1.3431 3 3 3a2.987 2.987 0 0 0 1.4857-.3931l.7263.7263A3.9813 3.9813 0 0 1 12 16c-2.2091 0-4-1.7909-4-4 0-.8179.2455-1.5784.6668-2.212l.7263.7263Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m16.1537 17.2751-.7344-.7345c-1.064.579-2.2206.9594-3.4193.9594-1.6718 0-3.2618-.7401-4.6329-1.7265-1.367-.9835-2.474-2.1817-3.1692-3.0257-.4243-.5152-.4682-.6043-.4682-.7478 0-.1435.0439-.2326.4682-.7478.6693-.8126 1.7204-1.9536 3.0178-2.9152l-.7143-.7143c-1.3315 1.008-2.3976 2.1708-3.0754 2.9937l-.0588.0712c-.3305.3994-.6375.7703-.6375 1.3124s.307.913.6375 1.3124l.0588.0712c.725.8802 1.8941 2.1491 3.3571 3.2017C8.2421 17.635 10.0361 18.5 12 18.5c1.5101 0 2.9196-.5114 4.1537-1.2249ZM9.1899 6.0686C10.0698 5.7183 11.0135 5.5 12 5.5c1.9639 0 3.7579.865 5.2169 1.9147 1.463 1.0526 2.6321 2.3215 3.3571 3.2017l.0588.0712c.3305.3994.6375.7703.6375 1.3124s-.307.913-.6375 1.3124l-.0588.0712c-.4805.5833-1.156 1.3374-1.9829 2.0861l-.7081-.708c.7957-.7161 1.4508-1.4453 1.9191-2.0139.4244-.5152.4682-.6043.4682-.7478 0-.1435-.0438-.2326-.4682-.7478C19.107 10.4082 18 9.21 16.6329 8.2265 15.2619 7.24 13.6718 6.5 12 6.5c-.6944 0-1.3747.1277-2.031.3476l-.779-.779Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path stroke="currentColor" d="m5 2 16 16" />
        </svg>
    );
}
export default ViewHideLight;
