import React, { SVGProps } from "react";

export function ViewHideDuotone(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M15.9202 12.7988A4.0188 4.0188 0 0 0 16 12c0-2.2091-1.7909-4-4-4a4.018 4.018 0 0 0-.7988.0798l4.719 4.719ZM8.6668 9.788A3.9814 3.9814 0 0 0 8 12c0 2.2091 1.7909 4 4 4a3.9813 3.9813 0 0 0 2.212-.6668L8.6668 9.788Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="M15.7872 16.9085 6.8584 7.9797c-1.3145.9852-2.373 2.137-3.0464 2.9546-.3882.4713-.5823.7069-.5823 1.0657 0 .3588.1941.5944.5823 1.0657C5.232 14.7899 8.3643 18 12 18c1.3529 0 2.636-.4445 3.7872-1.0915ZM9.5769 6.4556C10.348 6.1712 11.1606 6 12 6c3.6357 0 6.768 3.2101 8.188 4.9343.3882.4713.5823.7069.5823 1.0657 0 .3588-.1941.5944-.5823 1.0657-.4743.5759-1.1396 1.3176-1.9509 2.05l-8.6602-8.66Z"
                clipRule="evenodd"
                fillOpacity=".24"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="M15.9202 12.7988A4.0188 4.0188 0 0 0 16 12c0-2.2091-1.7909-4-4-4a4.018 4.018 0 0 0-.7988.0798l4.719 4.719ZM8.6668 9.788A3.9814 3.9814 0 0 0 8 12c0 2.2091 1.7909 4 4 4a3.9813 3.9813 0 0 0 2.212-.6668L8.6668 9.788Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path stroke="currentColor" d="m8 5 12 12" strokeWidth="1.2" />
        </svg>
    );
}
export default ViewHideDuotone;
