import React, { SVGProps } from "react";

export function ViewHide(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M15.9202 12.7988A4.0188 4.0188 0 0 0 16 12c0-2.2091-1.7909-4-4-4a4.018 4.018 0 0 0-.7988.0798l4.719 4.719ZM8.6668 9.788A3.9814 3.9814 0 0 0 8 12c0 2.2091 1.7909 4 4 4a3.9813 3.9813 0 0 0 2.212-.6668l-1.4739-1.4738A1.995 1.995 0 0 1 12 14c-1.1046 0-2-.8954-2-2 0-.2607.0499-.5098.1406-.7381l-1.4738-1.474Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m16.5191 17.6405-1.4692-1.4693C14.0776 16.6805 13.0477 17 12 17c-1.5258 0-3.0138-.6776-4.3409-1.6323-1.319-.9491-2.395-2.1119-3.0752-2.9377a13.4178 13.4178 0 0 1-.236-.2915A2.0472 2.0472 0 0 1 4.2476 12a2.0472 2.0472 0 0 1 .1002-.1385c.0618-.0797.1363-.1703.236-.2915.6655-.8078 1.7096-1.9381 2.9895-2.8754L6.1446 7.266C4.7964 8.2962 3.7225 9.4701 3.04 10.2985c-.0236.0287-.0482.0581-.0735.0884-.3134.3755-.7369.8827-.7369 1.6131 0 .7304.4235 1.2376.7369 1.6131l.0002.0002c.0252.0302.0498.0596.0733.0882.7399.8983 1.94 2.2026 3.451 3.2897C7.9941 18.0725 9.8901 19 12 19c1.67 0 3.206-.581 4.5191-1.3595ZM8.8068 5.6855C9.7906 5.2687 10.8643 5 12 5c2.1099 0 4.0059.9275 5.5089 2.0088 1.5109 1.0871 2.7112 2.3914 3.451 3.2897.0236.0287.0482.0581.0735.0884.3134.3755.7369.8827.7369 1.6131 0 .7304-.4235 1.2376-.7369 1.6131-.0253.0303-.0499.0597-.0735.0884-.4866.5908-1.1725 1.3574-2.0149 2.1222l-1.416-1.416c.7799-.6997 1.4249-1.4165 1.8872-1.9777.0997-.1212.1742-.2118.236-.2915.0488-.0631.08-.107.1003-.1385a2.0702 2.0702 0 0 0-.1003-.1385 13.8499 13.8499 0 0 0-.236-.2915c-.6803-.8258-1.7562-1.9886-3.0753-2.9377C15.0139 7.6776 13.5258 7 12 7c-.551 0-1.0971.0884-1.6324.2462L8.8068 5.6855Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path stroke="currentColor" d="m5 2 16 16" strokeWidth="2" />
        </svg>
    );
}
export default ViewHide;
