import React, { SVGProps } from "react";

export function VideoFileDuotoneLine(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M12.7534 3.2663c.2876.2663.3213.7043.3886 1.5803l.216 2.8068c.0673.876.101 1.314.3886 1.5803.2875.2663.7268.2663 1.6055.2663h2.0101c1.0018 0 1.5028 0 1.7992.3168s.263.8166.1964 1.8162L19 17c0 1.8856 0 2.8284-.5858 3.4142C17.8284 21 16.8856 21 15 21H9c-1.8856 0-2.8284 0-3.4142-.5858C5 19.8284 5 18.8856 5 17V7c0-1.8856 0-2.8284.5858-3.4142C6.1716 3 7.1144 3 9 3h2.1479c.8787 0 1.318 0 1.6055.2663Zm-2.0807 9.4502 3.1826 1.364c.8081.3463.8081 1.4919 0 1.8383l-3.1826 1.3639C9.8809 17.6221 9 17.0413 9 16.1798v-2.3603c0-.8615.8809-1.4424 1.6727-1.103Z"
                clipRule="evenodd"
                fillOpacity=".24"
                fillRule="evenodd"
            />
            <path
                stroke="currentColor"
                d="M13.1716 3H9c-1.8856 0-2.8284 0-3.4142.5858C5 4.1716 5 5.1144 5 7v10c0 1.8856 0 2.8284.5858 3.4142C6.1716 21 7.1144 21 9 21h6c1.8856 0 2.8284 0 3.4142-.5858C19 19.8284 19 18.8856 19 17V8.8284c0-.4087 0-.6131-.0761-.7969-.0761-.1837-.2207-.3283-.5097-.6173l-3.8284-3.8284c-.289-.289-.4336-.4336-.6173-.5097C13.7847 3 13.5803 3 13.1716 3Z"
                strokeWidth="1.2"
            />
            <path
                stroke="currentColor"
                d="m13.8553 14.0805-3.1826-1.364C9.8809 12.3771 9 12.958 9 13.8195v2.3603c0 .8615.8809 1.4423 1.6727 1.1029l3.1826-1.3639c.8081-.3464.8081-1.492 0-1.8383Z"
                strokeLinejoin="round"
                strokeWidth="1.2"
            />
            <path
                stroke="currentColor"
                d="M13 3v4c0 .9428 0 1.4142.2929 1.7071C13.5858 9 14.0572 9 15 9h4"
                strokeWidth="1.2"
            />
        </svg>
    );
}
export default VideoFileDuotoneLine;
