import React, { SVGProps } from "react";

export function UserBoxDuotone(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <path
                fill="currentColor"
                d="M3 11c0-3.7712 0-5.6569 1.1716-6.8284C5.343 3 7.2288 3 11 3h2c3.7712 0 5.6569 0 6.8284 1.1716C21 5.343 21 7.2288 21 11v2c0 3.7712 0 5.6569-1.1716 6.8284C18.6569 21 16.7712 21 13 21h-2c-3.7712 0-5.6569 0-6.8284-1.1716C3 18.6569 3 16.7712 3 13v-2Z"
                fillOpacity=".24"
            />
            <circle cx="12" cy="10" r="4" fill="currentColor" />
            <path
                fill="currentColor"
                d="M18.9463 20.2532a.2322.2322 0 0 1-.14.2489C17.6048 21 15.8353 21 13 21h-2c-2.8352 0-4.6047 0-5.8062-.4978a.2324.2324 0 0 1-.14-.249C5.4825 17.2919 8.429 15 12 15s6.5174 2.2919 6.9463 5.2532Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
        </svg>
    );
}
export default UserBoxDuotone;
