import React, { SVGProps } from "react";

export function UploadDuotoneLine(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <mask
                id="a"
                width="20"
                height="12"
                x="2"
                y="2"
                fill="currentColor"
                maskUnits="userSpaceOnUse"
            >
                <path fill="currentColor" d="M2 2h20v12H2z" />
                <path
                    d="M6 13h12c1.6569 0 3-1.3431 3-3s-1.3431-3-3-3c-.2795 0-.4193 0-.517-.0197-.298-.06-.4395-.1515-.6163-.3989-.0579-.081-.1395-.2629-.3028-.6266C15.7822 4.2131 14.0328 3 12 3 9.9672 3 8.2178 4.213 7.436 5.9548c-.1632.3637-.2448.5456-.3027.6266-.1768.2474-.3183.339-.6163.399C6.4193 7 6.2795 7 6 7c-1.6569 0-3 1.3431-3 3s1.3431 3 3 3Z"
                    clipRule="evenodd"
                    fillRule="evenodd"
                />
            </mask>
            <path
                fill="currentColor"
                d="M6 13h12c1.6569 0 3-1.3431 3-3s-1.3431-3-3-3c-.2795 0-.4193 0-.517-.0197-.298-.06-.4395-.1515-.6163-.3989-.0579-.081-.1395-.2629-.3028-.6266C15.7822 4.2131 14.0328 3 12 3 9.9672 3 8.2178 4.213 7.436 5.9548c-.1632.3637-.2448.5456-.3027.6266-.1768.2474-.3183.339-.6163.399C6.4193 7 6.2795 7 6 7c-1.6569 0-3 1.3431-3 3s1.3431 3 3 3Z"
                clipRule="evenodd"
                fillOpacity=".24"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m7.1333 6.5814-.4882-.3488.4882.3488Zm-.6163.399.1184.5881-.1184-.5882Zm10.966 0-.1184.5881.1184-.5882Zm-.6163-.399-.4881.3489.4881-.3489ZM12 12.4H6v1.2h6v-1.2Zm6 0h-6v1.2h6v-1.2Zm2.4-2.4c0 1.3255-1.0745 2.4-2.4 2.4v1.2c1.9882 0 3.6-1.6118 3.6-3.6h-1.2ZM18 7.6c1.3255 0 2.4 1.0745 2.4 2.4h1.2c0-1.9882-1.6118-3.6-3.6-3.6v1.2Zm-.8887-1.8909C16.2364 3.7597 14.2776 2.4 12 2.4v1.2c1.7879 0 3.3281 1.0665 4.0165 2.6005l1.0948-.4914ZM12 2.4c-2.2776 0-4.2364 1.3597-5.1113 3.3091l1.0948.4914C8.6719 4.6665 10.212 3.6 12 3.6V2.4Zm-6 4c-1.9882 0-3.6 1.6118-3.6 3.6h1.2c0-1.3255 1.0745-2.4 2.4-2.4V6.4ZM2.4 10c0 1.9882 1.6118 3.6 3.6 3.6v-1.2c-1.3255 0-2.4-1.0745-2.4-2.4H2.4Zm4.4887-4.2909a23.33 23.33 0 0 1-.1854.4074c-.0492.1035-.064.1241-.0582.116l.9763.6978c.0637-.0891.1188-.2.1656-.2985.0516-.1085.116-.2521.1965-.4313L6.8887 5.709ZM6 7.6c.2442 0 .4631.0032.6354-.0315l-.2368-1.1764c.0015-.0003-.0175.0035-.0899.0057C6.2377 6.4 6.1435 6.4 6 6.4v1.2Zm.6451-1.3674c-.0658.092-.0938.1105-.1005.1149-.0067.0043-.035.0223-.146.0446l.2368 1.1764c.1871-.0376.3785-.0954.5612-.2137.1828-.1183.3139-.2692.4248-.4245l-.9763-.6977ZM18 6.4c-.1435 0-.2377 0-.3087-.0022-.0724-.0022-.0914-.006-.0899-.0057l-.2368 1.1764c.1723.0347.3913.0315.6354.0315V6.4Zm-1.9835-.1995c.0805.1792.1449.3228.1965.4313.0468.0985.1019.2094.1656.2985l.9763-.6977c.0057.008-.009-.0126-.0582-.1161a24.0557 24.0557 0 0 1-.1854-.4074l-1.0948.4914Zm1.5849.1916c-.1109-.0223-.1393-.0403-.146-.0446-.0067-.0044-.0347-.0229-.1005-.115l-.9763.6978c.1109.1553.242.3062.4248.4245.1827.1183.3741.176.5612.2137l.2368-1.1764Z"
                fillOpacity=".24"
                mask="url(#a)"
            />
            <path
                fill="currentColor"
                d="M12 2.4c-2.2776 0-4.2364 1.3597-5.1113 3.3092a23.3137 23.3137 0 0 1-.1854.4073 1.975 1.975 0 0 1-.0579.1148c-.002.0036-.002.0036-.0003.0013-.0658.092-.0939.1105-.1005.1149-.0067.0043-.0351.0223-.146.0447-.0017.0002-.023.0036-.0899.0056C6.2377 6.4 6.1435 6.4 6 6.4c-1.9882 0-3.6 1.6118-3.6 3.6 0 1.9883 1.6118 3.6 3.6 3.6h.5716l1.2-1.2H6c-1.3255 0-2.4-1.0745-2.4-2.4S4.6745 7.6 6 7.6h.0573c.2211.0003.4194.0005.578-.0314.1872-.0377.3786-.0954.5613-.2138.1828-.1182.3138-.2692.4248-.4245.0637-.0891.1188-.2.1656-.2985.051-.107.1143-.2483.1933-.4242l.0032-.007C8.6719 4.6664 10.212 3.6 12 3.6c1.7879 0 3.3281 1.0665 4.0165 2.6005l.0031.0068c.079.176.1424.3174.1933.4245.0469.0986.102.2094.1657.2985.1109.1553.242.3063.4248.4245.1827.1184.3741.1761.5612.2138.1587.0319.357.0317.5781.0315H18c1.3255 0 2.4 1.0744 2.4 2.3999 0 1.3255-1.0745 2.4-2.4 2.4h-1.7716l1.2 1.2H18c1.9882 0 3.6-1.6117 3.6-3.6 0-1.9882-1.6118-3.6-3.6-3.6-.1435 0-.2378 0-.3087-.0022-.0669-.002-.0882-.0054-.0899-.0056-.0001 0-.0001 0 0 0-.1109-.0224-.1393-.0404-.146-.0447-.0067-.0044-.0347-.0229-.1005-.1149l.0011.0015-.0015-.0027c-.0049-.009-.0225-.0406-.0578-.115a23.3245 23.3245 0 0 1-.1854-.4072C16.2364 3.7597 14.2776 2.4 12 2.4Z"
                clipRule="evenodd"
                fillRule="evenodd"
            />
            <path
                fill="currentColor"
                d="m12 12-.4243-.4243.4243-.4242.4243.4242L12 12Zm.6 9a.6.6 0 1 1-1.2 0h1.2Zm-5.0243-5.4243 4-4 .8486.8486-4 4-.8486-.8486Zm4.8486-4 4 4-.8486.8486-4-4 .8486-.8486ZM12.6 12v9h-1.2v-9h1.2Z"
            />
        </svg>
    );
}
export default UploadDuotoneLine;
