import React, { SVGProps } from "react";

export function Phone(props: SVGProps<SVGSVGElement>) {
    return (
        <svg
            fill="currentColor"
            viewBox="0 0 24 24"
            width="1em"
            height="1em"
            {...props}
        >
            <mask
                id="a"
                width="10"
                height="6"
                x="7"
                y="2"
                fill="currentColor"
                maskUnits="userSpaceOnUse"
            >
                <path fill="currentColor" d="M7 2h10v6H7z" />
                <path d="M13.3333 5h-2.6666c-.155 0-.2325 0-.2961-.017a.5.5 0 0 1-.3536-.3536C10 4.5658 10 4.4884 10 4.3334c0-.0776 0-.1163.0085-.1481a.25.25 0 0 1 .1768-.1768C10.2171 4 10.2558 4 10.3333 4h3.3334c.0775 0 .1162 0 .148.0085a.25.25 0 0 1 .1768.1768c.0085.0318.0085.0705.0085.148 0 .155 0 .2325-.017.2961a.5.5 0 0 1-.3536.3536C13.5658 5 13.4883 5 13.3333 5Z" />
            </mask>
            <path
                fill="currentColor"
                d="m10.017 4.6294-1.9318.5176 1.9318-.5176Zm.3536.3536L9.853 6.9148l.5176-1.9318Zm3.6124-.3536-1.9319-.5176 1.9319.5176Zm-.3536.3536.5176 1.9318-.5176-1.9318Zm.3621-.7977 1.9318-.5176-1.9318.5176Zm-.1768-.1768-.5176 1.9319.5176-1.9319Zm-3.8062.1768 1.9319.5176-1.9319-.5176Zm.1768-.1768.5176 1.9319-.5176-1.9319ZM10.6667 7h2.6666V3h-2.6666v4Zm3-5h-3.3334v4h3.3334V2ZM8 4.3333c0 .0263-.0172.4317.0852.8137l3.8637-1.0352c.0446.1664.0502.2926.0512.3127.0005.0118.0003.0131.0001-.0062C12 4.399 12 4.3746 12 4.3333H8ZM10.6667 3c-.0413 0-.0656 0-.085-.0002-.0193-.0002-.018-.0004-.0062.0002.0201.0009.1463.0065.3127.0511L9.853 6.9148c.382.1024.7874.0852.8137.0852V3ZM8.0852 5.147a2.5 2.5 0 0 0 1.7677 1.7678l1.0353-3.8637a1.5 1.5 0 0 1 1.0607 1.0607L8.0852 5.147ZM12 4.3334c0 .0413 0 .0656-.0002.085-.0002.0193-.0004.018.0001.0062.001-.0201.0066-.1463.0512-.3127l3.8637 1.0353c.1024-.382.0852-.7875.0852-.8138h-4ZM13.3333 7c.0263 0 .4317.0172.8137-.0852l-1.0352-3.8637c.1664-.0446.2926-.0502.3127-.0511.0118-.0006.0131-.0004-.0062-.0002a10.5887 10.5887 0 0 1-.085.0002v4Zm-1.2822-2.8882a1.5 1.5 0 0 1 1.0607-1.0607l1.0352 3.8637a2.5 2.5 0 0 0 1.7678-1.7677l-3.8637-1.0353ZM16 4.3333c0-.0206.0005-.1028-.0031-.1822a2.2607 2.2607 0 0 0-.0736-.4834l-3.8637 1.0352a1.7523 1.7523 0 0 1-.0586-.3696c-.0011-.0235-.0011-.0379-.0011-.0336L12 4.3333h4ZM13.6667 6h.0336c.0043 0-.0101 0-.0336-.001a1.7476 1.7476 0 0 1-.3696-.0586l1.0352-3.8637a2.2546 2.2546 0 0 0-.4834-.0736C13.7695 1.9995 13.6873 2 13.6667 2v4Zm2.2566-2.3323a2.2498 2.2498 0 0 0-1.591-1.591l-1.0352 3.8637a1.75 1.75 0 0 1-1.2375-1.2375l3.8637-1.0352ZM12 4.3333l.0001-.0336c0-.0043 0 .0101-.0011.0336a1.7522 1.7522 0 0 1-.0586.3696L8.0767 3.6677a2.2555 2.2555 0 0 0-.0736.4834C7.9995 4.2305 8 4.3127 8 4.3333h4ZM10.3333 2c-.0206 0-.1028-.0005-.1822.0031a2.255 2.255 0 0 0-.4834.0736l1.0352 3.8637a1.7476 1.7476 0 0 1-.3696.0586C10.3098 6 10.2954 6 10.2997 6h.0336V2Zm1.6071 2.703a1.75 1.75 0 0 1-1.2375 1.2374L9.6677 2.0767a2.25 2.25 0 0 0-1.591 1.591l3.8637 1.0352Z"
                mask="url(#a)"
            />
            <rect
                width="12"
                height="18"
                x="6"
                y="3"
                stroke="currentColor"
                rx="2"
                strokeWidth="2"
            />
            <circle cx="12" cy="18" r="1" fill="currentColor" />
        </svg>
    );
}
export default Phone;
